/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.keys.FreenetURI;
import freenet.support.api.Bucket;

public class ManifestElement {
    final String name;
    final String fullName;
    Bucket data;
    final String mimeOverride;
    final long dataSize;
    final FreenetURI targetURI;

    public ManifestElement(String name2, String fullName2, Bucket data2, String mimeOverride2, long size) {
        this.name = name2;
        this.fullName = fullName2;
        this.data = data2;
        assert (this.data != null);
        this.mimeOverride = mimeOverride2;
        this.dataSize = size;
        this.targetURI = null;
    }

    public ManifestElement(String name2, Bucket data2, String mimeOverride2, long size2) {
        this.name = name2;
        this.fullName = name2;
        this.data = data2;
        this.mimeOverride = mimeOverride2;
        this.dataSize = size2;
        this.targetURI = null;
    }

    public ManifestElement(ManifestElement me, String newName) {
        this.name = newName;
        this.fullName = me.fullName;
        this.data = me.data;
        this.mimeOverride = me.mimeOverride;
        this.dataSize = me.dataSize;
        this.targetURI = me.targetURI;
    }

    public ManifestElement(ManifestElement me, String newName, String newFullName) {
        this.name = newName;
        this.fullName = newFullName;
        assert (this.fullName != null);
        this.data = me.data;
        this.mimeOverride = me.mimeOverride;
        this.dataSize = me.dataSize;
        this.targetURI = me.targetURI;
    }

    public ManifestElement(String name2, FreenetURI targetURI2, String mimeOverride2) {
        this.name = name2;
        this.fullName = name2;
        this.data = null;
        this.mimeOverride = mimeOverride2;
        this.dataSize = -1L;
        this.targetURI = targetURI2;
        assert (this.targetURI != null);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof ManifestElement && ((ManifestElement)o).name.equals(this.name);
    }

    public void freeData(ObjectContainer container, boolean persistForever) {
        if (this.data != null) {
            if (persistForever) {
                container.activate((Object)this.data, 1);
            }
            this.data.free();
            if (persistForever) {
                this.data.removeFrom(container);
            }
            this.data = null;
        }
        if (persistForever) {
            container.delete((Object)this);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getMimeTypeOverride() {
        return this.mimeOverride;
    }

    public Bucket getData() {
        return this.data;
    }

    public long getSize() {
        return this.dataSize;
    }

    public FreenetURI getTargetURI() {
        return this.targetURI;
    }

    public void removeFrom(ObjectContainer container) {
        container.activate((Object)this.data, 1);
        this.data.removeFrom(container);
        container.activate((Object)this.targetURI, 5);
        this.targetURI.removeFrom(container);
        container.delete((Object)this);
    }
}

