/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Candidate;
import com.db4o.query.Evaluation;
import com.db4o.query.Query;
import freenet.client.async.CooldownQueue;
import freenet.client.async.PersistentCooldownQueueItem;
import freenet.keys.Key;
import freenet.node.SendableGet;
import freenet.support.HexUtil;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class PersistentCooldownQueue
implements CooldownQueue {
    private static volatile transient boolean logMINOR;
    private long cooldownTime;
    private transient LinkedList<PersistentCooldownQueueItem> itemsFromLastTime;
    private static final int KEEP_ITEMS_FROM_LAST_TIME = 1024;

    void setCooldownTime(long time) {
        this.cooldownTime = time;
        this.itemsFromLastTime = new LinkedList();
    }

    @Override
    public long add(Key key, SendableGet client, ObjectContainer container) {
        assert (this.cooldownTime != 0L);
        long removeTime = System.currentTimeMillis() + this.cooldownTime;
        container.activate((Object)key, 5);
        PersistentCooldownQueueItem persistentCooldownQueueItem = new PersistentCooldownQueueItem(client, key.cloneKey(), removeTime, this);
        container.store((Object)persistentCooldownQueueItem);
        return removeTime;
    }

    @Override
    public boolean removeKey(final Key key, final SendableGet client, long time, ObjectContainer container) {
        boolean found = false;
        String keyAsBytes = HexUtil.bytesToHex(key.getFullKey());
        Query query = container.query();
        query.constrain(PersistentCooldownQueueItem.class);
        query.descend("keyAsBytes").constrain((Object)keyAsBytes);
        Evaluation eval = new Evaluation(){
            private static final long serialVersionUID = 1537102695504880276L;

            public void evaluate(Candidate candidate) {
                PersistentCooldownQueueItem item = (PersistentCooldownQueueItem)candidate.getObject();
                if (item.client != client) {
                    candidate.include(false);
                    return;
                }
                if (item.parent != PersistentCooldownQueue.this) {
                    candidate.include(false);
                    return;
                }
                Key k = item.key;
                candidate.objectContainer().activate((Object)k, 5);
                if (k.equals(key)) {
                    candidate.include(true);
                } else {
                    candidate.include(false);
                    candidate.objectContainer().deactivate((Object)k, 5);
                }
            }
        };
        query.constrain((Object)eval);
        ObjectSet results = query.execute();
        while (results.hasNext()) {
            found = true;
            PersistentCooldownQueueItem i = (PersistentCooldownQueueItem)results.next();
            i.delete(container);
            this.itemsFromLastTime.remove(i);
        }
        return found;
    }

    @Override
    public Object removeKeyBefore(long now, long dontCareAfterMillis, ObjectContainer container, int maxCount) {
        return this.removeKeyBefore(now, dontCareAfterMillis, container, maxCount, null);
    }

    public Object removeKeyBefore(long now, long dontCareAfterMillis, ObjectContainer container, int maxCount, PersistentCooldownQueue altQueue) {
        ArrayList<Key> v = null;
        if (!this.itemsFromLastTime.isEmpty()) {
            if (v == null) {
                v = new ArrayList<Key>(Math.min(maxCount, this.itemsFromLastTime.size()));
            }
            Logger.normal(this, "Overflow handling in cooldown queue: reusing items from last time, now " + this.itemsFromLastTime.size());
            Iterator it = this.itemsFromLastTime.iterator();
            while (it.hasNext() && v.size() < maxCount) {
                PersistentCooldownQueueItem i = (PersistentCooldownQueueItem)it.next();
                container.activate((Object)i, 1);
                if (i.parent != this && i.parent != altQueue) {
                    container.deactivate((Object)i, 1);
                    continue;
                }
                if (i.time >= now) {
                    container.deactivate((Object)i, 1);
                    if (v.isEmpty()) {
                        return i.time;
                    }
                    return v.toArray(new Key[v.size()]);
                }
                container.activate((Object)i.key, 5);
                if (i.client == null || !container.ext().isStored((Object)i.client)) {
                    Logger.normal(this, "Client has been removed but not the persistent cooldown queue item: time " + i.time + " for key " + i.key);
                }
                if (i.key == null) {
                    Logger.error(this, "Key is null on cooldown queue! i = " + i + " client=" + i.client + " key as bytes = " + i.keyAsBytes);
                } else {
                    v.add(i.key.cloneKey());
                    i.key.removeFrom(container);
                }
                i.delete(container);
                it.remove();
            }
        }
        if (v != null && v.size() == maxCount) {
            return v.toArray(new Key[v.size()]);
        }
        long tStart = System.currentTimeMillis();
        Query query = container.query();
        query.constrain(PersistentCooldownQueueItem.class);
        query.descend("time").orderAscending().constrain((Object)(now + dontCareAfterMillis)).smaller();
        ObjectSet results = query.execute();
        if (results.hasNext()) {
            PersistentCooldownQueueItem i;
            long tEnd = System.currentTimeMillis();
            if (tEnd - tStart > 1000L) {
                Logger.error(this, "Query took " + (tEnd - tStart) + " for " + results.size());
            } else if (logMINOR) {
                Logger.minor(this, "Query took " + (tEnd - tStart));
            }
            if (v == null) {
                v = new ArrayList(Math.min(maxCount, results.size()));
            }
            while (results.hasNext() && v.size() < maxCount) {
                i = (PersistentCooldownQueueItem)results.next();
                if (i.parent != this && i.parent != altQueue) continue;
                if (i.time >= now) {
                    if (!v.isEmpty()) break;
                    return i.time;
                }
                container.activate((Object)i.key, 5);
                if (i.client == null || !container.ext().isStored((Object)i.client)) {
                    Logger.normal(this, "Client has been removed but not the persistent cooldown queue item: time " + i.time + " for key " + i.key);
                }
                if (i.key == null) {
                    Logger.error(this, "Key is null on cooldown queue! i = " + i + " client=" + i.client + " key as bytes = " + i.keyAsBytes);
                } else {
                    v.add(i.key.cloneKey());
                    i.key.removeFrom(container);
                }
                i.delete(container);
            }
            if (!v.isEmpty()) {
                while (results.hasNext() && this.itemsFromLastTime.size() < 1024) {
                    i = (PersistentCooldownQueueItem)results.next();
                    container.deactivate((Object)i, 1);
                    this.itemsFromLastTime.add(i);
                }
                Logger.normal(this, "Overflow handling in cooldown queue: added items, items from last time now " + this.itemsFromLastTime.size());
                return v.toArray(new Key[v.size()]);
            }
        } else {
            long tEnd = System.currentTimeMillis();
            if (tEnd - tStart > 1000L) {
                Logger.error(this, "Query took " + (tEnd - tStart));
            } else if (logMINOR) {
                Logger.minor(this, "Query took " + (tEnd - tStart));
            }
            return null;
        }
        return null;
    }

    public long size(ObjectContainer container) {
        Query query = container.query();
        query.constrain(PersistentCooldownQueueItem.class);
        query.descend("parent").constrain((Object)this).identity();
        ObjectSet results = query.execute();
        return results.size();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

