/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import freenet.client.async.ClientContext;
import freenet.client.async.DBJob;
import freenet.node.Node;
import freenet.support.BandwidthStatsContainer;
import freenet.support.Logger;
import freenet.support.UptimeContainer;

public class PersistentStatsPutter
implements DBJob {
    public static final int OFFSET = 60000;
    private Node n;
    private long latestNodeBytesOut = 0L;
    private long latestNodeBytesIn = 0L;
    private long latestUptimeVal = 0L;
    private BandwidthStatsContainer latestBW = new BandwidthStatsContainer();
    private UptimeContainer latestUptime = new UptimeContainer();

    public PersistentStatsPutter(Node n) {
        this.n = n;
    }

    public void restorePreviousData(ObjectContainer container) {
        BandwidthStatsContainer storedBSC = null;
        ObjectSet BSCresult = container.query(BandwidthStatsContainer.class);
        for (BandwidthStatsContainer candidate : BSCresult) {
            if (candidate == null) {
                Logger.error(this, "DB4O BUG??? Querying for BandwidthStatsContainer returned null");
                continue;
            }
            storedBSC = candidate;
            break;
        }
        if (storedBSC == null) {
            storedBSC = new BandwidthStatsContainer();
        }
        this.latestBW = storedBSC;
        UptimeContainer storedUC = null;
        ObjectSet UptimeResult = container.query(UptimeContainer.class);
        for (UptimeContainer candidate : UptimeResult) {
            if (candidate == null) {
                Logger.error(this, "DB4O BUG??? Querying for UptimeResult returned null");
                continue;
            }
            storedUC = candidate;
            break;
        }
        if (storedUC == null) {
            storedUC = new UptimeContainer();
        }
        this.latestUptime = storedUC;
    }

    public BandwidthStatsContainer getLatestBWData() {
        return this.latestBW;
    }

    public UptimeContainer getLatestUptimeData() {
        return this.latestUptime;
    }

    public void updateData() {
        long[] nodeBW = this.n.collector.getTotalIO();
        this.latestBW.totalBytesOut += nodeBW[0] - this.latestNodeBytesOut;
        this.latestBW.totalBytesIn += nodeBW[1] - this.latestNodeBytesIn;
        this.latestBW.creationTime = System.currentTimeMillis();
        this.latestNodeBytesOut = nodeBW[0];
        this.latestNodeBytesIn = nodeBW[1];
        long uptime = this.n.getUptime();
        this.latestUptime.totalUptime += uptime - this.latestUptimeVal;
        this.latestUptime.creationTime = System.currentTimeMillis();
        this.latestUptimeVal = uptime;
    }

    @Override
    public boolean run(ObjectContainer container, ClientContext context) {
        this.updateData();
        container.store((Object)this.latestBW);
        container.store((Object)this.latestUptime);
        return false;
    }
}

