/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientRequester;
import freenet.client.async.CooldownQueue;
import freenet.keys.Key;
import freenet.node.SendableGet;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class RequestCooldownQueue
implements CooldownQueue {
    private Key[] keys = new Key[128];
    private long[] times = new long[128];
    private SendableGet[] clients = new SendableGet[128];
    int holes = 0;
    int startPtr = 0;
    int endPtr = 0;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    static final int MIN_SIZE = 128;
    final long cooldownTime;
    private static final String DEBUG_TARGET_URI = "CHK@.../chaosradio_131.mp3";

    RequestCooldownQueue(long cooldownTime) {
        this.cooldownTime = cooldownTime;
    }

    @Override
    public synchronized long add(Key key, SendableGet client, ObjectContainer container) {
        long removeTime = System.currentTimeMillis() + this.cooldownTime;
        if (removeTime < this.getLastTime()) {
            removeTime = this.getLastTime();
            Logger.error(this, "CLOCK SKEW DETECTED!!! Attempting to compensate, expect things to break!");
        }
        this.add(key, client, removeTime);
        return removeTime;
    }

    private synchronized long getLastTime() {
        if (this.startPtr == this.endPtr) {
            return -1L;
        }
        if (this.endPtr > 0) {
            return this.times[this.endPtr - 1];
        }
        return this.times[this.times.length - 1];
    }

    private synchronized void add(Key key, SendableGet client, long removeTime) {
        if (this.holes < 0) {
            Logger.error(this, "holes = " + this.holes + " !!");
        }
        if (logMINOR) {
            Logger.minor(this, "Adding key " + key + " client " + client + " remove time " + removeTime + " startPtr=" + this.startPtr + " endPtr=" + this.endPtr + " keys.length=" + this.keys.length);
        }
        int ptr = this.endPtr;
        if (this.endPtr > this.startPtr) {
            if (logMINOR) {
                Logger.minor(this, "endPtr > startPtr");
            }
            if (this.endPtr == this.keys.length - 1) {
                if (this.startPtr == 0) {
                    this.expandQueue();
                    this.add(key, client, null);
                    return;
                }
                this.endPtr = 0;
            } else {
                ++this.endPtr;
            }
        } else if (this.endPtr < this.startPtr) {
            if (logMINOR) {
                Logger.minor(this, "endPtr < startPtr");
            }
            if (this.endPtr == this.startPtr - 1) {
                this.expandQueue();
                this.add(key, client, null);
                return;
            }
            ++this.endPtr;
        } else {
            if (logMINOR) {
                Logger.minor(this, "endPtr == startPtr");
            }
            this.endPtr = 1;
            this.startPtr = 0;
            ptr = 0;
        }
        if (logMINOR) {
            Logger.minor(this, "Added at " + ptr + " startPtr=" + this.startPtr + " endPtr=" + this.endPtr);
        }
        this.keys[ptr] = key;
        this.times[ptr] = removeTime;
        this.clients[ptr] = client;
    }

    @Override
    public synchronized Object removeKeyBefore(long now, long dontCareAfterMillis, ObjectContainer container, int maxKeys) {
        ArrayList<Key> v = new ArrayList<Key>();
        boolean foundIT = false;
        if (logDEBUG) {
            foundIT = this.bigLog();
        }
        if (logMINOR) {
            Logger.minor(this, "Remove key before " + now + " : startPtr=" + this.startPtr + " endPtr=" + this.endPtr + " holes=" + this.holes + " keys.length=" + this.keys.length);
        }
        if (this.holes < 0) {
            Logger.error(this, "holes = " + this.holes + " !!");
        }
        if (foundIT && logMINOR) {
            Logger.minor(this, "FOUND IT!");
        }
        while (true) {
            if (this.startPtr == this.endPtr) {
                if (logMINOR) {
                    Logger.minor(this, "No keys queued");
                }
                if (!v.isEmpty()) {
                    return v.toArray(new Key[v.size()]);
                }
                return null;
            }
            long time = this.times[this.startPtr];
            Key key = this.keys[this.startPtr];
            if (key == null) {
                this.times[this.startPtr] = 0L;
                this.clients[this.startPtr] = null;
                ++this.startPtr;
                --this.holes;
                if (this.startPtr == this.times.length) {
                    this.startPtr = 0;
                }
                if (!logMINOR) continue;
                Logger.minor(this, "Skipped hole");
                continue;
            }
            if (time > now) {
                if (logMINOR) {
                    Logger.minor(this, "First key is later at time " + time);
                }
                if (!v.isEmpty()) {
                    return v.toArray(new Key[v.size()]);
                }
                if (time < now + dontCareAfterMillis) {
                    return time;
                }
                return null;
            }
            this.times[this.startPtr] = 0L;
            this.keys[this.startPtr] = null;
            this.clients[this.startPtr] = null;
            ++this.startPtr;
            if (this.startPtr == this.times.length) {
                this.startPtr = 0;
            }
            if (logMINOR) {
                Logger.minor(this, "Returning key " + key);
            }
            v.add(key);
            if (v.size() == maxKeys) break;
        }
        return v.toArray(new Key[v.size()]);
    }

    private boolean bigLog() {
        ClientRequester cr;
        boolean foundIT = false;
        if (this.clients[this.startPtr] != null && (cr = this.clients[this.startPtr].parent) instanceof ClientGetter) {
            String s = ((ClientGetter)cr).getURI().toShortString();
            if (logMINOR) {
                Logger.minor(this, "client = " + s);
            }
            if (s.equals(DEBUG_TARGET_URI)) {
                foundIT = true;
            }
        }
        HashMap<String, Integer> countsByShortURI = new HashMap<String, Integer>();
        int nulls = 0;
        int nullClients = 0;
        int notGetter = 0;
        int valid = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) {
                ++nulls;
                continue;
            }
            if (this.clients[i] == null) {
                ++nullClients;
                continue;
            }
            ++valid;
            ClientRequester cr2 = this.clients[i].parent;
            if (cr2 instanceof ClientGetter) {
                String shortURI = ((ClientGetter)cr2).getURI().toShortString();
                Integer ctr = (Integer)countsByShortURI.get(shortURI);
                ctr = ctr == null ? Integer.valueOf(1) : Integer.valueOf(ctr + 1);
                countsByShortURI.put(shortURI, ctr);
                continue;
            }
            ++notGetter;
        }
        return foundIT;
    }

    @Override
    public synchronized boolean removeKey(Key key, SendableGet client, long time, ObjectContainer container) {
        if (time <= 0L) {
            return false;
        }
        if (this.holes < 0) {
            Logger.error(this, "holes = " + this.holes + " !!");
        }
        if (logMINOR) {
            Logger.minor(this, "Remove key " + key + " client " + client + " at time " + time + " startPtr=" + this.startPtr + " endPtr=" + this.endPtr + " holes=" + this.holes + " keys.length=" + this.keys.length);
        }
        int idx = -1;
        if (this.endPtr > this.startPtr) {
            idx = Arrays.binarySearch(this.times, this.startPtr, this.endPtr, time);
        } else {
            if (this.endPtr == this.startPtr) {
                if (logMINOR) {
                    Logger.minor(this, "No keys queued");
                }
                return false;
            }
            if (this.startPtr != this.times.length - 1) {
                idx = Arrays.binarySearch(this.times, this.startPtr, this.times.length, time);
            }
            if (idx < 0 && this.startPtr != 0) {
                idx = Arrays.binarySearch(this.times, 0, this.endPtr, time);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "idx = " + idx);
        }
        if (idx < 0) {
            return false;
        }
        if (this.keys[idx] == key && this.clients[idx] == client) {
            this.keys[idx] = null;
            this.clients[idx] = null;
            ++this.holes;
            if (logMINOR) {
                Logger.minor(this, "Found (exact)");
            }
            return true;
        }
        int nidx = idx;
        while (this.times[nidx] == time) {
            if (this.keys[nidx] == key && this.clients[nidx] == client) {
                this.keys[nidx] = null;
                this.clients[nidx] = null;
                ++this.holes;
                if (logMINOR) {
                    Logger.minor(this, "Found (backwards)");
                }
                return true;
            }
            if (nidx == this.startPtr) break;
            if (--nidx != -1) continue;
            nidx = this.times.length - 1;
        }
        nidx = idx;
        while (this.times[nidx] == time) {
            if (this.keys[nidx] == key && this.clients[nidx] == client) {
                this.keys[nidx] = null;
                this.clients[nidx] = null;
                ++this.holes;
                if (logMINOR) {
                    Logger.minor(this, "Found (forwards)");
                }
                return true;
            }
            if (nidx == this.endPtr) break;
            if (++nidx != this.times.length) continue;
            nidx = 0;
        }
        if (logMINOR) {
            Logger.minor(this, "Not found");
        }
        return false;
    }

    private synchronized void expandQueue() {
        int newSize;
        if (logMINOR) {
            Logger.minor(this, "Expanding queue");
        }
        if (this.holes < 0) {
            Logger.error(this, "holes = " + this.holes + " !!");
            this.holes = 0;
        }
        if ((newSize = (this.keys.length - this.holes) * 2) < 128) {
            newSize = 128;
        }
        Key[] newKeys = new Key[newSize];
        long[] newTimes = new long[newSize];
        SendableGet[] newClients = new SendableGet[newSize];
        int x = 0;
        long lastTime = -1L;
        if (this.endPtr > this.startPtr) {
            for (int i = this.startPtr; i < this.endPtr; ++i) {
                if (this.keys[i] == null) continue;
                newKeys[x] = this.keys[i];
                newTimes[x] = this.times[i];
                newClients[x] = this.clients[i];
                if (lastTime > this.times[i]) {
                    Logger.error(this, "RequestCooldownQueue INCONSISTENCY: times[" + i + "] = times[i] but lastTime=" + lastTime);
                }
                lastTime = this.times[i];
                ++x;
            }
        } else if (this.endPtr < this.startPtr) {
            int i;
            for (i = this.startPtr; i < this.keys.length; ++i) {
                if (this.keys[i] == null) continue;
                newKeys[x] = this.keys[i];
                newTimes[x] = this.times[i];
                newClients[x] = this.clients[i];
                if (lastTime > this.times[i]) {
                    Logger.error(this, "RequestCooldownQueue INCONSISTENCY: times[" + i + "] = times[i] but lastTime=" + lastTime);
                }
                lastTime = this.times[i];
                ++x;
            }
            for (i = 0; i < this.endPtr; ++i) {
                if (this.keys[i] == null) continue;
                newKeys[x] = this.keys[i];
                newTimes[x] = this.times[i];
                newClients[x] = this.clients[i];
                if (lastTime > this.times[i]) {
                    Logger.error(this, "RequestCooldownQueue INCONSISTENCY: times[" + i + "] = times[i] but lastTime=" + lastTime);
                }
                lastTime = this.times[i];
                ++x;
            }
        } else {
            Logger.error(this, "RequestCooldownQueue: expandQueue() called with endPtr == startPtr == " + this.startPtr + " !!");
            return;
        }
        this.holes = 0;
        this.startPtr = 0;
        this.keys = newKeys;
        this.times = newTimes;
        this.clients = newClients;
        this.endPtr = x;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }
}

