/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.async.BaseSingleFileFetcher;
import freenet.client.async.ClientContext;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListener;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.NodeSSK;
import freenet.node.LowLevelGetException;
import freenet.node.SendableGet;
import freenet.support.Logger;

public class SingleKeyListener
implements KeyListener {
    private final Key key;
    private final BaseSingleFileFetcher fetcher;
    private boolean done;
    private short prio;
    private final boolean persistent;
    private final boolean realTime;

    public SingleKeyListener(Key key, BaseSingleFileFetcher fetcher, short prio, boolean persistent, boolean realTime) {
        this.key = key;
        this.fetcher = fetcher;
        this.prio = prio;
        this.persistent = persistent;
        this.realTime = realTime;
    }

    @Override
    public long countKeys() {
        if (this.done) {
            return 0L;
        }
        return 1L;
    }

    @Override
    public short definitelyWantKey(Key key, byte[] saltedKey, ObjectContainer container, ClientContext context) {
        if (!key.equals(this.key)) {
            return -1;
        }
        return this.prio;
    }

    @Override
    public HasKeyListener getHasKeyListener() {
        return this.fetcher;
    }

    @Override
    public short getPriorityClass(ObjectContainer container) {
        return this.prio;
    }

    @Override
    public SendableGet[] getRequestsForKey(Key key, byte[] saltedKey, ObjectContainer container, ClientContext context) {
        if (!key.equals(this.key)) {
            return null;
        }
        return new SendableGet[]{this.fetcher};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleBlock(Key key, byte[] saltedKey, KeyBlock found, ObjectContainer container, ClientContext context) {
        if (!key.equals(this.key)) {
            return false;
        }
        if (this.persistent) {
            container.activate((Object)this.fetcher, 1);
        }
        try {
            this.fetcher.onGotKey(key, found, container, context);
        }
        catch (Throwable t) {
            Logger.error(this, "Failed: " + t, t);
            this.fetcher.onFailure(new LowLevelGetException(3), null, container, context);
        }
        if (this.persistent) {
            container.deactivate((Object)this.fetcher, 1);
        }
        SingleKeyListener singleKeyListener = this;
        synchronized (singleKeyListener) {
            this.done = true;
        }
        return true;
    }

    public Key[] listKeys(ObjectContainer container) {
        return new Key[]{this.key};
    }

    @Override
    public boolean persistent() {
        return this.persistent;
    }

    @Override
    public boolean probablyWantKey(Key key, byte[] saltedKey) {
        if (this.done) {
            return false;
        }
        return key.equals(this.key);
    }

    @Override
    public synchronized void onRemove() {
        this.done = true;
    }

    @Override
    public boolean isEmpty() {
        return this.done;
    }

    @Override
    public boolean isSSK() {
        return this.key instanceof NodeSSK;
    }

    @Override
    public boolean isRealTime() {
        return this.realTime;
    }
}

