/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.FECCallback;
import freenet.client.FECCodec;
import freenet.client.FECJob;
import freenet.client.FECQueue;
import freenet.client.FetchException;
import freenet.client.SplitfileBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequester;
import freenet.client.async.MinimalSplitfileBlock;
import freenet.client.async.SplitFileFetcher;
import freenet.client.async.SplitFileFetcherSegment;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;

public class SplitFileFetcherCrossSegment
implements FECCallback {
    private static volatile boolean logMINOR;
    private final SplitFileFetcherSegment[] segments;
    private final SplitFileFetcher splitFetcher;
    private final int[] blockNumbers;
    private final boolean[] blocksFound;
    final int dataBlocks;
    final int crossCheckBlocks;
    final boolean persistent;
    final short splitfileType;
    final ClientRequester parent;
    private boolean finishedEncoding;
    private boolean startedDecoding;
    private boolean startedEncoding;
    private boolean shouldRemove;
    private transient int counter;
    private transient FECCodec codec;

    public SplitFileFetcherCrossSegment(boolean persistent, int blocksPerSegment, int crossCheckBlocks, ClientRequester parent, SplitFileFetcher fetcher, short splitfileType) {
        this.persistent = persistent;
        this.dataBlocks = blocksPerSegment;
        this.crossCheckBlocks = crossCheckBlocks;
        this.parent = parent;
        this.splitfileType = splitfileType;
        int totalBlocks = this.dataBlocks + crossCheckBlocks;
        this.segments = new SplitFileFetcherSegment[totalBlocks];
        this.blockNumbers = new int[totalBlocks];
        this.blocksFound = new boolean[totalBlocks];
        this.splitFetcher = fetcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFetched(SplitFileFetcherSegment segment, int blockNo, ObjectContainer container, ClientContext context) {
        SplitFileFetcherCrossSegment splitFileFetcherCrossSegment = this;
        synchronized (splitFileFetcherCrossSegment) {
            boolean found = false;
            int totalFound = 0;
            for (int i = 0; i < this.segments.length; ++i) {
                if (this.segments[i] == segment && this.blockNumbers[i] == blockNo) {
                    found = true;
                    if (this.blocksFound[i]) {
                        return;
                    }
                    this.blocksFound[i] = true;
                }
                if (!this.blocksFound[i]) continue;
                ++totalFound;
            }
            if (this.persistent) {
                container.store((Object)this);
            }
            if (this.shouldRemove || this.finishedEncoding || this.startedDecoding || this.startedEncoding) {
                return;
            }
            if (!found) {
                Logger.error(this, "Block " + blockNo + " on " + segment + " not wanted by " + this);
                return;
            }
            if (totalFound < this.dataBlocks) {
                Logger.normal(this, "Not decoding " + this + " : found " + totalFound + " blocks of " + this.dataBlocks + " (total " + this.segments.length + ")");
                return;
            }
        }
        if (!this.decodeOrEncode(segment, container, context)) {
            boolean bye;
            SplitFileFetcherCrossSegment splitFileFetcherCrossSegment2 = this;
            synchronized (splitFileFetcherCrossSegment2) {
                bye = this.shouldRemove;
                this.finishedEncoding = true;
            }
            if (logMINOR) {
                Logger.minor(this, "Finished as nothing to encode/decode in onFetched on " + this);
            }
            if (bye) {
                this.onFinished(container, context);
            } else if (this.persistent) {
                container.store((Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean decodeOrEncode(SplitFileFetcherSegment segment, ObjectContainer container, ClientContext context) {
        boolean needsDecode = false;
        boolean needsEncode = false;
        SplitfileBlock[] decodeData = new SplitfileBlock[this.dataBlocks];
        SplitfileBlock[] decodeCheck = new SplitfileBlock[this.segments.length - this.dataBlocks];
        for (int i = 0; i < this.segments.length; ++i) {
            boolean found;
            MinimalSplitfileBlock wrapper = new MinimalSplitfileBlock(i);
            SplitFileFetcherCrossSegment splitFileFetcherCrossSegment = this;
            synchronized (splitFileFetcherCrossSegment) {
                found = this.blocksFound[i];
            }
            if (found) {
                Bucket data;
                SplitFileFetcherSegment seg = this.segments[i];
                boolean active = true;
                if (seg != segment && this.persistent && !(active = container.ext().isActive((Object)seg))) {
                    container.activate((Object)seg, 1);
                }
                if ((data = seg.getBlockBucket(this.blockNumbers[i], container)) == null) {
                    Logger.error(this, "Cannot decode/encode: Found block " + i + " : " + this.blockNumbers[i] + " of " + this.segments[i] + " but is gone now!", (Throwable)new Exception("error"));
                    data = seg.getBlockBucket(this.blockNumbers[i], container);
                    if (data == null) {
                        if (seg.isFinished(container)) {
                            Logger.error(this, "SEGMENT IS FINISHED ALREADY when trying to decode/encode splitfile block: " + this.segments[i]);
                        } else if (seg.isFinishing(container)) {
                            Logger.error(this, "SEGMENT IS FINISHING ALREADY when trying to decode/encode splitfile block: " + this.segments[i]);
                        }
                        if (seg.hasBlockWrapper(this.blockNumbers[i])) {
                            Logger.error(this, "SEGMENT HAS BLOCK WRAPPER BUT NOT BUCKET: " + seg);
                        }
                        Logger.error(this, "Cannot decode/encode: Found block " + i + " : " + this.blockNumbers[i] + " of " + this.segments[i] + " but is gone now!", (Throwable)new Exception("error"));
                        SplitFileFetcher fetcher = this.getFetcher(container);
                        if (fetcher != null) {
                            container.activate((Object)fetcher, 1);
                            fetcher.onFailed(new FetchException(17, "Cannot decode/encode cross blocks: lost a block"), container, context);
                        }
                        return false;
                    }
                    Logger.error(this, "Synchronization bug: got the bucket the second time?!");
                }
                wrapper.assertSetData(data);
                if (this.persistent) {
                    container.activate((Object)data, Integer.MAX_VALUE);
                }
                if (!active) {
                    container.deactivate((Object)seg, 1);
                }
                if (this.persistent) {
                    wrapper.storeTo(container);
                }
            } else if (i < this.dataBlocks) {
                needsDecode = true;
            } else {
                needsEncode = true;
            }
            if (i < this.dataBlocks) {
                decodeData[i] = wrapper;
                continue;
            }
            decodeCheck[i - this.dataBlocks] = wrapper;
        }
        if (!needsDecode && !needsEncode) {
            return false;
        }
        SplitFileFetcherCrossSegment i = this;
        synchronized (i) {
            if (needsDecode) {
                if (this.startedDecoding) {
                    if (logMINOR) {
                        Logger.minor(this, "Not starting decoding, already started, on " + this);
                    }
                    return true;
                }
                this.startedDecoding = true;
                if (this.persistent) {
                    container.store((Object)this);
                }
                if (logMINOR) {
                    Logger.minor(this, "Starting decoding on " + this);
                }
            } else {
                if (this.startedEncoding) {
                    if (logMINOR) {
                        Logger.minor(this, "Not starting encoding, already started, on " + this);
                    }
                    return true;
                }
                this.startedEncoding = true;
                if (this.persistent) {
                    container.store((Object)this);
                }
                if (logMINOR) {
                    Logger.minor(this, "Starting encoding on " + this);
                }
            }
        }
        FECQueue queue = context.fecQueue;
        if (this.codec == null) {
            this.codec = FECCodec.getCodec(this.splitfileType, this.dataBlocks, decodeCheck.length);
        }
        FECJob job = new FECJob(this.codec, queue, decodeData, decodeCheck, 32768, context.getBucketFactory(this.persistent), (FECCallback)this, needsDecode, this.getPriorityClass(container), this.persistent);
        this.codec.addToQueue(job, queue, container);
        return true;
    }

    private short getPriorityClass(ObjectContainer container) {
        boolean parentActive = true;
        if (this.persistent && !(parentActive = container.ext().isActive((Object)this.parent))) {
            container.activate((Object)this.parent, 1);
        }
        short ret = this.parent.getPriorityClass();
        if (!parentActive) {
            container.deactivate((Object)this.parent, 1);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDecodedSegment(ObjectContainer container, ClientContext context, FECJob job, Bucket[] dataBuckets, Bucket[] checkBuckets, SplitfileBlock[] dataBlocks, SplitfileBlock[] checkBlocks) {
        if (logMINOR) {
            Logger.minor(this, "Decoded segment on " + this);
        }
        for (int i = 0; i < dataBlocks.length; ++i) {
            boolean found;
            Bucket data = dataBlocks[i].getData();
            SplitFileFetcherCrossSegment splitFileFetcherCrossSegment = this;
            synchronized (splitFileFetcherCrossSegment) {
                found = this.blocksFound[i];
            }
            SplitFileFetcherSegment seg = this.segments[i];
            boolean active = true;
            if (this.persistent && !(active = container.ext().isActive((Object)seg))) {
                container.activate((Object)seg, 1);
            }
            if (found) {
                Bucket segData = seg.getBlockBucket(this.blockNumbers[i], container);
                if (segData != data) {
                    if (this.persistent && container.ext().getID((Object)segData) == container.ext().getID((Object)data)) {
                        Logger.error(this, "SAME ID BUG FOUND IN CROSS SEGMENT DECODE: " + segData + " has same ID as " + data);
                    } else {
                        data.free();
                        if (this.persistent) {
                            data.removeFrom(container);
                        }
                    }
                }
            } else {
                this.blocksFound[i] = true;
                if (seg.onSuccess(data, this.blockNumbers[i], null, container, context, null)) {
                    Logger.normal(this, "Cross-segment decoded a block.");
                }
            }
            if (!active) {
                container.deactivate((Object)seg, 1);
            }
            dataBlocks[i].clearData();
            if (!this.persistent) continue;
            container.delete((Object)dataBlocks[i]);
        }
        boolean bye = false;
        SplitFileFetcherCrossSegment splitFileFetcherCrossSegment = this;
        synchronized (splitFileFetcherCrossSegment) {
            if (this.shouldRemove) {
                bye = true;
                this.finishedEncoding = true;
                if (logMINOR) {
                    Logger.minor(this, "Finished as cancelled in decoded segment on " + this);
                }
            }
        }
        if (bye) {
            this.onFinished(container, context);
        } else if (!this.decodeOrEncode(null, container, context)) {
            splitFileFetcherCrossSegment = this;
            synchronized (splitFileFetcherCrossSegment) {
                bye = this.shouldRemove;
                this.finishedEncoding = true;
            }
            if (logMINOR) {
                Logger.minor(this, "Finished as nothing to encode/decode in decoded segment on " + this);
            }
            if (bye) {
                this.onFinished(container, context);
            } else if (this.persistent) {
                container.store((Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEncodedSegment(ObjectContainer container, ClientContext context, FECJob job, Bucket[] dataBuckets, Bucket[] checkBuckets, SplitfileBlock[] dataBlocks, SplitfileBlock[] checkBlocks) {
        if (logMINOR) {
            Logger.minor(this, "Encoded segment on " + this);
        }
        for (int i = 0; i < checkBlocks.length; ++i) {
            boolean found;
            Bucket data = checkBlocks[i].getData();
            int num = this.dataBlocks + i;
            SplitFileFetcherCrossSegment splitFileFetcherCrossSegment = this;
            synchronized (splitFileFetcherCrossSegment) {
                found = this.blocksFound[num];
                if (data == null) {
                    Logger.error(this, "Check block " + i + " is null in onEncodedSegment on " + this + " - shouldRemove = " + this.shouldRemove);
                    continue;
                }
            }
            SplitFileFetcherSegment seg = this.segments[num];
            boolean active = true;
            if (this.persistent && !(active = container.ext().isActive((Object)seg))) {
                container.activate((Object)seg, 1);
            }
            if (found) {
                Bucket segData = seg.getBlockBucket(this.blockNumbers[i], container);
                if (segData != data) {
                    if (this.persistent && container.ext().getID((Object)segData) == container.ext().getID((Object)data)) {
                        Logger.error(this, "SAME ID BUG FOUND IN CROSS SEGMENT DECODE: " + segData + " has same ID as " + data);
                    } else {
                        data.free();
                        if (this.persistent) {
                            data.removeFrom(container);
                        }
                    }
                }
            } else if (seg.onSuccess(data, this.blockNumbers[num], null, container, context, null)) {
                Logger.normal(this, "Cross-segment encoded a block.");
            }
            if (!active) {
                container.deactivate((Object)seg, 1);
            }
            checkBlocks[i].clearData();
            if (!this.persistent) continue;
            container.delete((Object)checkBlocks[i]);
        }
        boolean bye = false;
        SplitFileFetcherCrossSegment splitFileFetcherCrossSegment = this;
        synchronized (splitFileFetcherCrossSegment) {
            this.finishedEncoding = true;
            bye = this.shouldRemove;
        }
        if (logMINOR) {
            Logger.minor(this, "Finished encoding on " + this);
        }
        if (bye) {
            this.onFinished(container, context);
        } else if (this.persistent) {
            container.store((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailed(Throwable t, ObjectContainer container, ClientContext context) {
        SplitFileFetcherCrossSegment splitFileFetcherCrossSegment = this;
        synchronized (splitFileFetcherCrossSegment) {
            if (this.finishedEncoding) {
                Logger.error(this, "Failed but already finished, ignoring on " + this, t);
                return;
            }
        }
        Logger.error(this, "Encode or decode failed for cross segment: " + this, t);
        SplitFileFetcher fetcher = this.getFetcher(container);
        if (this.persistent) {
            container.activate((Object)fetcher, 1);
        }
        fetcher.onFailed(new FetchException(17, t), container, context);
    }

    public void addDataBlock(SplitFileFetcherSegment seg, int blockNum) {
        this.segments[this.counter] = seg;
        this.blockNumbers[this.counter] = blockNum;
        ++this.counter;
    }

    public void storeTo(ObjectContainer container) {
        container.store((Object)this);
    }

    public void onFinished(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Finished on " + this);
        }
        assert (this.finishedEncoding);
        SplitFileFetcher fetcher = this.getFetcher(container);
        if (fetcher == null) {
            return;
        }
        boolean active = container.ext().isActive((Object)fetcher);
        if (this.persistent && !active) {
            container.activate((Object)fetcher, 1);
        }
        if (!fetcher.onFinishedCrossSegment(container, context, this) && this.persistent) {
            container.store((Object)this);
        }
        if (this.persistent && !active) {
            container.deactivate((Object)fetcher, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRemove(ObjectContainer container, ClientContext context) {
        SplitFileFetcherCrossSegment splitFileFetcherCrossSegment = this;
        synchronized (splitFileFetcherCrossSegment) {
            this.shouldRemove = true;
            if (!this.startedDecoding && !this.startedEncoding) {
                this.finishedEncoding = true;
                this.startedDecoding = true;
                this.startedEncoding = true;
            }
        }
        container.store((Object)this);
    }

    public void removeFrom(ObjectContainer container, ClientContext context) {
        container.delete((Object)this);
    }

    private SplitFileFetcher getFetcher(ObjectContainer container) {
        if (this.splitFetcher != null) {
            return this.splitFetcher;
        }
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i] == null) continue;
            boolean active = true;
            if (this.persistent) {
                active = container.ext().isActive((Object)this.segments[i]);
                container.activate((Object)this.segments[i], 1);
            }
            SplitFileFetcher fetcher = this.segments[i].parentFetcher;
            if (!active) {
                container.deactivate((Object)this.segments[i], 1);
            }
            return fetcher;
        }
        return null;
    }

    public boolean isFinished() {
        return this.finishedEncoding;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

