/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveManager;
import freenet.client.ClientMetadata;
import freenet.client.FECCodec;
import freenet.client.FailureCodeTracker;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutState;
import freenet.client.async.PutCompletionCallback;
import freenet.client.async.SplitFileInserterCrossSegment;
import freenet.client.async.SplitFileInserterSegment;
import freenet.crypt.HashResult;
import freenet.keys.ClientCHK;
import freenet.support.Executor;
import freenet.support.HexUtil;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.compress.Compressor;
import freenet.support.io.BucketTools;
import freenet.support.math.MersenneTwister;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;

public class SplitFileInserter
implements ClientPutState {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    final BaseClientPutter parent;
    final InsertContext ctx;
    final PutCompletionCallback cb;
    final long dataLength;
    final Compressor.COMPRESSOR_TYPE compressionCodec;
    final short splitfileAlgorithm;
    final int segmentSize;
    final int deductBlocksFromSegments;
    final int checkSegmentSize;
    final SplitFileInserterSegment[] segments;
    final boolean getCHKOnly;
    final int countCheckBlocks;
    final int countDataBlocks;
    private boolean haveSentMetadata;
    final ClientMetadata cm;
    final boolean isMetadata;
    private volatile boolean finished;
    private boolean fetchable;
    public final Object token;
    final ArchiveManager.ARCHIVE_TYPE archiveType;
    private boolean forceEncode;
    private final long decompressedLength;
    final boolean persistent;
    final HashResult[] hashes;
    final byte[] hashThisLayerOnly;
    private byte splitfileCryptoAlgorithm;
    private byte[] splitfileCryptoKey;
    private final boolean specifySplitfileKeyInMetadata;
    private final boolean realTimeFlag;
    public final long topSize;
    public final long topCompressedSize;
    private final int crossCheckBlocks;
    private final SplitFileInserterCrossSegment[] crossSegments;
    private final int hashCode;

    public int hashCode() {
        return this.hashCode;
    }

    private SplitFileInserter() {
        this.topSize = 0L;
        this.topCompressedSize = 0L;
        this.token = null;
        this.splitfileAlgorithm = 0;
        this.specifySplitfileKeyInMetadata = false;
        this.segments = null;
        this.segmentSize = 0;
        this.persistent = false;
        this.parent = null;
        this.isMetadata = false;
        this.hashes = null;
        this.hashThisLayerOnly = null;
        this.hashCode = 0;
        this.getCHKOnly = false;
        this.deductBlocksFromSegments = 0;
        this.decompressedLength = 0L;
        this.dataLength = 0L;
        this.ctx = null;
        this.crossSegments = null;
        this.crossCheckBlocks = 0;
        this.countDataBlocks = 0;
        this.countCheckBlocks = 0;
        this.compressionCodec = null;
        this.cm = null;
        this.checkSegmentSize = 0;
        this.cb = null;
        this.archiveType = null;
        this.realTimeFlag = false;
    }

    public SplitFileInserter(BaseClientPutter put, PutCompletionCallback cb, Bucket data, Compressor.COMPRESSOR_TYPE bestCodec, long decompressedLength, ClientMetadata clientMetadata, InsertContext ctx, boolean getCHKOnly, boolean isMetadata, Object token, ArchiveManager.ARCHIVE_TYPE archiveType, boolean freeData, boolean persistent, boolean realTimeFlag, ObjectContainer container, ClientContext context, HashResult[] hashes, byte[] hashThisLayerOnly, long origTopSize, long origTopCompressedSize, byte cryptoAlgorithm, byte[] splitfileKey) throws InsertException {
        int i;
        int segs;
        Bucket[] dataBuckets;
        this.hashCode = super.hashCode();
        if (put == null) {
            throw new NullPointerException();
        }
        this.parent = put;
        this.realTimeFlag = realTimeFlag;
        this.archiveType = archiveType;
        this.compressionCodec = bestCodec;
        this.token = token;
        this.finished = false;
        this.isMetadata = isMetadata;
        this.cm = clientMetadata;
        this.getCHKOnly = getCHKOnly;
        this.cb = cb;
        this.ctx = ctx;
        this.decompressedLength = decompressedLength;
        this.dataLength = data.size();
        this.hashes = hashes;
        this.topSize = origTopSize;
        this.topCompressedSize = origTopCompressedSize;
        this.hashThisLayerOnly = hashThisLayerOnly;
        context.jobRunner.setCommitThisTransaction();
        try {
            dataBuckets = BucketTools.split(data, 32768, persistent ? context.persistentBucketFactory : context.tempBucketFactory, freeData, persistent, container);
            if (dataBuckets[dataBuckets.length - 1].size() < 32768L) {
                Bucket oldData = dataBuckets[dataBuckets.length - 1];
                dataBuckets[dataBuckets.length - 1] = BucketTools.pad(oldData, 32768, context.getBucketFactory(persistent), (int)oldData.size());
                if (persistent) {
                    dataBuckets[dataBuckets.length - 1].storeTo(container);
                }
                oldData.free();
                if (persistent) {
                    oldData.removeFrom(container);
                }
            }
            if (logMINOR) {
                Logger.minor(this, "Data size " + data.size() + " buckets " + dataBuckets.length);
            }
        }
        catch (IOException e) {
            throw new InsertException(2, e, null);
        }
        this.countDataBlocks = dataBuckets.length;
        this.splitfileAlgorithm = ctx.splitfileAlgorithm;
        InsertContext.CompatibilityMode cmode = ctx.getCompatibilityMode();
        if (cmode == InsertContext.CompatibilityMode.COMPAT_1250_EXACT) {
            segs = (this.countDataBlocks + 128 - 1) / 128;
            this.segmentSize = 128;
            this.deductBlocksFromSegments = 0;
        } else {
            segs = cmode == InsertContext.CompatibilityMode.COMPAT_1251 ? (this.countDataBlocks + 131 - 1) / 131 : (this.countDataBlocks > 520 ? (this.countDataBlocks + 128 - 1) / 128 : (this.countDataBlocks > 393 ? 4 : (this.countDataBlocks > 266 ? 3 : (this.countDataBlocks > 136 ? 2 : 1))));
            int segSize = (this.countDataBlocks + segs - 1) / segs;
            if (ctx.splitfileSegmentDataBlocks < segSize) {
                segs = (this.countDataBlocks + ctx.splitfileSegmentDataBlocks - 1) / ctx.splitfileSegmentDataBlocks;
                segSize = (this.countDataBlocks + segs - 1) / segs;
            }
            this.segmentSize = segSize;
            if (cmode == InsertContext.CompatibilityMode.COMPAT_CURRENT || cmode.ordinal() >= InsertContext.CompatibilityMode.COMPAT_1255.ordinal()) {
                int lastSegmentSize = this.countDataBlocks - this.segmentSize * (segs - 1);
                this.deductBlocksFromSegments = this.segmentSize - lastSegmentSize;
            } else {
                this.deductBlocksFromSegments = 0;
            }
        }
        int crossCheckBlocks = 0;
        if (segs >= 20 && (cmode == InsertContext.CompatibilityMode.COMPAT_CURRENT || cmode.ordinal() >= InsertContext.CompatibilityMode.COMPAT_1255.ordinal())) {
            crossCheckBlocks = 3;
        }
        this.crossCheckBlocks = crossCheckBlocks;
        this.checkSegmentSize = this.splitfileAlgorithm == 0 ? 0 : FECCodec.getCheckBlocks(this.splitfileAlgorithm, this.segmentSize + crossCheckBlocks, cmode);
        this.persistent = persistent;
        if (persistent) {
            container.activate((Object)this.parent, 1);
        }
        this.splitfileCryptoAlgorithm = cryptoAlgorithm;
        if (splitfileKey != null) {
            this.splitfileCryptoKey = splitfileKey;
            this.specifySplitfileKeyInMetadata = true;
        } else if (cmode == InsertContext.CompatibilityMode.COMPAT_CURRENT || cmode.ordinal() >= InsertContext.CompatibilityMode.COMPAT_1255.ordinal()) {
            if (hashThisLayerOnly != null) {
                this.splitfileCryptoKey = Metadata.getCryptoKey(hashThisLayerOnly);
            } else {
                if (persistent) {
                    for (HashResult res : hashes) {
                        if (res == null) {
                            throw new NullPointerException();
                        }
                        container.activate((Object)res, Integer.MAX_VALUE);
                    }
                }
                this.splitfileCryptoKey = Metadata.getCryptoKey(hashes);
            }
            this.specifySplitfileKeyInMetadata = false;
        } else {
            this.specifySplitfileKeyInMetadata = false;
        }
        this.segments = this.splitIntoSegments(this.segmentSize, crossCheckBlocks, segs, this.deductBlocksFromSegments, dataBuckets, context.mainExecutor, container, context, persistent, put, cryptoAlgorithm, this.splitfileCryptoKey);
        if (persistent) {
            for (int i2 = 0; i2 < dataBuckets.length; ++i2) {
                dataBuckets[i2].storeTo(container);
                container.deactivate((Object)dataBuckets[i2], 1);
                if (dataBuckets.length <= this.segmentSize) continue;
                dataBuckets[i2] = null;
            }
        }
        dataBuckets = null;
        if (crossCheckBlocks != 0) {
            byte[] seed = Metadata.getCrossSegmentSeed(hashes, hashThisLayerOnly);
            if (logMINOR) {
                Logger.minor(this, "Cross-segment seed: " + HexUtil.bytesToHex(seed));
            }
            MersenneTwister random = new MersenneTwister(seed);
            this.crossSegments = new SplitFileInserterCrossSegment[segs];
            int segLen = this.segmentSize;
            for (int i3 = 0; i3 < this.crossSegments.length; ++i3) {
                int j;
                SplitFileInserterCrossSegment seg;
                if (logMINOR) {
                    Logger.minor(this, "Allocating blocks for cross segment " + i3);
                }
                if (this.segments.length - i3 == this.deductBlocksFromSegments) {
                    --segLen;
                }
                this.crossSegments[i3] = seg = new SplitFileInserterCrossSegment(persistent, segLen, crossCheckBlocks, put, this.splitfileAlgorithm, this, i3);
                for (j = 0; j < segLen; ++j) {
                    this.allocateCrossDataBlock(seg, (Random)((Object)random));
                }
                for (j = 0; j < crossCheckBlocks; ++j) {
                    this.allocateCrossCheckBlock(seg, (Random)((Object)random));
                }
                if (!persistent) continue;
                seg.storeTo(container);
            }
        } else {
            this.crossSegments = null;
        }
        int count = 0;
        for (i = 0; i < this.segments.length; ++i) {
            count += this.segments[i].countCheckBlocks();
        }
        this.countCheckBlocks = count;
        this.parent.onMajorProgress(container);
        if (persistent) {
            for (i = 0; i < this.segments.length; ++i) {
                container.store((Object)this.segments[i]);
                container.deactivate((Object)this.segments[i], 1);
            }
        }
    }

    private void allocateCrossDataBlock(SplitFileInserterCrossSegment segment, Random random) {
        int blockNum;
        SplitFileInserterSegment seg;
        int i;
        int x = 0;
        for (i = 0; i < 10; ++i) {
            x = random.nextInt(this.segments.length);
            seg = this.segments[x];
            blockNum = seg.allocateCrossDataBlock(segment, random);
            if (blockNum < 0) continue;
            segment.addDataBlock(seg, blockNum);
            return;
        }
        for (i = 0; i < this.segments.length; ++i) {
            if (++x == this.segments.length) {
                x = 0;
            }
            if ((blockNum = (seg = this.segments[x]).allocateCrossDataBlock(segment, random)) < 0) continue;
            segment.addDataBlock(seg, blockNum);
            return;
        }
        throw new IllegalStateException("Unable to allocate cross data block!");
    }

    private void allocateCrossCheckBlock(SplitFileInserterCrossSegment segment, Random random) {
        int blockNum;
        SplitFileInserterSegment seg;
        int i;
        int x = 0;
        for (i = 0; i < 10; ++i) {
            x = random.nextInt(this.segments.length);
            seg = this.segments[x];
            blockNum = seg.allocateCrossCheckBlock(segment, random);
            if (blockNum < 0) continue;
            segment.addDataBlock(seg, blockNum);
            return;
        }
        for (i = 0; i < this.segments.length; ++i) {
            if (++x == this.segments.length) {
                x = 0;
            }
            if ((blockNum = (seg = this.segments[x]).allocateCrossCheckBlock(segment, random)) < 0) continue;
            segment.addDataBlock(seg, blockNum);
            return;
        }
        throw new IllegalStateException("Unable to allocate cross data block!");
    }

    private SplitFileInserterSegment[] splitIntoSegments(int segmentSize, int crossCheckBlocks, int segCount, int deductBlocksFromSegments, Bucket[] origDataBlocks, Executor executor, ObjectContainer container, ClientContext context, boolean persistent, BaseClientPutter putter, byte cryptoAlgorithm, byte[] splitfileCryptoKey) {
        int dataBlocks = origDataBlocks.length;
        ArrayList<SplitFileInserterSegment> segs = new ArrayList<SplitFileInserterSegment>();
        InsertContext.CompatibilityMode cmode = this.ctx.getCompatibilityMode();
        if (segCount == 1) {
            SplitFileInserterSegment onlySeg = new SplitFileInserterSegment(this, persistent, this.realTimeFlag, putter, this.splitfileAlgorithm, crossCheckBlocks, FECCodec.getCheckBlocks(this.splitfileAlgorithm, origDataBlocks.length + crossCheckBlocks, cmode), origDataBlocks, this.ctx, this.getCHKOnly, 0, cryptoAlgorithm, splitfileCryptoKey, container);
            segs.add(onlySeg);
        } else {
            int j = 0;
            int segNo = 0;
            int data = segmentSize;
            int check = FECCodec.getCheckBlocks(this.splitfileAlgorithm, data + crossCheckBlocks, cmode);
            int i = segmentSize;
            while (true) {
                if (i > dataBlocks) {
                    i = dataBlocks;
                }
                if (data > i - j) {
                    assert (segNo == segCount - 1);
                    data = i - j;
                    check = FECCodec.getCheckBlocks(this.splitfileAlgorithm, data + crossCheckBlocks, cmode);
                }
                Bucket[] seg = new Bucket[i - j];
                System.arraycopy(origDataBlocks, j, seg, 0, data);
                j = i;
                for (int x = 0; x < seg.length; ++x) {
                    if (seg[x] != null) continue;
                    throw new NullPointerException("In splitIntoSegs: " + x + " is null of " + seg.length + " of " + segNo);
                }
                SplitFileInserterSegment s = new SplitFileInserterSegment(this, persistent, this.realTimeFlag, putter, this.splitfileAlgorithm, crossCheckBlocks, check, seg, this.ctx, this.getCHKOnly, segNo, cryptoAlgorithm, splitfileCryptoKey, container);
                segs.add(s);
                if (deductBlocksFromSegments != 0 && logMINOR) {
                    Logger.minor(this, "INSERTING: Segment " + segNo + " of " + segCount + " : " + data + " data blocks " + check + " check blocks");
                }
                ++segNo;
                if (i == dataBlocks) break;
                if (segCount - segNo == deductBlocksFromSegments) {
                    --data;
                }
                i += data;
            }
            assert (segNo == segCount);
        }
        if (persistent) {
            container.activate((Object)this.parent, 1);
        }
        this.parent.notifyClients(container, context);
        return segs.toArray(new SplitFileInserterSegment[segs.size()]);
    }

    public void start(ObjectContainer container, ClientContext context) throws InsertException {
        if (this.crossCheckBlocks != 0) {
            for (SplitFileInserterCrossSegment seg : this.crossSegments) {
                if (this.persistent) {
                    container.activate((Object)seg, 1);
                }
                seg.start(container, context);
                if (!this.persistent) continue;
                container.deactivate((Object)seg, 1);
            }
        }
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.persistent) {
                container.activate((Object)this.segments[i], 1);
            }
            this.segments[i].start(container, context);
            if (!this.persistent) continue;
            container.deactivate((Object)this.segments[i], 1);
        }
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        if (this.countDataBlocks > 32) {
            this.parent.onMajorProgress(container);
        }
        this.parent.notifyClients(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodedSegment(SplitFileInserterSegment segment, ObjectContainer container, ClientContext context) {
        boolean encode;
        if (logMINOR) {
            Logger.minor(this, "Encoded segment " + segment.segNo + " of " + this);
        }
        boolean ret = false;
        SplitFileInserter splitFileInserter = this;
        synchronized (splitFileInserter) {
            encode = this.forceEncode;
            for (int i = 0; i < this.segments.length; ++i) {
                if (this.segments[i] != segment && this.persistent) {
                    container.activate((Object)this.segments[i], 1);
                }
                if (this.segments[i] == null || !this.segments[i].isEncoded()) {
                    ret = true;
                    if (this.segments[i] == segment || !this.persistent) break;
                    container.deactivate((Object)this.segments[i], 1);
                    break;
                }
                if (this.segments[i] == segment || !this.persistent) continue;
                container.deactivate((Object)this.segments[i], 1);
            }
        }
        if (encode) {
            segment.forceEncode(container, context);
        }
        if (ret) {
            return;
        }
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onBlockSetFinished(this, container, context);
        if (this.persistent) {
            container.deactivate((Object)this.cb, 1);
        }
        if (this.countDataBlocks > 32) {
            if (this.persistent) {
                container.activate((Object)this.parent, 1);
            }
            this.parent.onMajorProgress(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean segmentHasURIs(SplitFileInserterSegment segment, ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Segment has URIs: " + segment);
        }
        SplitFileInserter splitFileInserter = this;
        synchronized (splitFileInserter) {
            if (this.haveSentMetadata) {
                return false;
            }
            for (int i = 0; i < this.segments.length; ++i) {
                if (this.persistent) {
                    container.activate((Object)this.segments[i], 1);
                }
                boolean hasURIs = this.segments[i].hasURIs();
                if (this.persistent && this.segments[i] != segment) {
                    container.deactivate((Object)this.segments[i], 1);
                }
                if (hasURIs) continue;
                if (logMINOR) {
                    Logger.minor(this, "Segment does not have URIs: " + this.segments[i]);
                }
                return false;
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Have URIs from all segments");
        }
        this.encodeMetadata(container, context, segment);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeMetadata(ObjectContainer container, ClientContext context, SplitFileInserterSegment dontDeactivateSegment) {
        boolean missingURIs;
        context.jobRunner.setCommitThisTransaction();
        Metadata m = null;
        Object[] dataURIs = new ClientCHK[this.countDataBlocks + this.crossCheckBlocks * this.segments.length];
        Object[] checkURIs = new ClientCHK[this.countCheckBlocks];
        SplitFileInserter splitFileInserter = this;
        synchronized (splitFileInserter) {
            int i;
            int dpos = 0;
            int cpos = 0;
            for (i = 0; i < this.segments.length; ++i) {
                if (this.persistent) {
                    container.activate((Object)this.segments[i], 1);
                }
                ClientCHK[] data = this.segments[i].getDataCHKs();
                System.arraycopy(data, 0, dataURIs, dpos, data.length);
                dpos += data.length;
                ClientCHK[] check = this.segments[i].getCheckCHKs();
                System.arraycopy(check, 0, checkURIs, cpos, check.length);
                cpos += check.length;
                if (!this.persistent || this.segments[i] == dontDeactivateSegment) continue;
                container.deactivate((Object)this.segments[i], 1);
            }
            if (logMINOR) {
                Logger.minor(this, "Data URIs: " + dataURIs.length + ", check URIs: " + checkURIs.length);
            }
            boolean bl = missingURIs = SplitFileInserter.anyNulls(dataURIs) || SplitFileInserter.anyNulls(checkURIs);
            if (this.persistent) {
                for (i = 0; i < dataURIs.length; ++i) {
                    container.activate(dataURIs[i], 5);
                    dataURIs[i] = ((ClientCHK)dataURIs[i]).cloneKey();
                }
                for (i = 0; i < checkURIs.length; ++i) {
                    container.activate(checkURIs[i], 5);
                    checkURIs[i] = ((ClientCHK)checkURIs[i]).cloneKey();
                }
            }
            if (!missingURIs) {
                if (this.persistent) {
                    container.activate((Object)this.cm, 5);
                }
                ClientMetadata meta = this.cm;
                if (this.persistent) {
                    meta = meta == null ? null : meta.clone();
                }
                boolean allowTopBlocks = this.topSize != 0L;
                int req = 0;
                int total = 0;
                long data = 0L;
                long compressed = 0L;
                boolean topDontCompress = false;
                short topCompatibilityMode = 0;
                if (allowTopBlocks) {
                    boolean wasActive = true;
                    boolean ctxWasActive = true;
                    if (this.persistent) {
                        wasActive = container.ext().isActive((Object)this.parent);
                        if (!wasActive) {
                            container.activate((Object)this.parent, 1);
                        }
                        if (!(ctxWasActive = container.ext().isActive((Object)this.ctx))) {
                            container.activate((Object)this.ctx, 1);
                        }
                    }
                    req = this.parent.getMinSuccessFetchBlocks();
                    total = this.parent.totalBlocks;
                    if (!wasActive) {
                        container.deactivate((Object)this.parent, 1);
                    }
                    data = this.topSize;
                    compressed = this.topCompressedSize;
                }
                if (this.persistent) {
                    container.activate((Object)this.hashes, Integer.MAX_VALUE);
                }
                HashResult[] h = this.persistent ? HashResult.copy(this.hashes) : this.hashes;
                if (this.persistent) {
                    container.activate((Object)this.compressionCodec, Integer.MAX_VALUE);
                }
                if (this.persistent) {
                    container.activate((Object)this.archiveType, Integer.MAX_VALUE);
                }
                m = new Metadata(this.splitfileAlgorithm, (ClientCHK[])dataURIs, (ClientCHK[])checkURIs, this.segmentSize, this.checkSegmentSize, this.deductBlocksFromSegments, meta, this.dataLength, this.archiveType, this.compressionCodec, this.decompressedLength, this.isMetadata, h, this.hashThisLayerOnly, data, compressed, req, total, topDontCompress, topCompatibilityMode, this.splitfileCryptoAlgorithm, this.splitfileCryptoKey, this.specifySplitfileKeyInMetadata, this.crossCheckBlocks);
            }
            this.haveSentMetadata = true;
        }
        if (missingURIs) {
            if (logMINOR) {
                Logger.minor(this, "Missing URIs");
            }
            this.fail(new InsertException(3, "Missing URIs after encoding", null), container, context);
            return;
        }
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onMetadata(m, (ClientPutState)this, container, context);
        if (this.persistent) {
            container.deactivate((Object)this.cb, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(InsertException e, ObjectContainer container, ClientContext context) {
        SplitFileInserter splitFileInserter = this;
        synchronized (splitFileInserter) {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }
        if (this.persistent) {
            container.store((Object)this);
            container.activate((Object)this.cb, 1);
        }
        this.cb.onFailure(e, this, container, context);
        if (this.persistent) {
            container.deactivate((Object)this.cb, 1);
        }
    }

    private static boolean anyNulls(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public BaseClientPutter getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void segmentFinished(SplitFileInserterSegment segment, ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Segment finished: " + segment, (Throwable)new Exception("debug"));
        }
        boolean allGone = true;
        if (this.countDataBlocks > 32) {
            if (this.persistent) {
                container.activate((Object)this.parent, 1);
            }
            this.parent.onMajorProgress(container);
        }
        SplitFileInserter splitFileInserter = this;
        synchronized (splitFileInserter) {
            InsertException e;
            if (this.finished) {
                if (logMINOR) {
                    Logger.minor(this, "Finished already");
                }
                return;
            }
            for (int i = 0; i < this.segments.length; ++i) {
                if (this.persistent && this.segments[i] != segment) {
                    container.activate((Object)this.segments[i], 1);
                }
                if (!this.segments[i].isFinished()) {
                    if (logMINOR) {
                        Logger.minor(this, "Segment not finished: " + i + ": " + this.segments[i] + " for " + this);
                    }
                    allGone = false;
                    if (!this.persistent || this.segments[i] == segment) break;
                    container.deactivate((Object)this.segments[i], 1);
                    break;
                }
                if (!this.segments[i].hasURIs() && this.segments[i].getException(container) == null) {
                    Logger.error(this, "Segment finished but hasURIs() is false: " + this.segments[i] + " for " + this);
                }
                if (!this.persistent || this.segments[i] == segment) continue;
                container.deactivate((Object)this.segments[i], 1);
            }
            if ((e = segment.getException(container)) != null && e.isFatal()) {
                this.cancel(container, context);
            } else if (!allGone) {
                return;
            }
            this.finished = true;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        this.onAllFinished(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void segmentFetchable(SplitFileInserterSegment segment, ObjectContainer container) {
        if (logMINOR) {
            Logger.minor(this, "Segment fetchable: " + segment);
        }
        SplitFileInserter splitFileInserter = this;
        synchronized (splitFileInserter) {
            if (this.finished) {
                return;
            }
            if (this.fetchable) {
                return;
            }
            for (int i = 0; i < this.segments.length; ++i) {
                if (this.persistent && this.segments[i] != segment) {
                    container.activate((Object)this.segments[i], 1);
                }
                if (!this.segments[i].isFetchable()) {
                    if (logMINOR) {
                        Logger.minor(this, "Segment not fetchable: " + i + ": " + this.segments[i]);
                    }
                    if (this.persistent && this.segments[i] != segment) {
                        container.deactivate((Object)this.segments[i], 1);
                    }
                    return;
                }
                if (!this.persistent || this.segments[i] == segment) continue;
                container.deactivate((Object)this.segments[i], 1);
            }
            this.fetchable = true;
        }
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
            container.store((Object)this);
        }
        this.cb.onFetchable(this, container);
    }

    private void onAllFinished(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "All finished");
        }
        try {
            FailureCodeTracker tracker = new FailureCodeTracker(true);
            boolean allSucceeded = true;
            for (int i = 0; i < this.segments.length; ++i) {
                InsertException e;
                if (this.persistent) {
                    container.activate((Object)this.segments[i], 1);
                }
                if ((e = this.segments[i].getException(container)) == null) continue;
                if (logMINOR) {
                    Logger.minor(this, "Failure on segment " + i + " : " + this.segments[i] + " : " + e, (Throwable)e);
                }
                allSucceeded = false;
                if (e.errorCodes != null) {
                    tracker.merge(e.errorCodes);
                }
                tracker.inc(e.getMode());
            }
            if (this.persistent) {
                container.activate((Object)this.cb, 1);
            }
            if (allSucceeded) {
                this.cb.onSuccess(this, container, context);
            } else {
                this.cb.onFailure(InsertException.construct(tracker), this, container, context);
            }
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t, t);
            this.cb.onFailure(new InsertException(3), this, container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Cancelling " + this);
        }
        SplitFileInserter splitFileInserter = this;
        synchronized (splitFileInserter) {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.persistent) {
                container.activate((Object)this.segments[i], 1);
            }
            this.segments[i].cancel(container, context);
        }
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onFailure(new InsertException(10), this, container, context);
    }

    @Override
    public void schedule(ObjectContainer container, ClientContext context) throws InsertException {
        this.start(container, context);
    }

    @Override
    public Object getToken() {
        return this.token;
    }

    public long getLength() {
        return this.dataLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceEncode(ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this, 1);
        }
        Logger.minor(this, "Forcing encode on " + this);
        SplitFileInserter splitFileInserter = this;
        synchronized (splitFileInserter) {
            this.forceEncode = true;
        }
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.persistent) {
                container.activate((Object)this.segments[i], 1);
            }
            this.segments[i].forceEncode(container, context);
            if (!this.persistent) continue;
            container.deactivate((Object)this.segments[i], 1);
        }
    }

    @Override
    public void removeFrom(ObjectContainer container, ClientContext context) {
        for (SplitFileInserterSegment segment : this.segments) {
            container.activate((Object)segment, 1);
            segment.removeFrom(container, context);
        }
        if (this.hashes != null) {
            for (HashResult res : this.hashes) {
                container.activate((Object)res, Integer.MAX_VALUE);
                res.removeFrom(container);
            }
        }
        container.delete((Object)this);
    }

    public boolean objectCanUpdate(ObjectContainer container) {
        if (logDEBUG) {
            Logger.debug(this, "objectCanUpdate() on " + this, (Throwable)new Exception("debug"));
        }
        return true;
    }

    public boolean objectCanNew(ObjectContainer container) {
        if (this.finished) {
            Logger.error(this, "objectCanNew but finished on " + this, (Throwable)new Exception("error"));
        } else if (logDEBUG) {
            Logger.debug(this, "objectCanNew() on " + this, (Throwable)new Exception("debug"));
        }
        return true;
    }

    public void dump(ObjectContainer container) {
        System.out.println("This: " + this);
        System.out.println("Persistent: " + this.persistent);
        System.out.println("Finished: " + this.finished);
        System.out.println("Data length: " + this.dataLength);
        System.out.println("Segment count: " + this.segments.length);
        System.out.println("Fetchable: " + this.fetchable);
        container.activate((Object)this.parent, 1);
        System.out.println("Parent: " + this.parent);
        this.parent.dump(container);
        container.deactivate((Object)this.parent, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCrossSegment(int segNum, SplitFileInserterCrossSegment segment, ObjectContainer container, ClientContext context) {
        boolean clearedAll = true;
        SplitFileInserter splitFileInserter = this;
        synchronized (splitFileInserter) {
            assert (this.crossSegments[segNum] == segment);
            this.crossSegments[segNum] = null;
            for (SplitFileInserterCrossSegment seg : this.crossSegments) {
                if (seg == null) continue;
                clearedAll = false;
            }
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        if (clearedAll) {
            for (int i = 0; i < this.segments.length; ++i) {
                if (this.persistent) {
                    container.activate((Object)this.segments[i], 1);
                }
                try {
                    this.segments[i].start(container, context);
                }
                catch (InsertException e) {
                    this.fail(e, container, context);
                }
                if (!this.persistent) continue;
                container.deactivate((Object)this.segments[i], 1);
            }
            if (this.persistent) {
                container.activate((Object)this.parent, 1);
            }
            if (this.countDataBlocks > 32) {
                this.parent.onMajorProgress(container);
            }
            this.parent.notifyClients(container, context);
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }
}

