/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.FECCallback;
import freenet.client.FECCodec;
import freenet.client.FECJob;
import freenet.client.FailureCodeTracker;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.SplitfileBlock;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ChosenBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutState;
import freenet.client.async.ClientRequester;
import freenet.client.async.Encodeable;
import freenet.client.async.PersistentChosenBlock;
import freenet.client.async.PersistentChosenRequest;
import freenet.client.async.SplitFileInserter;
import freenet.client.async.SplitFileInserterCrossSegment;
import freenet.keys.CHKBlock;
import freenet.keys.CHKEncodeException;
import freenet.keys.ClientCHK;
import freenet.keys.ClientCHKBlock;
import freenet.keys.ClientKey;
import freenet.keys.KeyBlock;
import freenet.node.KeysFetchingLocally;
import freenet.node.LowLevelPutException;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.node.RequestScheduler;
import freenet.node.SendableInsert;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestItemKey;
import freenet.node.SendableRequestSender;
import freenet.store.KeyCollisionException;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.BucketTools;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class SplitFileInserterSegment
extends SendableInsert
implements FECCallback,
Encodeable {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    final SplitFileInserter parent;
    final BaseClientPutter putter;
    final short splitfileAlgo;
    final Bucket[] dataBlocks;
    final Bucket[] checkBlocks;
    final ClientCHK[] dataURIs;
    final ClientCHK[] checkURIs;
    final int[] dataRetries;
    final int[] checkRetries;
    final int[] dataConsecutiveRNFs;
    final int[] checkConsecutiveRNFs;
    final ArrayList<Integer> blocks;
    final boolean[] dataFinished;
    final boolean[] checkFinished;
    final boolean[] dataFailed;
    final boolean[] checkFailed;
    final int maxRetries;
    final InsertContext blockInsertContext;
    final int segNo;
    private volatile boolean encoded;
    private volatile boolean started;
    private volatile boolean finished;
    private volatile boolean hasURIs;
    private final boolean getCHKOnly;
    private InsertException toThrow;
    private final FailureCodeTracker errors;
    private int blocksGotURI;
    private int blocksSucceeded;
    private int blocksCompleted;
    private final boolean persistent;
    private FECJob encodeJob;
    private byte cryptoAlgorithm;
    private final byte[] cryptoKey;
    private final int crossCheckBlocks;
    private transient int crossDataBlocksAllocated;
    private transient int crossCheckBlocksAllocated;
    private final SplitFileInserterCrossSegment[] crossSegmentsByBlock;
    private int encodedCrossCheckBlocks;
    private boolean removeOnEncode;

    private SplitFileInserterSegment() {
        this.splitfileAlgo = 0;
        this.segNo = 0;
        this.putter = null;
        this.persistent = false;
        this.parent = null;
        this.maxRetries = 0;
        this.getCHKOnly = false;
        this.errors = null;
        this.dataURIs = null;
        this.dataRetries = null;
        this.dataFinished = null;
        this.dataFailed = null;
        this.dataConsecutiveRNFs = null;
        this.dataBlocks = null;
        this.cryptoKey = null;
        this.crossSegmentsByBlock = null;
        this.crossCheckBlocks = 0;
        this.checkURIs = null;
        this.checkRetries = null;
        this.checkFinished = null;
        this.checkFailed = null;
        this.checkConsecutiveRNFs = null;
        this.checkBlocks = null;
        this.blocks = null;
        this.blockInsertContext = null;
    }

    public SplitFileInserterSegment(SplitFileInserter parent, boolean persistent, boolean realTimeFlag, BaseClientPutter putter, short splitfileAlgo, int crossCheckBlocks, int checkBlockCount, Bucket[] origDataBlocks, InsertContext blockInsertContext, boolean getCHKOnly, int segNo, byte cryptoAlgorithm, byte[] cryptoKey, ObjectContainer container) {
        super(persistent, realTimeFlag);
        this.crossCheckBlocks = crossCheckBlocks;
        this.crossSegmentsByBlock = new SplitFileInserterCrossSegment[origDataBlocks.length + crossCheckBlocks];
        this.parent = parent;
        this.getCHKOnly = getCHKOnly;
        this.persistent = persistent;
        this.errors = new FailureCodeTracker(true);
        this.blockInsertContext = blockInsertContext;
        this.splitfileAlgo = splitfileAlgo;
        if (crossCheckBlocks != 0) {
            this.dataBlocks = Arrays.copyOf(origDataBlocks, origDataBlocks.length + crossCheckBlocks);
            origDataBlocks = this.dataBlocks;
        } else {
            this.dataBlocks = origDataBlocks;
        }
        this.checkBlocks = new Bucket[checkBlockCount];
        this.checkURIs = new ClientCHK[checkBlockCount];
        this.dataURIs = new ClientCHK[origDataBlocks.length];
        this.dataRetries = new int[origDataBlocks.length];
        this.checkRetries = new int[checkBlockCount];
        this.dataFinished = new boolean[origDataBlocks.length];
        this.checkFinished = new boolean[checkBlockCount];
        this.dataFailed = new boolean[origDataBlocks.length];
        this.checkFailed = new boolean[checkBlockCount];
        this.dataConsecutiveRNFs = new int[origDataBlocks.length];
        this.checkConsecutiveRNFs = new int[checkBlockCount];
        this.blocks = new ArrayList();
        putter.addMustSucceedBlocks(this.dataURIs.length, container);
        putter.addRedundantBlocks(this.checkURIs.length, container);
        this.segNo = segNo;
        if (persistent) {
            container.activate((Object)blockInsertContext, 1);
        }
        this.maxRetries = blockInsertContext.maxInsertRetries;
        this.putter = putter;
        this.cryptoAlgorithm = cryptoAlgorithm;
        this.cryptoKey = cryptoKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ObjectContainer container, ClientContext context) throws InsertException {
        boolean fetchable;
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            if (this.crossCheckBlocks != 0) {
                if (this.encodedCrossCheckBlocks != this.crossCheckBlocks) {
                    return;
                }
                if (logMINOR) {
                    Logger.minor(this, "Starting segment " + this.segNo);
                }
            }
            if (this.started) {
                return;
            }
            this.started = true;
        }
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
            container.activate((Object)this.parent.parent, 1);
            container.activate(this.blocks, 2);
        }
        if (logMINOR) {
            if (this.parent == null) {
                throw new NullPointerException();
            }
            Logger.minor(this, "Starting segment " + this.segNo + " of " + this.parent + " (" + this.parent.dataLength + "): " + this + " ( finished=" + this.finished + " encoded=" + this.encoded + " hasURIs=" + this.hasURIs + " persistent=" + this.persistent + ')');
        }
        boolean fin = true;
        for (int i = 0; i < this.dataBlocks.length; ++i) {
            if (this.dataBlocks[i] != null) {
                fin = false;
                SplitFileInserterSegment splitFileInserterSegment2 = this;
                synchronized (splitFileInserterSegment2) {
                    this.blocks.add(i);
                    continue;
                }
            }
            this.parent.parent.completedBlock(true, container, context);
        }
        FECJob job = null;
        FECCodec splitfileAlgo = null;
        if (!this.encoded) {
            if (logMINOR) {
                Logger.minor(this, "Segment " + this.segNo + " of " + this.parent + " (" + this.parent.dataLength + ") is not encoded");
            }
            splitfileAlgo = FECCodec.getCodec(this.splitfileAlgo, this.dataBlocks.length, this.checkBlocks.length);
            if (logMINOR) {
                Logger.minor(this, "Encoding segment " + this.segNo + " of " + this.parent + " (" + this.parent.dataLength + ") persistent=" + this.persistent);
            }
            SplitFileInserterSegment splitFileInserterSegment3 = this;
            synchronized (splitFileInserterSegment3) {
                if (!this.encoded) {
                    if (this.persistent) {
                        for (int i = 0; i < this.dataBlocks.length; ++i) {
                            container.activate((Object)this.dataBlocks[i], 5);
                        }
                    }
                    job = this.encodeJob = new FECJob(splitfileAlgo, context.fecQueue, this.dataBlocks, this.checkBlocks, 32768, this.persistent ? context.persistentBucketFactory : context.tempBucketFactory, (FECCallback)this, false, this.parent.parent.getPriorityClass(), this.persistent);
                }
            }
            fin = false;
        } else {
            for (int i = 0; i < this.checkBlocks.length; ++i) {
                if (this.checkBlocks[i] != null) {
                    SplitFileInserterSegment splitFileInserterSegment4 = this;
                    synchronized (splitFileInserterSegment4) {
                        this.blocks.add(i + this.dataBlocks.length);
                    }
                    fin = false;
                    continue;
                }
                this.parent.parent.completedBlock(true, container, context);
            }
            this.onEncodedSegment(container, context, null, this.dataBlocks, this.checkBlocks, null, null);
        }
        if (this.hasURIs) {
            this.parent.segmentHasURIs(this, container, context);
        }
        SplitFileInserterSegment splitFileInserterSegment5 = this;
        synchronized (splitFileInserterSegment5) {
            fetchable = this.blocksCompleted > this.dataBlocks.length;
        }
        if (this.persistent) {
            container.store((Object)this);
            container.store(this.blocks);
        }
        if (fetchable) {
            this.parent.segmentFetchable(this, container);
        }
        if (fin) {
            this.finish(container, context, this.parent);
        } else {
            this.schedule(container, context);
        }
        if (this.finished) {
            this.finish(container, context, this.parent);
        }
        if (job != null) {
            splitfileAlgo.addToQueue(job, context.fecQueue, container);
        }
    }

    private void schedule(ObjectContainer container, ClientContext context) {
        if (!this.getCHKOnly) {
            this.getScheduler(container, context).registerInsert(this, this.persistent, false, container);
        } else {
            this.tryEncode(container, context);
        }
    }

    @Override
    public void tryEncode(ObjectContainer container, ClientContext context) {
        ClientCHK key;
        int i;
        boolean deactivateParent = false;
        boolean deactivateParentCtx = false;
        if (this.persistent) {
            deactivateParent = !container.ext().isActive((Object)this.parent);
            boolean bl = deactivateParentCtx = !container.ext().isActive((Object)this.parent.ctx);
            if (deactivateParent) {
                container.activate((Object)this.parent, 1);
            }
            if (deactivateParentCtx) {
                container.activate((Object)this.parent.ctx, 1);
            }
        }
        if (this.parent == null) {
            Logger.error(this, "tryEncode() but parent is null!", (Throwable)new Exception("error"));
            return;
        }
        if (this.parent.ctx == null) {
            Logger.error(this, "tryEncode() but parent.ctx is null!", (Throwable)new Exception("error"));
            return;
        }
        String compressorDescriptor = this.parent.ctx.compressorDescriptor;
        if (this.persistent) {
            if (deactivateParent) {
                container.deactivate((Object)this.parent, 1);
            }
            if (deactivateParentCtx) {
                container.deactivate((Object)this.parent.ctx, 1);
            }
        }
        byte cryptoAlgorithm = this.getCryptoAlgorithm(container);
        for (i = 0; i < this.dataBlocks.length; ++i) {
            if (this.dataURIs[i] == null && this.dataBlocks[i] != null) {
                try {
                    boolean deactivate = false;
                    if (this.persistent) {
                        boolean bl = deactivate = !container.ext().isActive((Object)this.dataBlocks[i]);
                        if (deactivate) {
                            container.activate((Object)this.dataBlocks[i], 1);
                        }
                    }
                    key = SplitFileInserterSegment.encodeBucket(this.dataBlocks[i], compressorDescriptor, cryptoAlgorithm, this.cryptoKey).getClientKey();
                    if (deactivate) {
                        container.deactivate((Object)this.dataBlocks[i], 1);
                    }
                    this.onEncode(i, key, container, context);
                }
                catch (CHKEncodeException e) {
                    this.fail(new InsertException(3, e, null), container, context);
                }
                catch (IOException e) {
                    this.fail(new InsertException(2, e, null), container, context);
                }
                continue;
            }
            if (this.dataURIs[i] != null || this.dataBlocks[i] != null) continue;
            this.fail(new InsertException(3, "Data block " + i + " cannot be encoded: no data", null), container, context);
        }
        if (this.encoded) {
            for (i = 0; i < this.checkBlocks.length; ++i) {
                if (this.checkURIs[i] == null && this.checkBlocks[i] != null) {
                    try {
                        boolean deactivate = false;
                        if (this.persistent) {
                            boolean bl = deactivate = !container.ext().isActive((Object)this.checkBlocks[i]);
                            if (deactivate) {
                                container.activate((Object)this.checkBlocks[i], 1);
                            }
                        }
                        key = SplitFileInserterSegment.encodeBucket(this.checkBlocks[i], compressorDescriptor, cryptoAlgorithm, this.cryptoKey).getClientKey();
                        if (deactivate) {
                            container.deactivate((Object)this.checkBlocks[i], 1);
                        }
                        this.onEncode(i + this.dataBlocks.length, key, container, context);
                    }
                    catch (CHKEncodeException e) {
                        this.fail(new InsertException(3, e, null), container, context);
                    }
                    catch (IOException e) {
                        this.fail(new InsertException(2, e, null), container, context);
                    }
                    continue;
                }
                if (this.checkURIs[i] != null || this.checkBlocks[i] != null) continue;
                this.fail(new InsertException(3, "Data block " + i + " cannot be encoded: no data", null), container, context);
            }
        }
    }

    private byte getCryptoAlgorithm(ObjectContainer container) {
        if (this.cryptoAlgorithm == 0) {
            this.cryptoAlgorithm = (byte)2;
            if (this.persistent) {
                container.store((Object)this);
            }
        }
        return this.cryptoAlgorithm;
    }

    @Override
    public void onDecodedSegment(ObjectContainer container, ClientContext context, FECJob job, Bucket[] dataBuckets, Bucket[] checkBuckets, SplitfileBlock[] dataBlockStatus, SplitfileBlock[] checkBlockStatus) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEncodedSegment(ObjectContainer container, ClientContext context, FECJob job, Bucket[] dataBuckets, Bucket[] checkBuckets, SplitfileBlock[] dataBlockStatus, SplitfileBlock[] checkBlockStatus) {
        boolean fin;
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
            container.activate((Object)this.parent.parent, 1);
            container.activate(this.blocks, 2);
        }
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            fin = this.finished;
            this.encodeJob = null;
        }
        if (this.removeOnEncode) {
            if (logMINOR) {
                Logger.minor(this, "Removing on encode: " + this);
            }
            this.freeBucketsArray(container, dataBuckets);
            this.freeBucketsArray(container, checkBuckets);
            this.removeFrom(container, context);
            return;
        }
        if (fin) {
            Logger.error(this, "Encoded segment even though segment finished! Freeing buckets...");
            this.freeBucketsArray(container, dataBuckets);
            this.freeBucketsArray(container, checkBuckets);
            return;
        }
        try {
            if (logMINOR) {
                Logger.minor(this, "Scheduling " + this.checkBlocks.length + " check blocks...");
            }
            for (int i = 0; i < this.checkBlocks.length; ++i) {
                this.checkBlocks[i] = checkBuckets[i];
                if (this.checkBlocks[i] == null) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Skipping check block " + i + " - is null");
                    continue;
                }
                if (this.persistent) {
                    this.checkBlocks[i].storeTo(container);
                }
                if (!this.persistent) continue;
                container.deactivate((Object)this.checkBlocks[i], 1);
            }
            SplitFileInserterSegment i = this;
            synchronized (i) {
                for (int i2 = 0; i2 < this.checkBlocks.length; ++i2) {
                    this.blocks.add(this.dataBlocks.length + i2);
                }
            }
            if (this.persistent) {
                container.store(this.blocks);
            }
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t + " while encoding " + this, t);
            InsertException ex = new InsertException(3, t, null);
            this.finish(ex, container, context, this.parent);
            if (this.persistent) {
                container.deactivate((Object)this.parent, 1);
            }
            return;
        }
        SplitFileInserterSegment splitFileInserterSegment2 = this;
        synchronized (splitFileInserterSegment2) {
            this.encoded = true;
        }
        if (this.persistent) {
            container.store((Object)this);
            container.activate((Object)this.parent, 1);
        }
        this.parent.encodedSegment(this, container, context);
        splitFileInserterSegment2 = this;
        synchronized (splitFileInserterSegment2) {
            this.freeFinishedDataBlocks(container);
        }
        if (this.persistent) {
            container.store((Object)this);
            container.deactivate((Object)this.parent, 1);
        }
        this.schedule(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish(InsertException ex, ObjectContainer container, ClientContext context, SplitFileInserter parent) {
        if (logMINOR) {
            Logger.minor(this, "Finishing " + this + " with " + ex, (Throwable)ex);
        }
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            if (this.finished) {
                return;
            }
            this.finished = true;
            this.toThrow = ex;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        parent.segmentFinished(this, container, context);
        this.freeBucketsArray(container, this.dataBlocks);
        this.freeBucketsArray(container, this.checkBlocks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(ObjectContainer container, ClientContext context, SplitFileInserter parent) {
        if (logMINOR) {
            Logger.minor(this, "Finishing " + this);
        }
        if (this.persistent) {
            container.activate((Object)this.errors, 5);
        }
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            if (this.finished) {
                return;
            }
            this.finished = true;
            if (this.blocksSucceeded < this.blocksCompleted) {
                this.toThrow = InsertException.construct(this.errors);
                if (logMINOR) {
                    Logger.minor(this, "Blocks succeeded " + this.blocksSucceeded + " blocks completed " + this.blocksCompleted + " gives error " + this.toThrow + " on " + this);
                }
            } else if (!this.hasURIs) {
                this.fail(new InsertException(3, "Completed but not encoded?!", null), container, context);
                return;
            }
        }
        if (this.persistent) {
            container.store((Object)this);
            container.deactivate((Object)this.errors, 5);
        }
        this.unregister(container, context, this.getPriorityClass(container));
        parent.segmentFinished(this, container, context);
        this.freeBucketsArray(container, this.dataBlocks);
        this.freeBucketsArray(container, this.checkBlocks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onEncode(int x, ClientCHK key, ObjectContainer container, final ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Encoded block " + x + " on " + this);
        }
        boolean gotAllURIs = false;
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            if (this.finished) {
                if (logMINOR) {
                    Logger.minor(this, "Already finished");
                }
                return false;
            }
            if (x >= this.dataBlocks.length) {
                if (this.checkURIs[x - this.dataBlocks.length] != null) {
                    if (logMINOR) {
                        Logger.minor(this, "Already encoded check block");
                    }
                    return false;
                }
                this.checkURIs[x - this.dataBlocks.length] = key;
            } else {
                if (this.dataURIs[x] != null) {
                    if (logMINOR) {
                        Logger.minor(this, "Already encoded data block");
                    }
                    return false;
                }
                this.dataURIs[x] = key;
            }
            ++this.blocksGotURI;
            if (this.persistent) {
                container.store((Object)this);
            }
            if (logMINOR) {
                Logger.minor(this, "Blocks got URI: " + this.blocksGotURI + " of " + (this.dataBlocks.length + this.checkBlocks.length));
            }
            boolean bl = gotAllURIs = this.blocksGotURI == this.dataBlocks.length + this.checkBlocks.length;
            if (gotAllURIs) {
                int i;
                for (i = 0; i < this.checkURIs.length; ++i) {
                    if (this.checkURIs[i] != null) continue;
                    Logger.error(this, "Check URI " + i + " is null");
                    gotAllURIs = false;
                }
                for (i = 0; i < this.dataURIs.length; ++i) {
                    if (this.dataURIs[i] != null) continue;
                    Logger.error(this, "Data URI " + i + " is null");
                    gotAllURIs = false;
                }
                if (gotAllURIs) {
                    this.hasURIs = true;
                }
            }
            if (!this.getCHKOnly && !this.hasURIs) {
                return false;
            }
        }
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
            container.store((Object)this);
        }
        if (gotAllURIs) {
            if (!this.persistent) {
                context.mainExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        SplitFileInserterSegment.this.parent.segmentHasURIs(SplitFileInserterSegment.this, null, context);
                    }
                });
            } else {
                this.parent.segmentHasURIs(this, container, context);
            }
        }
        if (this.getCHKOnly) {
            byte cryptoAlgorithm = this.getCryptoAlgorithm(container);
            try {
                BlockItem block = this.getBlockItem(container, context, x, cryptoAlgorithm);
                this.onSuccess(block, container, context);
            }
            catch (IOException e) {
                this.fail(new InsertException(2, e, null), container, context);
            }
        }
        if (this.persistent) {
            container.deactivate((Object)this.parent, 1);
        }
        return gotAllURIs;
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public boolean isEncoded() {
        return this.encoded;
    }

    public int countCheckBlocks() {
        return this.checkBlocks.length;
    }

    public int countDataBlocks() {
        return this.dataBlocks.length;
    }

    public ClientCHK[] getCheckCHKs() {
        return this.checkURIs;
    }

    public ClientCHK[] getDataCHKs() {
        return this.dataURIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InsertException getException(ObjectContainer container) {
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            if (this.persistent) {
                container.activate((Object)this.toThrow, 5);
            }
            return this.toThrow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(ObjectContainer container, ClientContext context) {
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            if (this.finished) {
                return;
            }
            this.finished = true;
            if (this.toThrow != null) {
                this.toThrow = new InsertException(10);
            }
        }
        this.cancelInner(container, context);
    }

    private void cancelInner(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Cancelling " + this);
        }
        super.unregister(container, context, this.getPriorityClass(container));
        if (this.persistent) {
            container.store((Object)this);
            container.activate((Object)this.parent, 1);
        }
        this.parent.segmentFinished(this, container, context);
        this.freeBucketsArray(container, this.dataBlocks);
        this.freeBucketsArray(container, this.checkBlocks);
    }

    public void onTransition(ClientPutState oldState, ClientPutState newState, ObjectContainer container) {
        Logger.error(this, "Illegal transition in SplitFileInserterSegment: " + oldState + " -> " + newState);
    }

    public void onMetadata(Metadata m, ClientPutState state, ObjectContainer container, ClientContext context) {
        Logger.error(this, "Got onMetadata from " + state);
    }

    public void onBlockSetFinished(ClientPutState state, ObjectContainer container, ClientContext context) {
        Logger.error(this, "Should not happen: onBlockSetFinished(" + state + ") on " + this);
    }

    public synchronized boolean hasURIs() {
        return this.hasURIs;
    }

    public synchronized boolean isFetchable() {
        return this.blocksCompleted >= this.dataBlocks.length;
    }

    public void onFetchable(ClientPutState state, ObjectContainer container) {
    }

    public void forceEncode(ObjectContainer container, ClientContext context) {
        context.backgroundBlockEncoder.queue(this, container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail(InsertException e, ObjectContainer container, ClientContext context) {
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            if (this.finished) {
                Logger.error(this, "Failing but already finished on " + this, (Throwable)new Exception("error"));
                return;
            }
            this.finished = true;
            Logger.error(this, "Insert segment failed: " + e + " for " + this, (Throwable)e);
            this.toThrow = e;
            if (this.persistent) {
                container.store((Object)this);
            }
        }
        this.cancelInner(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailed(Throwable t, ObjectContainer container, ClientContext context) {
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            if (this.finished) {
                Logger.error(this, "FEC decode or encode failed but already finished: " + t, t);
                return;
            }
            this.finished = true;
            Logger.error(this, "Insert segment failed: " + t + " for " + this, t);
            this.toThrow = new InsertException(3, "FEC failure: " + t, null);
        }
        this.cancelInner(container, context);
    }

    Bucket getBucket(int blockNum) {
        if (blockNum >= this.dataBlocks.length) {
            return this.checkBlocks[blockNum - this.dataBlocks.length];
        }
        return this.dataBlocks[blockNum];
    }

    private BlockItem getBlockItem(ObjectContainer container, ClientContext context, int blockNum, byte cryptoAlgorithm) throws IOException {
        Bucket data;
        Bucket sourceData = this.getBucket(blockNum);
        if (sourceData == null) {
            Logger.error(this, "Selected block " + blockNum + " but is null - already finished?? on " + this);
            return null;
        }
        boolean deactivateBucket = false;
        if (this.persistent) {
            boolean bl = deactivateBucket = !container.ext().isActive((Object)sourceData);
            if (deactivateBucket) {
                container.activate((Object)sourceData, 1);
            }
        }
        if ((data = sourceData.createShadow()) == null) {
            data = context.tempBucketFactory.makeBucket(sourceData.size());
            BucketTools.copy(sourceData, data);
        }
        if (logMINOR) {
            Logger.minor(this, "Block " + blockNum + " : bucket " + sourceData + " shadow " + data);
        }
        if (this.persistent && deactivateBucket) {
            container.deactivate((Object)sourceData, 1);
        }
        return new BlockItem(this, blockNum, data, this.persistent, cryptoAlgorithm, this.cryptoKey);
    }

    private int hashCodeForBlock(int blockNum) {
        return this.hashCode() * (blockNum + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(LowLevelPutException e, Object keyNum, ObjectContainer container, ClientContext context) {
        int succeeded;
        int completed;
        BlockItem block = (BlockItem)keyNum;
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            if (this.finished) {
                return;
            }
        }
        if (this.persistent) {
            container.activate((Object)this.errors, 5);
        }
        switch (e.code) {
            case 5: {
                Logger.error(this, "Collision on a CHK?!?!?");
                this.fail(new InsertException(3, "Collision on a CHK", null), container, context);
                return;
            }
            case 1: {
                Logger.error(this, "Internal error: " + e, (Throwable)e);
                this.fail(new InsertException(3, e.toString(), null), container, context);
                return;
            }
            case 3: {
                this.errors.inc(4);
                break;
            }
            case 2: {
                this.errors.inc(5);
                break;
            }
            case 4: {
                this.errors.inc(8);
                break;
            }
            default: {
                Logger.error(this, "Unknown LowLevelPutException code: " + e.code);
                this.fail(new InsertException(3, e.toString(), null), container, context);
                return;
            }
        }
        if (this.persistent) {
            container.store((Object)this.errors);
        }
        boolean isRNF = e.code == 2 || e.code == 4;
        int blockNum = block.blockNum();
        if (logMINOR) {
            Logger.minor(this, "Block " + blockNum + " failed on " + this + " : " + e);
        }
        boolean treatAsSuccess = false;
        boolean failedBlock = false;
        SplitFileInserterSegment splitFileInserterSegment2 = this;
        synchronized (splitFileInserterSegment2) {
            if (blockNum >= this.dataBlocks.length) {
                int checkNum = blockNum - this.dataBlocks.length;
                if (this.checkFinished[checkNum]) {
                    if (this.checkFailed[checkNum]) {
                        Logger.error(this, "Got onFailure() but block has already failed! Check block " + checkNum + " on " + this);
                    } else {
                        Logger.error(this, "Got onFailure() but block has already succeeded: Check block " + checkNum + " on " + this);
                    }
                    return;
                }
                if (isRNF) {
                    int n = checkNum;
                    this.checkConsecutiveRNFs[n] = this.checkConsecutiveRNFs[n] + 1;
                    if (this.persistent) {
                        container.activate((Object)this.blockInsertContext, 1);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Consecutive RNFs: " + this.checkConsecutiveRNFs[checkNum] + " / " + this.blockInsertContext.consecutiveRNFsCountAsSuccess);
                    }
                    if (this.checkConsecutiveRNFs[checkNum] == this.blockInsertContext.consecutiveRNFsCountAsSuccess) {
                        treatAsSuccess = true;
                    }
                } else {
                    this.checkConsecutiveRNFs[checkNum] = 0;
                }
                if (!treatAsSuccess) {
                    int n = checkNum;
                    this.checkRetries[n] = this.checkRetries[n] + 1;
                    if (this.checkRetries[checkNum] > this.maxRetries && this.maxRetries != -1) {
                        failedBlock = true;
                        this.checkFinished[checkNum] = true;
                        this.checkFailed[checkNum] = true;
                        ++this.blocksCompleted;
                        if (this.persistent) {
                            container.activate(this.blocks, 2);
                        }
                        this.blocks.remove((Object)blockNum);
                        if (this.persistent) {
                            container.store(this.blocks);
                        }
                        if (this.checkBlocks[checkNum] != null) {
                            if (this.persistent) {
                                container.activate((Object)this.checkBlocks[checkNum], 1);
                            }
                            this.checkBlocks[checkNum].free();
                            if (this.persistent) {
                                this.checkBlocks[checkNum].removeFrom(container);
                            }
                            this.checkBlocks[checkNum] = null;
                            if (logMINOR) {
                                Logger.minor(this, "Failed to insert check block " + checkNum + " on " + this);
                            }
                        } else {
                            Logger.error(this, "Check block " + checkNum + " failed on " + this + " but bucket is already nulled out!");
                        }
                    }
                } else {
                    this.checkFinished[checkNum] = true;
                    this.checkFailed[checkNum] = false;
                    ++this.blocksCompleted;
                    ++this.blocksSucceeded;
                    if (this.persistent) {
                        container.activate(this.blocks, 2);
                    }
                    this.blocks.remove((Object)blockNum);
                    if (this.persistent) {
                        container.store(this.blocks);
                    }
                    if (this.checkBlocks[checkNum] != null) {
                        if (this.persistent) {
                            container.activate((Object)this.checkBlocks[checkNum], 1);
                        }
                        this.checkBlocks[checkNum].free();
                        if (this.persistent) {
                            this.checkBlocks[checkNum].removeFrom(container);
                        }
                        this.checkBlocks[checkNum] = null;
                        if (logMINOR) {
                            Logger.minor(this, "Repeated RNF, treating as success for check block " + checkNum + " on " + this);
                        }
                    } else {
                        Logger.error(this, "Check block " + checkNum + " succeeded (sort of) on " + this + " but bucket is already nulled out!");
                    }
                }
            } else {
                if (this.dataFinished[blockNum]) {
                    if (this.dataFailed[blockNum]) {
                        Logger.error(this, "Got onFailure() but block has already failed! Data block " + blockNum + " on " + this);
                    } else {
                        Logger.error(this, "Got onFailure() but block has already succeeded: Data block " + blockNum + " on " + this);
                    }
                    return;
                }
                if (isRNF) {
                    int n = blockNum;
                    this.dataConsecutiveRNFs[n] = this.dataConsecutiveRNFs[n] + 1;
                    if (this.persistent) {
                        container.activate((Object)this.blockInsertContext, 1);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Consecutive RNFs: " + this.dataConsecutiveRNFs[blockNum] + " / " + this.blockInsertContext.consecutiveRNFsCountAsSuccess);
                    }
                    if (this.dataConsecutiveRNFs[blockNum] == this.blockInsertContext.consecutiveRNFsCountAsSuccess) {
                        treatAsSuccess = true;
                    }
                } else {
                    this.dataConsecutiveRNFs[blockNum] = 0;
                }
                if (!treatAsSuccess) {
                    int n = blockNum;
                    this.dataRetries[n] = this.dataRetries[n] + 1;
                    if (this.dataRetries[blockNum] > this.maxRetries && this.maxRetries != -1) {
                        failedBlock = true;
                        this.dataFinished[blockNum] = true;
                        this.dataFailed[blockNum] = true;
                        ++this.blocksCompleted;
                        if (this.persistent) {
                            container.activate(this.blocks, 2);
                        }
                        this.blocks.remove((Object)blockNum);
                        if (this.persistent) {
                            container.store(this.blocks);
                        }
                        if (this.encoded && this.dataBlocks[blockNum] != null) {
                            if (this.persistent) {
                                container.activate((Object)this.dataBlocks[blockNum], 1);
                            }
                            this.dataBlocks[blockNum].free();
                            if (this.persistent) {
                                this.dataBlocks[blockNum].removeFrom(container);
                            }
                            this.dataBlocks[blockNum] = null;
                            if (logMINOR) {
                                Logger.minor(this, "Failed to insert data block " + blockNum + " on " + this);
                            }
                        } else if (this.dataBlocks[blockNum] == null) {
                            Logger.error(this, "Data block " + blockNum + " failed on " + this + " but bucket is already nulled out!");
                        }
                    }
                } else {
                    this.dataFinished[blockNum] = true;
                    this.dataFailed[blockNum] = false;
                    ++this.blocksCompleted;
                    ++this.blocksSucceeded;
                    if (this.persistent) {
                        container.activate(this.blocks, 2);
                    }
                    this.blocks.remove((Object)blockNum);
                    if (this.persistent) {
                        container.store(this.blocks);
                    }
                    if (this.dataBlocks[blockNum] != null && this.encoded) {
                        if (this.persistent) {
                            container.activate((Object)this.dataBlocks[blockNum], 1);
                        }
                        this.dataBlocks[blockNum].free();
                        if (this.persistent) {
                            this.dataBlocks[blockNum].removeFrom(container);
                        }
                        this.dataBlocks[blockNum] = null;
                        if (logMINOR) {
                            Logger.minor(this, "Repeated RNF, treating as success for data block " + blockNum + " on " + this);
                        }
                    } else {
                        Logger.error(this, "Data block " + blockNum + " succeeded (sort of) on " + this + " but bucket is already nulled out!");
                    }
                }
            }
            if (this.persistent) {
                container.store((Object)this);
            }
            completed = this.blocksCompleted;
            succeeded = this.blocksSucceeded;
        }
        if (this.persistent) {
            container.activate((Object)this.putter, 1);
        }
        if (failedBlock) {
            this.putter.failedBlock(container, context);
        } else if (treatAsSuccess) {
            this.putter.completedBlock(false, container, context);
        }
        if (this.persistent) {
            container.deactivate((Object)this.putter, 1);
        }
        if (completed == this.dataBlocks.length + this.checkBlocks.length) {
            if (this.persistent) {
                container.activate((Object)this.parent, 1);
            }
            this.finish(container, context, this.parent);
            if (this.persistent) {
                container.deactivate((Object)this.parent, 1);
            }
        } else if (treatAsSuccess && succeeded == this.dataBlocks.length) {
            if (this.persistent) {
                container.activate((Object)this.parent, 1);
            }
            this.parent.segmentFetchable(this, container);
            if (this.persistent) {
                container.deactivate((Object)this.parent, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(Object keyNum, ObjectContainer container, final ClientContext context) {
        int succeeded;
        int completed;
        BlockItem block = (BlockItem)keyNum;
        int blockNum = block.blockNum();
        if (logMINOR) {
            Logger.minor(this, "Block " + blockNum + " succeeded on " + this);
        }
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            if (this.finished) {
                return;
            }
            if (blockNum >= this.dataBlocks.length) {
                int checkNum = blockNum - this.dataBlocks.length;
                if (!this.checkFinished[checkNum]) {
                    this.checkFinished[checkNum] = true;
                    this.checkFailed[checkNum] = false;
                    ++this.blocksCompleted;
                    ++this.blocksSucceeded;
                    if (this.persistent) {
                        container.activate(this.blocks, 2);
                    }
                    this.blocks.remove((Object)blockNum);
                    if (this.persistent) {
                        container.store(this.blocks);
                    }
                } else {
                    if (this.checkFailed[checkNum]) {
                        Logger.error(this, "Got onSuccess() but block has already failed! Check block " + checkNum + " on " + this);
                    } else {
                        Logger.error(this, "Got onSuccess() but block has already succeeded: Check block " + checkNum + " on " + this);
                    }
                    return;
                }
                if (this.checkBlocks[checkNum] != null) {
                    if (this.persistent) {
                        container.activate((Object)this.checkBlocks[checkNum], 1);
                    }
                    this.checkBlocks[checkNum].free();
                    if (this.persistent) {
                        this.checkBlocks[checkNum].removeFrom(container);
                    }
                    this.checkBlocks[checkNum] = null;
                } else {
                    Logger.error(this, "Check block " + checkNum + " succeeded on " + this + " but bucket is already nulled out!");
                }
            } else {
                if (!this.dataFinished[blockNum]) {
                    this.dataFinished[blockNum] = true;
                    this.dataFailed[blockNum] = false;
                    ++this.blocksCompleted;
                    ++this.blocksSucceeded;
                    if (this.persistent) {
                        container.activate(this.blocks, 2);
                    }
                    this.blocks.remove((Object)blockNum);
                    if (this.persistent) {
                        container.store(this.blocks);
                    }
                } else {
                    if (this.dataFailed[blockNum]) {
                        Logger.error(this, "Got onSuccess() but block has already failed! Data block " + blockNum + " on " + this);
                    } else {
                        Logger.error(this, "Got onSuccess() but block has already succeeded: Data block " + blockNum + " on " + this);
                    }
                    return;
                }
                if (this.encoded && this.dataBlocks[blockNum] != null) {
                    if (this.persistent) {
                        container.activate((Object)this.dataBlocks[blockNum], 1);
                    }
                    this.dataBlocks[blockNum].free();
                    if (this.persistent) {
                        this.dataBlocks[blockNum].removeFrom(container);
                    }
                    this.dataBlocks[blockNum] = null;
                } else if (this.dataBlocks[blockNum] == null) {
                    Logger.error(this, "Data block " + blockNum + " succeeded on " + this + " but bucket is already nulled out!");
                    if (this.persistent) {
                        Logger.minor(this, "Activation state: " + container.ext().isActive((Object)this));
                    }
                }
            }
            if (this.persistent) {
                container.store((Object)this);
            }
            completed = this.blocksCompleted;
            succeeded = this.blocksSucceeded;
        }
        if (this.persistent) {
            container.activate((Object)this.putter, 1);
        }
        this.putter.completedBlock(false, container, context);
        if (this.persistent) {
            container.deactivate((Object)this.putter, 1);
        }
        if (completed == this.dataBlocks.length + this.checkBlocks.length) {
            if (this.persistent) {
                container.activate((Object)this.parent, 1);
            }
            if (!this.persistent) {
                context.mainExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        SplitFileInserterSegment.this.finish(null, context, SplitFileInserterSegment.this.parent);
                    }
                });
            } else {
                this.finish(container, context, this.parent);
            }
            if (this.persistent) {
                container.deactivate((Object)this.parent, 1);
            }
        } else if (succeeded == this.dataBlocks.length) {
            if (this.persistent) {
                container.activate((Object)this.parent, 1);
            }
            if (!this.persistent) {
                context.mainExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        SplitFileInserterSegment.this.parent.segmentFetchable(SplitFileInserterSegment.this, null);
                    }
                });
            } else {
                this.parent.segmentFetchable(this, container);
            }
            if (this.persistent) {
                container.deactivate((Object)this.parent, 1);
            }
        }
    }

    @Override
    public long countAllKeys(ObjectContainer container, ClientContext context) {
        return this.countSendableKeys(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendableRequestItem chooseKey(KeysFetchingLocally keys, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this, 1);
            container.activate(this.blocks, 1);
        }
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            if (this.finished) {
                return null;
            }
            if (this.blocks.isEmpty()) {
                if (logMINOR) {
                    Logger.minor(this, "No blocks to remove");
                }
                return null;
            }
            for (int i = 0; i < 10; ++i) {
                if (this.blocks.size() == 0) {
                    return null;
                }
                int x = context.random.nextInt(this.blocks.size());
                Integer ret = this.blocks.get(x);
                int num = ret;
                if (!this.persistent && keys.hasTransientInsert(this, new BlockItemKey(this, num))) continue;
                try {
                    return this.getBlockItem(container, context, num, this.cryptoAlgorithm);
                }
                catch (IOException e) {
                    this.fail(new InsertException(2, e, null), container, context);
                    return null;
                }
            }
            return null;
        }
    }

    @Override
    public RequestClient getClient(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.putter, 1);
        }
        return this.putter.getClient();
    }

    @Override
    public ClientRequester getClientRequest() {
        return this.putter;
    }

    @Override
    public short getPriorityClass(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.putter, 1);
        }
        return this.putter.getPriorityClass();
    }

    @Override
    public SendableRequestSender getSender(ObjectContainer container, ClientContext context) {
        boolean deactivateParent = false;
        boolean deactivateParentCtx = false;
        if (this.persistent) {
            deactivateParent = !container.ext().isActive((Object)this.parent);
            boolean bl = deactivateParentCtx = !container.ext().isActive((Object)this.parent.ctx);
            if (deactivateParent) {
                container.activate((Object)this.parent, 1);
            }
            if (deactivateParentCtx) {
                container.activate((Object)this.parent.ctx, 1);
            }
        }
        MySendableRequestSender result = new MySendableRequestSender(this.parent.ctx.compressorDescriptor, this);
        if (this.persistent) {
            if (deactivateParent) {
                container.deactivate((Object)this.parent, 1);
            }
            if (deactivateParentCtx) {
                container.deactivate((Object)this.parent.ctx, 1);
            }
        }
        return result;
    }

    protected static ClientCHKBlock encodeBucket(Bucket copyBucket, String compressorDescriptor, byte cryptoAlgorithm, byte[] cryptoKey) throws CHKEncodeException, IOException {
        byte[] buf = BucketTools.toByteArray(copyBucket);
        assert (buf.length == 32768);
        return ClientCHKBlock.encodeSplitfileBlock(buf, cryptoKey, cryptoAlgorithm);
    }

    @Override
    public boolean isCancelled(ObjectContainer container) {
        return this.finished;
    }

    @Override
    public boolean isSSK() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PersistentChosenBlock> makeBlocks(PersistentChosenRequest request, RequestScheduler sched, KeysFetchingLocally keys, ObjectContainer container, ClientContext context) {
        Object[] blockNumbers;
        if (this.persistent) {
            container.activate(this.blocks, 1);
        }
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            blockNumbers = this.blocks.toArray(new Integer[this.blocks.size()]);
        }
        ArrayList<PersistentChosenBlock> ret = new ArrayList<PersistentChosenBlock>();
        Arrays.sort(blockNumbers);
        int prevBlockNumber = -1;
        byte cryptoAlgorithm = this.getCryptoAlgorithm(container);
        Object[] arr$ = blockNumbers;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            BlockItem item;
            int blockNumber = (Integer)arr$[i$];
            if (blockNumber == prevBlockNumber) {
                Logger.error(this, "Duplicate block number in makeBlocks() in " + this + ": two copies of " + blockNumber);
                continue;
            }
            prevBlockNumber = blockNumber;
            try {
                item = this.getBlockItem(container, context, blockNumber, cryptoAlgorithm);
                if (item == null) {
                    continue;
                }
            }
            catch (IOException e) {
                this.fail(new InsertException(2, e, null), container, context);
                return null;
            }
            PersistentChosenBlock block = new PersistentChosenBlock(true, request, item, null, null, sched);
            if (logMINOR) {
                Logger.minor(this, "Created block " + block + " for block number " + blockNumber + " on " + this);
            }
            ret.add(block);
        }
        if (this.persistent) {
            container.deactivate(this.blocks, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Returning " + ret.size() + " blocks");
        }
        return ret;
    }

    @Override
    public synchronized long countSendableKeys(ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate(this.blocks, 1);
        }
        int sz = this.blocks.size();
        if (this.persistent) {
            container.deactivate(this.blocks, 1);
        }
        return sz;
    }

    @Override
    public synchronized boolean isEmpty(ObjectContainer container) {
        boolean ret;
        if (this.persistent) {
            container.activate(this.blocks, 2);
        }
        boolean bl = ret = this.finished || this.blocks.isEmpty();
        if (this.persistent) {
            container.deactivate(this.blocks, 1);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFrom(ObjectContainer container, ClientContext context) {
        ClientCHK chk;
        int i;
        container.activate((Object)this.encodeJob, 1);
        if (this.encodeJob != null) {
            if (!this.encodeJob.cancel(container, context)) {
                SplitFileInserterSegment splitFileInserterSegment = this;
                synchronized (splitFileInserterSegment) {
                    this.removeOnEncode = true;
                    if (logMINOR) {
                        Logger.minor(this, "Will remove after encode finished: " + this);
                    }
                    container.store((Object)this);
                    return;
                }
            }
            this.encodeJob = null;
        }
        this.freeBucketsArray(container, this.dataBlocks);
        this.freeBucketsArray(container, this.checkBlocks);
        for (i = 0; i < this.dataURIs.length; ++i) {
            chk = this.dataURIs[i];
            if (chk != null) {
                container.activate((Object)chk, 5);
                chk.removeFrom(container);
                continue;
            }
            if (!logMINOR) continue;
            Logger.minor(this, "dataURI " + i + " is null on " + this);
        }
        for (i = 0; i < this.checkURIs.length; ++i) {
            chk = this.checkURIs[i];
            if (chk != null) {
                container.activate((Object)chk, 5);
                chk.removeFrom(container);
                continue;
            }
            if (!logMINOR) continue;
            Logger.minor(this, "checkURI " + i + " is null on " + this);
        }
        container.activate(this.blocks, 5);
        for (Integer i2 : this.blocks) {
            container.activate((Object)i2, 1);
            container.delete((Object)i2);
        }
        container.delete(this.blocks);
        if (this.toThrow != null) {
            container.activate((Object)this.toThrow, 5);
            this.toThrow.removeFrom(container);
        }
        if (this.errors != null) {
            container.activate((Object)this.errors, 1);
            this.errors.removeFrom(container);
        }
        container.delete((Object)this);
    }

    @Override
    public boolean canWriteClientCache(ObjectContainer container) {
        boolean deactivate = false;
        if (this.persistent) {
            boolean bl = deactivate = !container.ext().isActive((Object)this.blockInsertContext);
            if (deactivate) {
                container.activate((Object)this.blockInsertContext, 1);
            }
        }
        boolean retval = this.blockInsertContext.canWriteClientCache;
        if (deactivate) {
            container.deactivate((Object)this.blockInsertContext, 1);
        }
        return retval;
    }

    @Override
    public boolean localRequestOnly(ObjectContainer container) {
        boolean deactivate = false;
        if (this.persistent) {
            boolean bl = deactivate = !container.ext().isActive((Object)this.blockInsertContext);
            if (deactivate) {
                container.activate((Object)this.blockInsertContext, 1);
            }
        }
        boolean retval = this.blockInsertContext.localRequestOnly;
        if (deactivate) {
            container.deactivate((Object)this.blockInsertContext, 1);
        }
        return retval;
    }

    @Override
    public boolean forkOnCacheable(ObjectContainer container) {
        boolean deactivate = false;
        if (this.persistent) {
            boolean bl = deactivate = !container.ext().isActive((Object)this.blockInsertContext);
            if (deactivate) {
                container.activate((Object)this.blockInsertContext, 1);
            }
        }
        boolean retval = this.blockInsertContext.forkOnCacheable;
        if (deactivate) {
            container.deactivate((Object)this.blockInsertContext, 1);
        }
        return retval;
    }

    public boolean objectCanNew(ObjectContainer container) {
        if (this.finished) {
            Logger.error(this, "Storing " + this + " when already finished!", (Throwable)new Exception("error"));
            return false;
        }
        if (logDEBUG) {
            Logger.debug(this, "Storing " + this + " activated=" + container.ext().isActive((Object)this) + " stored=" + container.ext().isStored((Object)this), (Throwable)new Exception("debug"));
        }
        return true;
    }

    private void freeBucketsArray(ObjectContainer container, Bucket[] buckets) {
        for (int i = 0; i < buckets.length; ++i) {
            if (buckets[i] == null) continue;
            if (this.persistent) {
                container.activate((Object)buckets[i], 1);
            }
            buckets[i].free();
            if (this.persistent) {
                buckets[i].removeFrom(container);
            }
            buckets[i] = null;
        }
    }

    private void freeFinishedDataBlocks(ObjectContainer container) {
        for (int i = 0; i < this.dataBlocks.length; ++i) {
            if (!this.dataFinished[i] || this.dataBlocks[i] == null) continue;
            if (logMINOR) {
                Logger.minor(this, "Freeing data block " + i + " delayed for encode");
            }
            if (this.persistent) {
                container.activate((Object)this.dataBlocks[i], 1);
            }
            this.dataBlocks[i].free();
            if (this.persistent) {
                this.dataBlocks[i].removeFrom(container);
            }
            this.dataBlocks[i] = null;
        }
    }

    @Override
    public boolean isStorageBroken(ObjectContainer container) {
        if (this.putter == null) {
            return true;
        }
        if (this.parent == null) {
            return true;
        }
        if (this.dataRetries == null) {
            return true;
        }
        return this.checkRetries == null;
    }

    public void checkHasDataBlocks(boolean log, ObjectContainer container) {
        int dataCount = 0;
        int dataKeys = 0;
        int dataDone = 0;
        for (int i = 0; i < this.dataBlocks.length; ++i) {
            Bucket data = this.dataBlocks[i];
            if (data == null) {
                if (log) {
                    System.err.println("Data block " + i + " is null!");
                }
            } else {
                container.activate((Object)data, 5);
                if (data.size() != 32768L) {
                    System.err.println("Size of data block " + i + " is " + data.size() + " should be " + 32768);
                } else {
                    ++dataCount;
                }
                if (log) {
                    System.err.println(data.toString() + " : " + data.size());
                }
                container.deactivate((Object)data, 5);
            }
            if (this.dataURIs[i] != null) {
                ++dataKeys;
            }
            if (!this.dataFinished[i]) continue;
            ++dataDone;
        }
        if (dataCount == this.dataBlocks.length) {
            System.out.println("Has all data blocks");
        } else {
            System.out.println("Does not have all data blocks: " + dataCount + " of " + this.dataBlocks.length);
        }
        System.out.println("Data blocks have URIs: " + dataKeys + " finished: " + dataDone);
        int checkCount = 0;
        int checkKeys = 0;
        int checkDone = 0;
        for (int i = 0; i < this.checkBlocks.length; ++i) {
            Bucket data = this.checkBlocks[i];
            if (data != null) {
                if (data.size() != 32768L) {
                    System.err.println("Size of check block " + i + " is " + data.size() + " should be " + 32768);
                } else {
                    ++checkCount;
                }
            }
            if (this.checkURIs[i] != null) {
                ++checkKeys;
            }
            if (!this.checkFinished[i]) continue;
            ++checkDone;
        }
        System.out.println("Check count: " + checkCount + " keys: " + checkKeys + " done: " + checkDone);
        if (this.encodeJob == null) {
            System.err.println("NO QUEUED FEC JOB!");
            container.activate((Object)this.parent, 1);
            System.err.println("Parent: " + this.parent);
            if (this.parent != null) {
                this.parent.dump(container);
            }
            container.deactivate((Object)this.parent, 1);
        } else {
            container.activate((Object)this.encodeJob, 1);
            System.err.println("Queued FEC job: " + this.encodeJob);
            this.encodeJob.dump(container);
            container.deactivate((Object)this.encodeJob, 1);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void onEncode(SendableRequestItem token, ClientKey key, ObjectContainer container, ClientContext context) {
        this.onEncode(((BlockItem)token).blockNum(), (ClientCHK)key, container, context);
    }

    public int allocateCrossDataBlock(SplitFileInserterCrossSegment seg, Random random) {
        int i;
        int size = this.realDataBlocks();
        if (this.crossDataBlocksAllocated == size) {
            return -1;
        }
        int x = 0;
        for (i = 0; i < 10; ++i) {
            x = random.nextInt(size);
            if (this.crossSegmentsByBlock[x] != null) continue;
            this.crossSegmentsByBlock[x] = seg;
            ++this.crossDataBlocksAllocated;
            return x;
        }
        for (i = 0; i < size; ++i) {
            if (++x == size) {
                x = 0;
            }
            if (this.crossSegmentsByBlock[x] != null) continue;
            this.crossSegmentsByBlock[x] = seg;
            ++this.crossDataBlocksAllocated;
            return x;
        }
        throw new IllegalStateException("Unable to allocate cross data block even though have not used all slots up???");
    }

    public int allocateCrossCheckBlock(SplitFileInserterCrossSegment seg, Random random) {
        if (this.crossCheckBlocksAllocated == this.crossCheckBlocks) {
            return -1;
        }
        int x = this.dataBlocks.length - (1 + random.nextInt(this.crossCheckBlocks));
        for (int i = 0; i < this.crossCheckBlocks; ++i) {
            if (++x == this.dataBlocks.length) {
                x = this.dataBlocks.length - this.crossCheckBlocks;
            }
            if (this.crossSegmentsByBlock[x] != null) continue;
            this.crossSegmentsByBlock[x] = seg;
            ++this.crossCheckBlocksAllocated;
            return x;
        }
        throw new IllegalStateException("Unable to allocate cross check block even though have not used all slots up???");
    }

    public final int realDataBlocks() {
        return this.dataBlocks.length - this.crossCheckBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEncodedCrossCheckBlock(int blockNum, Bucket data, ObjectContainer container, ClientContext context) {
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            if (this.dataBlocks[blockNum] != null) {
                Logger.error(this, "Cross-check block already encoded??? " + blockNum + " on " + this);
                data.free();
                return;
            }
            this.dataBlocks[blockNum] = data;
            ++this.encodedCrossCheckBlocks;
            if (logMINOR && this.encodedCrossCheckBlocks != this.crossCheckBlocks) {
                Logger.minor(this, "Segment " + this.segNo + " has " + this.encodedCrossCheckBlocks + " encoded of " + this.crossCheckBlocks + ", still waiting...");
            }
        }
        if (this.persistent) {
            data.storeTo(container);
            container.store((Object)this);
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, SplitFileInserterSegment.class);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, SplitFileInserterSegment.class);
            }
        });
    }

    static class MySendableRequestSender
    implements SendableRequestSender {
        private final String compressorDescriptor;
        private final SplitFileInserterSegment seg;

        MySendableRequestSender(String compressorDescriptor2, SplitFileInserterSegment seg) {
            this.compressorDescriptor = compressorDescriptor2;
            this.seg = seg;
        }

        @Override
        public boolean send(NodeClientCore core, RequestScheduler sched, ClientContext context, ChosenBlock req) {
            block19: {
                BlockItem block = (BlockItem)req.token;
                try {
                    CHKBlock b;
                    ClientCHKBlock encodedBlock;
                    if (logMINOR) {
                        Logger.minor(this, "Starting request: block number " + block.blockNum());
                    }
                    try {
                        encodedBlock = SplitFileInserterSegment.encodeBucket(block.copyBucket, this.compressorDescriptor, block.cryptoAlgorithm, block.cryptoKey);
                        b = encodedBlock.getBlock();
                    }
                    catch (CHKEncodeException e) {
                        throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage() + " for " + block.copyBucket, e);
                    }
                    catch (MalformedURLException e) {
                        throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage() + " for " + block.copyBucket, e);
                    }
                    catch (IOException e) {
                        throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage() + " for " + block.copyBucket, e);
                    }
                    finally {
                        block.copyBucket.free();
                    }
                    if (b == null) {
                        Logger.error(this, "Asked to send empty block", (Throwable)new Exception("error"));
                        return false;
                    }
                    ClientCHK key = encodedBlock.getClientKey();
                    int num = block.blockNum();
                    if (block.persistent) {
                        req.setGeneratedKey(key);
                    } else {
                        this.seg.onEncode(num, key, null, context);
                    }
                    if (req.localRequestOnly) {
                        try {
                            core.node.store((KeyBlock)b, false, req.canWriteClientCache, true, false);
                            break block19;
                        }
                        catch (KeyCollisionException e) {
                            throw new LowLevelPutException(5);
                        }
                    }
                    core.realPut(b, req.canWriteClientCache, req.forkOnCacheable, false, false, req.realTimeFlag);
                }
                catch (LowLevelPutException e) {
                    req.onFailure(e, context);
                    if (logMINOR) {
                        Logger.minor(this, "Request failed for " + e);
                    }
                    return true;
                }
            }
            if (logMINOR) {
                Logger.minor(this, "Request succeeded");
            }
            req.onInsertSuccess(context);
            return true;
        }

        @Override
        public boolean sendIsBlocking() {
            return true;
        }
    }

    private static class BlockItem
    implements SendableRequestItem {
        private final Bucket copyBucket;
        private final BlockItemKey key;
        private final boolean persistent;
        final byte cryptoAlgorithm;
        public byte[] cryptoKey;

        BlockItem(SplitFileInserterSegment parent, int blockNum, Bucket bucket, boolean persistent, byte cryptoAlgorithm, byte[] cryptoKey) throws IOException {
            this.key = new BlockItemKey(parent, blockNum);
            this.copyBucket = bucket;
            this.persistent = persistent;
            this.cryptoAlgorithm = cryptoAlgorithm;
            this.cryptoKey = cryptoKey;
        }

        @Override
        public void dump() {
            this.copyBucket.free();
        }

        @Override
        public SendableRequestItemKey getKey() {
            return this.key;
        }

        public int blockNum() {
            return this.key.blockNum;
        }
    }

    private static class BlockItemKey
    implements SendableRequestItemKey {
        private final int hashCode;
        private final SplitFileInserterSegment parent;
        private final int blockNum;

        BlockItemKey(SplitFileInserterSegment parent, int blockNum) {
            this.parent = parent;
            this.blockNum = blockNum;
            this.hashCode = parent.hashCodeForBlock(blockNum);
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof BlockItemKey && ((BlockItemKey)o).parent == this.parent && ((BlockItemKey)o).blockNum == this.blockNum;
        }
    }
}

