/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutState;
import freenet.client.async.MultiPutCompletionCallback;
import freenet.client.async.PutCompletionCallback;
import freenet.client.async.SingleBlockInserter;
import freenet.client.async.USKDateHint;
import freenet.client.async.USKFetcherCallback;
import freenet.client.async.USKFetcherTag;
import freenet.keys.BaseClientKey;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableUSK;
import freenet.keys.USK;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.BucketTools;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.Arrays;

public class USKInserter
implements ClientPutState,
USKFetcherCallback,
PutCompletionCallback {
    private static volatile boolean logMINOR;
    final BaseClientPutter parent;
    Bucket data;
    final short compressionCodec;
    final InsertContext ctx;
    final PutCompletionCallback cb;
    final boolean isMetadata;
    final int sourceLength;
    final int token;
    final boolean getCHKOnly;
    public final Object tokenObject;
    final boolean persistent;
    final boolean realTimeFlag;
    final InsertableUSK privUSK;
    final USK pubUSK;
    private USKFetcherTag fetcher;
    private SingleBlockInserter sbi;
    private long edition;
    private int consecutiveCollisions;
    private boolean finished;
    private static final long MAX_TRIED_SLOTS = 10L;
    private boolean freeData;
    final int hashCode = super.hashCode();
    private final int extraInserts;
    final byte cryptoAlgorithm;
    final byte[] forceCryptoKey;

    @Override
    public void schedule(ObjectContainer container, ClientContext context) throws InsertException {
        this.scheduleFetcher(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleFetcher(ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.pubUSK, 5);
        }
        USKInserter uSKInserter = this;
        synchronized (uSKInserter) {
            if (logMINOR) {
                Logger.minor(this, "scheduling fetcher for " + this.pubUSK.getURI());
            }
            if (this.finished) {
                return;
            }
            this.fetcher = context.uskManager.getFetcherForInsertDontSchedule(this.persistent ? this.pubUSK.copy() : this.pubUSK, this.parent.priorityClass, this, this.parent.getClient(), container, context, this.persistent, this.ctx.ignoreUSKDatehints);
            if (logMINOR) {
                Logger.minor(this, "scheduled: " + this.fetcher);
            }
        }
        if (this.persistent) {
            container.store((Object)this.fetcher);
            container.store((Object)this);
        }
        this.fetcher.schedule(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFoundEdition(long l, USK key, ObjectContainer container, ClientContext context, boolean lastContentWasMetadata, short codec, byte[] hisData, boolean newKnownGood, boolean newSlotToo) {
        boolean alreadyInserted = false;
        USKInserter uSKInserter = this;
        synchronized (uSKInserter) {
            this.edition = Math.max(l, this.edition);
            this.consecutiveCollisions = 0;
            if (lastContentWasMetadata == this.isMetadata && hisData != null && codec == this.compressionCodec) {
                try {
                    byte[] myData;
                    if (this.persistent) {
                        container.activate((Object)this.data, 1);
                    }
                    if (Arrays.equals(myData = BucketTools.toByteArray(this.data), hisData)) {
                        alreadyInserted = true;
                        this.finished = true;
                        this.sbi = null;
                    }
                }
                catch (IOException e) {
                    Logger.error(this, "Could not decode: " + e, (Throwable)e);
                }
            }
            if (this.persistent) {
                container.activate((Object)this.fetcher, 1);
                container.activate((Object)this.fetcher.ctx, 1);
                this.fetcher.removeFrom(container, context);
                this.fetcher.ctx.removeFrom(container);
                this.fetcher = null;
                container.store((Object)this);
            }
        }
        if (alreadyInserted) {
            if (this.persistent) {
                container.activate((Object)this.parent, 1);
            }
            this.parent.completedBlock(true, container, context);
            if (this.persistent) {
                container.activate((Object)this.cb, 1);
                container.activate((Object)this.pubUSK, 5);
            }
            this.cb.onEncode(this.pubUSK.copy(this.edition), this, container, context);
            this.insertSucceeded(container, context, l);
            if (this.freeData) {
                this.data.free();
                if (this.persistent) {
                    this.data.removeFrom(container);
                }
            }
        } else {
            this.scheduleInsert(container, context);
        }
    }

    private void insertSucceeded(ObjectContainer container, ClientContext context, long edition) {
        byte[] hintData;
        if (this.ctx.ignoreUSKDatehints) {
            if (logMINOR) {
                Logger.minor(this, "Inserted to edition " + edition);
            }
            boolean cbActive = true;
            if (this.persistent && !container.ext().isActive((Object)this.cb)) {
                cbActive = false;
                container.activate((Object)this.cb, 1);
            }
            this.cb.onSuccess(this, container, context);
            if (!cbActive) {
                container.deactivate((Object)this.cb, 1);
            }
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Inserted to edition " + edition + " - inserting USK date hints...");
        }
        USKDateHint hint = USKDateHint.now();
        MultiPutCompletionCallback m = new MultiPutCompletionCallback(this.cb, this.parent, this.tokenObject, this.persistent, true);
        try {
            hintData = hint.getData(edition).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        boolean cbActive = true;
        boolean parentActive = true;
        if (this.persistent) {
            container.activate((Object)this.privUSK, 5);
            container.activate((Object)this.pubUSK, 5);
            if (!container.ext().isActive((Object)this.cb)) {
                cbActive = false;
                container.activate((Object)this.cb, 1);
            }
            if (!container.ext().isActive((Object)this.parent)) {
                parentActive = false;
                container.activate((Object)this.parent, 1);
            }
        }
        FreenetURI[] hintURIs = hint.getInsertURIs(this.privUSK);
        boolean added = false;
        for (FreenetURI uri : hintURIs) {
            try {
                Bucket bucket = BucketTools.makeImmutableBucket(context.getBucketFactory(this.persistent), hintData);
                SingleBlockInserter sb = new SingleBlockInserter(this.parent, bucket, -1, uri, this.ctx, this.realTimeFlag, m, false, this.sourceLength, this.token, this.getCHKOnly, true, true, null, container, context, this.persistent, false, this.extraInserts, this.cryptoAlgorithm, this.forceCryptoKey);
                Logger.normal(this, "Inserting " + uri + " with " + sb + " for insert of " + this.pubUSK);
                m.add(sb, container);
                sb.schedule(container, context);
                added = true;
            }
            catch (IOException e) {
                Logger.error(this, "Unable to insert USK date hints due to disk I/O error: " + e, (Throwable)e);
                if (added) continue;
                this.cb.onFailure(new InsertException(2, e, this.pubUSK.getSSK(edition).getURI()), this, container, context);
                return;
            }
            catch (InsertException e) {
                Logger.error(this, "Unable to insert USK date hints due to error: " + e, (Throwable)e);
                if (added) continue;
                this.cb.onFailure(e, this, container, context);
                return;
            }
        }
        this.cb.onTransition(this, m, container);
        m.arm(container, context);
        if (!parentActive) {
            container.deactivate((Object)this.parent, 1);
        }
        if (!cbActive) {
            container.deactivate((Object)this.cb, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleInsert(ObjectContainer container, ClientContext context) {
        long edNo = Math.max(this.edition, context.uskManager.lookupLatestSlot(this.pubUSK) + 1L);
        if (this.persistent) {
            container.activate((Object)this.privUSK, 5);
            container.activate((Object)this.pubUSK, 5);
            container.activate((Object)this.parent, 1);
        }
        USKInserter uSKInserter = this;
        synchronized (uSKInserter) {
            if (this.finished) {
                return;
            }
            this.edition = edNo;
            if (logMINOR) {
                Logger.minor(this, "scheduling insert for " + this.pubUSK.getURI() + ' ' + this.edition);
            }
            this.sbi = new SingleBlockInserter(this.parent, this.data, this.compressionCodec, this.privUSK.getInsertableSSK(this.edition).getInsertURI(), this.ctx, this.realTimeFlag, this, this.isMetadata, this.sourceLength, this.token, this.getCHKOnly, false, true, this.tokenObject, container, context, this.persistent, false, this.extraInserts, this.cryptoAlgorithm, this.forceCryptoKey);
        }
        try {
            this.sbi.schedule(container, context);
            if (this.persistent) {
                container.store((Object)this);
            }
        }
        catch (InsertException e) {
            USKInserter uSKInserter2 = this;
            synchronized (uSKInserter2) {
                this.finished = true;
            }
            if (this.freeData) {
                if (this.persistent) {
                    container.activate((Object)this.data, 1);
                }
                this.data.free();
                if (this.persistent) {
                    this.data.removeFrom(container);
                }
                uSKInserter2 = this;
                synchronized (uSKInserter2) {
                    this.data = null;
                }
            }
            if (this.persistent) {
                container.store((Object)this);
            }
            this.cb.onFailure(e, this, container, context);
        }
    }

    @Override
    public synchronized void onSuccess(ClientPutState state, ObjectContainer container, ClientContext context) {
        FreenetURI realURI;
        if (this.persistent) {
            container.activate((Object)this.pubUSK, 5);
        }
        USK newEdition = this.pubUSK.copy(this.edition);
        this.finished = true;
        this.sbi = null;
        FreenetURI targetURI = this.pubUSK.getSSK(this.edition).getURI();
        if (!targetURI.equals(realURI = ((SingleBlockInserter)state).getURI(container, context))) {
            Logger.error(this, "URI should be " + targetURI + " actually is " + realURI);
        } else {
            if (logMINOR) {
                Logger.minor(this, "URI should be " + targetURI + " actually is " + realURI);
            }
            context.uskManager.updateKnownGood(this.pubUSK, this.edition, context);
        }
        if (this.persistent) {
            state.removeFrom(container, context);
        }
        if (this.freeData) {
            if (this.persistent) {
                container.activate((Object)this.data, 1);
            }
            this.data.free();
            if (this.persistent) {
                this.data.removeFrom(container);
            }
            this.data = null;
            if (this.persistent) {
                container.store((Object)this);
            }
        }
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
            container.store((Object)this);
        }
        this.cb.onEncode(newEdition, this, container, context);
        this.insertSucceeded(container, context, this.edition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(InsertException e, ClientPutState state, ObjectContainer container, ClientContext context) {
        SingleBlockInserter oldSBI;
        USKInserter uSKInserter = this;
        synchronized (uSKInserter) {
            oldSBI = this.sbi;
            this.sbi = null;
            if (e.getMode() == 9) {
                ++this.edition;
                ++this.consecutiveCollisions;
                if (this.persistent) {
                    container.store((Object)this);
                }
                if ((long)this.consecutiveCollisions > 10L) {
                    this.scheduleFetcher(container, context);
                } else {
                    this.scheduleInsert(container, context);
                }
            } else {
                Bucket d = null;
                USKInserter uSKInserter2 = this;
                synchronized (uSKInserter2) {
                    this.finished = true;
                    if (this.freeData) {
                        d = this.data;
                        this.data = null;
                    }
                }
                if (this.freeData) {
                    if (this.persistent) {
                        container.activate((Object)d, 1);
                    }
                    d.free();
                    if (this.persistent) {
                        d.removeFrom(container);
                    }
                    if (this.persistent) {
                        container.store((Object)this);
                    }
                }
                if (this.persistent) {
                    container.activate((Object)this.cb, 1);
                }
                this.cb.onFailure(e, state, container, context);
            }
        }
        if (state != null && this.persistent) {
            state.removeFrom(container, context);
        }
        if (oldSBI != null && oldSBI != state && this.persistent) {
            container.activate((Object)oldSBI, 1);
            oldSBI.removeFrom(container, context);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public USKInserter(BaseClientPutter parent, Bucket data, short compressionCodec, FreenetURI uri, InsertContext ctx, PutCompletionCallback cb, boolean isMetadata, int sourceLength, int token, boolean getCHKOnly, boolean addToParent, Object tokenObject, ObjectContainer container, ClientContext context, boolean freeData, boolean persistent, boolean realTimeFlag, int extraInserts, byte cryptoAlgorithm, byte[] forceCryptoKey) throws MalformedURLException {
        this.tokenObject = tokenObject;
        this.persistent = persistent;
        this.parent = parent;
        this.data = data;
        this.compressionCodec = compressionCodec;
        this.ctx = ctx;
        this.cb = cb;
        this.isMetadata = isMetadata;
        this.sourceLength = sourceLength;
        this.token = token;
        this.getCHKOnly = getCHKOnly;
        if (addToParent) {
            parent.addMustSucceedBlocks(1, container);
            parent.notifyClients(container, context);
        }
        this.privUSK = InsertableUSK.createInsertable(uri, persistent);
        this.pubUSK = this.privUSK.getUSK();
        this.edition = this.pubUSK.suggestedEdition;
        this.freeData = freeData;
        this.extraInserts = extraInserts;
        this.cryptoAlgorithm = cryptoAlgorithm;
        this.forceCryptoKey = forceCryptoKey;
        this.realTimeFlag = realTimeFlag;
    }

    @Override
    public BaseClientPutter getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ObjectContainer container, ClientContext context) {
        USKFetcherTag tag;
        boolean persist = this.persistent;
        USKInserter uSKInserter = this;
        synchronized (uSKInserter) {
            if (this.finished) {
                return;
            }
            this.finished = true;
            tag = this.fetcher;
            this.fetcher = null;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        if (tag != null) {
            tag.cancel(container, context);
            if (persist) {
                container.activate((Object)this, 1);
            }
        }
        if (this.sbi != null) {
            this.sbi.cancel(container, context);
            if (persist) {
                container.activate((Object)this, 1);
            }
        }
        if (this.freeData) {
            if (this.data == null) {
                if (this.persistent) {
                    if (container.ext().isActive((Object)this)) {
                        Logger.error(this, "data = null in cancel() on " + this + " even though active");
                    } else {
                        Logger.error(this, "Not active in cancel() on " + this);
                    }
                }
                Logger.error(this, "data == null in cancel() on " + this, (Throwable)new Exception("error"));
            } else {
                if (this.persistent) {
                    container.activate((Object)this.data, 1);
                }
                this.data.free();
                if (this.persistent) {
                    this.data.removeFrom(container);
                }
                uSKInserter = this;
                synchronized (uSKInserter) {
                    this.data = null;
                }
                if (this.persistent) {
                    container.store((Object)this);
                }
            }
        }
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onFailure(new InsertException(10), this, container, context);
    }

    @Override
    public void onFailure(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Fetcher failed to find the given edition or any later edition on " + this);
        }
        this.scheduleInsert(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCancelled(ObjectContainer container, ClientContext context) {
        USKInserter uSKInserter = this;
        synchronized (uSKInserter) {
            if (this.fetcher != null) {
                if (this.persistent) {
                    container.activate((Object)this.fetcher, 1);
                    container.activate((Object)this.fetcher.ctx, 1);
                    this.fetcher.ctx.removeFrom(container);
                    this.fetcher.removeFrom(container, context);
                }
                this.fetcher = null;
            }
            if (this.finished) {
                return;
            }
        }
        Logger.error(this, "Unexpected onCancelled()", (Throwable)new Exception("error"));
        this.cancel(container, context);
    }

    @Override
    public void onEncode(BaseClientKey key, ClientPutState state, ObjectContainer container, ClientContext context) {
    }

    @Override
    public void onTransition(ClientPutState oldState, ClientPutState newState, ObjectContainer container) {
        Logger.error(this, "Got onTransition(" + oldState + ',' + newState + ')');
    }

    @Override
    public void onMetadata(Metadata m, ClientPutState state, ObjectContainer container, ClientContext context) {
        Logger.error(this, "Got onMetadata(" + m + ',' + state + ')');
    }

    @Override
    public void onBlockSetFinished(ClientPutState state, ObjectContainer container, ClientContext context) {
    }

    @Override
    public Object getToken() {
        return this.tokenObject;
    }

    @Override
    public void onFetchable(ClientPutState state, ObjectContainer container) {
    }

    @Override
    public short getPollingPriorityNormal() {
        return this.parent.getPriorityClass();
    }

    @Override
    public short getPollingPriorityProgress() {
        return this.parent.getPriorityClass();
    }

    @Override
    public void removeFrom(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Removing from database: " + this, (Throwable)new Exception("debug"));
        }
        if (this.freeData && this.data != null && container.ext().isStored((Object)this.data)) {
            try {
                this.data.free();
            }
            catch (Throwable t) {
                Logger.error(this, "Already freed? Caught in removeFrom on " + this + " : " + this.data + " : " + t, t);
            }
            this.data.removeFrom(container);
        }
        container.activate((Object)this.privUSK, 5);
        this.privUSK.removeFrom(container);
        container.activate((Object)this.pubUSK, 5);
        this.pubUSK.removeFrom(container);
        if (this.fetcher != null) {
            Logger.error(this, "Fetcher tag still present: " + this.fetcher + " in removeFrom() for " + this, (Throwable)new Exception("debug"));
            container.activate((Object)this.fetcher, 1);
            container.activate((Object)this.fetcher.ctx, 1);
            this.fetcher.ctx.removeFrom(container);
            this.fetcher.removeFrom(container, context);
        }
        if (this.sbi != null) {
            Logger.error(this, "sbi still present: " + this.sbi + " in removeFrom() for " + this);
            container.activate((Object)this.sbi, 1);
            this.sbi.removeFrom(container, context);
        }
        container.delete((Object)this);
    }

    @Override
    public void onMetadata(Bucket meta, ClientPutState state, ObjectContainer container, ClientContext context) {
        Logger.error(this, "onMetadata on " + this + " from " + state, (Throwable)new Exception("error"));
        meta.free();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

