/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveContext;
import freenet.client.ClientMetadata;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.InsertContext;
import freenet.client.async.BaseClientGetter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.SingleFileFetcher;
import freenet.client.async.StreamGenerator;
import freenet.client.async.USKCallback;
import freenet.client.async.USKFetcher;
import freenet.client.async.USKManager;
import freenet.client.async.USKRetrieverCallback;
import freenet.crypt.HashResult;
import freenet.keys.FreenetURI;
import freenet.keys.USK;
import freenet.node.RequestClient;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.compress.Compressor;
import java.net.MalformedURLException;
import java.util.List;

public class USKRetriever
extends BaseClientGetter
implements USKCallback {
    final FetchContext ctx;
    final USKRetrieverCallback cb;
    final USK origUSK;
    private USKCallback proxy;
    private USKFetcher fetcher;
    private static volatile boolean logMINOR;

    public USKRetriever(FetchContext fctx, short prio, RequestClient client, USKRetrieverCallback cb, USK origUSK) {
        super(prio, client);
        if (client.persistent()) {
            throw new UnsupportedOperationException("USKRetriever cannot be persistent");
        }
        this.ctx = fctx;
        this.cb = cb;
        this.origUSK = origUSK;
        this.proxy = this;
    }

    @Override
    public void onFoundEdition(long l, USK key, ObjectContainer container, ClientContext context, boolean metadata, short codec, byte[] data, boolean newKnownGood, boolean newSlotToo) {
        if (l < 0L) {
            Logger.error(this, "Found negative edition: " + l + " for " + key + " !!!");
            return;
        }
        if (l < this.origUSK.suggestedEdition) {
            Logger.warning(this, "Found edition prior to that specified by the client: " + l + " < " + this.origUSK.suggestedEdition, (Throwable)new Exception("error"));
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Found edition " + l + " for " + this + " - fetching...");
        }
        FreenetURI uri = key.getSSK(l).getURI();
        try {
            SingleFileFetcher getter = (SingleFileFetcher)SingleFileFetcher.create(this, this, uri, this.ctx, new ArchiveContext(this.ctx.maxTempLength, this.ctx.maxArchiveLevels), this.ctx.maxNonSplitfileRetries, 0, true, l, true, false, null, context, this.realTimeFlag, false);
            getter.schedule(null, context);
        }
        catch (MalformedURLException e) {
            Logger.error(this, "Impossible: " + e, (Throwable)e);
        }
        catch (FetchException e) {
            Logger.error(this, "Could not start fetcher for " + uri + " : " + e, (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void onSuccess(StreamGenerator streamGenerator, ClientMetadata clientMetadata, List<? extends Compressor> decompressors, ClientGetState state, ObjectContainer container, ClientContext context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void onFailure(FetchException e, ClientGetState state, ObjectContainer container, ClientContext context) {
        switch (e.mode) {
            case 24: 
            case 27: {
                context.uskManager.updateKnownGood(this.origUSK, state.getToken(), context);
                return;
            }
        }
        Logger.warning(this, "Found edition " + state.getToken() + " but failed to fetch edition: " + e, (Throwable)e);
    }

    @Override
    public void onBlockSetFinished(ClientGetState state, ObjectContainer container, ClientContext context) {
    }

    public USK getOriginalUSK() {
        return this.origUSK;
    }

    @Override
    public FreenetURI getURI() {
        return this.origUSK.getURI();
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    public void notifyClients(ObjectContainer container, ClientContext context) {
    }

    @Override
    public void onTransition(ClientGetState oldState, ClientGetState newState, ObjectContainer container) {
    }

    @Override
    public void onExpectedMIME(ClientMetadata meta, ObjectContainer container, ClientContext context) {
    }

    @Override
    public void onExpectedSize(long size, ObjectContainer container, ClientContext context) {
    }

    @Override
    public void onFinalizedMetadata(ObjectContainer container) {
    }

    @Override
    public short getPollingPriorityNormal() {
        return this.cb.getPollingPriorityNormal();
    }

    @Override
    public short getPollingPriorityProgress() {
        return this.cb.getPollingPriorityProgress();
    }

    @Override
    public void cancel(ObjectContainer container, ClientContext context) {
        super.cancel();
    }

    @Override
    protected void innerToNetwork(ObjectContainer container, ClientContext context) {
    }

    @Override
    public void onExpectedTopSize(long size, long compressed, int blocksReq, int blocksTotal, ObjectContainer container, ClientContext context) {
    }

    @Override
    public void onSplitfileCompatibilityMode(InsertContext.CompatibilityMode min, InsertContext.CompatibilityMode max, byte[] splitfileKey, boolean compressed, boolean bottomLayer, boolean definitiveAnyway, ObjectContainer container, ClientContext context) {
    }

    @Override
    public void onHashes(HashResult[] hashes, ObjectContainer container, ClientContext context) {
    }

    synchronized void setProxy(USKCallback cb) {
        this.proxy = cb;
    }

    synchronized USKCallback getProxy() {
        return this.proxy;
    }

    synchronized void setFetcher(USKFetcher f) {
        this.fetcher = f;
    }

    synchronized USKFetcher getFetcher() {
        return this.fetcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(USKManager manager) {
        USKCallback p;
        USKFetcher f;
        USKRetriever uSKRetriever = this;
        synchronized (uSKRetriever) {
            f = this.fetcher;
            p = this.proxy;
        }
        if (f != null) {
            f.cancel(null, manager.getContext());
        }
        if (p != null) {
            manager.unsubscribe(this.origUSK, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeUSKPollParameters(long time, int tries, ClientContext context) {
        USKFetcher f;
        USKRetriever uSKRetriever = this;
        synchronized (uSKRetriever) {
            f = this.fetcher;
        }
        if (f == null) {
            throw new IllegalStateException();
        }
        f.changeUSKPollParameters(time, tries, context);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

