/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.CommentException;
import freenet.client.filter.ContentFilter;
import freenet.client.filter.ElementInfo;
import freenet.client.filter.FilterCallback;
import freenet.client.filter.FilterUtils;
import freenet.client.filter.UnsupportedCharsetInFilterException;
import freenet.support.Fields;
import freenet.support.Logger;
import freenet.support.io.Closer;
import freenet.support.io.FileBucket;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

class CSSTokenizerFilter {
    private Reader r;
    Writer w = null;
    FilterCallback cb;
    private static volatile boolean logDEBUG;
    private final String passedCharset;
    private String detectedCharset;
    private final boolean stopAtDetectedCharset;
    private final boolean isInline;
    private static final Map<String, CSSPropertyVerifier> elementVerifiers;
    private static final HashSet<String> allelementVerifiers;
    private static final CSSPropertyVerifier[] auxilaryVerifiers;

    CSSTokenizerFilter() {
        this.passedCharset = "UTF-8";
        this.stopAtDetectedCharset = false;
        this.isInline = false;
    }

    CSSTokenizerFilter(Reader r, Writer w, FilterCallback cb, String charset, boolean stopAtDetectedCharset, boolean isInline) {
        this.r = r;
        this.w = w;
        this.cb = cb;
        this.passedCharset = charset;
        this.stopAtDetectedCharset = stopAtDetectedCharset;
        this.isInline = isInline;
    }

    public boolean isValidURI(String URI2) {
        try {
            return URI2.equals(this.cb.processURI(URI2, null));
        }
        catch (CommentException e) {
            return false;
        }
    }

    public static <T> T[] concat(T[] a, T[] b) {
        int alen = a.length;
        int blen = b.length;
        if (alen == 0) {
            return b;
        }
        if (blen == 0) {
            return a;
        }
        Object[] result = (Object[])Array.newInstance(a.getClass().getComponentType(), alen + blen);
        System.arraycopy(a, 0, result, 0, alen);
        System.arraycopy(b, 0, result, alen, blen);
        return result;
    }

    private static void addVerifier(String element) {
        if ("azimuth".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[0] = new CSSPropertyVerifier(new String[]{"left-side", "far-left", "left", "center-left", "center", "center-right", "right", "far-right", "right-side"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[1] = new CSSPropertyVerifier(new String[]{"behind"}, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"leftwards", "rightwards", "inherit"}, ElementInfo.AURALMEDIA, new String[]{"an"}, new String[]{"0a1"}));
            allelementVerifiers.remove(element);
        } else if ("background-attachment".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[60] = new CSSPropertyVerifier(new String[]{"local", "scroll", "fixed"}, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, null, new String[]{"60<1,65535>"}, true, true));
            allelementVerifiers.remove(element);
        } else if ("background-clip".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"61<1,65535>"}, true, true));
            allelementVerifiers.remove(element);
        } else if ("background-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"transparent", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"co"}));
            allelementVerifiers.remove(element);
        } else if ("background-image".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[56] = new CSSPropertyVerifier(new String[]{"none"}, new String[]{"ur"}, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, null, new String[]{"56<1,65535>"}, true, true));
            allelementVerifiers.remove(element);
        } else if ("background-origin".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"61<1,65535>"}, true, true));
            allelementVerifiers.remove(element);
        } else if ("background-position".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, null, new String[]{"2 3?", "4a5"}));
            allelementVerifiers.remove(element);
        } else if ("background-repeat".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[57] = new CSSPropertyVerifier(new String[]{"repeat", "space", "round", "no-repeat"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[58] = new CSSPropertyVerifier(new String[]{"repeat-x", "repeat-y"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[59] = new CSSPropertyVerifier(null, null, new String[]{"58", "57<1,2>"}, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, null, new String[]{"59<1,65535>"}, true, true));
            allelementVerifiers.remove(element);
        } else if ("background-size".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[61] = new CSSPropertyVerifier(new String[]{"auto"}, new String[]{"le", "pe"}, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[62] = new CSSPropertyVerifier(new String[]{"cover", "contain"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[63] = new CSSPropertyVerifier(null, null, new String[]{"61<1,2>", "62"}, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"63<1,65535>"}, true, true));
            allelementVerifiers.remove(element);
        } else if ("background".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[6] = new CSSPropertyVerifier(new String[]{"scroll", "fixed", "inherit"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[7] = new CSSPropertyVerifier(new String[]{"transparent", "inherit"}, new String[]{"co"}, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[8] = new CSSPropertyVerifier(new String[]{"none", "inherit"}, new String[]{"ur"}, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[9] = new CSSPropertyVerifier(new String[]{"inherit"}, null, new String[]{"2 3?", "4a5"}, true);
            CSSTokenizerFilter.auxilaryVerifiers[10] = new CSSPropertyVerifier(new String[]{"repeat", "repeat-x", "repeat-y", "no-repeat", "inherit"}, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, null, new String[]{"6a7a8a9a10"}));
            allelementVerifiers.remove(element);
        } else if ("border-collapse".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"collapse", "separate", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("border-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, new String[]{"co"}, new String[]{"11<1,4>"}));
            allelementVerifiers.remove(element);
        } else if ("border-top-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, null, new String[]{"11"}, ElementInfo.VISUALMEDIA, true));
            allelementVerifiers.remove(element);
        } else if ("border-bottom-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, null, new String[]{"11"}, ElementInfo.VISUALMEDIA, true));
            allelementVerifiers.remove(element);
        } else if ("border-left-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, null, new String[]{"11"}, ElementInfo.VISUALMEDIA, true));
            allelementVerifiers.remove(element);
        } else if ("border-right-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, null, new String[]{"11"}, ElementInfo.VISUALMEDIA, true));
            allelementVerifiers.remove(element);
        } else if ("border-spacing".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[12] = new CSSPropertyVerifier(null, new String[]{"le"}, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, null, new String[]{"12 12?"}));
            allelementVerifiers.remove(element);
        } else if ("border-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, null, new String[]{"13<1,4>"}));
            allelementVerifiers.remove(element);
        } else if ("border-top-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, null, new String[]{"13"}, ElementInfo.VISUALMEDIA, true));
            allelementVerifiers.remove(element);
        } else if ("border-bottom-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, null, new String[]{"13"}, ElementInfo.VISUALMEDIA, true));
            allelementVerifiers.remove(element);
        } else if ("border-left-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, null, new String[]{"13"}, ElementInfo.VISUALMEDIA, true));
            allelementVerifiers.remove(element);
        } else if ("border-right-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, null, new String[]{"13"}, ElementInfo.VISUALMEDIA, true));
            allelementVerifiers.remove(element);
        } else if ("border-left".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, null, new String[]{"13a14a15"}));
            allelementVerifiers.remove(element);
        } else if ("border-top".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, null, new String[]{"13a14a15"}));
            allelementVerifiers.remove(element);
        } else if ("border-right".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, null, new String[]{"13a14a15"}));
            allelementVerifiers.remove(element);
        } else if ("border-bottom".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, null, new String[]{"13a14a15"}));
            allelementVerifiers.remove(element);
        } else if ("border-top-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"transparent", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"co"}));
            allelementVerifiers.remove(element);
        } else if ("border-right-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"transparent", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"co"}));
            allelementVerifiers.remove(element);
        } else if ("border-bottom-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"transparent", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"co"}));
            allelementVerifiers.remove(element);
        } else if ("border-left-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"transparent", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"co"}));
            allelementVerifiers.remove(element);
        } else if ("border-top-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"none", "hidden", "dotted", "dashed", "solid", "double", "groove", "ridge", "inset", "outset", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("border-right-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"none", "hidden", "dotted", "dashed", "solid", "double", "groove", "ridge", "inset", "outset", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("border-bottom-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"none", "hidden", "dotted", "dashed", "solid", "double", "groove", "ridge", "inset", "outset", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("border-left-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"none", "hidden", "dotted", "dashed", "solid", "double", "groove", "ridge", "inset", "outset", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("border-top-width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"thin", "medium", "thick", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le"}));
            allelementVerifiers.remove(element);
        } else if ("border-right-width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"thin", "medium", "thick", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le"}));
            allelementVerifiers.remove(element);
        } else if ("border-bottom-width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"thin", "medium", "thick", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le"}));
            allelementVerifiers.remove(element);
        } else if ("border-left-width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"thin", "medium", "thick", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le"}));
            allelementVerifiers.remove(element);
        } else if ("border-width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, null, new String[]{"14<1,4>"}));
            allelementVerifiers.remove(element);
        } else if ("border-top-width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"14"}));
            allelementVerifiers.remove(element);
        } else if ("border-bottom-width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"14"}));
            allelementVerifiers.remove(element);
        } else if ("border-left-width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"14"}));
            allelementVerifiers.remove(element);
        } else if ("border-right-width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"14"}));
            allelementVerifiers.remove(element);
        } else if ("border".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, null, new String[]{"13a14a15"}));
            allelementVerifiers.remove(element);
        } else if ("border-radius".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[65] = new CSSPropertyVerifier(new String[]{"/"}, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"64<1,4>", "64<1,4> 65 64<1,4>"}));
            allelementVerifiers.remove(element);
        } else if ("border-top-radius".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"64<1,2>"}));
            allelementVerifiers.remove(element);
        } else if ("border-bottom-radius".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"64<1,2>"}));
            allelementVerifiers.remove(element);
        } else if ("border-left-radius".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"64<1,2>"}));
            allelementVerifiers.remove(element);
        } else if ("border-right-radius".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"64<1,2>"}));
            allelementVerifiers.remove(element);
        } else if ("border-image-source".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"76"}));
            allelementVerifiers.remove(element);
        } else if ("border-image-slice".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[66] = new CSSPropertyVerifier(null, new String[]{"pe", "in"}, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[67] = new CSSPropertyVerifier(new String[]{"fill"}, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"66<1,4> 67?"}));
            allelementVerifiers.remove(element);
        } else if ("border-image-width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"77"}));
            allelementVerifiers.remove(element);
        } else if ("border-image-outset".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[69] = new CSSPropertyVerifier(null, new String[]{"le", "in"}, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"69<1,4>"}));
            allelementVerifiers.remove(element);
        } else if ("border-image-repeat".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"78"}));
            allelementVerifiers.remove(element);
        } else if ("border-image".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"76a77a78"}));
            allelementVerifiers.remove(element);
        } else if ("bottom".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le", "pe"}));
            allelementVerifiers.remove(element);
        } else if ("box-decoration-break".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"slice", "clone"}, ElementInfo.VISUALMEDIA, null));
            allelementVerifiers.remove(element);
        } else if ("box-shadow".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"none"}, ElementInfo.VISUALMEDIA, null, new String[]{"75<1,65535>"}, true, true));
            allelementVerifiers.remove(element);
        } else if ("caption-side".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"top", "bottom", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("clear".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"none", "left", "right", "both", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("clip".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"sh"}));
            allelementVerifiers.remove(element);
        } else if ("break-after".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "always", "avoid", "left", "right", "page", "column", "avoid-page", "avoid-column"}, ElementInfo.VISUALPAGEDMEDIA));
            allelementVerifiers.remove(element);
        } else if ("break-before".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "always", "avoid", "left", "right", "page", "column", "avoid-page", "avoid-column"}, ElementInfo.VISUALPAGEDMEDIA));
            allelementVerifiers.remove(element);
        } else if ("break-inside".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "avoid", "avoid-page", "avoid-column"}, ElementInfo.VISUALPAGEDMEDIA));
            allelementVerifiers.remove(element);
        } else if ("column-count".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto"}, ElementInfo.VISUALMEDIA, new String[]{"in"}));
            allelementVerifiers.remove(element);
        } else if ("column-fill".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "balance"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("column-gap".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"normal"}, ElementInfo.VISUALMEDIA, new String[]{"le"}));
            allelementVerifiers.remove(element);
        } else if ("column-rule-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, new String[]{"co"}));
            allelementVerifiers.remove(element);
        } else if ("column-rule-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, null, new String[]{"13<1,4>"}));
            allelementVerifiers.remove(element);
        } else if ("column-rule-width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, null, new String[]{"14<1,4>"}));
            allelementVerifiers.remove(element);
        } else if ("column-rule".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[54] = new CSSPropertyVerifier(null, null, null, new String[]{"14<1,4>"});
            CSSTokenizerFilter.auxilaryVerifiers[55] = new CSSPropertyVerifier(null, null, null, new String[]{"13<1,4>"});
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"54a55a15"}));
            allelementVerifiers.remove(element);
        } else if ("column-span".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"1", "all"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("column-width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto"}, ElementInfo.VISUALMEDIA, new String[]{"le"}));
            allelementVerifiers.remove(element);
        } else if ("columns".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[52] = new CSSPropertyVerifier(new String[]{"auto"}, new String[]{"le"}, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[53] = new CSSPropertyVerifier(new String[]{"auto"}, new String[]{"in"}, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"52a53"}));
            allelementVerifiers.remove(element);
        } else if ("color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, new String[]{"co"}));
            allelementVerifiers.remove(element);
        } else if ("color-interpolation".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "sRGB", "linearRGB", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("color-rendering".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "optimizeSpeed", "optimizeQuality", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("content".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[16] = new contentPropertyVerifier(new String[]{"open-quote", "close-quote", "no-open-quote", "no-close-quote"});
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"normal", "none", "inherit"}, ElementInfo.MEDIAARRAY, null, new String[]{"16<1,10>"}));
            allelementVerifiers.remove(element);
        } else if ("counter-increment".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[17] = new CSSPropertyVerifier(null, new String[]{"id"}, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[18] = new CSSPropertyVerifier(null, new String[]{"in"}, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[19] = new CSSPropertyVerifier(null, null, new String[]{"17 18?"}, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"none", "inherit"}, ElementInfo.MEDIAARRAY, null, new String[]{"19<1,10>[1,2]"}));
            allelementVerifiers.remove(element);
        } else if ("counter-reset".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[20] = new CSSPropertyVerifier(null, new String[]{"id"}, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[21] = new CSSPropertyVerifier(null, new String[]{"in"}, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[22] = new CSSPropertyVerifier(null, null, new String[]{"20 21?"}, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"none", "inherit"}, ElementInfo.MEDIAARRAY, null, new String[]{"22<1,10>[1,2]"}));
            allelementVerifiers.remove(element);
        } else if ("cue-after".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"none", "inherit"}, ElementInfo.AURALMEDIA, new String[]{"ur"}));
            allelementVerifiers.remove(element);
        } else if ("cue-before".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"none", "inherit"}, ElementInfo.AURALMEDIA, new String[]{"ur"}));
            allelementVerifiers.remove(element);
        } else if ("cue".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[23] = new CSSPropertyVerifier(new String[]{"none", "inherit"}, new String[]{"ur"}, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[24] = new CSSPropertyVerifier(new String[]{"none", "inherit"}, new String[]{"ur"}, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.MEDIAARRAY, null, new String[]{"23a24"}));
            allelementVerifiers.remove(element);
        } else if ("cursor".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[25] = new CSSPropertyVerifier(null, new String[]{"ur"}, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[26] = new CSSPropertyVerifier(new String[]{"auto", "crosshair", "default", "pointer", "move", "e-resize", "ne-resize", "nw-resize", "n-resize", "se-resize", "sw-resize", "s-resize", "w-resize", "text", "wait", "help", "progress"}, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALINTERACTIVEMEDIA, null, new String[]{"25<0,10> 26"}, false, true));
            allelementVerifiers.remove(element);
        } else if ("direction".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"ltr", "rtl", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("display".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inline", "block", "list-item", "run-in", "inline-block", "table", "inline-table", "table-row-group", "table-header-group", "table-footer-group", "table-row", "table-column-group", "table-column", "table-cell", "table-caption", "none", "inherit"}, ElementInfo.MEDIAARRAY));
            allelementVerifiers.remove(element);
        } else if ("elevation".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"below", "level", "above", "higher", "lower", "inherit"}, ElementInfo.AURALMEDIA, new String[]{"an"}));
            allelementVerifiers.remove(element);
        } else if ("empty-cells".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"show", "hide", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("float".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"left", "right", "none", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("font-family".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new FontPropertyVerifier(false));
            allelementVerifiers.remove(element);
        } else if ("font-size".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large", "larger", "smaller", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le", "pe"}));
            allelementVerifiers.remove(element);
        } else if ("font-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"normal", "italic", "oblique", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("font-variant".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"normal", "small-caps", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("font-weight".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"normal", "bold", "bolder", "lighter", "100", "200", "300", "400", "500", "600", "700", "800", "900", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("font".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[27] = new CSSPropertyVerifier(new String[]{"normal", "italic", "oblique", "inherit"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[28] = new CSSPropertyVerifier(new String[]{"normal", "small-caps", "inherit"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[29] = new CSSPropertyVerifier(new String[]{"normal", "bold", "bolder", "lighter", "100", "200", "300", "400", "500", "600", "700", "800", "900", "inherit"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[30] = new CSSPropertyVerifier(null, null, new String[]{"27a28a29"}, true);
            CSSTokenizerFilter.auxilaryVerifiers[31] = new FontPartPropertyVerifier();
            CSSTokenizerFilter.auxilaryVerifiers[59] = new FontPropertyVerifier(true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"caption", "icon", "menu", "message-box", "small-caption", "status-bar", "inherit"}, ElementInfo.VISUALMEDIA, null, new String[]{"30<0,1>[1,3] 31<0,1>[1,3] 59"}, false, true));
            allelementVerifiers.remove(element);
        } else if ("hanging-punctuation".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[97] = new CSSPropertyVerifier(new String[]{"allow-end", "force-end"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[98] = new CSSPropertyVerifier(new String[]{"first"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[99] = new CSSPropertyVerifier(new String[]{"last"}, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"none"}, ElementInfo.VISUALMEDIA, null, new String[]{"97a98a99"}));
            allelementVerifiers.remove(element);
        } else if ("height".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le", "pe"}));
            allelementVerifiers.remove(element);
        } else if ("left".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le", "pe"}));
            allelementVerifiers.remove(element);
        } else if ("letter-spacing".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, null, ElementInfo.VISUALMEDIA, new String[]{"85<1,3>"}));
            allelementVerifiers.remove(element);
        } else if ("line-height".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"normal", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le", "pe", "re", "in"}));
            allelementVerifiers.remove(element);
        } else if ("line-break".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "newspaper", "normal", "strict", "keep-all"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("list-style-image".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"none", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"ur"}));
            allelementVerifiers.remove(element);
        } else if ("list-style-position".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inside", "outside", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("list-style-type".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"disc", "circle", "square", "decimal", "decimal-leading-zero", "lower-roman", "upper-roman", "lower-greek", "lower-latin", "upper-latin", "armenian", "georgian", "lower-alpha", "upper-alpha", "none", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("list-style".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[33] = new CSSPropertyVerifier(new String[]{"none", "inherit"}, new String[]{"ur"}, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[34] = new CSSPropertyVerifier(new String[]{"inside", "outside", "inherit"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[35] = new CSSPropertyVerifier(new String[]{"disc", "circle", "square", "decimal", "decimal-leading-zero", "lower-roman", "upper-roman", "lower-greek", "lower-latin", "upper-latin", "armenian", "georgian", "lower-alpha", "upper-alpha", "none", "inherit"}, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, null, new String[]{"33a34a35"}));
            allelementVerifiers.remove(element);
        } else if ("margin-right".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le", "pe"}));
            allelementVerifiers.remove(element);
        } else if ("margin-left".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le", "pe"}));
            allelementVerifiers.remove(element);
        } else if ("margin-top".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le", "pe"}));
            allelementVerifiers.remove(element);
        } else if ("margin-bottom".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le", "pe"}));
            allelementVerifiers.remove(element);
        } else if ("margin".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[36] = new CSSPropertyVerifier(new String[]{"auto", "inherit"}, new String[]{"le", "pe"}, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, null, new String[]{"36<1,4>"}));
            allelementVerifiers.remove(element);
        } else if ("max-height".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"none", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le", "pe"}));
            allelementVerifiers.remove(element);
        } else if ("max-width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"none", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le", "pe"}));
            allelementVerifiers.remove(element);
        } else if ("min-height".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le", "pe"}));
            allelementVerifiers.remove(element);
        } else if ("min-width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le", "pe"}));
            allelementVerifiers.remove(element);
        } else if ("opacity".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALPAGEDMEDIA, new String[]{"re"}));
            allelementVerifiers.remove(element);
        } else if ("orphans".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALPAGEDMEDIA, new String[]{"in"}));
            allelementVerifiers.remove(element);
        } else if ("outline-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"invert", "inherit"}, ElementInfo.VISUALINTERACTIVEMEDIA, new String[]{"co"}));
            allelementVerifiers.remove(element);
        } else if ("outline-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"none", "hidden", "dotted", "dashed", "solid", "double", "groove", "ridge", "inset", "outset", "inherit"}, ElementInfo.VISUALINTERACTIVEMEDIA));
            allelementVerifiers.remove(element);
        } else if ("outline-width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"thin", "medium", "thick", "inherit"}, ElementInfo.VISUALINTERACTIVEMEDIA, new String[]{"le"}));
            allelementVerifiers.remove(element);
        } else if ("outline".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[37] = new CSSPropertyVerifier(new String[]{"invert", "inherit"}, new String[]{"co"}, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[38] = new CSSPropertyVerifier(new String[]{"none", "hidden", "dotted", "dashed", "solid", "double", "groove", "ridge", "inset", "outset", "inherit"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[39] = new CSSPropertyVerifier(new String[]{"thin", "medium", "thick", "inherit"}, new String[]{"le"}, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALINTERACTIVEMEDIA, new String[]{"le"}, new String[]{"37a38a39"}));
            allelementVerifiers.remove(element);
        } else if ("overflow".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"visible", "hidden", "scroll", "auto", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("padding-top".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le", "pe"}));
            allelementVerifiers.remove(element);
        } else if ("padding-right".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le", "pe"}));
            allelementVerifiers.remove(element);
        } else if ("padding-bottom".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le", "pe"}));
            allelementVerifiers.remove(element);
        } else if ("padding-left".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le", "pe"}));
            allelementVerifiers.remove(element);
        } else if ("padding".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[40] = new CSSPropertyVerifier(new String[]{"inherit"}, new String[]{"le", "pe"}, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, null, new String[]{"40<1,4>"}));
            allelementVerifiers.remove(element);
        } else if ("page-break-after".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "always", "avoid", "left", "right", "inherit"}, ElementInfo.VISUALPAGEDMEDIA));
            allelementVerifiers.remove(element);
        } else if ("page-break-before".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "always", "avoid", "left", "right", "inherit"}, ElementInfo.VISUALPAGEDMEDIA));
            allelementVerifiers.remove(element);
        } else if ("page-break-inside".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "avoid", "inherit"}, ElementInfo.VISUALPAGEDMEDIA));
            allelementVerifiers.remove(element);
        } else if ("pause-after".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.AURALMEDIA, new String[]{"ti", "pe"}));
            allelementVerifiers.remove(element);
        } else if ("pause-before".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.AURALMEDIA, new String[]{"ti", "pe"}));
            allelementVerifiers.remove(element);
        } else if ("pause".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[41] = new CSSPropertyVerifier(new String[]{"inherit"}, new String[]{"ti", "pe"}, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, null, null, new String[]{"41<1,2>"}));
            allelementVerifiers.remove(element);
        } else if ("pitch-range".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.AURALMEDIA, new String[]{"in", "re"}));
            allelementVerifiers.remove(element);
        } else if ("pitch".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"x-low", "low", "medium", "high", "x-high", "inherit"}, ElementInfo.AURALMEDIA, new String[]{"fr"}));
            allelementVerifiers.remove(element);
        } else if ("play-during".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[42] = new CSSPropertyVerifier(null, new String[]{"ur"}, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[43] = new CSSPropertyVerifier(new String[]{"mix"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[44] = new CSSPropertyVerifier(new String[]{"repeat"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[45] = new CSSPropertyVerifier(null, null, new String[]{"43a44"}, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "none", "inherit"}, ElementInfo.AURALMEDIA, null, new String[]{"42 45<0,1>[1,2]"}));
            allelementVerifiers.remove(element);
        } else if ("punctuation-trim".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[86] = new CSSPropertyVerifier(new String[]{"start"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[87] = new CSSPropertyVerifier(new String[]{"end", "allow-end"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[88] = new CSSPropertyVerifier(new String[]{"adjacent"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[89] = new CSSPropertyVerifier(null, null, new String[]{"86a87a88"}, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"none"}, ElementInfo.AURALMEDIA, null, new String[]{"89"}));
            allelementVerifiers.remove(element);
        } else if ("position".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"static", "relative", "absolute", "fixed", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("quotes".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[46] = new CSSPropertyVerifier(null, new String[]{"st"}, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[47] = new CSSPropertyVerifier(null, null, new String[]{"46 46"}, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"none", "inherit"}, null, ElementInfo.VISUALMEDIA, new String[]{"47<1,10>[2,2]"}));
            allelementVerifiers.remove(element);
        } else if ("richness".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.AURALMEDIA, new String[]{"re", "in"}));
            allelementVerifiers.remove(element);
        } else if ("right".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le", "pe"}));
            allelementVerifiers.remove(element);
        } else if ("speak-header".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"once", "always", "inherit"}, ElementInfo.AURALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("speak-numeral".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"digits", "continuous", "inherit"}, ElementInfo.AURALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("speak-punctuation".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"code", "none", "inherit"}, ElementInfo.AURALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("speak".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"normal", "none", "spell-out", "inherit"}, ElementInfo.AURALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("speech-rate".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"x-slow", "slow", "medium", "fast", "x-fast", "faster", "slower", "inherit"}, ElementInfo.AURALMEDIA, new String[]{"re", "in"}));
            allelementVerifiers.remove(element);
        } else if ("stress".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.AURALMEDIA, new String[]{"re", "in"}));
            allelementVerifiers.remove(element);
        } else if ("table-layout".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "fixed", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("text-align".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"start", "end", "left", "right", "center", "justify", "match-parent", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("text-align-last".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"start", "end", "left", "right", "center", "justify"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("text-autospace".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[90] = new CSSPropertyVerifier(new String[]{"ideograph-numeric"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[91] = new CSSPropertyVerifier(new String[]{"ideograph-alpha"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[92] = new CSSPropertyVerifier(new String[]{"ideograph-space"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[93] = new CSSPropertyVerifier(new String[]{"ideograph-parenthesis"}, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"none"}, ElementInfo.VISUALMEDIA, null, new String[]{"90a91a92a93"}));
            allelementVerifiers.remove(element);
        } else if ("text-decoration".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, null, new String[]{"115a103a104a116"}));
            allelementVerifiers.remove(element);
        } else if ("text-decoration-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"103"}));
            allelementVerifiers.remove(element);
        } else if ("text-decoration-line".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"none"}, ElementInfo.VISUALMEDIA, null, new String[]{"100a101a102"}));
            allelementVerifiers.remove(element);
        } else if ("text-decoration-skip".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[48] = new CSSPropertyVerifier(new String[]{"images"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[49] = new CSSPropertyVerifier(new String[]{"spaces"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[50] = new CSSPropertyVerifier(new String[]{"ink"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[51] = new CSSPropertyVerifier(new String[]{"all"}, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"none"}, ElementInfo.VISUALMEDIA, null, new String[]{"48a49a50a51"}));
            allelementVerifiers.remove(element);
        } else if ("text-decoration-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"104"}));
            allelementVerifiers.remove(element);
        } else if ("text-emphasis".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"103a107"}));
            allelementVerifiers.remove(element);
        } else if ("text-emphasis-color".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"103"}));
            allelementVerifiers.remove(element);
        } else if ("text-emphasis-position".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"over", "under"}, ElementInfo.VISUALMEDIA, null, null));
            allelementVerifiers.remove(element);
        } else if ("text-emphasis-style".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"107"}));
            allelementVerifiers.remove(element);
        } else if ("text-indent".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[94] = new CSSPropertyVerifier(new String[]{"hanging", "each-line"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[95] = new CSSPropertyVerifier(null, null, new String[]{"94<0,2>"}, true);
            CSSTokenizerFilter.auxilaryVerifiers[96] = new CSSPropertyVerifier(null, new String[]{"le", "pe"}, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"96 95"}));
            allelementVerifiers.remove(element);
        } else if ("text-justify".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[83] = new CSSPropertyVerifier(new String[]{"inter-word", "inter-ideograph", "inter-cluster", "distribute", "kashida"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[84] = new CSSPropertyVerifier(new String[]{"trim"}, null, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "inherit"}, ElementInfo.VISUALMEDIA, null, new String[]{"84a83"}));
            allelementVerifiers.remove(element);
        } else if ("text-outline".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[108] = new CSSPropertyVerifier(null, null, new String[]{"73 72 72<0,1>"}, true);
            CSSTokenizerFilter.auxilaryVerifiers[109] = new CSSPropertyVerifier(null, null, new String[]{"72 72<0,1> 73"}, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"none"}, ElementInfo.VISUALMEDIA, null, new String[]{"108a109"}));
            allelementVerifiers.remove(element);
        } else if ("text-overflow".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"clip", "ellipsis"}, ElementInfo.VISUALMEDIA, new String[]{"st"}));
            allelementVerifiers.remove(element);
        } else if ("text-shadow".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"none"}, ElementInfo.VISUALMEDIA, null, new String[]{"79<0,65535>"}, true, true));
            allelementVerifiers.remove(element);
        } else if ("text-transform".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"capitalize", "uppercase", "lowercase", "none", "inherit", "fullwidth", "large-kana"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("text-underline-position".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "under", "alphabetic", "over"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("text-wrap".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"normal", "unrestricted", "none", "suppress"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("top".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le", "pe"}));
            allelementVerifiers.remove(element);
        } else if ("transform".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[110] = new CSSPropertyVerifier(null, new String[]{"tr"}, null, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"110<0,65536>"}, true, true));
            allelementVerifiers.remove(element);
        } else if ("transform-origin".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[111] = new CSSPropertyVerifier(null, null, new String[]{"2 3<0,1>"}, true);
            CSSTokenizerFilter.auxilaryVerifiers[112] = new CSSPropertyVerifier(new String[]{"left", "center", "right"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[113] = new CSSPropertyVerifier(new String[]{"top", "center", "bottom"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[114] = new CSSPropertyVerifier(null, null, new String[]{"112a113"}, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(null, ElementInfo.VISUALMEDIA, null, new String[]{"111", "114"}, true, true));
            allelementVerifiers.remove(element);
        } else if ("unicode-bidi".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"normal", "embed", "bidi-override", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("vertical-align".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"baseline", "sub", "super", "top", "text-top", "middle", "bottom", "text-bottom", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"pe", "le"}));
            allelementVerifiers.remove(element);
        } else if ("visibility".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"visible", "hidden", "collapse", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("voice-family".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new VoiceFamilyPropertyVerifier(false));
            allelementVerifiers.remove(element);
        } else if ("volume".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"silent", "x-soft", "soft", "medium", "loud", "x-loud", "inherit"}, ElementInfo.AURALMEDIA, new String[]{"re", "le", "pe"}));
            allelementVerifiers.remove(element);
        } else if ("white-space".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"normal", "pre", "nowrap", "pre-wrap", "pre-line", "inherit"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("white-space-collapsing".equalsIgnoreCase(element)) {
            CSSTokenizerFilter.auxilaryVerifiers[80] = new CSSPropertyVerifier(new String[]{"preserve", "preserve-break"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[81] = new CSSPropertyVerifier(new String[]{"trim-inner"}, null, null, true);
            CSSTokenizerFilter.auxilaryVerifiers[82] = new CSSPropertyVerifier(null, null, new String[]{"80a81"}, true);
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"collapse", "discard"}, null, ElementInfo.VISUALMEDIA, new String[]{"82"}));
            allelementVerifiers.remove(element);
        } else if ("widows".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, ElementInfo.VISUALMEDIA, new String[]{"in"}));
            allelementVerifiers.remove(element);
        } else if ("width".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"le", "pe"}));
            allelementVerifiers.remove(element);
        } else if ("word-break".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"normal", "break-all", "hyphenate"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("word-spacing".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"inherit"}, null, ElementInfo.VISUALMEDIA, new String[]{"85<1,3>"}));
            allelementVerifiers.remove(element);
        } else if ("word-wrap".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"normal", "break-word"}, ElementInfo.VISUALMEDIA));
            allelementVerifiers.remove(element);
        } else if ("z-index".equalsIgnoreCase(element)) {
            elementVerifiers.put(element, new CSSPropertyVerifier(new String[]{"auto", "inherit"}, ElementInfo.VISUALMEDIA, new String[]{"in"}));
            allelementVerifiers.remove(element);
        }
    }

    private static synchronized CSSPropertyVerifier getVerifier(String element) {
        if (elementVerifiers.get(element = element.toLowerCase()) != null) {
            return elementVerifiers.get(element);
        }
        if (allelementVerifiers.contains(element)) {
            CSSTokenizerFilter.addVerifier(element);
            return elementVerifiers.get(element);
        }
        return null;
    }

    private boolean verifyToken(String[] media, String[] elements, CSSPropertyVerifier obj, ParsedWord[] words) {
        if (words == null) {
            return false;
        }
        if (logDEBUG) {
            Logger.debug(this, "verifyToken for " + CSSPropertyVerifier.toString(words));
        }
        if (obj == null) {
            return false;
        }
        int important = this.checkImportant(words);
        if (important > 0) {
            if (words.length == important) {
                return true;
            }
            words = Arrays.copyOf(words, words.length - important);
        }
        return obj.checkValidity(media, elements, words, this.cb);
    }

    private int checkImportant(ParsedWord[] words) {
        if (words.length == 0) {
            return 0;
        }
        if (words.length >= 1 && words[words.length - 1] instanceof SimpleParsedWord && ((SimpleParsedWord)words[words.length - 1]).original.equalsIgnoreCase("!important")) {
            return 1;
        }
        if (words.length >= 2 && words[words.length - 1] instanceof ParsedIdentifier && words[words.length - 2] instanceof SimpleParsedWord && ((SimpleParsedWord)words[words.length - 2]).original.equals("!") && ((ParsedIdentifier)words[words.length - 1]).original.equalsIgnoreCase("important")) {
            return 2;
        }
        return 0;
    }

    public String HTMLelementVerifier(String elementString) {
        int index;
        if (logDEBUG) {
            Logger.debug(this, "varifying element/selector: \"" + elementString + "\"");
        }
        String HTMLelement = "";
        String pseudoClass = "";
        String className = "";
        String id = "";
        boolean isValid = true;
        StringBuilder fBuffer = new StringBuilder();
        ArrayList<String> attSelections = null;
        while (elementString.indexOf(91) != -1 && elementString.indexOf(93) != -1 && elementString.indexOf(91) < elementString.indexOf(93)) {
            String attSelection = elementString.substring(elementString.indexOf(91) + 1, elementString.indexOf(93)).trim();
            StringBuilder buf = new StringBuilder(elementString);
            buf.delete(elementString.indexOf(91), elementString.indexOf(93) + 1);
            elementString = buf.toString();
            if (logDEBUG) {
                Logger.debug(this, "attSelection=" + attSelection + "  elementString=" + elementString);
            }
            if (attSelections == null) {
                attSelections = new ArrayList<String>();
            }
            attSelections.add(attSelection);
        }
        if (elementString.indexOf(58) != -1) {
            int index2 = elementString.indexOf(58);
            if (index2 != elementString.length() - 1) {
                pseudoClass = elementString.substring(index2 + 1, elementString.length()).trim();
                HTMLelement = elementString.substring(0, index2).trim();
                if (logDEBUG) {
                    Logger.debug(this, "pseudoclass=" + pseudoClass + " HTMLelement=" + HTMLelement);
                }
            } else {
                HTMLelement = elementString.trim();
            }
        } else {
            HTMLelement = elementString.trim();
        }
        if (HTMLelement.indexOf(46) != -1) {
            int index3 = HTMLelement.indexOf(46);
            if (index3 != HTMLelement.length() - 1) {
                className = HTMLelement.substring(index3 + 1, HTMLelement.length()).trim();
                HTMLelement = HTMLelement.substring(0, index3).trim();
                if (logDEBUG) {
                    Logger.debug(this, "class=" + className + " HTMLelement=" + HTMLelement);
                }
            }
        } else if (HTMLelement.indexOf(35) != -1 && (index = HTMLelement.indexOf(35)) != HTMLelement.length() - 1) {
            id = HTMLelement.substring(index + 1, HTMLelement.length()).trim();
            HTMLelement = HTMLelement.substring(0, index).trim();
            if (logDEBUG) {
                Logger.debug(this, "id=" + id + " element=" + HTMLelement);
            }
        }
        if ("*".equals(HTMLelement) || ElementInfo.isValidHTMLTag(HTMLelement.toLowerCase()) || "".equals(HTMLelement.trim()) && (!className.equals("") || !id.equals("") || attSelections != null || !pseudoClass.equals(""))) {
            if (!className.equals("")) {
                if (!ElementInfo.isValidName(className)) {
                    isValid = false;
                }
            } else if (!id.equals("") && !ElementInfo.isValidName(id)) {
                isValid = false;
            }
            if (isValid && !pseudoClass.equals("") && !ElementInfo.isValidPseudoClass(pseudoClass)) {
                isValid = false;
            }
            if (isValid && attSelections != null) {
                for (String attSelection : attSelections) {
                    String[] attSelectionParts = attSelection.indexOf("|=") != -1 ? new String[]{attSelection.substring(0, attSelection.indexOf("|=")), attSelection.substring(attSelection.indexOf("|=") + 2, attSelection.length())} : (attSelection.indexOf("~=") != -1 ? new String[]{attSelection.substring(0, attSelection.indexOf("~=")), attSelection.substring(attSelection.indexOf("~=") + 2, attSelection.length())} : (attSelection.indexOf(61) != -1 ? new String[]{attSelection.substring(0, attSelection.indexOf(61)), attSelection.substring(attSelection.indexOf(61) + 1, attSelection.length())} : new String[]{attSelection}));
                    if (logDEBUG) {
                        Logger.debug(this, "HTMLelementVerifier length of attSelectionParts=" + attSelectionParts.length);
                    }
                    if (attSelectionParts[0].length() == 0) {
                        isValid = false;
                    } else {
                        char c = attSelectionParts[0].charAt(0);
                        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                            isValid = false;
                        }
                        for (int i = 1; i < attSelectionParts[0].length(); ++i) {
                            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-') continue;
                            isValid = false;
                        }
                    }
                    if (attSelectionParts.length <= 1) continue;
                    if (logDEBUG) {
                        Logger.debug(this, "RHS is \"" + attSelectionParts[1] + "\"");
                    }
                    if (ElementInfo.isValidIdentifier(attSelectionParts[1]) || ElementInfo.isValidStringWithQuotes(attSelectionParts[1])) continue;
                    isValid = false;
                }
            }
            if (isValid) {
                fBuffer.append(HTMLelement);
                if (!className.equals("")) {
                    fBuffer.append('.');
                    fBuffer.append(className);
                } else if (!id.equals("")) {
                    fBuffer.append('#');
                    fBuffer.append(id);
                }
                if (!pseudoClass.equals("")) {
                    fBuffer.append(':');
                    fBuffer.append(pseudoClass);
                }
                if (attSelections != null) {
                    for (String attSelection : attSelections) {
                        fBuffer.append('[');
                        fBuffer.append(attSelection);
                        fBuffer.append(']');
                    }
                }
                return fBuffer.toString();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String recursiveSelectorVerifier(String selectorString) {
        if (logDEBUG) {
            Logger.debug(this, "selector: \"" + selectorString + "\"");
        }
        selectorString = selectorString.trim();
        int index = -1;
        char selector = '\u0000';
        char quoting = '\u0000';
        boolean escaping = false;
        int bracketing = 0;
        boolean eatLF = false;
        int escapedDigits = 0;
        for (int i = 0; i < selectorString.length(); ++i) {
            block50: {
                char c = selectorString.charAt(i);
                if (c == '+' && quoting == '\u0000' && !escaping && bracketing == 0) {
                    if (index == -1 || index == i - 1 && selector == ' ') {
                        index = i;
                        selector = c;
                    }
                } else if (c == '>' && quoting == '\u0000' && !escaping) {
                    if (index == -1 || index == i - 1 && selector == ' ') {
                        index = i;
                        selector = c;
                    }
                } else if (c == ' ' && quoting == '\u0000' && !escaping) {
                    if (index == -1 || index == i - 1 && selector == ' ') {
                        index = i;
                        selector = c;
                    }
                } else if (c == '(' && quoting == '\u0000' && !escaping) {
                    ++bracketing;
                } else if (c == ')' && quoting == '\u0000' && !escaping) {
                    --bracketing;
                } else if (c == '\'' && quoting == '\u0000' && !escaping) {
                    quoting = c;
                } else if (c == '\"' && quoting == '\u0000' && !escaping) {
                    quoting = c;
                } else if (c == quoting && !escaping) {
                    quoting = '\u0000';
                } else if (c == '\n' && eatLF) {
                    escaping = false;
                    eatLF = false;
                } else {
                    if (!(c != '\r' && c != '\n' && c != '\f' || quoting != '\u0000' && escaping)) {
                        if (logDEBUG) {
                            Logger.debug(this, "no newlines unless in a string *and* quoted at index " + i);
                        }
                        return null;
                    }
                    if (c == '\r' && escaping && escapedDigits == 0) {
                        escaping = false;
                        eatLF = true;
                    } else {
                        if ((c == '\n' || c == '\f') && escaping) {
                            if (escapedDigits == 0) {
                                escaping = false;
                                break block50;
                            } else {
                                if (logDEBUG) {
                                    Logger.debug(this, "invalid newline escaping at char " + i);
                                }
                                return null;
                            }
                        }
                        if (escaping && (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) {
                            if (++escapedDigits == 6) {
                                escaping = false;
                            }
                        } else if (escaping && escapedDigits > 0 && " \t\r\n\f".indexOf(c) != -1) {
                            escaping = false;
                            if (c == '\r') {
                                eatLF = true;
                            }
                        } else if (c == '\\' && !escaping) {
                            escaping = true;
                        } else {
                            if (c == '\\' && escaping && escapedDigits > 0) {
                                if (logDEBUG) {
                                    Logger.debug(this, "backslash but already escaping with digits at char " + i);
                                }
                                return null;
                            }
                            if (c == '\\' && escaping) {
                                escaping = false;
                            } else if (escaping) {
                                escaping = false;
                            }
                        }
                    }
                }
            }
            eatLF = false;
        }
        if (logDEBUG) {
            Logger.debug(this, "index=" + index + " quoting=" + quoting + " selector=" + selector + " for \"" + selectorString + "\"");
        }
        if (quoting != '\u0000') {
            return null;
        }
        if (bracketing != 0) {
            return null;
        }
        if (index == -1) {
            return this.HTMLelementVerifier(selectorString);
        }
        String[] parts = new String[]{selectorString.substring(0, index).trim(), selectorString.substring(index + 1, selectorString.length()).trim()};
        if (logDEBUG) {
            Logger.debug(this, "recursiveSelectorVerifier parts[0]=" + parts[0] + " parts[1]=" + parts[1]);
        }
        parts[0] = this.HTMLelementVerifier(parts[0]);
        parts[1] = this.recursiveSelectorVerifier(parts[1]);
        if (parts[0] != null && parts[1] != null) {
            return parts[0] + selector + parts[1];
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public void parse() throws IOException {
        STATE1 = true;
        STATE2 = 2;
        STATE3 = 3;
        STATECOMMENT = 4;
        STATE1INQUOTE = 5;
        STATE2INQUOTE = 6;
        STATE3INQUOTE = 7;
        currentQuote = '\"';
        stateBeforeComment = 0;
        currentState = 1;
        isState1Present = false;
        elements = null;
        filteredTokens = new StringBuilder();
        buffer = new StringBuilder();
        openBraces = 0;
        defaultMedia = "screen";
        currentMedia = new String[]{defaultMedia};
        propertyName = "";
        propertyValue = "";
        ignoreElementsS1 = false;
        ignoreElementsS2 = false;
        ignoreElementsS3 = false;
        closeIgnoredS2 = false;
        c = '\u0000';
        prevc = '\u0000';
        s2Comma = false;
        canImport = true;
        whitespaceAfterColon = "";
        whitespaceBeforeProperty = "";
        charsetPossible = true;
        bomPossible = true;
        openBracesStartingS3 = 0;
        forPage = false;
        if (this.isInline) {
            currentState = 3;
        }
        block54: while (true) {
            x = this.r.read();
            if (x == -1) {
                if (currentState != 3 || c == ';' || propertyName.isEmpty() || !propertyValue.isEmpty()) break;
                x = 59;
            }
            if (x == 65279) {
                if (!bomPossible) continue;
                if (CSSTokenizerFilter.logDEBUG) {
                    Logger.debug(this, "Ignoring BOM");
                }
                this.w.write(x);
                continue;
            }
            bomPossible = false;
            prevc = c;
            c = (char)x;
            if (CSSTokenizerFilter.logDEBUG) {
                Logger.debug(this, "Read: " + c + " 0x" + Integer.toHexString(c));
            }
            if (prevc == '/' && c == '*' && currentState != 5 && currentState != 6 && currentState != 7 && currentState != 4) {
                stateBeforeComment = currentState;
                currentState = 4;
                if (buffer.charAt(buffer.length() - 1) == '/') {
                    buffer.deleteCharAt(buffer.length() - 1);
                }
                if (CSSTokenizerFilter.logDEBUG) {
                    Logger.debug(this, "Comment detected: buffer=" + buffer);
                }
            }
            if (c == '\u0000') continue;
            switch (currentState) {
                case 1: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case ' ': {
                            buffer.append(c);
                            if (!CSSTokenizerFilter.logDEBUG) continue block54;
                            Logger.debug(this, "STATE1 CASE whitespace: " + c);
                            break;
                        }
                        case '@': {
                            if (prevc != '\\') {
                                isState1Present = true;
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "STATE1 CASE @: " + c);
                                }
                            }
                            buffer.append(c);
                            break;
                        }
                        case '{': {
                            charsetPossible = false;
                            if (this.stopAtDetectedCharset) {
                                return;
                            }
                            if (prevc == '\\') {
                                buffer.append(c);
                                break;
                            }
                            ++openBraces;
                            isState1Present = false;
                            i = 0;
                            for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                            }
                            braceSpace = buffer.substring(0, i);
                            buffer.delete(0, i);
                            if (buffer.length() > 4 && buffer.substring(0, 4).equals("<!--")) {
                                braceSpace = braceSpace + buffer.substring(0, 4);
                                if (" \t\r\n".indexOf(buffer.charAt(4)) == -1) {
                                    Logger.error(this, "<!-- not followed by whitespace!");
                                    return;
                                }
                                buffer.delete(0, 4);
                                for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                                }
                                braceSpace = braceSpace + buffer.substring(0, i);
                                buffer.delete(0, i);
                            }
                            for (i = buffer.length() - 1; i >= 0 && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); --i) {
                            }
                            postSpace = buffer.substring(++i);
                            buffer.setLength(i);
                            orig = buffer.toString().trim();
                            parts = CSSTokenizerFilter.split(orig, false);
                            if (CSSTokenizerFilter.logDEBUG) {
                                Logger.debug(this, "Split: " + CSSPropertyVerifier.toString(parts));
                            }
                            buffer.setLength(0);
                            valid = false;
                            if (parts != null) {
                                if (parts.length < 1) {
                                    ignoreElementsS1 = true;
                                    if (CSSTokenizerFilter.logDEBUG) {
                                        Logger.debug(this, "STATE1 CASE {: Does not have one part. ignoring " + buffer.toString());
                                    }
                                    valid = false;
                                } else if (parts[0] instanceof SimpleParsedWord && "@media".equals(((SimpleParsedWord)parts[0]).original.toLowerCase())) {
                                    if (parts.length < 2) {
                                        ignoreElementsS1 = true;
                                        if (CSSTokenizerFilter.logDEBUG) {
                                            Logger.debug(this, "STATE1 CASE {: Does not have two parts. ignoring " + buffer.toString());
                                        }
                                        valid = false;
                                    } else {
                                        medias = this.commaListFromIdentifiers(parts, 1);
                                        if (medias != null && medias.size() > 0) {
                                            for (i = 0; i < medias.size(); ++i) {
                                                if (FilterUtils.isMedia(medias.get(i))) continue;
                                                medias.remove(i);
                                                --i;
                                            }
                                        }
                                        if (medias != null && medias.size() > 0) {
                                            filteredTokens.append(braceSpace);
                                            filteredTokens.append("@media ");
                                            first = true;
                                            for (String media : medias) {
                                                if (!first) {
                                                    filteredTokens.append(", ");
                                                }
                                                first = false;
                                                filteredTokens.append(media);
                                            }
                                            filteredTokens.append(postSpace);
                                            filteredTokens.append("{");
                                            valid = true;
                                            currentMedia = medias.toArray(new String[medias.size()]);
                                        }
                                    }
                                } else if (parts[0] instanceof SimpleParsedWord && "@page".equals(((SimpleParsedWord)parts[0]).original.toLowerCase())) {
                                    if (parts.length == 0) {
                                        valid = true;
                                    } else {
                                        valid = true;
                                        for (j = 1; j < parts.length; ++j) {
                                            if (!(parts[j] instanceof SimpleParsedWord)) {
                                                valid = false;
                                                break;
                                            }
                                            s = ((SimpleParsedWord)parts[j]).original;
                                            if (s.equalsIgnoreCase(":left") || s.equalsIgnoreCase(":right") || s.equals(":first")) continue;
                                            valid = false;
                                            break;
                                        }
                                    }
                                    if (valid) {
                                        forPage = true;
                                        filteredTokens.append(braceSpace);
                                        filteredTokens.append(orig);
                                        filteredTokens.append(postSpace);
                                        filteredTokens.append("{");
                                    }
                                }
                            }
                            if (!valid) {
                                ignoreElementsS1 = true;
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "STATE1 CASE {: Failed verification test. ignoring " + buffer.toString());
                                }
                            } else {
                                this.w.write(filteredTokens.toString());
                                filteredTokens.setLength(0);
                            }
                            buffer.setLength(0);
                            s2Comma = false;
                            if (forPage) {
                                currentState = 3;
                                openBracesStartingS3 = openBraces;
                            } else {
                                currentState = 2;
                            }
                            buffer.setLength(0);
                            break;
                        }
                        case ';': {
                            if (prevc == '\\') {
                                buffer.append(c);
                                break;
                            }
                            if (CSSTokenizerFilter.logDEBUG) {
                                Logger.debug(this, "buffer in state 1 ; : \"" + buffer.toString() + "\"");
                            }
                            for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                            }
                            this.w.write(buffer.substring(0, i));
                            buffer.delete(0, i);
                            if (buffer.length() > 4 && buffer.substring(0, 4).equals("<!--")) {
                                this.w.write(buffer.substring(0, 4));
                                if (" \t\r\n".indexOf(buffer.charAt(4)) == -1) {
                                    Logger.error(this, "<!-- not followed by whitespace!");
                                    return;
                                }
                                buffer.delete(0, 4);
                                for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                                }
                                this.w.write(buffer.substring(0, i));
                                buffer.delete(0, i);
                            }
                            if (canImport && !ignoreElementsS1 && buffer.toString().contains("@import")) {
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "STATE1 CASE ;statement=" + buffer.toString());
                                }
                                if ("".equals((strbuffer = buffer.toString().trim()).substring(0, importIndex = strbuffer.toLowerCase().indexOf("@import")).trim()) && (strparts = CSSTokenizerFilter.split(str1 = strbuffer.substring(importIndex + 7, strbuffer.length()), false)) != null && strparts.length > 0 && (strparts[0] instanceof ParsedURL || strparts[0] instanceof ParsedString)) {
                                    uri = strparts[0] instanceof ParsedString != false ? ((ParsedString)strparts[0]).getDecoded() : ((ParsedURL)strparts[0]).getDecoded();
                                    medias = this.commaListFromIdentifiers(strparts, 1);
                                    if (medias != null) {
                                        output = new StringBuilder();
                                        output.append("@import url(\"");
                                        try {
                                            s = this.cb.processURI(uri, "text/css");
                                            if (this.passedCharset != null) {
                                                s = s.indexOf(63) == -1 ? s + "?maybecharset=" + this.passedCharset : s + "&maybecharset=" + this.passedCharset;
                                            }
                                            output.append(s);
                                            output.append("\")");
                                            first = true;
                                            for (String media : medias) {
                                                if (!FilterUtils.isMedia(media)) continue;
                                                if (!first) {
                                                    output.append(", ");
                                                } else {
                                                    output.append(' ');
                                                }
                                                first = false;
                                                output.append(media);
                                            }
                                            output.append(";");
                                            this.w.write(output.toString());
                                        }
                                        catch (CommentException e) {}
                                    }
                                }
                            } else if (charsetPossible && buffer.toString().startsWith("@charset ")) {
                                s = buffer.delete(0, "@charset ".length()).toString();
                                this.detectedCharset = s = CSSTokenizerFilter.removeOuterQuotes(s);
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "Detected charset: \"" + this.detectedCharset + "\"");
                                }
                                if (!Charset.isSupported(this.detectedCharset)) {
                                    Logger.normal(this, "Charset not supported: " + this.detectedCharset);
                                    throw new UnsupportedCharsetInFilterException("Charset not supported: " + this.detectedCharset);
                                }
                                if (this.stopAtDetectedCharset) {
                                    return;
                                }
                                if (this.passedCharset != null && !this.detectedCharset.equalsIgnoreCase(this.passedCharset)) {
                                    Logger.normal(this, "Detected charset \"" + this.detectedCharset + "\" differs from passed in charset \"" + this.passedCharset + "\"");
                                    throw new IOException("Detected charset differs from passed in charset");
                                }
                                this.w.write("@charset \"" + this.detectedCharset + "\";");
                            }
                            isState1Present = false;
                            ignoreElementsS1 = false;
                            buffer.setLength(0);
                            charsetPossible = false;
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            if (prevc == '\\') {
                                buffer.append(c);
                                break;
                            }
                            buffer.append(c);
                            currentState = 5;
                            currentQuote = c;
                            break;
                        }
                        default: {
                            buffer.append(c);
                            if (!(isState1Present || (s = buffer.toString().trim()).equals("") || s.equals("/") || s.equals("<") || s.equals("<!") || s.equals("<!-") || s.equals("<!--"))) {
                                currentState = 2;
                            }
                            if (!CSSTokenizerFilter.logDEBUG) continue block54;
                            Logger.debug(this, "STATE1 default CASE: " + c);
                            break;
                        }
                    }
                    continue block54;
                }
                case 5: {
                    if (CSSTokenizerFilter.logDEBUG) {
                        Logger.debug(this, "STATE1INQUOTE: " + c);
                    }
                    switch (c) {
                        case '\"': {
                            if (currentQuote == '\"' && prevc != '\\') {
                                currentState = 1;
                            }
                            buffer.append(c);
                            break;
                        }
                        case '\'': {
                            if (currentQuote == '\'' && prevc != '\\') {
                                currentState = 1;
                            }
                            buffer.append(c);
                            break;
                        }
                        case '\n': {
                            if (prevc == '\r') break;
                        }
                        case '\f': 
                        case '\r': {
                            if (prevc != '\\') {
                                ignoreElementsS1 = true;
                                currentState = 1;
                                break;
                            }
                            buffer.setLength(buffer.length() - 1);
                            break;
                        }
                        default: {
                            buffer.append(c);
                            break;
                        }
                    }
                    continue block54;
                }
                case 2: {
                    canImport = false;
                    charsetPossible = false;
                    if (this.stopAtDetectedCharset) {
                        return;
                    }
                    switch (c) {
                        case '{': {
                            if (prevc == '\\') {
                                buffer.append(c);
                                break;
                            }
                            i = 0;
                            for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                            }
                            if (CSSTokenizerFilter.logDEBUG) {
                                Logger.debug(this, "Appending whitespace in state2: \"" + buffer.substring(0, i) + "\"");
                            }
                            ws = buffer.substring(0, i);
                            buffer.delete(0, i);
                            if (buffer.length() > 4 && buffer.substring(0, 4).equals("<!--")) {
                                ws = ws + buffer.substring(0, 4);
                                if (" \t\r\n".indexOf(buffer.charAt(4)) == -1) {
                                    Logger.error(this, "<!-- not followed by whitespace!");
                                    return;
                                }
                                buffer.delete(0, 4);
                                for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                                }
                                ws = ws + buffer.substring(0, i);
                                buffer.delete(0, i);
                            }
                            ++openBraces;
                            if (!buffer.toString().trim().equals("")) {
                                filtered = this.recursiveSelectorVerifier(buffer.toString());
                                if (filtered != null) {
                                    if (s2Comma) {
                                        filteredTokens.append(",");
                                        s2Comma = false;
                                    }
                                    filteredTokens.append(ws);
                                    filteredTokens.append(filtered);
                                    filteredTokens.append(" {");
                                } else {
                                    ignoreElementsS2 = true;
                                    filteredTokens.setLength(0);
                                }
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "STATE2 CASE { filtered elements" + filtered);
                                }
                            } else {
                                ignoreElementsS2 = true;
                                filteredTokens.setLength(0);
                            }
                            currentState = 3;
                            openBracesStartingS3 = openBraces;
                            if (CSSTokenizerFilter.logDEBUG) {
                                Logger.debug(this, "STATE2 -> STATE3, openBracesStartingS3 = " + openBracesStartingS3);
                            }
                            buffer.setLength(0);
                            break;
                        }
                        case ',': {
                            if (prevc == '\\') {
                                buffer.append(c);
                                break;
                            }
                            for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                            }
                            if (CSSTokenizerFilter.logDEBUG) {
                                Logger.debug(this, "Appending whitespace in state2: \"" + buffer.substring(0, i) + "\"");
                            }
                            ws = buffer.substring(0, i);
                            buffer.delete(0, i);
                            if (!s2Comma && buffer.length() > 4 && buffer.substring(0, 4).equals("<!--")) {
                                filteredTokens.append(buffer.substring(0, 4));
                                if (" \t\r\n".indexOf(buffer.charAt(4)) == -1) {
                                    Logger.error(this, "<!-- not followed by whitespace!");
                                    return;
                                }
                                buffer.delete(0, 4);
                                for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                                }
                                filteredTokens.append(buffer.substring(0, i));
                                buffer.delete(0, i);
                            }
                            filtered = this.recursiveSelectorVerifier(buffer.toString().trim());
                            if (CSSTokenizerFilter.logDEBUG) {
                                Logger.debug(this, "STATE2 CASE , filtered elements" + filtered);
                            }
                            if (filtered != null) {
                                if (s2Comma) {
                                    filteredTokens.append(",");
                                } else {
                                    s2Comma = true;
                                }
                                filteredTokens.append(ws);
                                filteredTokens.append(filtered);
                            }
                            buffer.setLength(0);
                            break;
                        }
                        case '}': {
                            if (prevc == '\\') {
                                buffer.append(c);
                                break;
                            }
                            if (openBraces > 0 && !ignoreElementsS1) {
                                if (--openBraces >= 0) {
                                    filteredTokens.append('}');
                                } else {
                                    openBraces = 0;
                                }
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "Writing \"" + filteredTokens + "\"");
                                }
                                this.w.write(filteredTokens.toString());
                            } else {
                                if (openBraces > 0) {
                                    --openBraces;
                                }
                                ignoreElementsS1 = false;
                            }
                            filteredTokens.setLength(0);
                            buffer.setLength(0);
                            currentMedia = new String[]{defaultMedia};
                            isState1Present = false;
                            currentState = 1;
                            if (this.isInline) {
                                return;
                            }
                            if (!CSSTokenizerFilter.logDEBUG) continue block54;
                            Logger.debug(this, "STATE2 CASE }: " + c);
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            if (prevc == '\\') {
                                buffer.append(c);
                                break;
                            }
                            buffer.append(c);
                            currentState = 6;
                            currentQuote = c;
                            break;
                        }
                        default: {
                            buffer.append(c);
                            if (!CSSTokenizerFilter.logDEBUG) continue block54;
                            Logger.debug(this, "STATE2 default CASE: " + c);
                            break;
                        }
                    }
                    continue block54;
                }
                case 6: {
                    if (CSSTokenizerFilter.logDEBUG) {
                        Logger.debug(this, "STATE2INQUOTE: " + c);
                    }
                    charsetPossible = false;
                    switch (c) {
                        case '\"': {
                            if (currentQuote == '\"' && prevc != '\\') {
                                currentState = 2;
                            }
                            buffer.append(c);
                            break;
                        }
                        case '\'': {
                            if (currentQuote == '\'' && prevc != '\\') {
                                currentState = 2;
                            }
                            buffer.append(c);
                            break;
                        }
                        case '\n': {
                            if (prevc == '\r') break;
                        }
                        case '\f': 
                        case '\r': {
                            if (prevc != '\\') {
                                ignoreElementsS2 = true;
                                closeIgnoredS2 = true;
                                currentState = 2;
                                break;
                            }
                            buffer.setLength(buffer.length() - 1);
                            break;
                        }
                        default: {
                            buffer.append(c);
                            break;
                        }
                    }
                    continue block54;
                }
                case 3: {
                    charsetPossible = false;
                    if (this.stopAtDetectedCharset) {
                        return;
                    }
                    switch (c) {
                        case ':': {
                            if (prevc == '\\') {
                                buffer.append(c);
                                break;
                            }
                            if (openBraces > openBracesStartingS3) {
                                buffer.append(c);
                                if (!CSSTokenizerFilter.logDEBUG) continue block54;
                                Logger.debug(this, "openBraces now " + openBraces + " not moving on because openBracesStartingS3=" + openBracesStartingS3 + " in S3");
                                break;
                            }
                            i = 0;
                            for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                            }
                            if (CSSTokenizerFilter.logDEBUG) {
                                Logger.debug(this, "Appending whitespace: " + buffer.substring(0, i));
                            }
                            whitespaceBeforeProperty = buffer.substring(0, i);
                            propertyName = buffer.delete(0, i).toString().trim();
                            if (CSSTokenizerFilter.logDEBUG) {
                                Logger.debug(this, "Property name: " + propertyName);
                            }
                            buffer.setLength(0);
                            if (!CSSTokenizerFilter.logDEBUG) continue block54;
                            Logger.debug(this, "STATE3 CASE :: " + c);
                            break;
                        }
                        case ';': {
                            if (prevc == '\\') {
                                buffer.append(c);
                                break;
                            }
                            if (openBraces > openBracesStartingS3) {
                                buffer.append(c);
                                if (!CSSTokenizerFilter.logDEBUG) continue block54;
                                Logger.debug(this, "openBraces now " + openBraces + " not moving on because openBracesStartingS3=" + openBracesStartingS3 + " in S3");
                                break;
                            }
                            i = 0;
                            for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                            }
                            if (CSSTokenizerFilter.logDEBUG) {
                                Logger.debug(this, "Appending whitespace after colon: \"" + buffer.substring(0, i) + "\"");
                            }
                            whitespaceAfterColon = buffer.substring(0, i);
                            propertyValue = buffer.delete(0, i).toString().trim();
                            if (CSSTokenizerFilter.logDEBUG) {
                                Logger.debug(this, "Property value: " + propertyValue);
                            }
                            buffer.setLength(0);
                            obj = CSSTokenizerFilter.getVerifier(propertyName);
                            if (obj != null) {
                                words = CSSTokenizerFilter.split(propertyValue, obj.allowCommaDelimiters);
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "Split: " + CSSPropertyVerifier.toString(words));
                                }
                                if (words != null && !ignoreElementsS2 && !ignoreElementsS3 && this.verifyToken(currentMedia, elements, obj, words)) {
                                    if (this.changedAnything(words)) {
                                        propertyValue = this.reconstruct(words);
                                    }
                                    filteredTokens.append(whitespaceBeforeProperty);
                                    whitespaceBeforeProperty = "";
                                    filteredTokens.append(propertyName);
                                    filteredTokens.append(':');
                                    filteredTokens.append(whitespaceAfterColon);
                                    filteredTokens.append(propertyValue);
                                    filteredTokens.append(';');
                                    if (CSSTokenizerFilter.logDEBUG) {
                                        Logger.debug(this, "STATE3 CASE ;: appending " + propertyName + ":" + propertyValue);
                                    }
                                    if (CSSTokenizerFilter.logDEBUG) {
                                        Logger.debug(this, "filtered tokens now: \"" + filteredTokens.toString() + "\"");
                                    }
                                } else if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "filtered tokens now (ignored): \"" + filteredTokens.toString() + "\" words=" + CSSPropertyVerifier.toString(words) + " ignoreS1=" + ignoreElementsS1 + " ignoreS2=" + ignoreElementsS2 + " ignoreS3=" + ignoreElementsS3);
                                }
                            } else if (CSSTokenizerFilter.logDEBUG) {
                                Logger.debug(this, "No such property name \"" + propertyName + "\"");
                            }
                            ignoreElementsS3 = false;
                            propertyName = "";
                            propertyValue = "";
                            break;
                        }
                        case '}': {
                            if (prevc == '\\') {
                                buffer.append(c);
                                break;
                            }
                            if (--openBraces > openBracesStartingS3 - 1) {
                                buffer.append(c);
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "openBraces now " + openBraces + " not moving on because openBracesStartingS3=" + openBracesStartingS3 + " in S3");
                                }
                                if (openBraces >= 0) continue block54;
                                openBraces = 0;
                                break;
                            }
                            if (openBraces < 0) {
                                openBraces = 0;
                            }
                            for (i = buffer.length() - 1; i >= 0 && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); --i) {
                            }
                            postSpace = buffer.substring(++i);
                            buffer.setLength(i);
                            if (propertyName != "") {
                                i = 0;
                                for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                                }
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "Appending whitespace after colon (}): " + buffer.substring(0, i));
                                }
                                whitespaceAfterColon = buffer.substring(0, i);
                                buffer.delete(0, i);
                                propertyValue = buffer.toString().trim();
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "Property value: " + propertyValue);
                                }
                                buffer.setLength(0);
                                obj = CSSTokenizerFilter.getVerifier(propertyName);
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "Found PropertyName:" + propertyName + " propertyValue:" + propertyValue);
                                }
                                if (obj != null) {
                                    words = CSSTokenizerFilter.split(propertyValue, obj.allowCommaDelimiters);
                                    if (CSSTokenizerFilter.logDEBUG) {
                                        Logger.debug(this, "Split: " + CSSPropertyVerifier.toString(words));
                                    }
                                    if (!ignoreElementsS2 && !ignoreElementsS3 && this.verifyToken(currentMedia, elements, obj, words)) {
                                        if (this.changedAnything(words)) {
                                            propertyValue = this.reconstruct(words);
                                        }
                                        filteredTokens.append(whitespaceBeforeProperty);
                                        whitespaceBeforeProperty = "";
                                        filteredTokens.append(propertyName);
                                        filteredTokens.append(':');
                                        filteredTokens.append(whitespaceAfterColon);
                                        filteredTokens.append(propertyValue);
                                        if (CSSTokenizerFilter.logDEBUG) {
                                            Logger.debug(this, "STATE3 CASE }: appending " + propertyName + ":" + propertyValue);
                                        }
                                    }
                                } else if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "No such property name \"" + propertyName + "\"");
                                }
                                propertyName = "";
                            } else {
                                i = 0;
                                for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
                                }
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "Appending whitespace after colon (}): " + buffer.substring(0, i));
                                }
                                filteredTokens.append(buffer.substring(0, i));
                                buffer.delete(0, i);
                            }
                            ignoreElementsS3 = false;
                            if (!ignoreElementsS2 || closeIgnoredS2) {
                                filteredTokens.append(postSpace);
                                filteredTokens.append("}");
                                closeIgnoredS2 = false;
                                ignoreElementsS2 = false;
                            } else {
                                ignoreElementsS2 = false;
                            }
                            if (!ignoreElementsS1) {
                                this.w.write(filteredTokens.toString());
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "writing filtered tokens: \"" + filteredTokens.toString() + "\"");
                                }
                            }
                            filteredTokens.setLength(0);
                            whitespaceAfterColon = "";
                            if (forPage) {
                                forPage = false;
                                currentState = 1;
                            } else {
                                currentState = 2;
                            }
                            if (this.isInline) {
                                return;
                            }
                            buffer.setLength(0);
                            s2Comma = false;
                            if (!CSSTokenizerFilter.logDEBUG) continue block54;
                            Logger.debug(this, "STATE3 CASE }: " + c);
                            break;
                        }
                        case '{': {
                            ++openBraces;
                            buffer.append(c);
                            if (!CSSTokenizerFilter.logDEBUG) continue block54;
                            Logger.debug(this, "openBraces now " + openBraces + " in S3");
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            if (prevc == '\\') {
                                buffer.append(c);
                                break;
                            }
                            buffer.append(c);
                            currentState = 7;
                            currentQuote = c;
                            break;
                        }
                        default: {
                            buffer.append(c);
                            if (!CSSTokenizerFilter.logDEBUG) continue block54;
                            Logger.debug(this, "STATE3 default CASE : " + c);
                            break;
                        }
                    }
                    continue block54;
                }
                case 7: {
                    charsetPossible = false;
                    if (this.stopAtDetectedCharset) {
                        return;
                    }
                    if (CSSTokenizerFilter.logDEBUG) {
                        Logger.debug(this, "STATE3INQUOTE: " + c);
                    }
                    switch (c) {
                        case '\"': {
                            if (currentQuote == '\"' && prevc != '\\') {
                                currentState = 3;
                            }
                            buffer.append(c);
                            break;
                        }
                        case '\'': {
                            if (currentQuote == '\'' && prevc != '\\') {
                                currentState = 3;
                            }
                            buffer.append(c);
                            break;
                        }
                        case '\n': {
                            if (prevc == '\r') break;
                        }
                        case '\f': 
                        case '\r': {
                            if (prevc != '\\') {
                                ignoreElementsS3 = true;
                                currentState = 3;
                                break;
                            }
                            buffer.setLength(buffer.length() - 1);
                            break;
                        }
                        default: {
                            buffer.append(c);
                            break;
                        }
                    }
                    continue block54;
                }
                case 4: {
                    charsetPossible = false;
                    if (this.stopAtDetectedCharset) {
                        return;
                    }
                    switch (c) {
                        case '/': {
                            if (prevc == '*') {
                                currentState = stateBeforeComment;
                                if (CSSTokenizerFilter.logDEBUG) {
                                    Logger.debug(this, "Exiting the comment state " + currentState);
                                } else {
                                    ** GOTO lbl757
                                }
                            } else {
                                ** GOTO lbl757
                            }
                        }
                    }
                }
            }
lbl757:
            // 7 sources

        }
        if (CSSTokenizerFilter.logDEBUG) {
            Logger.debug(this, "Filtered tokens: \"" + filteredTokens + "\"");
        }
        this.w.write(filteredTokens.toString());
        for (i = 0; i < openBraces; ++i) {
            this.w.write(125);
        }
        if (CSSTokenizerFilter.logDEBUG) {
            Logger.debug(this, "Remaining buffer: \"" + buffer + "\"");
        }
        i = 0;
        for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
        }
        this.w.write(buffer.substring(0, i));
        buffer.delete(0, i);
        while (buffer.toString().trim().equals("-->")) {
            this.w.write("-->");
            buffer.delete(0, 3);
            for (i = 0; i < buffer.length() && ((c1 = buffer.charAt(i)) == ' ' || c1 == '\f' || c1 == '\t' || c1 == '\r' || c1 == '\n'); ++i) {
            }
            this.w.write(buffer.substring(0, i));
            buffer.delete(0, i);
        }
    }

    private String reconstruct(ParsedWord[] words) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        ParsedWord lastWord = null;
        for (ParsedWord word : words) {
            if (lastWord != null && lastWord.postComma) {
                sb.append(',');
            }
            lastWord = word;
            if (!first) {
                sb.append(" ");
            }
            if (!word.changed) {
                sb.append(word.original);
                if (logDEBUG) {
                    Logger.debug(this, "Adding word (original): \"" + word.original + "\"");
                }
            } else {
                sb.append(word.encode(false));
                if (logDEBUG) {
                    Logger.debug(this, "Adding word (new): \"" + word.encode(false) + "\"");
                }
            }
            first = false;
        }
        if (logDEBUG) {
            Logger.debug(this, "Reconstructed: \"" + sb.toString() + "\"");
        }
        return sb.toString();
    }

    private boolean changedAnything(ParsedWord[] words) {
        for (ParsedWord word : words) {
            if (!word.changed) continue;
            return true;
        }
        return false;
    }

    private ArrayList<String> commaListFromIdentifiers(ParsedWord[] strparts, int offset) {
        ArrayList<String> medias = new ArrayList<String>(strparts.length - 1);
        if (strparts.length > offset) {
            if (strparts.length == offset + 1 && strparts[1] instanceof ParsedIdentifier) {
                medias.add(((ParsedIdentifier)strparts[1]).getDecoded());
            } else {
                boolean first = true;
                for (ParsedWord word : strparts) {
                    if (first) {
                        first = false;
                        continue;
                    }
                    if (word instanceof ParsedIdentifier) {
                        medias.add(((ParsedIdentifier)word).getDecoded());
                        continue;
                    }
                    if (word instanceof SimpleParsedWord) {
                        String data = ((SimpleParsedWord)word).original;
                        String[] split = FilterUtils.removeWhiteSpace(data.split(","), false);
                        medias.addAll(Arrays.asList(split));
                        continue;
                    }
                    return null;
                }
            }
        }
        return medias;
    }

    private static ParsedWord[] split(String input, boolean allowCommaDelimiters) {
        if (logDEBUG) {
            Logger.debug(CSSTokenizerFilter.class, "Splitting \"" + input + "\" allowCommaDelimiters=" + allowCommaDelimiters);
        }
        ArrayList<ParsedWord> words = new ArrayList<ParsedWord>();
        ParsedWord lastWord = null;
        char c = '\u0000';
        char stringchar = '\u0000';
        boolean escaping = false;
        boolean eatLF = false;
        StringBuilder origToken = new StringBuilder(input.length());
        StringBuilder decodedToken = new StringBuilder(input.length());
        boolean dontLikeOrigToken = false;
        StringBuilder escape = new StringBuilder(6);
        boolean couldBeIdentifier = true;
        boolean addComma = false;
        int bracketCount = 0;
        for (int i = 0; i < input.length(); ++i) {
            c = input.charAt(i);
            if (stringchar == '\u0000') {
                if (eatLF && c == '\n') {
                    eatLF = false;
                    continue;
                }
                eatLF = false;
                if (!escaping) {
                    if ((" \t\r\n\f".indexOf(c) != -1 || allowCommaDelimiters && c == ',') && bracketCount == 0) {
                        if (c == ',') {
                            if (decodedToken.length() == 0) {
                                if (lastWord == null) {
                                    if (logDEBUG) {
                                        Logger.debug(CSSTokenizerFilter.class, "Extra comma before first element in \"" + input + "\" i=" + i);
                                    }
                                    return null;
                                }
                                if (lastWord.postComma) {
                                    if (logDEBUG) {
                                        Logger.debug(CSSTokenizerFilter.class, "Extra comma after element " + lastWord + " in \"" + input + "\" i=" + i);
                                    }
                                    lastWord.changed = true;
                                } else {
                                    lastWord.postComma = true;
                                }
                            } else {
                                if (addComma) {
                                    if (logDEBUG) {
                                        Logger.debug(CSSTokenizerFilter.class, "Extra comma after a comma in \"" + input + "\" i=" + i);
                                    }
                                    return null;
                                }
                                addComma = true;
                            }
                        }
                        if (decodedToken.length() <= 0) continue;
                        ParsedWord word = CSSTokenizerFilter.parseToken(origToken, decodedToken, dontLikeOrigToken, couldBeIdentifier);
                        if (logDEBUG) {
                            Logger.debug(CSSTokenizerFilter.class, "Token: orig: \"" + origToken.toString() + "\" decoded: \"" + decodedToken.toString() + "\" dontLike=" + dontLikeOrigToken + " couldBeIdentifier=" + couldBeIdentifier + " parsed " + word);
                        }
                        if (word == null) {
                            return null;
                        }
                        if (addComma) {
                            word.postComma = true;
                            addComma = false;
                        }
                        words.add(word);
                        origToken.setLength(0);
                        decodedToken.setLength(0);
                        dontLikeOrigToken = false;
                        couldBeIdentifier = true;
                        lastWord = word;
                        continue;
                    }
                    if (c == '\"') {
                        stringchar = c;
                        origToken.append(c);
                        decodedToken.append(c);
                        couldBeIdentifier = false;
                        continue;
                    }
                    if (c == '\'') {
                        stringchar = c;
                        origToken.append(c);
                        decodedToken.append(c);
                        couldBeIdentifier = false;
                        continue;
                    }
                    if (c == '\\') {
                        origToken.append(c);
                        escape.setLength(0);
                        escaping = true;
                        continue;
                    }
                    if (c == '(') {
                        ++bracketCount;
                        origToken.append(c);
                        decodedToken.append(c);
                        couldBeIdentifier = false;
                        continue;
                    }
                    if (c == ')') {
                        if (--bracketCount < 0) {
                            return null;
                        }
                        origToken.append(c);
                        decodedToken.append(c);
                        couldBeIdentifier = false;
                        continue;
                    }
                    if (couldBeIdentifier) {
                        if (!(c >= '0' && c <= '9' && origToken.length() > 0 || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '-' || c == '_' || c >= '\u00a1')) {
                            couldBeIdentifier = false;
                        }
                        if (origToken.length() == 1 && origToken.charAt(0) == '-' && c >= '0' && c <= '9') {
                            couldBeIdentifier = false;
                        }
                    }
                    origToken.append(c);
                    decodedToken.append(c);
                    continue;
                }
                if (escaping && escape.length() == 0) {
                    if (c == '\"' || c == '\'') {
                        escaping = false;
                        origToken.append(c);
                        decodedToken.append(c);
                        continue;
                    }
                    if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
                        escape.append(c);
                        continue;
                    }
                    if (c == '\n' || c == '\r' || c == '\f') {
                        return null;
                    }
                    escaping = false;
                    origToken.append(c);
                    decodedToken.append(c);
                    continue;
                }
                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
                    escape.append(c);
                    if (escape.length() != 6) continue;
                    origToken.append((CharSequence)escape);
                    decodedToken.append((char)Integer.parseInt(escape.toString(), 16));
                    escape.setLength(0);
                    escaping = false;
                    continue;
                }
                if (" \t\r\n\f".indexOf(c) != -1) {
                    origToken.append((CharSequence)escape);
                    decodedToken.append((char)Integer.parseInt(escape.toString(), 16));
                    origToken.append(" ");
                    escape.setLength(0);
                    escaping = false;
                    if (c != '\r') continue;
                    eatLF = true;
                    continue;
                }
                return null;
            }
            if (eatLF && c == '\n') {
                eatLF = false;
                origToken.append(c);
                continue;
            }
            eatLF = false;
            if (c == stringchar && !escaping) {
                origToken.append(c);
                decodedToken.append(c);
                stringchar = '\u0000';
                continue;
            }
            if (c == '\f' || c == '\r' || c == '\n' && !escaping) {
                return null;
            }
            if (c == '\\' && !escaping) {
                escaping = true;
                escape.setLength(0);
                origToken.append(c);
                continue;
            }
            if (escaping && escape.length() == 0) {
                if (c == '\"' || c == '\'') {
                    escaping = false;
                    origToken.append(c);
                    decodedToken.append(c);
                    continue;
                }
                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
                    escape.append(c);
                    continue;
                }
                if (c == '\r' || c == '\n' || c == '\f') {
                    origToken.append(c);
                    if (c != '\r') continue;
                    eatLF = true;
                    continue;
                }
                origToken.append(c);
                decodedToken.append(c);
                escaping = false;
                continue;
            }
            if (escaping) {
                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
                    escape.append(c);
                    if (escape.length() != 6) continue;
                    origToken.append((CharSequence)escape);
                    decodedToken.append((char)Integer.parseInt(escape.toString(), 16));
                    escape.setLength(0);
                    escaping = false;
                    continue;
                }
                if (" \t\r\n\f".indexOf(c) != -1) {
                    origToken.append((CharSequence)escape);
                    decodedToken.append((char)Integer.parseInt(escape.toString(), 16));
                    escape.setLength(0);
                    escaping = false;
                    if (c != '\r') continue;
                    eatLF = true;
                    dontLikeOrigToken = true;
                    continue;
                }
                return null;
            }
            origToken.append(c);
            decodedToken.append(c);
        }
        if (escaping && escape.length() > 0) {
            origToken.append((CharSequence)escape);
            decodedToken.append((char)Integer.parseInt(escape.toString(), 16));
        } else if (escaping) {
            dontLikeOrigToken = true;
        }
        if (origToken.length() > 0) {
            ParsedWord word;
            if (logDEBUG) {
                Logger.debug(CSSTokenizerFilter.class, "Token: orig: \"" + origToken.toString() + "\" decoded: \"" + decodedToken.toString() + "\" dontLike=" + dontLikeOrigToken + " couldBeIdentifier=" + couldBeIdentifier);
            }
            if ((word = CSSTokenizerFilter.parseToken(origToken, decodedToken, dontLikeOrigToken, couldBeIdentifier)) == null) {
                return null;
            }
            words.add(word);
        }
        return words.toArray(new ParsedWord[words.size()]);
    }

    private static ParsedWord parseToken(StringBuilder origToken, StringBuilder decodedToken, boolean dontLikeOrigToken, boolean couldBeIdentifier) {
        char c;
        if (origToken.length() > 2 && ((c = origToken.charAt(0)) == '\'' || c == '\"')) {
            char d = origToken.charAt(origToken.length() - 1);
            if (c == d) {
                decodedToken.setLength(decodedToken.length() - 1);
                decodedToken.deleteCharAt(0);
                return new ParsedString(origToken.toString(), decodedToken.toString(), dontLikeOrigToken, c);
            }
            if (d != ',') {
                return null;
            }
            return new SimpleParsedWord(origToken.toString());
        }
        String s = origToken.toString();
        if (couldBeIdentifier) {
            return new ParsedIdentifier(s, decodedToken.toString(), dontLikeOrigToken);
        }
        String sl = s.toLowerCase();
        if (sl.startsWith("url(")) {
            if (s.endsWith(")")) {
                char c2;
                int i;
                decodedToken.delete(0, 4);
                decodedToken.setLength(decodedToken.length() - 1);
                if (logDEBUG) {
                    Logger.debug(CSSTokenizerFilter.class, "stripped: " + decodedToken);
                }
                String strippedOrig = s.substring(4, s.length() - 1);
                for (i = 0; i < strippedOrig.length() && ((c2 = strippedOrig.charAt(i)) == ' ' || c2 == '\t'); ++i) {
                }
                decodedToken.delete(0, i);
                strippedOrig = strippedOrig.substring(i);
                for (i = strippedOrig.length() - 1; !(i < 0 || (c2 = strippedOrig.charAt(i)) != ' ' && c2 != '\t' || i > 0 && strippedOrig.charAt(i - 1) == '\\'); --i) {
                }
                decodedToken.setLength(decodedToken.length() - (strippedOrig.length() - i - 1));
                strippedOrig = strippedOrig.substring(0, i + 1);
                if (logDEBUG) {
                    Logger.debug(CSSTokenizerFilter.class, "whitespace stripped: " + strippedOrig + " decoded " + decodedToken);
                }
                if (strippedOrig.length() == 0) {
                    return null;
                }
                if (strippedOrig.length() > 2 && ((c2 = strippedOrig.charAt(0)) == '\'' || c2 == '\"')) {
                    char d = strippedOrig.charAt(strippedOrig.length() - 1);
                    if (c2 == d) {
                        decodedToken.setLength(decodedToken.length() - 1);
                        decodedToken.deleteCharAt(0);
                        if (logDEBUG) {
                            Logger.debug(CSSTokenizerFilter.class, "creating url(): orig=\"" + origToken.toString() + "\" decoded=\"" + decodedToken.toString() + "\"");
                        }
                        return new ParsedURL(origToken.toString(), decodedToken.toString(), dontLikeOrigToken, c2);
                    }
                    return null;
                }
                return new ParsedURL(origToken.toString(), decodedToken.toString(), dontLikeOrigToken, '\u0000');
            }
            return null;
        }
        if (sl.startsWith("attr(")) {
            if (s.endsWith(")")) {
                char c3;
                int i;
                decodedToken.delete(0, 5);
                decodedToken.setLength(decodedToken.length() - 1);
                String strippedOrig = s.substring(4, s.length() - 1);
                for (i = 0; i < strippedOrig.length() && ((c3 = strippedOrig.charAt(i)) == ' ' || c3 == '\t'); ++i) {
                }
                decodedToken.delete(0, i);
                strippedOrig = strippedOrig.substring(i);
                for (i = strippedOrig.length() - 1; !(i < 0 || (c3 = strippedOrig.charAt(i)) != ' ' && c3 != '\t' || i > 0 && strippedOrig.charAt(i - 1) == '\\'); --i) {
                }
                decodedToken.setLength(decodedToken.length() - (strippedOrig.length() - i - 1));
                strippedOrig = strippedOrig.substring(0, i + 1);
                if (strippedOrig.length() == 0) {
                    return null;
                }
                return new ParsedAttr(origToken.toString(), decodedToken.toString(), dontLikeOrigToken);
            }
            return null;
        }
        boolean plural = false;
        if (sl.startsWith("counter(") || (plural = sl.startsWith("counters("))) {
            if (s.endsWith(")")) {
                char c4;
                int i;
                int len = plural ? "counters(".length() : "counter(".length();
                decodedToken.delete(0, len);
                decodedToken.setLength(decodedToken.length() - 1);
                String strippedOrig = s.substring(len, s.length() - 1);
                for (i = 0; i < strippedOrig.length() && ((c4 = strippedOrig.charAt(i)) == ' ' || c4 == '\t'); ++i) {
                }
                decodedToken.delete(0, i);
                strippedOrig = strippedOrig.substring(i);
                for (i = strippedOrig.length() - 1; !(i < 0 || (c4 = strippedOrig.charAt(i)) != ' ' && c4 != '\t' || i > 0 && strippedOrig.charAt(i - 1) == '\\'); --i) {
                }
                decodedToken.setLength(decodedToken.length() - (strippedOrig.length() - i - 1));
                strippedOrig = strippedOrig.substring(0, i + 1);
                if (strippedOrig.length() == 0) {
                    return null;
                }
                String[] split = FilterUtils.removeWhiteSpace(strippedOrig.split(","), false);
                if (split.length == 0 || plural && split.length > 3 || !plural && split.length > 2 || plural && split.length < 2) {
                    return null;
                }
                ParsedIdentifier ident = CSSTokenizerFilter.makeParsedIdentifier(split[0]);
                if (ident == null) {
                    return null;
                }
                ParsedString separator = null;
                ParsedIdentifier listType = null;
                if (plural && (separator = CSSTokenizerFilter.makeParsedString(split[1])) == null) {
                    return null;
                }
                if ((!plural && split.length == 2 || plural && split.length == 3) && (listType = CSSTokenizerFilter.makeParsedIdentifier(split[split.length - 1])) == null) {
                    return null;
                }
                return new ParsedCounter(origToken.toString(), ident, listType, separator);
            }
            return null;
        }
        return new SimpleParsedWord(origToken.toString());
    }

    private static ParsedIdentifier makeParsedIdentifier(String string) {
        ParsedWord[] words = CSSTokenizerFilter.split(string, false);
        if (words == null) {
            return null;
        }
        if (words.length != 1) {
            return null;
        }
        if (!(words[0] instanceof ParsedIdentifier)) {
            return null;
        }
        return (ParsedIdentifier)words[0];
    }

    private static ParsedString makeParsedString(String string) {
        ParsedWord[] words = CSSTokenizerFilter.split(string, false);
        if (words == null) {
            return null;
        }
        if (words.length != 1) {
            return null;
        }
        if (!(words[0] instanceof ParsedString)) {
            return null;
        }
        return (ParsedString)words[0];
    }

    public static String removeOuterQuotes(String decoded) {
        if (decoded.length() < 2) {
            return decoded;
        }
        char first = decoded.charAt(0);
        if (first != '\'' && first != '\"') {
            return decoded;
        }
        if (decoded.charAt(decoded.length() - 1) == first) {
            return decoded.substring(1, decoded.length() - 1);
        }
        return decoded;
    }

    public String detectedCharset() {
        return this.detectedCharset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arg) throws Throwable {
        File fin = new File("/tmp/test.css");
        File fout = new File("/tmp/test2.css");
        fout.delete();
        FileBucket inputBucket = new FileBucket(fin, true, false, false, false, false);
        FileBucket outputBucket = new FileBucket(fout, false, true, false, false, false);
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = inputBucket.getInputStream();
            outputStream = outputBucket.getOutputStream();
            Logger.setupStdoutLogging(Logger.LogLevel.DEBUG, "");
            ContentFilter.filter(inputStream, outputStream, "text/css", new URI("http://127.0.0.1:8888/freenet:USK@ZupQjDFZSc3I4orBpl1iTEAPZKo2733RxCUbZ2Q7iH0,EO8Tuf8SP3lnDjQdAPdCM2ve2RaUEN8m-hod3tQ5oQE,AQACAAE/jFreesite/19/Style/"), null, null, null);
        }
        finally {
            Closer.close(inputStream);
            Closer.close(outputStream);
            inputBucket.free();
            outputBucket.free();
        }
    }

    static {
        Logger.registerClass(CSSTokenizerFilter.class);
        elementVerifiers = new HashMap<String, CSSPropertyVerifier>();
        allelementVerifiers = new HashSet();
        allelementVerifiers.add("azimuth");
        allelementVerifiers.add("background-attachment");
        allelementVerifiers.add("background-clip");
        allelementVerifiers.add("background-color");
        allelementVerifiers.add("background-image");
        allelementVerifiers.add("background-origin");
        allelementVerifiers.add("background-position");
        allelementVerifiers.add("background-repeat");
        allelementVerifiers.add("background-size");
        allelementVerifiers.add("background");
        allelementVerifiers.add("border-collapse");
        allelementVerifiers.add("border-color");
        allelementVerifiers.add("border-top-color");
        allelementVerifiers.add("border-bottom-color");
        allelementVerifiers.add("border-right-color");
        allelementVerifiers.add("border-left-color");
        allelementVerifiers.add("border-spacing");
        allelementVerifiers.add("border-style");
        allelementVerifiers.add("border-top-style");
        allelementVerifiers.add("border-bottom-style");
        allelementVerifiers.add("border-left-style");
        allelementVerifiers.add("border-right-style");
        allelementVerifiers.add("border-left");
        allelementVerifiers.add("border-top");
        allelementVerifiers.add("border-right");
        allelementVerifiers.add("border-bottom");
        allelementVerifiers.add("border-top-color");
        allelementVerifiers.add("border-right-color");
        allelementVerifiers.add("border-bottom-color");
        allelementVerifiers.add("border-left-color");
        allelementVerifiers.add("border-top-style");
        allelementVerifiers.add("border-right-style");
        allelementVerifiers.add("border-bottom-style");
        allelementVerifiers.add("border-top-width");
        allelementVerifiers.add("border-right-width");
        allelementVerifiers.add("border-bottom-width");
        allelementVerifiers.add("border-left-width");
        allelementVerifiers.add("border-width");
        allelementVerifiers.add("border-top-width");
        allelementVerifiers.add("border-bottom-width");
        allelementVerifiers.add("border-left-width");
        allelementVerifiers.add("border-right-width");
        allelementVerifiers.add("border-radius");
        allelementVerifiers.add("border-top-radius");
        allelementVerifiers.add("border-bottom-radius");
        allelementVerifiers.add("border-left-radius");
        allelementVerifiers.add("border-right-radius");
        allelementVerifiers.add("border-image-source");
        allelementVerifiers.add("border-image-slice");
        allelementVerifiers.add("border-image-width");
        allelementVerifiers.add("border-image-outset");
        allelementVerifiers.add("border-image-repeat");
        allelementVerifiers.add("border-image");
        allelementVerifiers.add("border");
        allelementVerifiers.add("bottom");
        allelementVerifiers.add("box-decoration-break");
        allelementVerifiers.add("box-shadow");
        allelementVerifiers.add("caption-side");
        allelementVerifiers.add("clear");
        allelementVerifiers.add("clip");
        allelementVerifiers.add("break-before");
        allelementVerifiers.add("break-after");
        allelementVerifiers.add("break-inside");
        allelementVerifiers.add("column-count");
        allelementVerifiers.add("column-fill");
        allelementVerifiers.add("column-gap");
        allelementVerifiers.add("column-rule-color");
        allelementVerifiers.add("column-rule-style");
        allelementVerifiers.add("column-rule-width");
        allelementVerifiers.add("column-span");
        allelementVerifiers.add("column-rule");
        allelementVerifiers.add("column-width");
        allelementVerifiers.add("columns");
        allelementVerifiers.add("color");
        allelementVerifiers.add("color-interpolation");
        allelementVerifiers.add("color-rendering");
        allelementVerifiers.add("content");
        allelementVerifiers.add("counter-increment");
        allelementVerifiers.add("counter-reset");
        allelementVerifiers.add("cue-after");
        allelementVerifiers.add("cue-before");
        allelementVerifiers.add("cue");
        allelementVerifiers.add("cursor");
        allelementVerifiers.add("direction");
        allelementVerifiers.add("display");
        allelementVerifiers.add("elevation");
        allelementVerifiers.add("empty-cells");
        allelementVerifiers.add("float");
        allelementVerifiers.add("font-family");
        allelementVerifiers.add("font-size");
        allelementVerifiers.add("font-style");
        allelementVerifiers.add("font-variant");
        allelementVerifiers.add("font-weight");
        allelementVerifiers.add("font");
        allelementVerifiers.add("hanging-punctuation");
        allelementVerifiers.add("height");
        allelementVerifiers.add("left");
        allelementVerifiers.add("letter-spacing");
        allelementVerifiers.add("line-break");
        allelementVerifiers.add("line-height");
        allelementVerifiers.add("list-style-image");
        allelementVerifiers.add("list-style-position");
        allelementVerifiers.add("list-style-type");
        allelementVerifiers.add("list-style");
        allelementVerifiers.add("margin-right");
        allelementVerifiers.add("margin-left");
        allelementVerifiers.add("margin-top");
        allelementVerifiers.add("margin-bottom");
        allelementVerifiers.add("margin");
        allelementVerifiers.add("max-height");
        allelementVerifiers.add("max-width");
        allelementVerifiers.add("min-height");
        allelementVerifiers.add("min-width");
        allelementVerifiers.add("opacity");
        allelementVerifiers.add("orphans");
        allelementVerifiers.add("outline-color");
        allelementVerifiers.add("outline-style");
        allelementVerifiers.add("outline-width");
        allelementVerifiers.add("outline");
        allelementVerifiers.add("overflow");
        allelementVerifiers.add("padding-top");
        allelementVerifiers.add("padding-right");
        allelementVerifiers.add("padding-bottom");
        allelementVerifiers.add("padding-left");
        allelementVerifiers.add("padding");
        allelementVerifiers.add("page-break-after");
        allelementVerifiers.add("page-break-before");
        allelementVerifiers.add("page-break-inside");
        allelementVerifiers.add("pause-after");
        allelementVerifiers.add("pause-before");
        allelementVerifiers.add("pause");
        allelementVerifiers.add("pitch-range");
        allelementVerifiers.add("pitch");
        allelementVerifiers.add("play-during");
        allelementVerifiers.add("punctuation-trim");
        allelementVerifiers.add("position");
        allelementVerifiers.add("quotes");
        allelementVerifiers.add("richness");
        allelementVerifiers.add("right");
        allelementVerifiers.add("speak-header");
        allelementVerifiers.add("speak-numeral");
        allelementVerifiers.add("speak-punctuation");
        allelementVerifiers.add("speak");
        allelementVerifiers.add("speech-rate");
        allelementVerifiers.add("stress");
        allelementVerifiers.add("table-layout");
        allelementVerifiers.add("text-align");
        allelementVerifiers.add("text-align-last");
        allelementVerifiers.add("text-autospace");
        allelementVerifiers.add("text-decoration");
        allelementVerifiers.add("text-decoration-color");
        allelementVerifiers.add("text-decoration-line");
        allelementVerifiers.add("text-decoration-skip");
        allelementVerifiers.add("text-decoration-style");
        allelementVerifiers.add("text-emphasis");
        allelementVerifiers.add("text-emphasis-color");
        allelementVerifiers.add("text-emphasis-position");
        allelementVerifiers.add("text-emphasis-style");
        allelementVerifiers.add("text-indent");
        allelementVerifiers.add("text-justify");
        allelementVerifiers.add("text-outline");
        allelementVerifiers.add("text-overflow");
        allelementVerifiers.add("text-shadow");
        allelementVerifiers.add("text-transform");
        allelementVerifiers.add("text-underline-position");
        allelementVerifiers.add("text-wrap");
        allelementVerifiers.add("top");
        allelementVerifiers.add("transform");
        allelementVerifiers.add("transform-origin");
        allelementVerifiers.add("unicode-bidi");
        allelementVerifiers.add("vertical-align");
        allelementVerifiers.add("visibility");
        allelementVerifiers.add("voice-family");
        allelementVerifiers.add("volume");
        allelementVerifiers.add("white-space");
        allelementVerifiers.add("white-space-collapsing");
        allelementVerifiers.add("widows");
        allelementVerifiers.add("width");
        allelementVerifiers.add("word-break");
        allelementVerifiers.add("word-spacing");
        allelementVerifiers.add("word-wrap");
        allelementVerifiers.add("z-index");
        auxilaryVerifiers = new CSSPropertyVerifier[117];
        CSSTokenizerFilter.auxilaryVerifiers[2] = new CSSPropertyVerifier(new String[]{"left", "center", "right"}, new String[]{"pe", "le"}, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[3] = new CSSPropertyVerifier(new String[]{"top", "center", "bottom"}, new String[]{"pe", "le"}, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[4] = new CSSPropertyVerifier(new String[]{"left", "center", "right"}, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[5] = new CSSPropertyVerifier(new String[]{"top", "center", "bottom"}, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[11] = new CSSPropertyVerifier(new String[]{"transparent"}, new String[]{"co"}, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[13] = new CSSPropertyVerifier(new String[]{"none", "hidden", "dotted", "dashed", "solid", "double", "groove", "ridge", "inset", "outset", "inherit"}, new String[]{"le"}, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[14] = new CSSPropertyVerifier(new String[]{"thin", "medium", "thick"}, new String[]{"le"}, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[15] = new CSSPropertyVerifier(new String[]{"transparent", "inherit"}, new String[]{"co"}, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[61] = new CSSPropertyVerifier(new String[]{"border-box", "padding-box", "content-box"}, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[64] = new CSSPropertyVerifier(null, new String[]{"le", "pe"}, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[71] = new CSSPropertyVerifier(new String[]{"inset"}, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[72] = new CSSPropertyVerifier(null, new String[]{"le"}, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[73] = new CSSPropertyVerifier(null, new String[]{"co"}, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[74] = new CSSPropertyVerifier(null, null, new String[]{"72<1,4>"}, true);
        CSSTokenizerFilter.auxilaryVerifiers[75] = new CSSPropertyVerifier(null, null, new String[]{"71a74a73"}, true);
        CSSTokenizerFilter.auxilaryVerifiers[76] = new CSSPropertyVerifier(new String[]{"none"}, new String[]{"ur"}, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[68] = new CSSPropertyVerifier(new String[]{"auto"}, new String[]{"le", "pe", "in"}, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[77] = new CSSPropertyVerifier(null, null, new String[]{"68<1,4>"}, true);
        CSSTokenizerFilter.auxilaryVerifiers[70] = new CSSPropertyVerifier(new String[]{"stretch", "repeat", "round"}, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[78] = new CSSPropertyVerifier(null, null, new String[]{"70<1,2>"}, true);
        CSSTokenizerFilter.auxilaryVerifiers[79] = new CSSPropertyVerifier(null, null, new String[]{"74a73"}, true);
        CSSTokenizerFilter.auxilaryVerifiers[85] = new CSSPropertyVerifier(new String[]{"normal"}, new String[]{"le", "pe"}, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[100] = new CSSPropertyVerifier(new String[]{"underline"}, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[101] = new CSSPropertyVerifier(new String[]{"overline"}, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[102] = new CSSPropertyVerifier(new String[]{"line-through"}, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[115] = new CSSPropertyVerifier(new String[]{"none"}, null, null, new String[]{"100a101a102"});
        CSSTokenizerFilter.auxilaryVerifiers[116] = new CSSPropertyVerifier(new String[]{"blink"}, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[103] = new CSSPropertyVerifier(null, new String[]{"co"}, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[104] = new CSSPropertyVerifier(new String[]{"solid", "double", "dotted", "dashed", "wave"}, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[105] = new CSSPropertyVerifier(new String[]{"filled", "open"}, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[106] = new CSSPropertyVerifier(new String[]{"dot", "circle", "double-circle", "triangle", "sesame"}, null, null, true);
        CSSTokenizerFilter.auxilaryVerifiers[107] = new CSSPropertyVerifier(new String[]{"none"}, ElementInfo.VISUALMEDIA, new String[]{"st"}, new String[]{"105a106"});
    }

    static class VoiceFamilyPropertyVerifier
    extends FamilyPropertyVerifier {
        VoiceFamilyPropertyVerifier(boolean valueOnly) {
            super(valueOnly, ElementInfo.AURALMEDIA);
        }

        @Override
        boolean isSpecificFamily(String s) {
            return ElementInfo.isSpecificVoiceFamily(s);
        }

        @Override
        boolean isGenericFamily(String s) {
            return ElementInfo.isGenericVoiceFamily(s);
        }
    }

    static class FontPropertyVerifier
    extends FamilyPropertyVerifier {
        FontPropertyVerifier(boolean valueOnly) {
            super(valueOnly, ElementInfo.VISUALMEDIA);
        }

        @Override
        boolean isSpecificFamily(String s) {
            return ElementInfo.isSpecificFontFamily(s);
        }

        @Override
        boolean isGenericFamily(String s) {
            return ElementInfo.isGenericFontFamily(s);
        }
    }

    static abstract class FamilyPropertyVerifier
    extends CSSPropertyVerifier {
        FamilyPropertyVerifier(boolean valueOnly, String[] mediaTypes) {
            super(null, mediaTypes, null, null, valueOnly, true);
        }

        @Override
        public boolean checkValidity(String[] media, String[] elements, ParsedWord[] value, FilterCallback cb) {
            if (logDEBUG) {
                Logger.debug(this, "font verifier: " + FamilyPropertyVerifier.toString(value));
            }
            if (value.length == 1 && value[0] instanceof ParsedIdentifier && "inherit".equalsIgnoreCase(((ParsedIdentifier)value[0]).original)) {
                if (logDEBUG) {
                    Logger.debug(this, "font: inherit");
                }
                return true;
            }
            if (this.allowedMedia != null && !this.onlyValueVerifier) {
                boolean allowed = false;
                for (String m : media) {
                    if (!this.allowedMedia.contains(m)) continue;
                    allowed = true;
                    break;
                }
                if (!allowed) {
                    if (logDEBUG) {
                        Logger.debug(this, "checkValidity Media of the element is not allowed.Media=" + Fields.commaList(media) + " allowed Media=" + this.allowedMedia.toString());
                    }
                    return false;
                }
            }
            ArrayList<String> fontWords = new ArrayList<String>();
            block1: for (int i = 0; i < value.length; ++i) {
                ParsedWord word = value[i];
                String s = null;
                if (word instanceof ParsedString) {
                    String decoded = ((ParsedString)word).getDecoded();
                    if (logDEBUG) {
                        Logger.debug(this, "decoded: \"" + decoded + "\"");
                    }
                    if (this.isSpecificFamily(decoded.toLowerCase()) || this.isGenericFamily(decoded.toLowerCase())) continue;
                    s = decoded;
                } else if (word instanceof ParsedIdentifier) {
                    s = ((ParsedIdentifier)word).getDecoded();
                    if (this.isGenericFamily(s) || this.isSpecificFamily(s)) continue;
                    if (word.postComma) {
                        if (logDEBUG) {
                            Logger.debug(this, "Word ends in comma, but is not a valid font on its own: " + word + " (index " + i + ")");
                        }
                        return false;
                    }
                } else {
                    return false;
                }
                fontWords.clear();
                assert (s != null);
                fontWords.add(s);
                if (logDEBUG) {
                    Logger.debug(this, "first word: \"" + s + "\"");
                }
                if (i == value.length - 1) {
                    if (logDEBUG) {
                        Logger.debug(this, "last word. font words: " + FamilyPropertyVerifier.getStringFromArray(fontWords.toArray(new String[fontWords.size()])) + " valid=" + this.validFontWords(fontWords));
                    }
                    return this.validFontWords(fontWords);
                }
                if (!this.possiblyValidFontWords(fontWords)) {
                    return false;
                }
                boolean last = false;
                for (int j = i + 1; j < value.length; ++j) {
                    ParsedWord newWord = value[j];
                    if (j == value.length - 1) {
                        last = true;
                    }
                    if (newWord instanceof ParsedIdentifier) {
                        String s1 = ((ParsedIdentifier)newWord).original;
                        fontWords.add(s1);
                        if (logDEBUG) {
                            Logger.debug(this, "adding word: \"" + s1 + "\"");
                        }
                        if (last) {
                            if (newWord.postComma && logDEBUG) {
                                Logger.debug(this, "not valid: trailing comma at end");
                            }
                            if (this.validFontWords(fontWords)) {
                                if (logDEBUG) {
                                    Logger.debug(this, "font: reached last in inner loop, valid. font words: " + FamilyPropertyVerifier.getStringFromArray(fontWords.toArray(new String[fontWords.size()])));
                                }
                                return true;
                            }
                        }
                        if (!newWord.postComma) continue;
                        if (this.validFontWords(fontWords)) {
                            fontWords.clear();
                            i = j;
                            continue block1;
                        }
                        if (logDEBUG) {
                            Logger.debug(this, "comma but can't parse font words: " + Fields.commaList(fontWords.toArray(new String[fontWords.size()])));
                        }
                        return false;
                    }
                    if (logDEBUG) {
                        Logger.debug(this, "cannot parse " + newWord);
                    }
                    return false;
                }
                return this.validFontWords(fontWords);
            }
            if (logDEBUG) {
                Logger.debug(this, "font: reached end, valid");
            }
            return true;
        }

        private boolean possiblyValidFontWords(ArrayList<String> fontWords) {
            if (ElementInfo.disallowUnknownSpecificFonts) {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (String s : fontWords) {
                    if (!first) {
                        sb.append(' ');
                    }
                    first = false;
                    sb.append(s);
                }
                String s = sb.toString().toLowerCase();
                return ElementInfo.isWordPrefixOrMatchOfSpecificFontFamily(s);
            }
            for (String s : fontWords) {
                if (this.isSpecificFamily(s)) continue;
                return false;
            }
            return true;
        }

        private boolean validFontWords(ArrayList<String> fontWords) {
            for (String s : fontWords) {
                if (s != null) continue;
                throw new NullPointerException();
            }
            if (fontWords.size() == 1 && this.isGenericFamily(fontWords.get(0).toLowerCase())) {
                return true;
            }
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String s : fontWords) {
                if (!first) {
                    sb.append(' ');
                }
                first = false;
                sb.append(s);
            }
            return this.isSpecificFamily(sb.toString().toLowerCase());
        }

        abstract boolean isSpecificFamily(String var1);

        abstract boolean isGenericFamily(String var1);
    }

    static class FontPartPropertyVerifier
    extends CSSPropertyVerifier {
        FontPartPropertyVerifier() {
            super(false);
        }

        @Override
        public boolean checkValidity(String[] media, String[] elements, ParsedWord[] value, FilterCallback cb) {
            CSSPropertyVerifier fontSize;
            if (logDEBUG) {
                Logger.debug(this, "FontPartPropertyVerifier called with " + FontPartPropertyVerifier.toString(value));
            }
            if ((fontSize = new CSSPropertyVerifier(new String[]{"xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large", "larger", "smaller", "inherit"}, new String[]{"le", "pe"}, null, true)).checkValidity(value, cb)) {
                return true;
            }
            for (ParsedWord word : value) {
                String orig;
                if (fontSize.checkValidity(word, cb)) continue;
                if (word instanceof SimpleParsedWord && (orig = ((SimpleParsedWord)word).original).indexOf("/") != -1) {
                    int slashIndex = orig.indexOf("/");
                    String firstPart = orig.substring(0, slashIndex);
                    String secondPart = orig.substring(slashIndex + 1, orig.length());
                    if (logDEBUG) {
                        Logger.debug(this, "FontPartPropertyVerifier FirstPart=" + firstPart + " secondPart=" + secondPart);
                    }
                    CSSPropertyVerifier lineHeight = new CSSPropertyVerifier(new String[]{"normal", "inherit"}, new String[]{"le", "pe", "re", "in"}, null, true);
                    ParsedWord[] first = CSSTokenizerFilter.split(firstPart, false);
                    ParsedWord[] second = CSSTokenizerFilter.split(secondPart, false);
                    if (first.length == 1 && second.length == 1 && fontSize.checkValidity(first, cb) && lineHeight.checkValidity(second, cb)) continue;
                }
                return false;
            }
            return true;
        }
    }

    static class contentPropertyVerifier
    extends CSSPropertyVerifier {
        contentPropertyVerifier(String[] allowedValues) {
            super(allowedValues, null, null, null);
        }

        @Override
        public boolean checkValidity(String[] media, String[] elements, ParsedWord[] value, FilterCallback cb) {
            if (logDEBUG) {
                Logger.debug(this, "contentPropertyVerifier checkValidity called: " + contentPropertyVerifier.toString(value));
            }
            if (value.length != 1) {
                return false;
            }
            if (value[0] instanceof ParsedIdentifier && this.allowedValues != null && this.allowedValues.contains(((ParsedIdentifier)value[0]).getDecoded())) {
                return true;
            }
            if (value[0] instanceof ParsedString) {
                return true;
            }
            if (value[0] instanceof ParsedCounter) {
                ParsedCounter counter = (ParsedCounter)value[0];
                if (counter.listType != null) {
                    HashSet<String> listStyleType = new HashSet<String>();
                    listStyleType.add("disc");
                    listStyleType.add("circle");
                    listStyleType.add("square");
                    listStyleType.add("decimal");
                    listStyleType.add("decimal-leading-zero");
                    listStyleType.add("lower-roman");
                    listStyleType.add("upper-roman");
                    listStyleType.add("lower-greek");
                    listStyleType.add("lower-latin");
                    listStyleType.add("upper-latin");
                    listStyleType.add("armenian");
                    listStyleType.add("georgian");
                    listStyleType.add("lower-alpha");
                    listStyleType.add("upper-alpha");
                    listStyleType.add("none");
                    if (!listStyleType.contains(counter.listType.getDecoded())) {
                        return false;
                    }
                }
                if (counter.separatorString != null) {
                    // empty if block
                }
                return true;
            }
            if (value[0] instanceof ParsedAttr) {
                return true;
            }
            if (value[0] instanceof ParsedURL) {
                return contentPropertyVerifier.isValidURI((ParsedURL)value[0], cb);
            }
            return false;
        }
    }

    static class CSSPropertyVerifier {
        public final boolean allowCommaDelimiters;
        public HashSet<String> allowedValues = null;
        public HashSet<String> allowedMedia = null;
        public boolean isInteger = false;
        public boolean isReal = false;
        public boolean isPercentage = false;
        public boolean isLength = false;
        public boolean isAngle = false;
        public boolean isColor = false;
        public boolean isURI = false;
        public boolean isShape = false;
        public boolean isString = false;
        public boolean isCounter = false;
        public boolean isIdentifier = false;
        public boolean isTime = false;
        public boolean isFrequency = false;
        public boolean isTransform = false;
        public boolean onlyValueVerifier = false;
        public String[] cssPropertyList = null;
        public String[] parserExpressions = null;

        CSSPropertyVerifier(boolean allowCommaDelimiters) {
            this.allowCommaDelimiters = allowCommaDelimiters;
        }

        CSSPropertyVerifier(String[] allowedValues, String[] allowedMedia) {
            this(allowedValues, allowedMedia, null, null);
        }

        CSSPropertyVerifier(String[] allowedValues, String[] possibleValues, String[] expression, boolean onlyValueVerifier) {
            this(allowedValues, null, possibleValues, expression);
            this.onlyValueVerifier = onlyValueVerifier;
        }

        CSSPropertyVerifier(String[] allowedValues, String[] possibleValues, String[] expression, String[] media, boolean onlyValueVerifier) {
            this(allowedValues, media, possibleValues, expression);
            this.onlyValueVerifier = onlyValueVerifier;
        }

        CSSPropertyVerifier(String[] allowedValues, String[] allowedMedia, String[] possibleValues, String[] parseExpression) {
            this(allowedValues, allowedMedia, possibleValues, parseExpression, false, false);
        }

        CSSPropertyVerifier(String[] allowedValues, String[] allowedMedia, String[] possibleValues, String[] parseExpression, boolean onlyValueVerifier, boolean allowCommaDelimiters) {
            this.onlyValueVerifier = onlyValueVerifier;
            this.allowCommaDelimiters = allowCommaDelimiters;
            if (possibleValues != null) {
                for (String possibleValue : possibleValues) {
                    if ("in".equals(possibleValue)) {
                        this.isInteger = true;
                        continue;
                    }
                    if ("re".equals(possibleValue)) {
                        this.isReal = true;
                        continue;
                    }
                    if ("pe".equals(possibleValue)) {
                        this.isPercentage = true;
                        continue;
                    }
                    if ("le".equals(possibleValue)) {
                        this.isLength = true;
                        continue;
                    }
                    if ("an".equals(possibleValue)) {
                        this.isAngle = true;
                        continue;
                    }
                    if ("co".equals(possibleValue)) {
                        this.isColor = true;
                        continue;
                    }
                    if ("ur".equals(possibleValue)) {
                        this.isURI = true;
                        continue;
                    }
                    if ("sh".equals(possibleValue)) {
                        this.isShape = true;
                        continue;
                    }
                    if ("st".equals(possibleValue)) {
                        this.isString = true;
                        continue;
                    }
                    if ("co".equals(possibleValue)) {
                        this.isCounter = true;
                        continue;
                    }
                    if ("id".equals(possibleValue)) {
                        this.isIdentifier = true;
                        continue;
                    }
                    if ("ti".equals(possibleValue)) {
                        this.isTime = true;
                        continue;
                    }
                    if ("fr".equals(possibleValue)) {
                        this.isFrequency = true;
                        continue;
                    }
                    if (!"tr".equals(possibleValue)) continue;
                    this.isTransform = true;
                }
            }
            if (allowedValues != null) {
                this.allowedValues = new HashSet();
                this.allowedValues.addAll(Arrays.asList(allowedValues));
            }
            if (allowedMedia != null) {
                this.allowedMedia = new HashSet();
                this.allowedMedia.addAll(Arrays.asList(allowedMedia));
            }
            this.parserExpressions = parseExpression != null ? (String[])parseExpression.clone() : null;
        }

        CSSPropertyVerifier(String[] allowedValues, String[] allowedMedia, String[] possibleValues) {
            this(allowedValues, allowedMedia, possibleValues, null);
        }

        public static boolean isIntegerChecker(String value) {
            try {
                Integer.parseInt(value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public static boolean isRealChecker(String value) {
            try {
                Float.parseFloat(value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public static boolean isValidURI(ParsedURL word, FilterCallback cb) {
            String w = CSSTokenizerFilter.removeOuterQuotes(word.getDecoded());
            try {
                String s = cb.processURI(w, null);
                if (s == null || s.equals("")) {
                    return false;
                }
                if (s.equals(w)) {
                    return true;
                }
                if (logDEBUG) {
                    Logger.debug(CSSTokenizerFilter.class, "New url: \"" + s + "\" from \"" + w + "\"");
                }
                word.setNewURL(s);
                return true;
            }
            catch (CommentException e) {
                return false;
            }
        }

        public boolean checkValidity(ParsedWord[] words, FilterCallback cb) {
            return this.checkValidity(null, null, words, cb);
        }

        public boolean checkValidity(ParsedWord word, FilterCallback cb) {
            return this.checkValidity(null, null, new ParsedWord[]{word}, cb);
        }

        public boolean checkValidity(String[] media, String[] elements, ParsedWord[] words, FilterCallback cb) {
            if (logDEBUG) {
                Logger.debug(this, "checkValidity for " + CSSPropertyVerifier.toString(words) + " for " + this);
            }
            if (!this.onlyValueVerifier && this.allowedMedia != null) {
                boolean allowed = false;
                for (String m : media) {
                    if (!this.allowedMedia.contains(m)) continue;
                    allowed = true;
                    break;
                }
                if (!allowed) {
                    if (logDEBUG) {
                        Logger.debug(this, "checkValidity Media of the element is not allowed.Media=" + Fields.commaList(media) + " allowed Media=" + this.allowedMedia.toString());
                    }
                    return false;
                }
            }
            if (words.length == 1) {
                if (words[0] instanceof ParsedIdentifier && this.allowedValues != null && this.allowedValues.contains(((ParsedIdentifier)words[0]).original.toLowerCase())) {
                    return true;
                }
                if (words[0] instanceof SimpleParsedWord) {
                    String word = ((SimpleParsedWord)words[0]).original;
                    if (this.allowedValues != null && this.allowedValues.contains(word)) {
                        return true;
                    }
                    if (this.isInteger && CSSPropertyVerifier.isIntegerChecker(word)) {
                        return true;
                    }
                    if (this.isReal && CSSPropertyVerifier.isRealChecker(word)) {
                        return true;
                    }
                    if (this.isPercentage && FilterUtils.isPercentage(word)) {
                        return true;
                    }
                    if (this.isLength && FilterUtils.isLength(word, false)) {
                        return true;
                    }
                    if (this.isAngle && FilterUtils.isAngle(word)) {
                        return true;
                    }
                    if (this.isColor && FilterUtils.isColor(word)) {
                        return true;
                    }
                    if (this.isShape && FilterUtils.isValidCSSShape(word)) {
                        return true;
                    }
                    if (this.isFrequency && FilterUtils.isFrequency(word)) {
                        return true;
                    }
                    if (this.isTime && FilterUtils.isTime(word)) {
                        return true;
                    }
                    if (this.isTransform && FilterUtils.isCSSTransform(word)) {
                        return true;
                    }
                }
                if (words[0] instanceof ParsedIdentifier && this.isColor && FilterUtils.isColor(((ParsedIdentifier)words[0]).original)) {
                    return true;
                }
                if (this.isURI && words[0] instanceof ParsedURL) {
                    return CSSPropertyVerifier.isValidURI((ParsedURL)words[0], cb);
                }
                if (this.isIdentifier && words[0] instanceof ParsedIdentifier) {
                    return true;
                }
                if (this.isString && words[0] instanceof ParsedString) {
                    return true;
                }
            }
            if (this.parserExpressions != null) {
                for (String parserExpression : this.parserExpressions) {
                    boolean result = this.recursiveParserExpressionVerifier(parserExpression, words, cb);
                    if (!result) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean recursiveParserExpressionVerifier(String expression, ParsedWord[] words, FilterCallback cb) {
            if (logDEBUG) {
                Logger.debug(this, "1recursiveParserExpressionVerifier called: with " + expression + " " + CSSPropertyVerifier.toString(words));
            }
            if (expression == null || "".equals(expression.trim())) {
                return words == null || words.length == 0;
            }
            int tokensCanBeGivenLowerLimit = 1;
            int tokensCanBeGivenUpperLimit = 1;
            for (int i = 0; i < expression.length(); ++i) {
                if (expression.charAt(i) == 'a') {
                    int noOfa = 0;
                    int endIndex = expression.length();
                    for (int j = 0; j < expression.length(); ++j) {
                        if (expression.charAt(j) == '?' || expression.charAt(j) == '<' || expression.charAt(j) == '>' || expression.charAt(j) == ' ') {
                            endIndex = j;
                            break;
                        }
                        if (expression.charAt(j) != 'a') continue;
                        ++noOfa;
                    }
                    String firstPart = expression.substring(0, endIndex);
                    String secondPart = "";
                    if (endIndex != expression.length()) {
                        secondPart = expression.substring(endIndex + 1, expression.length());
                    }
                    int j = 1;
                    if (secondPart.equals("")) {
                        j = words.length;
                    }
                    while (j <= words.length) {
                        if (logDEBUG) {
                            Logger.debug(this, "2Making recursiveDoubleBarVerifier to consume " + j + " words");
                        }
                        ParsedWord[] partToPassToDB = Arrays.copyOf(words, j);
                        if (logDEBUG) {
                            Logger.debug(this, "3Calling recursiveDoubleBarVerifier with " + firstPart + " " + CSSPropertyVerifier.toString(partToPassToDB));
                        }
                        if (this.recursiveDoubleBarVerifier(firstPart, partToPassToDB, cb)) {
                            ParsedWord[] partToPass = Arrays.copyOfRange(words, j, words.length);
                            if (logDEBUG) {
                                Logger.debug(this, "4recursiveDoubleBarVerifier true calling itself with " + secondPart + CSSPropertyVerifier.toString(partToPass));
                            }
                            if (this.recursiveParserExpressionVerifier(secondPart, partToPass, cb)) {
                                return true;
                            }
                        }
                        if (logDEBUG) {
                            Logger.debug(this, "5Back to recursiveDoubleBarVerifier " + j + " " + (noOfa + 1) + " " + words.length);
                        }
                        ++j;
                    }
                    return false;
                }
                if (expression.charAt(i) == ' ') {
                    String firstPart = expression.substring(0, i);
                    String secondPart = expression.substring(i + 1, expression.length());
                    if (words != null && words.length > 0) {
                        int index = Integer.parseInt(firstPart);
                        boolean result = auxilaryVerifiers[index].checkValidity(words[0], cb);
                        if (result) {
                            ParsedWord[] partToPass = Arrays.copyOfRange(words, 1, words.length);
                            if (logDEBUG) {
                                Logger.debug(this, "8First part is true. partToPass=" + CSSPropertyVerifier.toString(partToPass));
                            }
                            if (this.recursiveParserExpressionVerifier(secondPart, partToPass, cb)) {
                                return true;
                            }
                        }
                    }
                    return false;
                }
                if (expression.charAt(i) == '?') {
                    ParsedWord[] partToPass;
                    boolean result;
                    String firstPart = expression.substring(0, i);
                    String secondPart = expression.substring(i + 1, expression.length());
                    int index = Integer.parseInt(firstPart);
                    return words.length > 0 ? (result = auxilaryVerifiers[index].checkValidity(words[0], cb)) && this.recursiveParserExpressionVerifier(secondPart, partToPass = Arrays.copyOfRange(words, 1, words.length), cb) : this.recursiveParserExpressionVerifier(secondPart, words, cb);
                }
                if (expression.charAt(i) != '<') continue;
                int tindex = expression.indexOf(62);
                if (tindex > i) {
                    int upperLimit;
                    int lowerLimit;
                    int indexOfSecondBracket;
                    int firstIndex = tindex + 1;
                    if (tindex != expression.length() - 1 && expression.charAt(tindex + 1) == '[' && (indexOfSecondBracket = expression.indexOf(93)) > tindex + 1) {
                        tokensCanBeGivenLowerLimit = Integer.parseInt(expression.substring(tindex + 2, indexOfSecondBracket).split(",")[0]);
                        tokensCanBeGivenUpperLimit = Integer.parseInt(expression.substring(tindex + 2, indexOfSecondBracket).split(",")[1]);
                        firstIndex = expression.indexOf(93) + 1;
                    }
                    String firstPart = expression.substring(0, i);
                    String secondPart = expression.substring(firstIndex, expression.length());
                    if (secondPart.length() > 0 && secondPart.charAt(0) == ' ') {
                        secondPart = secondPart.substring(1);
                    } else if (secondPart.length() > 0) {
                        throw new IllegalStateException("Don't know what to do with char after <>[]: " + secondPart.charAt(0));
                    }
                    if (logDEBUG) {
                        Logger.debug(this, "9in < firstPart=" + firstPart + " secondPart=" + secondPart + " tokensCanBeGivenLowerLimit=" + tokensCanBeGivenLowerLimit + " tokensCanBeGivenUpperLimit=" + tokensCanBeGivenUpperLimit);
                    }
                    int index = Integer.parseInt(firstPart);
                    String[] strLimits = expression.substring(i + 1, tindex).split(",");
                    if (strLimits.length == 2 && this.recursiveVariableOccuranceVerifier(index, words, lowerLimit = Integer.parseInt(strLimits[0]), upperLimit = Integer.parseInt(strLimits[1]), tokensCanBeGivenLowerLimit, tokensCanBeGivenUpperLimit, secondPart, cb)) {
                        return true;
                    }
                }
                return false;
            }
            if (logDEBUG) {
                Logger.debug(this, "10Single token:" + expression);
            }
            int index = Integer.parseInt(expression);
            return auxilaryVerifiers[index].checkValidity(words, cb);
        }

        public static String getStringFromArray(String[] parts, int lowerIndex, int upperIndex) {
            StringBuilder buffer = new StringBuilder();
            if (parts != null && lowerIndex < parts.length) {
                for (int i = lowerIndex; i < upperIndex && i < parts.length; ++i) {
                    buffer.append(parts[i]);
                    buffer.append(' ');
                }
                return buffer.toString();
            }
            return "";
        }

        public static String getStringFromArray(String[] parts) {
            return CSSPropertyVerifier.getStringFromArray(parts, 0, parts.length - 1);
        }

        public static ParsedWord[] getSubArray(ParsedWord[] array, int lowerIndex, int upperIndex) {
            ParsedWord[] arrayToReturn = new ParsedWord[upperIndex - lowerIndex];
            if (array != null && lowerIndex < array.length) {
                for (int i = lowerIndex; i < upperIndex && i < array.length; ++i) {
                    arrayToReturn[i - lowerIndex] = array[i];
                }
                return arrayToReturn;
            }
            return new ParsedWord[0];
        }

        public boolean recursiveVariableOccuranceVerifier(int verifierIndex, ParsedWord[] valueParts, int lowerLimit, int upperLimit, int tokensCanBeGivenLowerLimit, int tokensCanBeGivenUpperLimit, String secondPart, FilterCallback cb) {
            if (logDEBUG) {
                Logger.debug(this, "recursiveVariableOccurranceVerifier(" + verifierIndex + "," + CSSPropertyVerifier.toString(valueParts) + "," + lowerLimit + "," + upperLimit + "," + tokensCanBeGivenLowerLimit + "," + tokensCanBeGivenUpperLimit + "," + secondPart + ")");
            }
            if ((valueParts == null || valueParts.length == 0) && lowerLimit == 0) {
                return true;
            }
            if (lowerLimit <= 0 && this.recursiveParserExpressionVerifier(secondPart, valueParts, cb)) {
                if (logDEBUG) {
                    Logger.debug(this, "recursiveVariableOccurranceVerifier completed by " + secondPart);
                }
                return true;
            }
            if (upperLimit == 0) {
                if (logDEBUG) {
                    Logger.debug(this, "recursiveVariableOccurranceVerifier: no more parts");
                }
                return false;
            }
            for (int i = tokensCanBeGivenLowerLimit; i <= tokensCanBeGivenUpperLimit && i <= valueParts.length; ++i) {
                ParsedWord[] before = Arrays.copyOf(valueParts, i);
                if (!auxilaryVerifiers[verifierIndex].checkValidity(before, cb)) continue;
                if (logDEBUG) {
                    Logger.debug(this, "first " + i + " tokens using " + verifierIndex + " match " + CSSPropertyVerifier.toString(before));
                }
                if (i == valueParts.length && lowerLimit <= 1) {
                    if (this.recursiveParserExpressionVerifier(secondPart, new ParsedWord[0], cb)) {
                        if (logDEBUG) {
                            Logger.debug(this, "recursiveVariableOccurranceVerifier completed with no more parts by " + secondPart);
                        }
                        return true;
                    }
                    if (logDEBUG) {
                        Logger.debug(this, "recursiveVariableOccurranceVerifier: satisfied self but nothing left to match " + secondPart);
                    }
                    return false;
                }
                if (i == valueParts.length && lowerLimit > 1) {
                    return false;
                }
                ParsedWord[] after = Arrays.copyOfRange(valueParts, i, valueParts.length);
                if (logDEBUG) {
                    Logger.debug(this, "rest of tokens: " + CSSPropertyVerifier.toString(after));
                }
                if (!this.recursiveVariableOccuranceVerifier(verifierIndex, after, lowerLimit - 1, upperLimit - 1, tokensCanBeGivenLowerLimit, tokensCanBeGivenUpperLimit, secondPart, cb)) continue;
                return true;
            }
            return false;
        }

        static String toString(ParsedWord[] words) {
            if (words == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (ParsedWord word : words) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append(word);
            }
            return sb.toString();
        }

        public boolean recursiveDoubleBarVerifier(String expression, ParsedWord[] words, FilterCallback cb) {
            if (logDEBUG) {
                Logger.debug(this, "11in recursiveDoubleBarVerifier expression=" + expression + " value=" + CSSPropertyVerifier.toString(words));
            }
            if (words == null || words.length == 0) {
                return true;
            }
            String ignoredParts = "";
            String firstPart = "";
            String secondPart = "";
            int lastA = -1;
            assert (expression.length() != 0);
            assert (expression.charAt(expression.length() - 1) != 'a');
            assert (expression.charAt(0) != 'a');
            for (int i = 0; i <= expression.length(); ++i) {
                if (i != expression.length() && expression.charAt(i) != 'a') continue;
                ignoredParts = !firstPart.equals("") ? (ignoredParts.length() == 0 ? firstPart : ignoredParts + "a" + firstPart) : "";
                firstPart = expression.substring(lastA + 1, i);
                lastA = i;
                secondPart = i == expression.length() ? "" : expression.substring(i + 1, expression.length());
                if (logDEBUG) {
                    Logger.debug(this, "12in a firstPart=" + firstPart + " secondPart=" + secondPart + " for expression " + expression + " i " + i);
                }
                boolean result = false;
                int index = Integer.parseInt(firstPart);
                for (int j = 0; j < words.length; ++j) {
                    result = auxilaryVerifiers[index].checkValidity(CSSPropertyVerifier.getSubArray(words, 0, j + 1), cb);
                    if (logDEBUG) {
                        Logger.debug(this, "14in for loop result:" + result + " for " + CSSPropertyVerifier.toString(words) + " for " + firstPart);
                    }
                    if (!result) continue;
                    ParsedWord[] valueToPass = Arrays.copyOfRange(words, j + 1, words.length);
                    if (valueToPass.length == 0) {
                        if (logDEBUG) {
                            Logger.debug(this, "14opt No more words to pass, have matched everything");
                        }
                        return true;
                    }
                    String pattern = ignoredParts + ("".equals(ignoredParts) || "".equals(secondPart) ? "" : "a") + secondPart;
                    if (logDEBUG) {
                        Logger.debug(this, "14a " + CSSPropertyVerifier.toString(CSSPropertyVerifier.getSubArray(words, 0, j + 1)) + " can be consumed by " + index + " passing on expression=" + pattern + " value=" + CSSPropertyVerifier.toString(valueToPass));
                    }
                    if (pattern.equals("")) {
                        return false;
                    }
                    result = this.recursiveDoubleBarVerifier(pattern, valueToPass, cb);
                    if (!result) continue;
                    if (logDEBUG) {
                        Logger.debug(this, "15else part is true, value consumed=" + words[j]);
                    }
                    return true;
                }
            }
            if (lastA != -1) {
                return false;
            }
            int index = Integer.parseInt(expression);
            if (logDEBUG) {
                Logger.debug(this, "16Single token:" + expression + " with value=*" + Fields.commaList(words) + "* validity=" + auxilaryVerifiers[index].checkValidity(words, cb));
            }
            return auxilaryVerifiers[index].checkValidity(words, cb);
        }
    }

    static class ParsedCounter
    extends ParsedWord {
        private final ParsedIdentifier identifier;
        private final ParsedIdentifier listType;
        private final ParsedString separatorString;

        public ParsedCounter(String original, ParsedIdentifier identifier, ParsedIdentifier listType, ParsedString separatorString) {
            super(original, true);
            this.identifier = identifier;
            this.listType = listType;
            this.separatorString = separatorString;
        }

        @Override
        protected void innerEncode(boolean unicode, StringBuilder out) {
            if (this.separatorString != null) {
                out.append("counters(");
            } else {
                out.append("counter(");
            }
            this.identifier.innerEncode(unicode, out);
            if (this.separatorString != null) {
                out.append(", ");
                this.separatorString.innerEncode(unicode, out);
            }
            if (this.listType != null) {
                out.append(", ");
                this.listType.innerEncode(unicode, out);
            }
            out.append(')');
            if (this.postComma) {
                out.append(',');
            }
        }

        protected boolean addComma() {
            return false;
        }
    }

    static class SimpleParsedWord
    extends ParsedWord {
        public SimpleParsedWord(String original) {
            super(original, false);
        }

        @Override
        protected void innerEncode(boolean unicode, StringBuilder out) {
            out.append(this.original);
        }
    }

    static class ParsedAttr
    extends ParsedIdentifier {
        ParsedAttr(String original, String decoded, boolean changed) {
            super(original, decoded, changed);
        }

        @Override
        protected void innerEncode(boolean unicode, StringBuilder out) {
            out.append("attr(");
            super.innerEncode(unicode, out);
            out.append(')');
        }
    }

    static class ParsedURL
    extends ParsedString {
        ParsedURL(String original, String decoded, boolean changed, char stringChar) {
            super(original, decoded, changed || stringChar == '\u0000', stringChar == '\u0000' ? (char)'\"' : (char)stringChar);
        }

        @Override
        protected void innerEncode(boolean unicode, StringBuilder out) {
            out.append("url(");
            super.innerEncode(unicode, out);
            out.append(')');
        }

        public void setNewURL(String s) {
            super.setNewValue(s);
        }
    }

    static class ParsedString
    extends BaseParsedWord {
        final char stringChar;

        ParsedString(String original, String decoded, boolean changed, char stringChar) {
            super(original, decoded, changed);
            this.stringChar = stringChar;
        }

        @Override
        protected boolean mustEncode(char c, int i, char prevc, boolean unicode) {
            if (c == '\r' || c == '\n' || c == '\f') {
                return true;
            }
            if (c == this.stringChar) {
                return true;
            }
            return c < ' ' || c >= '\u0080' && !unicode;
        }

        @Override
        protected void innerEncode(boolean unicode, StringBuilder out) {
            out.append(this.stringChar);
            super.innerEncode(unicode, out);
            out.append(this.stringChar);
        }
    }

    static class ParsedIdentifier
    extends BaseParsedWord {
        ParsedIdentifier(String original, String decoded, boolean changed) {
            super(original, decoded, changed);
        }

        @Override
        protected boolean mustEncode(char c, int i, char prevc, boolean unicode) {
            return !(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_') && (c < '\u00a1' || !unicode) || i == 0 && c >= '0' && c <= '9' || i == 1 && prevc == '-' && c >= '0' && c <= '9';
        }
    }

    static abstract class BaseParsedWord
    extends ParsedWord {
        private String decoded;

        BaseParsedWord(String original, String decoded, boolean changed) {
            super(original, changed);
            this.decoded = decoded;
        }

        @Override
        protected void innerEncode(boolean unicode, StringBuilder out) {
            char prevc = '\u0000';
            char c = '\u0000';
            for (int i = 0; i < this.decoded.length(); ++i) {
                prevc = c;
                c = this.decoded.charAt(i);
                if (!this.mustEncode(c, i, prevc, unicode)) {
                    out.append(c);
                    continue;
                }
                this.encodeChar(c, out);
            }
        }

        protected abstract boolean mustEncode(char var1, int var2, char var3, boolean var4);

        private void encodeChar(char c, StringBuilder sb) {
            String s = Integer.toHexString(c);
            sb.append('\\');
            if (s.length() == 6) {
                sb.append(s);
            } else {
                if (s.length() > 6) {
                    throw new IllegalStateException();
                }
                int x = 6 - s.length();
                for (int i = 0; i < x; ++i) {
                    sb.append('0');
                }
                sb.append(s);
            }
        }

        public String getDecoded() {
            return this.decoded;
        }

        public void setNewValue(String s) {
            this.changed = true;
            this.decoded = s;
        }
    }

    static abstract class ParsedWord {
        final String original;
        protected boolean changed;
        public boolean postComma;

        public ParsedWord(String original, boolean changed) {
            this.original = original;
            this.changed = changed;
        }

        public String encode(boolean unicode) {
            if (!this.changed) {
                return this.original;
            }
            StringBuilder out = new StringBuilder();
            this.innerEncode(unicode, out);
            return out.toString();
        }

        public String toString() {
            return super.toString() + ":\"" + this.original + "\"";
        }

        protected abstract void innerEncode(boolean var1, StringBuilder var2);
    }
}

