/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.CSSTokenizerFilter;
import freenet.client.filter.FilterUtils;
import freenet.client.filter.HTMLFilter;
import java.util.HashSet;

public class ElementInfo {
    static boolean disallowUnknownSpecificFonts = false;
    static boolean disallowNonAlnumFonts = true;
    private static final HashSet<String> VOID_ELEMENTS = new HashSet();
    public static final HashSet<String> HTML_ELEMENTS;
    static final HashSet<String> REPLACED_ELEMENTS;
    public static final HashSet<String> LANGUAGES;
    public static final String[] MEDIAARRAY;
    public static final String[] VISUALMEDIA;
    public static final String[] AURALMEDIA;
    public static final String[] VISUALPAGEDMEDIA;
    public static final String[] VISUALINTERACTIVEMEDIA;
    public static final int UPPERLIMIT = 10;
    public static final String[] FONT_LIST;
    public static final String[] GENERIC_FONT_KEYWORDS;
    public static final String[] GENERIC_VOICE_KEYWORDS;
    public static final HashSet<String> PSEUDOCLASS;
    public static final boolean ALLOW_ALL_VALID_STRINGS = true;

    static void addHTMLTag(String tag) {
        HTML_ELEMENTS.add(tag.toLowerCase());
    }

    public static boolean isSpecificFontFamily(String font) {
        if (disallowUnknownSpecificFonts) {
            for (String s : FONT_LIST) {
                if (!s.equals(font)) continue;
                return true;
            }
            return false;
        }
        if (disallowNonAlnumFonts) {
            for (int i = 0; i < font.length(); ++i) {
                char c = font.charAt(i);
                if (Character.isLetterOrDigit(c) || c == ' ' || c == '.' || c == '_' || c == '-' || c == ',' || c == '+' || c == '~') continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean isSpecificVoiceFamily(String font) {
        if (disallowNonAlnumFonts) {
            for (int i = 0; i < font.length(); ++i) {
                char c = font.charAt(i);
                if (Character.isLetterOrDigit(c) || c == ' ' || c == '.' || c == '_' || c == '-' || c == ',' || c == '+' || c == '~') continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean isGenericFontFamily(String font) {
        for (String s : GENERIC_FONT_KEYWORDS) {
            if (!s.equals(font)) continue;
            return true;
        }
        return false;
    }

    public static boolean isGenericVoiceFamily(String font) {
        for (String s : GENERIC_VOICE_KEYWORDS) {
            if (!s.equals(font)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWordPrefixOrMatchOfSpecificFontFamily(String prefix) {
        String extraSpace = prefix + " ";
        for (String s : FONT_LIST) {
            if (!s.equals(prefix) && !s.startsWith(extraSpace)) continue;
            return true;
        }
        return false;
    }

    public static boolean isVoidElement(String element) {
        return VOID_ELEMENTS.contains(element);
    }

    public static boolean tryAutoClose(String element) {
        return "li".equals(element);
    }

    public static boolean isValidHTMLTag(String tag) {
        return HTML_ELEMENTS.contains(tag.toLowerCase()) || VOID_ELEMENTS.contains(tag.toLowerCase());
    }

    public static boolean isValidName(String name) {
        if (name.length() == 0) {
            return false;
        }
        if (!(name.charAt(0) >= 'a' && name.charAt(0) <= 'z' || name.charAt(0) >= 'A' && name.charAt(0) <= 'Z')) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (name.charAt(i) >= 'a' && name.charAt(i) <= 'z' || name.charAt(i) >= 'A' && name.charAt(i) <= 'Z' || name.charAt(i) >= '0' && name.charAt(i) <= '9' || name.charAt(i) == '_' || name.charAt(i) == ':' || name.charAt(i) == '.' || name.charAt(i) == '-') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidIdentifier(String name) {
        if (name.length() == 0) {
            return false;
        }
        boolean escape = false;
        boolean escapeNewline = false;
        boolean digitsAllowed = false;
        int unicodeChars = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (escape) {
                if (escapeNewline) {
                    escapeNewline = false;
                    escape = false;
                    if (c == '\n') continue;
                }
                escapeNewline = false;
                if ('0' <= c && '9' >= c || 'a' <= c && 'f' >= c || 'A' <= c && 'F' >= c) {
                    if (unicodeChars == 5) {
                        unicodeChars = 0;
                        escape = false;
                        continue;
                    }
                    ++unicodeChars;
                    continue;
                }
                if (unicodeChars > 0) {
                    if (c == '\r') {
                        escapeNewline = true;
                        unicodeChars = 0;
                        continue;
                    }
                    if (c != '\n' && c != '\f' && c != '\t' && c != ' ') {
                        return false;
                    }
                }
                if (c == '\r' || c == '\n' || c == '\f') {
                    return false;
                }
                escape = false;
                continue;
            }
            if (digitsAllowed && c >= '0' && c <= '9' || c == '-') continue;
            digitsAllowed = true;
            if (c == '_') continue;
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '\u00a1' && !Character.isISOControl(c)) continue;
            return false;
        }
        return !escape;
    }

    public static boolean isValidPseudoClass(String cname) {
        if (cname.indexOf(58) != -1) {
            String[] split;
            for (String s : split = cname.split(":")) {
                if (ElementInfo.isValidPseudoClass(s)) continue;
                return false;
            }
            return true;
        }
        if (PSEUDOCLASS.contains(cname = cname.toLowerCase())) {
            return true;
        }
        if (cname.indexOf("lang") != -1 && LANGUAGES.contains(ElementInfo.getPseudoClassArg(cname, "lang"))) {
            return true;
        }
        if (cname.indexOf("nth-child") != -1 && FilterUtils.isNth(ElementInfo.getPseudoClassArg(cname, "nth-child"))) {
            return true;
        }
        if (cname.indexOf("nth-last-child") != -1 && FilterUtils.isNth(ElementInfo.getPseudoClassArg(cname, "nth-last-child"))) {
            return true;
        }
        if (cname.indexOf("nth-of-type") != -1 && FilterUtils.isNth(ElementInfo.getPseudoClassArg(cname, "nth-of-type"))) {
            return true;
        }
        return cname.indexOf("nth-last-of-type") != -1 && FilterUtils.isNth(ElementInfo.getPseudoClassArg(cname, "nth-last-of-type"));
    }

    public static String getPseudoClassArg(String cname, String cname_sans_arg) {
        String arg = "";
        int cnameIndex = cname.indexOf(cname_sans_arg);
        int firstIndex = cname.indexOf(40);
        int secondIndex = cname.lastIndexOf(41);
        if (cname.substring(cnameIndex + cname_sans_arg.length(), firstIndex).trim().equals("") && cname.substring(0, cnameIndex).trim().equals("") && cname.substring(secondIndex + 1, cname.length()).trim().equals("")) {
            arg = CSSTokenizerFilter.removeOuterQuotes(cname.substring(firstIndex + 1, secondIndex).trim());
        }
        return arg;
    }

    public static boolean isValidString(String name) {
        boolean escape = false;
        boolean escapeNewline = false;
        int unicodeChars = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (escape) {
                if (escapeNewline) {
                    escapeNewline = false;
                    escape = false;
                    if (c == '\n') continue;
                }
                escapeNewline = false;
                if ('0' <= c && '9' >= c || 'a' <= c && 'f' >= c || 'A' <= c && 'F' >= c) {
                    if (unicodeChars == 5) {
                        unicodeChars = 0;
                        escape = false;
                        continue;
                    }
                    ++unicodeChars;
                    continue;
                }
                if (unicodeChars > 0) {
                    if (c == '\r') {
                        escapeNewline = true;
                        unicodeChars = 0;
                        continue;
                    }
                    if (c != '\n' && c != '\f' && c != '\t' && c != ' ') {
                        return false;
                    }
                }
                if (c == '\r') {
                    escapeNewline = true;
                    continue;
                }
                if (c == '\r' || c == '\n' || c == '\f') {
                    escape = false;
                    continue;
                }
                escape = false;
                continue;
            }
            if (c == '\'' || c == '\"') {
                return false;
            }
            if (c == '\r' || c == '\n' || c == '\f') {
                return false;
            }
            if (c != '\\') continue;
            escape = true;
        }
        return !escape;
    }

    public static boolean isValidStringDecoded(String s) {
        return true;
    }

    public static boolean isValidStringWithQuotes(String string) {
        if (string.length() < 2) {
            return false;
        }
        if (string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'' || string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(1, string.length() - 1);
            return ElementInfo.isValidString(string);
        }
        return false;
    }

    static {
        VOID_ELEMENTS.add("area");
        VOID_ELEMENTS.add("base");
        VOID_ELEMENTS.add("basefont");
        VOID_ELEMENTS.add("bgsound");
        VOID_ELEMENTS.add("br");
        VOID_ELEMENTS.add("col");
        VOID_ELEMENTS.add("command");
        VOID_ELEMENTS.add("embed");
        VOID_ELEMENTS.add("event-source");
        VOID_ELEMENTS.add("frame");
        VOID_ELEMENTS.add("hr");
        VOID_ELEMENTS.add("img");
        VOID_ELEMENTS.add("input");
        VOID_ELEMENTS.add("keygen");
        VOID_ELEMENTS.add("link");
        VOID_ELEMENTS.add("meta");
        VOID_ELEMENTS.add("param");
        VOID_ELEMENTS.add("source");
        VOID_ELEMENTS.add("spacer");
        VOID_ELEMENTS.add("wbr");
        HTML_ELEMENTS = new HashSet();
        HTMLFilter.forceSetup();
        REPLACED_ELEMENTS = new HashSet();
        REPLACED_ELEMENTS.add("img");
        REPLACED_ELEMENTS.add("object");
        REPLACED_ELEMENTS.add("textarea");
        REPLACED_ELEMENTS.add("select");
        REPLACED_ELEMENTS.add("input");
        REPLACED_ELEMENTS.add("applet");
        REPLACED_ELEMENTS.add("button");
        LANGUAGES = new HashSet();
        LANGUAGES.add("az");
        LANGUAGES.add("be");
        LANGUAGES.add("bg");
        LANGUAGES.add("cs");
        LANGUAGES.add("de");
        LANGUAGES.add("el");
        LANGUAGES.add("en");
        LANGUAGES.add("es");
        LANGUAGES.add("fi");
        LANGUAGES.add("fr");
        LANGUAGES.add("id");
        LANGUAGES.add("it");
        LANGUAGES.add("ja");
        LANGUAGES.add("ka");
        LANGUAGES.add("kk");
        LANGUAGES.add("ky");
        LANGUAGES.add("lv");
        LANGUAGES.add("mo");
        LANGUAGES.add("nl");
        LANGUAGES.add("no");
        LANGUAGES.add("pl");
        LANGUAGES.add("pt");
        LANGUAGES.add("ro");
        LANGUAGES.add("ru");
        LANGUAGES.add("sv");
        LANGUAGES.add("tl");
        LANGUAGES.add("tr");
        LANGUAGES.add("tt");
        LANGUAGES.add("uk");
        LANGUAGES.add("zh-hans");
        LANGUAGES.add("zh-hant");
        MEDIAARRAY = new String[]{"all", "aural", "braille", "embossed", "handheld", "print", "projection", "screen", "speech", "tty", "tv"};
        VISUALMEDIA = new String[]{"handheld", "print", "projection", "screen", "tty", "tv"};
        AURALMEDIA = new String[]{"speech", "aural"};
        VISUALPAGEDMEDIA = new String[]{"embossed", "handheld", "print", "projection", "screen", "tty", "tv"};
        VISUALINTERACTIVEMEDIA = new String[]{"braille", "handheld", "print", "projection", "screen", "speech", "tty", "tv"};
        FONT_LIST = new String[]{"arial", "helvetica", "arial black", "gadget", "comic sans ms", "comic sans ms5", "courier new", "courier6", "monospace georgia1", "georgia", "impact", "impact5", "charcoal6", "lucida console", "monaco5", "lucida sans unicode", "lucida grande", "palatino linotype", "book antiqua3", "palatino6", "tahoma", "geneva", "times new roman", "times", "trebuchet ms1", "helvetica", "verdana", "webdings", "webdings2", "wingdings", "zapf dingbats", "wingdings2", "zapf dingbats2", "ms sans serif4", "ms serif4", "new york6"};
        GENERIC_FONT_KEYWORDS = new String[]{"serif", "sans-serif", "cursive", "fantasy", "monospace"};
        GENERIC_VOICE_KEYWORDS = new String[]{"male", "female", "child"};
        PSEUDOCLASS = new HashSet();
        PSEUDOCLASS.add("first-child");
        PSEUDOCLASS.add("last-child");
        PSEUDOCLASS.add("nth-child");
        PSEUDOCLASS.add("nth-last-child");
        PSEUDOCLASS.add("nth-of-type");
        PSEUDOCLASS.add("nth-last-of-type");
        PSEUDOCLASS.add("link");
        PSEUDOCLASS.add("visited");
        PSEUDOCLASS.add("hover");
        PSEUDOCLASS.add("active");
        PSEUDOCLASS.add("focus");
        PSEUDOCLASS.add("lang");
        PSEUDOCLASS.add("first-line");
        PSEUDOCLASS.add("first-letter");
        PSEUDOCLASS.add("before");
        PSEUDOCLASS.add("after");
        PSEUDOCLASS.add("target");
    }
}

