/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.LinkEnabledCallback;
import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.config.Config;
import freenet.config.ConfigCallback;
import freenet.config.EnumerableOptionCallback;
import freenet.config.InvalidConfigValueException;
import freenet.config.NodeNeedRestartException;
import freenet.config.Option;
import freenet.config.SubConfig;
import freenet.config.WrapperConfig;
import freenet.l10n.NodeL10n;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.ProgramDirectory;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.pluginmanager.FredPluginConfigurable;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.URLEncoder;
import freenet.support.api.BooleanCallback;
import freenet.support.api.HTTPRequest;
import java.io.IOException;
import java.net.URI;

public class ConfigToadlet
extends Toadlet
implements LinkEnabledCallback {
    private static final int MAX_PARAM_VALUE_SIZE = 0x100000;
    private String directoryBrowserPath;
    private final SubConfig subConfig;
    private final Config config;
    private final NodeClientCore core;
    private final Node node;
    private final FredPluginConfigurable plugin;
    private boolean needRestart = false;
    private NeedRestartUserAlert needRestartUserAlert;

    public ConfigToadlet(String directoryBrowserPath, HighLevelSimpleClient client, Config conf, SubConfig subConfig, Node node, NodeClientCore core) {
        this(directoryBrowserPath, client, conf, subConfig, node, core, null);
    }

    public ConfigToadlet(HighLevelSimpleClient client, Config conf, SubConfig subConfig, Node node, NodeClientCore core) {
        this(client, conf, subConfig, node, core, null);
    }

    public ConfigToadlet(String directoryBrowserPath, HighLevelSimpleClient client, Config conf, SubConfig subConfig, Node node, NodeClientCore core, FredPluginConfigurable plugin) {
        this(client, conf, subConfig, node, core, plugin);
        this.directoryBrowserPath = directoryBrowserPath;
    }

    public ConfigToadlet(HighLevelSimpleClient client, Config conf, SubConfig subConfig, Node node, NodeClientCore core, FredPluginConfigurable plugin) {
        super(client);
        this.config = conf;
        this.core = core;
        this.node = node;
        this.subConfig = subConfig;
        this.plugin = plugin;
        this.directoryBrowserPath = "/unset-browser-path/";
    }

    public void handleMethodPOST(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        HTMLNode content;
        boolean resetToDefault;
        String value;
        if (!ctx.checkFullAccess(this)) {
            return;
        }
        if (request.isPartSet("confirm-reset-to-defaults")) {
            PageNode page = ctx.getPageMaker().getPageNode(ConfigToadlet.l10n("confirmResetTitle"), ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            HTMLNode content2 = ctx.getPageMaker().getInfobox("infobox-warning", ConfigToadlet.l10n("confirmResetTitle"), contentNode, "reset-confirm", true);
            content2.addChild("#", ConfigToadlet.l10n("confirmReset"));
            HTMLNode formNode = ctx.addFormChild(content2, this.path(), "yes-button");
            String subconfig = request.getPartAsStringFailsafe("subconfig", 0x100000);
            formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "subconfig", subconfig});
            for (String part : request.getParts()) {
                if (!part.startsWith(subconfig)) continue;
                formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", part, request.getPartAsStringFailsafe(part, 0x100000)});
            }
            formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "reset-to-defaults", NodeL10n.getBase().getString("Toadlet.yes")});
            formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "decline-default-reset", NodeL10n.getBase().getString("Toadlet.no")});
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
            return;
        }
        if (request.isPartSet("select-dir") || request.isPartSet("decline-default-reset")) {
            this.handleMethodGET(uri, request, ctx);
            return;
        }
        boolean directorySelector = false;
        String params = "?";
        for (String key : request.getParts()) {
            value = request.getPartAsStringFailsafe(key, 0x100000);
            if (key.startsWith("select-directory.")) {
                params = params + "select-for=" + URLEncoder.encode(key.substring("select-directory.".length()), true) + '&';
                directorySelector = true;
                continue;
            }
            params = params + URLEncoder.encode(key, true) + '=' + URLEncoder.encode(value, true) + '&';
        }
        if (directorySelector) {
            MultiValueTable<String, String> headers = new MultiValueTable<String, String>(1);
            headers.put("Location", this.directoryBrowserPath + params + "path=" + this.core.getDownloadsDir().getAbsolutePath());
            ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
            return;
        }
        StringBuilder errbuf = new StringBuilder();
        boolean logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        String prefix = request.getPartAsStringFailsafe("subconfig", 0x100000);
        if (logMINOR) {
            Logger.minor(this, "Current config prefix is " + prefix);
        }
        if ((resetToDefault = request.isPartSet("reset-to-defaults")) && logMINOR) {
            Logger.minor(this, "Resetting to defaults");
        }
        for (Option<?> o : this.config.get(prefix).getOptions()) {
            String configName = o.getName();
            if (logMINOR) {
                Logger.minor(this, "Checking option " + prefix + '.' + configName);
            }
            if (!request.isPartSet(prefix + '.' + configName)) continue;
            if (resetToDefault) {
                if (prefix.equals("fproxy") && configName.equals("port")) continue;
                value = o.getDefault();
            } else {
                value = request.getPartAsStringFailsafe(prefix + '.' + configName, 0x100000);
            }
            if (!o.getValueString().equals(value)) {
                if (logMINOR) {
                    Logger.minor(this, "Changing " + prefix + '.' + configName + " to " + value);
                }
                try {
                    o.setValue(value);
                }
                catch (InvalidConfigValueException e) {
                    errbuf.append(o.getName()).append(' ').append(e.getMessage()).append('\n');
                }
                catch (NodeNeedRestartException e) {
                    this.needRestart = true;
                }
                catch (Exception e) {
                    errbuf.append(o.getName()).append(' ').append(e).append('\n');
                    Logger.error(this, "Caught " + e, (Throwable)e);
                }
                continue;
            }
            if (!logMINOR) continue;
            Logger.minor(this, prefix + '.' + configName + " not changed");
        }
        String wrapperConfigName = "wrapper.java.maxmemory";
        if (request.isPartSet(wrapperConfigName)) {
            value = request.getPartAsStringFailsafe(wrapperConfigName, 0x100000);
            if (!WrapperConfig.getWrapperProperty(wrapperConfigName).equals(value)) {
                if (logMINOR) {
                    Logger.minor(this, "Setting " + wrapperConfigName + " to " + value);
                }
                WrapperConfig.setWrapperProperty(wrapperConfigName, value);
            }
        }
        this.config.store();
        PageNode page = ctx.getPageMaker().getPageNode(ConfigToadlet.l10n("appliedTitle"), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        if (errbuf.length() == 0) {
            content = ctx.getPageMaker().getInfobox("infobox-success", ConfigToadlet.l10n("appliedTitle"), contentNode, "configuration-applied", true);
            content.addChild("#", ConfigToadlet.l10n("appliedSuccess"));
            if (this.needRestart) {
                content.addChild("br");
                content.addChild("#", ConfigToadlet.l10n("needRestart"));
                if (this.node.isUsingWrapper()) {
                    content.addChild("br");
                    HTMLNode restartForm = ctx.addFormChild(content, "/", "restartForm");
                    restartForm.addChild("input", new String[]{"type", "name"}, new String[]{"hidden", "restart"});
                    restartForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "restart2", ConfigToadlet.l10n("restartNode")});
                }
                if (this.needRestartUserAlert == null) {
                    this.needRestartUserAlert = new NeedRestartUserAlert(ctx.getFormPassword());
                    ctx.getAlertManager().register(this.needRestartUserAlert);
                }
            }
        } else {
            content = ctx.getPageMaker().getInfobox("infobox-error", ConfigToadlet.l10n("appliedFailureTitle"), contentNode, "configuration-error", true).addChild("div", "class", "infobox-content");
            content.addChild("#", ConfigToadlet.l10n("appliedFailureExceptions"));
            content.addChild("br");
            content.addChild("#", errbuf.toString());
        }
        content = ctx.getPageMaker().getInfobox("infobox-normal", ConfigToadlet.l10n("possibilitiesTitle"), contentNode, "configuration-possibilities", false);
        content.addChild("a", new String[]{"href", "title"}, new String[]{this.path(), ConfigToadlet.l10n("shortTitle")}, ConfigToadlet.l10n("returnToNodeConfig"));
        content.addChild("br");
        ConfigToadlet.addHomepageLink(content);
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    private static String l10n(String string) {
        return NodeL10n.getBase().getString("ConfigToadlet." + string);
    }

    @Override
    public void handleMethodGET(URI uri, HTTPRequest req, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        if (!ctx.checkFullAccess(this)) {
            return;
        }
        boolean advancedModeEnabled = ctx.isAdvancedModeEnabled();
        PageNode page = ctx.getPageMaker().getPageNode(NodeL10n.getBase().getString("ConfigToadlet.fullTitle"), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        contentNode.addChild(ctx.getAlertManager().createSummary());
        HTMLNode infobox = contentNode.addChild("div", "class", "infobox infobox-normal");
        infobox.addChild("div", "class", "infobox-header", ConfigToadlet.l10n("title"));
        HTMLNode configNode = infobox.addChild("div", "class", "infobox-content");
        HTMLNode formNode = ctx.addFormChild(configNode, this.path(), "configForm");
        formNode.addChild("input", new String[]{"type", "value", "class"}, new String[]{"submit", ConfigToadlet.l10n("apply"), "invisible"});
        if (this.subConfig.getPrefix().equals("node") && WrapperConfig.canChangeProperties()) {
            String configName = "wrapper.java.maxmemory";
            String curValue = WrapperConfig.getWrapperProperty(configName);
            if (req.isPartSet(configName)) {
                curValue = req.getPartAsStringFailsafe(configName, 0x100000);
            }
            if (curValue != null) {
                formNode.addChild("div", "class", "configprefix", ConfigToadlet.l10n("wrapper"));
                HTMLNode list = formNode.addChild("ul", "class", "config");
                HTMLNode item = list.addChild("li", "class", OptionType.TEXT.cssClass);
                String defaultValue = "256";
                item.addChild("span", new String[]{"class", "title", "style"}, new String[]{"configshortdesc", NodeL10n.getBase().getString("ConfigToadlet.defaultIs", new String[]{"default"}, new String[]{defaultValue}), "cursor: help;"}).addChild(NodeL10n.getBase().getHTMLNode("WrapperConfig." + configName + ".short"));
                item.addChild("span", "class", "config").addChild("input", new String[]{"type", "class", "name", "value"}, new String[]{"text", "config", configName, curValue});
                item.addChild("span", "class", "configlongdesc").addChild(NodeL10n.getBase().getHTMLNode("WrapperConfig." + configName + ".long"));
            }
        }
        int displayedConfigElements = 0;
        HTMLNode configGroupUlNode = new HTMLNode("ul", "class", "config");
        String overriddenOption = null;
        String overriddenValue = null;
        if (req.isPartSet("select-for") && req.isPartSet("select-dir")) {
            overriddenOption = req.getPartAsStringFailsafe("select-for", 0x100000);
            overriddenValue = req.getPartAsStringFailsafe("filename", 0x100000);
        }
        for (Option<?> o : this.subConfig.getOptions()) {
            if (!advancedModeEnabled && o.isExpert()) continue;
            displayedConfigElements = (short)(displayedConfigElements + 1);
            String configName = o.getName();
            String fullName = this.subConfig.getPrefix() + '.' + configName;
            String value = o.getValueString();
            if (value == null) {
                Logger.error(this, fullName + "has returned null from config!);");
                continue;
            }
            ConfigCallback<?> callback = o.getCallback();
            OptionType optionType = callback instanceof EnumerableOptionCallback ? OptionType.DROP_DOWN : (callback instanceof BooleanCallback ? OptionType.BOOLEAN : (callback instanceof ProgramDirectory.DirectoryCallback && !callback.isReadOnly() ? OptionType.DIRECTORY : (!callback.isReadOnly() ? OptionType.TEXT : OptionType.TEXT_READ_ONLY)));
            HTMLNode shortDesc = o.getShortDescNode(this.plugin);
            HTMLNode longDesc = o.getLongDescNode(this.plugin);
            HTMLNode configItemNode = configGroupUlNode.addChild("li");
            String defaultValue = callback instanceof BooleanCallback ? ConfigToadlet.l10n(Boolean.toString(Boolean.valueOf(value))) : o.getDefault();
            configItemNode.addAttribute("class", optionType.cssClass);
            configItemNode.addChild("a", new String[]{"name", "id"}, new String[]{configName, configName}).addChild("span", new String[]{"class", "title", "style"}, new String[]{"configshortdesc", NodeL10n.getBase().getString("ConfigToadlet.defaultIs", new String[]{"default"}, new String[]{defaultValue}) + (advancedModeEnabled ? " [" + fullName + ']' : ""), "cursor: help;"}).addChild(shortDesc);
            HTMLNode configItemValueNode = configItemNode.addChild("span", "class", "config");
            if (req.isPartSet(fullName)) {
                value = req.getPartAsStringFailsafe(fullName, 0x100000);
            }
            if (overriddenOption != null && overriddenOption.equals(fullName)) {
                value = overriddenValue;
            }
            switch (optionType) {
                case DROP_DOWN: {
                    configItemValueNode.addChild(ConfigToadlet.addComboBox(value, (EnumerableOptionCallback)((Object)callback), fullName, callback.isReadOnly()));
                    break;
                }
                case BOOLEAN: {
                    configItemValueNode.addChild(ConfigToadlet.addBooleanComboBox(Boolean.valueOf(value), fullName, callback.isReadOnly()));
                    break;
                }
                case DIRECTORY: {
                    configItemValueNode.addChild(ConfigToadlet.addTextBox(value, fullName, o, false));
                    configItemValueNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "select-directory." + fullName, NodeL10n.getBase().getString("QueueToadlet.browseToChange")});
                    break;
                }
                case TEXT_READ_ONLY: {
                    configItemValueNode.addChild(ConfigToadlet.addTextBox(value, fullName, o, true));
                    break;
                }
                case TEXT: {
                    configItemValueNode.addChild(ConfigToadlet.addTextBox(value, fullName, o, false));
                }
            }
            configItemNode.addChild("span", "class", "configlongdesc").addChild(longDesc);
        }
        if (displayedConfigElements > 0) {
            formNode.addChild("div", "class", "configprefix", this.plugin == null ? ConfigToadlet.l10n(this.subConfig.getPrefix()) : this.plugin.getString(this.subConfig.getPrefix()));
            formNode.addChild("a", "id", this.subConfig.getPrefix());
            formNode.addChild(configGroupUlNode);
        }
        formNode.addChild("input", new String[]{"type", "value"}, new String[]{"submit", ConfigToadlet.l10n("apply")});
        formNode.addChild("input", new String[]{"type", "value"}, new String[]{"reset", ConfigToadlet.l10n("undo")});
        formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "subconfig", this.subConfig.getPrefix()});
        if (!this.subConfig.getPrefix().equals("node")) {
            formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "confirm-reset-to-defaults", ConfigToadlet.l10n("resetToDefaults")});
        }
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    public static HTMLNode addTextBox(String value, String fullName, Option<?> o, boolean disabled) {
        HTMLNode result = disabled ? new HTMLNode("input", new String[]{"type", "class", "disabled", "alt", "name", "value"}, new String[]{"text", "config", "disabled", o.getShortDesc(), fullName, value}) : new HTMLNode("input", new String[]{"type", "class", "alt", "name", "value"}, new String[]{"text", "config", o.getShortDesc(), fullName, value});
        return result;
    }

    public static HTMLNode addComboBox(String value, EnumerableOptionCallback o, String fullName, boolean disabled) {
        HTMLNode result = disabled ? new HTMLNode("select", new String[]{"name", "disabled"}, new String[]{fullName, "disabled"}) : new HTMLNode("select", "name", fullName);
        for (String possibleValue : o.getPossibleValues()) {
            if (possibleValue.equals(value)) {
                result.addChild("option", new String[]{"value", "selected"}, new String[]{possibleValue, "selected"}, possibleValue);
                continue;
            }
            result.addChild("option", "value", possibleValue, possibleValue);
        }
        return result;
    }

    public static HTMLNode addBooleanComboBox(boolean value, String fullName, boolean disabled) {
        HTMLNode result = disabled ? new HTMLNode("select", new String[]{"name", "disabled"}, new String[]{fullName, "disabled"}) : new HTMLNode("select", "name", fullName);
        if (value) {
            result.addChild("option", new String[]{"value", "selected"}, new String[]{"true", "selected"}, ConfigToadlet.l10n("true"));
            result.addChild("option", "value", "false", ConfigToadlet.l10n("false"));
        } else {
            result.addChild("option", "value", "true", ConfigToadlet.l10n("true"));
            result.addChild("option", new String[]{"value", "selected"}, new String[]{"false", "selected"}, ConfigToadlet.l10n("false"));
        }
        return result;
    }

    @Override
    public String path() {
        return "/config/" + this.subConfig.getPrefix();
    }

    @Override
    public boolean isEnabled(ToadletContext ctx) {
        Option<?>[] o = this.subConfig.getOptions();
        if (ctx.isAdvancedModeEnabled()) {
            return true;
        }
        for (Option<?> option : o) {
            if (option.isExpert()) continue;
            return true;
        }
        return false;
    }

    private static enum OptionType {
        DROP_DOWN("dropdown"),
        BOOLEAN("boolean"),
        DIRECTORY("directory"),
        TEXT("text"),
        TEXT_READ_ONLY("text readonly");

        public final String cssClass;

        private OptionType(String cssClass) {
            this.cssClass = cssClass;
        }
    }

    private class NeedRestartUserAlert
    extends AbstractUserAlert {
        private final String formPassword;

        public NeedRestartUserAlert(String formPassword) {
            this.formPassword = formPassword;
        }

        @Override
        public String getTitle() {
            return ConfigToadlet.l10n("needRestartTitle");
        }

        @Override
        public String getText() {
            return this.getHTMLText().toString();
        }

        @Override
        public String getShortText() {
            return ConfigToadlet.l10n("needRestartShort");
        }

        @Override
        public HTMLNode getHTMLText() {
            HTMLNode alertNode = new HTMLNode("div");
            alertNode.addChild("#", ConfigToadlet.l10n("needRestart"));
            if (ConfigToadlet.this.node.isUsingWrapper()) {
                alertNode.addChild("br");
                HTMLNode restartForm = alertNode.addChild("form", new String[]{"action", "method", "enctype", "id", "accept-charset"}, new String[]{"/", "post", "multipart/form-data", "restartForm", "utf-8"}).addChild("div");
                restartForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", this.formPassword});
                restartForm.addChild("div");
                restartForm.addChild("input", new String[]{"type", "name"}, new String[]{"hidden", "restart"});
                restartForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "restart2", ConfigToadlet.l10n("restartNode")});
            }
            return alertNode;
        }

        @Override
        public short getPriorityClass() {
            return 2;
        }

        @Override
        public boolean isValid() {
            return ConfigToadlet.this.needRestart;
        }

        @Override
        public boolean userCanDismiss() {
            return false;
        }
    }
}

