/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.client.async.DatabaseDisabledException;
import freenet.clients.http.RedirectException;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.config.SubConfig;
import freenet.io.xfer.BlockReceiver;
import freenet.io.xfer.BlockTransmitter;
import freenet.l10n.BaseL10n;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.NodeStarter;
import freenet.node.NodeStats;
import freenet.node.OpennetManager;
import freenet.node.PeerManager;
import freenet.node.PeerNodeStatus;
import freenet.node.RequestTracker;
import freenet.node.Version;
import freenet.node.fcp.DownloadRequestStatus;
import freenet.node.fcp.FCPServer;
import freenet.node.fcp.RequestStatus;
import freenet.node.fcp.UploadDirRequestStatus;
import freenet.node.fcp.UploadFileRequestStatus;
import freenet.node.stats.DataStoreInstanceType;
import freenet.node.stats.DataStoreStats;
import freenet.node.stats.StatsNotAvailableException;
import freenet.node.stats.StoreAccessStats;
import freenet.pluginmanager.PluginInfoWrapper;
import freenet.pluginmanager.PluginManager;
import freenet.support.BandwidthStatsContainer;
import freenet.support.SizeUtil;
import freenet.support.api.HTTPRequest;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;

public class DiagnosticToadlet
extends Toadlet {
    private final Node node;
    private final NodeClientCore core;
    private final NodeStats stats;
    private final PeerManager peers;
    private final NumberFormat thousandPoint = NumberFormat.getInstance();
    private final FCPServer fcp;
    private final DecimalFormat fix1p4 = new DecimalFormat("0.0000");
    private final DecimalFormat fix3p1pct = new DecimalFormat("##0.0%");
    public static final String TOADLET_URL = "/diagnostic/";
    private final BaseL10n baseL10n;

    protected DiagnosticToadlet(Node n, NodeClientCore core, FCPServer fcp, HighLevelSimpleClient client) {
        super(client);
        this.node = n;
        this.core = core;
        this.fcp = fcp;
        this.stats = this.node.nodeStats;
        this.peers = this.node.peers;
        this.baseL10n = new BaseL10n("freenet/l10n/", "freenet.l10n.${lang}.properties", new File(".").getPath() + File.separator + "freenet.l10n.${lang}.override.properties", BaseL10n.LANGUAGE.ENGLISH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMethodGET(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        if (!ctx.checkFullAccess(this)) {
            return;
        }
        this.node.clientCore.bandwidthStatsPutter.updateData();
        SubConfig nodeConfig = this.node.config.get("node");
        String text = "";
        DiagnosticToadlet diagnosticToadlet = this;
        synchronized (diagnosticToadlet) {
            OpennetManager om;
            text = text + "Freenet Version:\n";
            text = text + this.baseL10n.getString("WelcomeToadlet.version", new String[]{"fullVersion", "build", "rev"}, new String[]{Version.publicVersion(), Integer.toString(Version.buildNumber()), Version.cvsRevision()}) + "\n";
            text = text + this.baseL10n.getString("WelcomeToadlet.extVersion", new String[]{"build", "rev"}, new String[]{Integer.toString(NodeStarter.extBuildNumber), NodeStarter.extRevisionNumber});
            text = text + "\n";
            text = text + "System Information:\n";
            Runtime rt = Runtime.getRuntime();
            long freeMemory = rt.freeMemory();
            long totalMemory = rt.totalMemory();
            long maxMemory = rt.maxMemory();
            long usedJavaMem = totalMemory - freeMemory;
            long allocatedJavaMem = totalMemory;
            long maxJavaMem = maxMemory;
            int availableCpus = rt.availableProcessors();
            int threadCount = this.stats.getActiveThreadCount();
            text = text + this.l10n("usedMemory", "memory", SizeUtil.formatSize(usedJavaMem, true)) + "\n";
            text = text + this.l10n("allocMemory", "memory", SizeUtil.formatSize(allocatedJavaMem, true)) + "\n";
            text = text + this.l10n("maxMemory", "memory", SizeUtil.formatSize(maxJavaMem, true)) + "\n";
            text = text + this.l10n("threads", new String[]{"running", "max"}, new String[]{this.thousandPoint.format(threadCount), Integer.toString(this.stats.getThreadLimit())}) + "\n";
            text = text + this.l10n("cpus", "count", Integer.toString(availableCpus)) + "\n";
            text = text + this.l10n("javaVersion", "version", System.getProperty("java.version")) + "\n";
            text = text + this.l10n("jvmVendor", "vendor", System.getProperty("java.vendor")) + "\n";
            text = text + this.l10n("jvmName", "name", System.getProperty("java.vm.name")) + "\n";
            text = text + this.l10n("jvmVersion", "version", System.getProperty("java.vm.version")) + "\n";
            text = text + this.l10n("osName", "name", System.getProperty("os.name")) + "\n";
            text = text + this.l10n("osVersion", "version", System.getProperty("os.version")) + "\n";
            text = text + this.l10n("osArch", "arch", System.getProperty("os.arch")) + "\n";
            text = text + "\n";
            text = text + "Store Size:\n";
            Map<DataStoreInstanceType, DataStoreStats> storeStats = this.node.getDataStoreStats();
            for (Map.Entry<DataStoreInstanceType, DataStoreStats> entry : storeStats.entrySet()) {
                StoreAccessStats totalAccess;
                DataStoreInstanceType instance = entry.getKey();
                DataStoreStats stats = entry.getValue();
                StoreAccessStats sessionAccess = stats.getSessionAccessStats();
                try {
                    totalAccess = stats.getTotalAccessStats();
                }
                catch (StatsNotAvailableException e) {
                    totalAccess = null;
                }
                text = text + this.l10n(instance.store.name()) + ": (" + this.l10n(instance.key.name()) + ")\n";
                text = text + "  " + this.l10n("keys") + ": " + this.thousandPoint.format(stats.keys()) + "\n";
                text = text + "  " + this.l10n("capacity") + ": " + this.thousandPoint.format(stats.capacity()) + "\n";
                text = text + "  " + this.l10n("datasize") + ": " + SizeUtil.formatSize(stats.dataSize()) + "\n";
                text = text + "  " + this.l10n("utilization") + ": " + this.fix3p1pct.format(stats.utilization()) + "\n";
                text = text + "  " + this.l10n("readRequests") + ": " + this.thousandPoint.format(sessionAccess.readRequests()) + (totalAccess == null ? "" : " (" + this.thousandPoint.format(totalAccess.readRequests()) + ")") + "\n";
                text = text + "  " + this.l10n("successfulReads") + ": " + this.thousandPoint.format(sessionAccess.successfulReads()) + (totalAccess == null ? "" : " (" + this.thousandPoint.format(totalAccess.successfulReads()) + ")") + "\n";
                try {
                    text = text + this.fix1p4.format(sessionAccess.successRate()) + "%";
                    if (totalAccess != null) {
                        try {
                            text = text + " (" + this.fix1p4.format(totalAccess.successRate()) + "%)";
                        }
                        catch (StatsNotAvailableException e) {
                            // empty catch block
                        }
                    }
                    text = text + "\n";
                }
                catch (StatsNotAvailableException e) {}
            }
            text = text + "\n";
            text = text + "Activity:\n";
            RequestTracker tracker = this.node.tracker;
            int numLocalCHKInserts = tracker.getNumLocalCHKInserts();
            int numRemoteCHKInserts = tracker.getNumRemoteCHKInserts();
            int numLocalSSKInserts = tracker.getNumLocalSSKInserts();
            int numRemoteSSKInserts = tracker.getNumRemoteSSKInserts();
            int numLocalCHKRequests = tracker.getNumLocalCHKRequests();
            int numRemoteCHKRequests = tracker.getNumRemoteCHKRequests();
            int numLocalSSKRequests = tracker.getNumLocalSSKRequests();
            int numRemoteSSKRequests = tracker.getNumRemoteSSKRequests();
            int numTransferringRequests = tracker.getNumTransferringRequestSenders();
            int numTransferringRequestHandlers = tracker.getNumTransferringRequestHandlers();
            int numCHKOfferReplys = tracker.getNumCHKOfferReplies();
            int numSSKOfferReplys = tracker.getNumSSKOfferReplies();
            int numCHKRequests = numLocalCHKRequests + numRemoteCHKRequests;
            int numSSKRequests = numLocalSSKRequests + numRemoteSSKRequests;
            int numCHKInserts = numLocalCHKInserts + numRemoteCHKInserts;
            int numSSKInserts = numLocalSSKInserts + numRemoteSSKInserts;
            if (numTransferringRequests == 0 && numCHKRequests == 0 && numSSKRequests == 0 && numCHKInserts == 0 && numSSKInserts == 0 && numTransferringRequestHandlers == 0 && numCHKOfferReplys == 0 && numSSKOfferReplys == 0) {
                text = text + this.l10n("noRequests") + "\n";
            } else {
                if (numCHKInserts > 0 || numSSKInserts > 0) {
                    text = text + this.l10n("activityInserts", new String[]{"CHKhandlers", "SSKhandlers", "local"}, new String[]{Integer.toString(numCHKInserts), Integer.toString(numSSKInserts), Integer.toString(numLocalCHKInserts) + "/" + Integer.toString(numLocalSSKInserts)}) + "\n";
                }
                if (numCHKRequests > 0 || numSSKRequests > 0) {
                    text = text + this.l10n("activityRequests", new String[]{"CHKhandlers", "SSKhandlers", "local"}, new String[]{Integer.toString(numCHKRequests), Integer.toString(numSSKRequests), Integer.toString(numLocalCHKRequests) + "/" + Integer.toString(numLocalSSKRequests)}) + "\n";
                }
                if (numTransferringRequests > 0 || numTransferringRequestHandlers > 0) {
                    text = text + this.l10n("transferringRequests", new String[]{"senders", "receivers", "turtles"}, new String[]{Integer.toString(numTransferringRequests), Integer.toString(numTransferringRequestHandlers), "0"}) + "\n";
                }
                if (numCHKOfferReplys > 0 || numSSKOfferReplys > 0) {
                    text = text + this.l10n("offerReplys", new String[]{"chk", "ssk"}, new String[]{Integer.toString(numCHKOfferReplys), Integer.toString(numSSKOfferReplys)}) + "\n";
                }
                text = text + this.l10n("runningBlockTransfers", new String[]{"sends", "receives"}, new String[]{Integer.toString(BlockTransmitter.getRunningSends()), Integer.toString(BlockReceiver.getRunningReceives())}) + "\n";
            }
            text = text + "\n";
            text = text + "Peer Statistics:\n";
            PeerNodeStatus[] peerNodeStatuses = this.peers.getPeerNodeStatuses(true);
            Arrays.sort(peerNodeStatuses, new Comparator<PeerNodeStatus>(){

                @Override
                public int compare(PeerNodeStatus firstNode, PeerNodeStatus secondNode) {
                    int statusDifference = firstNode.getStatusValue() - secondNode.getStatusValue();
                    if (statusDifference != 0) {
                        return statusDifference;
                    }
                    return 0;
                }
            });
            int numberOfConnected = this.getPeerStatusCount(peerNodeStatuses, 1);
            int numberOfRoutingBackedOff = this.getPeerStatusCount(peerNodeStatuses, 2);
            int numberOfTooNew = this.getPeerStatusCount(peerNodeStatuses, 3);
            int numberOfTooOld = this.getPeerStatusCount(peerNodeStatuses, 4);
            int numberOfDisconnected = this.getPeerStatusCount(peerNodeStatuses, 5);
            int numberOfNeverConnected = this.getPeerStatusCount(peerNodeStatuses, 6);
            int numberOfDisabled = this.getPeerStatusCount(peerNodeStatuses, 7);
            int numberOfBursting = this.getPeerStatusCount(peerNodeStatuses, 8);
            int numberOfListening = this.getPeerStatusCount(peerNodeStatuses, 9);
            int numberOfListenOnly = this.getPeerStatusCount(peerNodeStatuses, 10);
            int numberOfSeedServers = this.getCountSeedServers(peerNodeStatuses);
            int numberOfSeedClients = this.getCountSeedClients(peerNodeStatuses);
            int numberOfRoutingDisabled = this.getPeerStatusCount(peerNodeStatuses, 14);
            int numberOfClockProblem = this.getPeerStatusCount(peerNodeStatuses, 11);
            int numberOfConnError = this.getPeerStatusCount(peerNodeStatuses, 12);
            int numberOfDisconnecting = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 13);
            int numberOfNoLoadStats = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 15);
            if (numberOfConnected > 0) {
                text = text + this.l10nDark("connectedShort") + ": " + numberOfConnected + "\n";
            }
            if (numberOfRoutingBackedOff > 0) {
                text = text + this.l10nDark("backedOffShort") + ": " + numberOfRoutingBackedOff + "\n";
            }
            if (numberOfTooNew > 0) {
                text = text + this.l10nDark("tooNewShort") + ": " + numberOfTooNew + "\n";
            }
            if (numberOfTooOld > 0) {
                text = text + this.l10nDark("tooOldShort") + ": " + numberOfTooOld + "\n";
            }
            if (numberOfDisconnected > 0) {
                text = text + this.l10nDark("notConnectedShort") + ": " + numberOfDisconnected + "\n";
            }
            if (numberOfNeverConnected > 0) {
                text = text + this.l10nDark("neverConnectedShort") + ": " + numberOfNeverConnected + "\n";
            }
            if (numberOfDisabled > 0) {
                text = text + this.l10nDark("disabledShort") + ": " + numberOfDisabled + "\n";
            }
            if (numberOfBursting > 0) {
                text = text + this.l10nDark("burstingShort") + ": " + numberOfBursting + "\n";
            }
            if (numberOfListening > 0) {
                text = text + this.l10nDark("listeningShort") + ": " + numberOfListening + "\n";
            }
            if (numberOfListenOnly > 0) {
                text = text + this.l10nDark("listenOnlyShort") + ": " + numberOfListenOnly + "\n";
            }
            if (numberOfClockProblem > 0) {
                text = text + this.l10nDark("clockProblemShort") + ": " + numberOfClockProblem + "\n";
            }
            if (numberOfConnError > 0) {
                text = text + this.l10nDark("connErrorShort") + ": " + numberOfConnError + "\n";
            }
            if (numberOfDisconnecting > 0) {
                text = text + this.l10nDark("disconnectingShort") + ": " + numberOfDisconnecting + "\n";
            }
            if (numberOfSeedServers > 0) {
                text = text + this.l10nDark("seedServersShort") + ": " + numberOfSeedServers + "\n";
            }
            if (numberOfSeedClients > 0) {
                text = text + this.l10nDark("seedClientsShort") + ": " + numberOfSeedClients + "\n";
            }
            if (numberOfRoutingDisabled > 0) {
                text = text + this.l10nDark("routingDisabledShort") + ": " + numberOfRoutingDisabled + "\n";
            }
            if (numberOfNoLoadStats > 0) {
                text = text + this.l10nDark("noLoadStatsShort") + ": " + numberOfNoLoadStats + "\n";
            }
            if ((om = this.node.getOpennet()) != null) {
                text = text + this.l10n("maxTotalPeers") + ": " + om.getNumberOfConnectedPeersToAimIncludingDarknet() + "\n";
                text = text + this.l10n("maxOpennetPeers") + ": " + om.getNumberOfConnectedPeersToAim() + "\n";
            }
            text = text + "\n";
            text = text + "Bandwidth:\n";
            long[] total = this.node.collector.getTotalIO();
            if (total[0] == 0L || total[1] == 0L) {
                text = text + "bandwidth error\n";
            } else {
                long now = System.currentTimeMillis();
                long nodeUptimeSeconds = (now - this.node.startupTime) / 1000L;
                long total_output_rate = total[0] / nodeUptimeSeconds;
                long total_input_rate = total[1] / nodeUptimeSeconds;
                long totalPayload = this.node.getTotalPayloadSent();
                long total_payload_rate = totalPayload / nodeUptimeSeconds;
                if (this.node.clientCore == null) {
                    throw new NullPointerException();
                }
                BandwidthStatsContainer stats = this.node.clientCore.bandwidthStatsPutter.getLatestBWData();
                if (stats == null) {
                    throw new NullPointerException();
                }
                long overall_total_out = stats.totalBytesOut;
                long overall_total_in = stats.totalBytesIn;
                int percent = (int)(100L * totalPayload / total[0]);
                long[] rate = this.node.nodeStats.getNodeIOStats();
                long delta = (rate[5] - rate[2]) / 1000L;
                if (delta > 0L) {
                    long output_rate = (rate[3] - rate[0]) / delta;
                    long input_rate = (rate[4] - rate[1]) / delta;
                    int outputBandwidthLimit = nodeConfig.getInt("outputBandwidthLimit");
                    int inputBandwidthLimit = nodeConfig.getInt("inputBandwidthLimit");
                    if (inputBandwidthLimit == -1) {
                        inputBandwidthLimit = outputBandwidthLimit * 4;
                    }
                    text = text + this.l10n("inputRate", new String[]{"rate", "max"}, new String[]{SizeUtil.formatSize(input_rate, true), SizeUtil.formatSize(inputBandwidthLimit, true)}) + "\n";
                    text = text + this.l10n("outputRate", new String[]{"rate", "max"}, new String[]{SizeUtil.formatSize(output_rate, true), SizeUtil.formatSize(outputBandwidthLimit, true)}) + "\n";
                }
                text = text + this.l10n("totalInputSession", new String[]{"total", "rate"}, new String[]{SizeUtil.formatSize(total[1], true), SizeUtil.formatSize(total_input_rate, true)}) + "\n";
                text = text + this.l10n("totalOutputSession", new String[]{"total", "rate"}, new String[]{SizeUtil.formatSize(total[0], true), SizeUtil.formatSize(total_output_rate, true)}) + "\n";
                text = text + this.l10n("payloadOutput", new String[]{"total", "rate", "percent"}, new String[]{SizeUtil.formatSize(totalPayload, true), SizeUtil.formatSize(total_payload_rate, true), Integer.toString(percent)}) + "\n";
                text = text + this.l10n("totalInput", new String[]{"total"}, new String[]{SizeUtil.formatSize(overall_total_in, true)}) + "\n";
                text = text + this.l10n("totalOutput", new String[]{"total"}, new String[]{SizeUtil.formatSize(overall_total_out, true)}) + "\n";
                long totalBytesSentCHKRequests = this.node.nodeStats.getCHKRequestTotalBytesSent();
                long totalBytesSentSSKRequests = this.node.nodeStats.getSSKRequestTotalBytesSent();
                long totalBytesSentCHKInserts = this.node.nodeStats.getCHKInsertTotalBytesSent();
                long totalBytesSentSSKInserts = this.node.nodeStats.getSSKInsertTotalBytesSent();
                long totalBytesSentOfferedKeys = this.node.nodeStats.getOfferedKeysTotalBytesSent();
                long totalBytesSendOffers = this.node.nodeStats.getOffersSentBytesSent();
                long totalBytesSentSwapOutput = this.node.nodeStats.getSwappingTotalBytesSent();
                long totalBytesSentAuth = this.node.nodeStats.getTotalAuthBytesSent();
                long totalBytesSentAckOnly = this.node.nodeStats.getNotificationOnlyPacketsSentBytes();
                long totalBytesSentResends = this.node.nodeStats.getResendBytesSent();
                long totalBytesSentUOM = this.node.nodeStats.getUOMBytesSent();
                long totalBytesSentAnnounce = this.node.nodeStats.getAnnounceBytesSent();
                long totalBytesSentAnnouncePayload = this.node.nodeStats.getAnnounceBytesPayloadSent();
                long totalBytesSentRoutingStatus = this.node.nodeStats.getRoutingStatusBytes();
                long totalBytesSentNetworkColoring = this.node.nodeStats.getNetworkColoringSentBytes();
                long totalBytesSentPing = this.node.nodeStats.getPingSentBytes();
                long totalBytesSentProbeRequest = this.node.nodeStats.getProbeRequestSentBytes();
                long totalBytesSentRouted = this.node.nodeStats.getRoutedMessageSentBytes();
                long totalBytesSentDisconn = this.node.nodeStats.getDisconnBytesSent();
                long totalBytesSentInitial = this.node.nodeStats.getInitialMessagesBytesSent();
                long totalBytesSentChangedIP = this.node.nodeStats.getChangedIPBytesSent();
                long totalBytesSentNodeToNode = this.node.nodeStats.getNodeToNodeBytesSent();
                long totalBytesSentAllocationNotices = this.node.nodeStats.getAllocationNoticesBytesSent();
                long totalBytesSentFOAF = this.node.nodeStats.getFOAFBytesSent();
                long totalBytesSentRemaining = total[0] - (totalPayload + totalBytesSentCHKRequests + totalBytesSentSSKRequests + totalBytesSentCHKInserts + totalBytesSentSSKInserts + totalBytesSentOfferedKeys + totalBytesSendOffers + totalBytesSentSwapOutput + totalBytesSentAuth + totalBytesSentAckOnly + totalBytesSentResends + totalBytesSentUOM + totalBytesSentAnnounce + totalBytesSentRoutingStatus + totalBytesSentNetworkColoring + totalBytesSentPing + totalBytesSentProbeRequest + totalBytesSentRouted + totalBytesSentDisconn + totalBytesSentInitial + totalBytesSentChangedIP + totalBytesSentNodeToNode + totalBytesSentAllocationNotices + totalBytesSentFOAF);
                text = text + this.l10n("requestOutput", new String[]{"chk", "ssk"}, new String[]{SizeUtil.formatSize(totalBytesSentCHKRequests, true), SizeUtil.formatSize(totalBytesSentSSKRequests, true)}) + "\n";
                text = text + this.l10n("insertOutput", new String[]{"chk", "ssk"}, new String[]{SizeUtil.formatSize(totalBytesSentCHKInserts, true), SizeUtil.formatSize(totalBytesSentSSKInserts, true)}) + "\n";
                text = text + this.l10n("offeredKeyOutput", new String[]{"total", "offered"}, new String[]{SizeUtil.formatSize(totalBytesSentOfferedKeys, true), SizeUtil.formatSize(totalBytesSendOffers, true)}) + "\n";
                text = text + this.l10n("swapOutput", "total", SizeUtil.formatSize(totalBytesSentSwapOutput, true)) + "\n";
                text = text + this.l10n("authBytes", "total", SizeUtil.formatSize(totalBytesSentAuth, true)) + "\n";
                text = text + this.l10n("ackOnlyBytes", "total", SizeUtil.formatSize(totalBytesSentAckOnly, true)) + "\n";
                text = text + this.l10n("resendBytes", new String[]{"total", "percent"}, new String[]{SizeUtil.formatSize(totalBytesSentResends, true), Long.toString(100L * totalBytesSentResends / Math.max(1L, total[0]))}) + "\n";
                text = text + this.l10n("uomBytes", "total", SizeUtil.formatSize(totalBytesSentUOM, true)) + "\n";
                text = text + this.l10n("announceBytes", new String[]{"total", "payload"}, new String[]{SizeUtil.formatSize(totalBytesSentAnnounce, true), SizeUtil.formatSize(totalBytesSentAnnouncePayload, true)}) + "\n";
                text = text + this.l10n("adminBytes", new String[]{"routingStatus", "disconn", "initial", "changedIP"}, new String[]{SizeUtil.formatSize(totalBytesSentRoutingStatus, true), SizeUtil.formatSize(totalBytesSentDisconn, true), SizeUtil.formatSize(totalBytesSentInitial, true), SizeUtil.formatSize(totalBytesSentChangedIP, true)}) + "\n";
                text = text + this.l10n("debuggingBytes", new String[]{"netColoring", "ping", "probe", "routed"}, new String[]{SizeUtil.formatSize(totalBytesSentNetworkColoring, true), SizeUtil.formatSize(totalBytesSentPing, true), SizeUtil.formatSize(totalBytesSentProbeRequest, true), SizeUtil.formatSize(totalBytesSentRouted, true)}) + "\n";
                text = text + this.l10n("nodeToNodeBytes", "total", SizeUtil.formatSize(totalBytesSentNodeToNode, true)) + "\n";
                text = text + this.l10n("loadAllocationNoticesBytes", "total", SizeUtil.formatSize(totalBytesSentAllocationNotices, true)) + "\n";
                text = text + this.l10n("foafBytes", "total", SizeUtil.formatSize(totalBytesSentFOAF, true)) + "\n";
                text = text + this.l10n("unaccountedBytes", new String[]{"total", "percent"}, new String[]{SizeUtil.formatSize(totalBytesSentRemaining, true), Integer.toString((int)(totalBytesSentRemaining * 100L / total[0]))}) + "\n";
                double sentOverheadPerSecond = this.node.nodeStats.getSentOverheadPerSecond();
                text = text + this.l10n("totalOverhead", new String[]{"rate", "percent"}, new String[]{SizeUtil.formatSize((long)sentOverheadPerSecond), Integer.toString((int)(100.0 * sentOverheadPerSecond / (double)total_output_rate))}) + "\n";
            }
            text = text + "\n";
            text = text + "Plugins:\n";
            PluginManager pm = this.node.pluginManager;
            if (!pm.getPlugins().isEmpty()) {
                text = text + this.baseL10n.getString("PluginToadlet.pluginListTitle") + "\n";
                for (PluginInfoWrapper pi : pm.getPlugins()) {
                    long ver = pi.getPluginLongVersion();
                    if (ver != -1L) {
                        text = text + pi.getFilename() + " (" + pi.getPluginClassName() + ") - " + pi.getPluginVersion() + " (" + ver + ")" + " " + pi.getThreadName() + "\n";
                        continue;
                    }
                    text = text + pi.getFilename() + " (" + pi.getPluginClassName() + ") - " + pi.getPluginVersion() + " " + pi.getThreadName() + "\n";
                }
            }
            text = text + "\n";
            text = text + "Queue:\n";
            try {
                RequestStatus[] reqs = this.fcp.getGlobalRequests();
                if (reqs.length < 1) {
                    text = text + this.baseL10n.getString("QueueToadlet.globalQueueIsEmpty") + "\n";
                } else {
                    long totalQueuedDownload = 0L;
                    long totalQueuedUpload = 0L;
                    for (RequestStatus req : reqs) {
                        if (req instanceof DownloadRequestStatus) {
                            ++totalQueuedDownload;
                            continue;
                        }
                        if (req instanceof UploadFileRequestStatus) {
                            ++totalQueuedUpload;
                            continue;
                        }
                        if (!(req instanceof UploadDirRequestStatus)) continue;
                        ++totalQueuedUpload;
                    }
                    text = text + "Downloads Queued: " + totalQueuedDownload + " (" + totalQueuedDownload + ")\n";
                    text = text + "Uploads Queued: " + totalQueuedUpload + " (" + totalQueuedUpload + ")\n";
                }
            }
            catch (DatabaseDisabledException e) {
                text = text + "DatabaseDisabledException\n";
            }
            text = text + "\n";
            text = text + "Threads:\n";
            int[] activeThreadsByPriority = this.stats.getActiveThreadsByPriority();
            int[] waitingThreadsByPriority = this.stats.getWaitingThreadsByPriority();
            for (int i = 0; i < activeThreadsByPriority.length; ++i) {
                text = text + this.l10n("running") + ": " + String.valueOf(activeThreadsByPriority[i]) + " (" + String.valueOf(i + 1) + ")\n";
                text = text + this.l10n("waiting") + ": " + String.valueOf(waitingThreadsByPriority[i]) + " (" + String.valueOf(i + 1) + ")\n";
            }
            text = text + "\n";
            int[] jobsByPriority = this.core.clientDatabaseExecutor.getQueuedJobsCountByPriority();
            for (int i = 0; i < jobsByPriority.length; ++i) {
                text = text + this.l10n("waiting") + ": " + String.valueOf(i) + " (" + String.valueOf(jobsByPriority[i]) + ")\n";
            }
            text = text + "\n";
        }
        this.writeTextReply(ctx, 200, "OK", text);
    }

    private int getPeerStatusCount(PeerNodeStatus[] peerNodeStatuses, int status) {
        int count = 0;
        for (PeerNodeStatus peerNodeStatus : peerNodeStatuses) {
            if (!peerNodeStatus.recordStatus() || peerNodeStatus.getStatusValue() != status) continue;
            ++count;
        }
        return count;
    }

    private int getCountSeedServers(PeerNodeStatus[] peerNodeStatuses) {
        int count = 0;
        for (PeerNodeStatus peerNodeStatus : peerNodeStatuses) {
            if (!peerNodeStatus.isSeedServer()) continue;
            ++count;
        }
        return count;
    }

    private int getCountSeedClients(PeerNodeStatus[] peerNodeStatuses) {
        int count = 0;
        for (PeerNodeStatus peerNodeStatus : peerNodeStatuses) {
            if (!peerNodeStatus.isSeedClient()) continue;
            ++count;
        }
        return count;
    }

    private String l10n(String key) {
        return this.baseL10n.getString("StatisticsToadlet." + key);
    }

    private String l10nDark(String key) {
        return this.baseL10n.getString("DarknetConnectionsToadlet." + key);
    }

    private String l10n(String key, String pattern, String value) {
        return this.baseL10n.getString("StatisticsToadlet." + key, new String[]{pattern}, new String[]{value});
    }

    private String l10n(String key, String[] patterns, String[] values) {
        return this.baseL10n.getString("StatisticsToadlet." + key, patterns, values);
    }

    @Override
    public String path() {
        return TOADLET_URL;
    }
}

