/*
 * Decompiled with CFR 0.152.
 */
package freenet.config;

import freenet.config.ConfigCallback;
import freenet.config.InvalidConfigValueException;
import freenet.config.NodeNeedRestartException;
import freenet.config.SubConfig;
import freenet.l10n.BaseL10n;
import freenet.l10n.NodeL10n;
import freenet.pluginmanager.FredPluginConfigurable;
import freenet.support.HTMLNode;

public abstract class Option<T> {
    protected final SubConfig config;
    protected final String name;
    protected final int sortOrder;
    protected final boolean expert;
    protected final boolean forceWrite;
    protected final String shortDesc;
    protected final String longDesc;
    protected final ConfigCallback<T> cb;
    protected T defaultValue;
    protected T currentValue;
    final DataType dataType;

    Option(SubConfig config, String name, ConfigCallback<T> cb, int sortOrder, boolean expert, boolean forceWrite, String shortDesc, String longDesc, DataType dataType) {
        this.config = config;
        this.name = name;
        this.cb = cb;
        this.sortOrder = sortOrder;
        this.expert = expert;
        this.shortDesc = shortDesc;
        this.longDesc = longDesc;
        this.forceWrite = forceWrite;
        this.dataType = dataType;
    }

    public final void setValue(String val) throws InvalidConfigValueException, NodeNeedRestartException {
        T x = this.parseString(val);
        this.set(x);
    }

    protected abstract T parseString(String var1) throws InvalidConfigValueException;

    protected abstract String toString(T var1);

    protected final void set(T val) throws InvalidConfigValueException, NodeNeedRestartException {
        try {
            this.cb.set(val);
            this.currentValue = val;
        }
        catch (NodeNeedRestartException e) {
            this.currentValue = val;
            throw e;
        }
    }

    public final String getValueString() {
        return this.toString(this.currentValue);
    }

    public final void setInitialValue(String val) throws InvalidConfigValueException {
        this.currentValue = this.parseString(val);
    }

    public void forceUpdate() throws InvalidConfigValueException, NodeNeedRestartException {
        this.setValue(this.getValueString());
    }

    public String getName() {
        return this.name;
    }

    public String getShortDesc() {
        return this.shortDesc;
    }

    private String getLongDesc() {
        return this.longDesc;
    }

    public boolean isExpert() {
        return this.expert;
    }

    public boolean isForcedWrite() {
        return this.forceWrite;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String getDataTypeStr() {
        switch (this.dataType) {
            case STRING: {
                return "string";
            }
            case NUMBER: {
                return "number";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case STRING_ARRAY: {
                return "stringArray";
            }
        }
        return null;
    }

    public final T getValue() {
        if (this.config.hasFinishedInitialization()) {
            this.currentValue = this.cb.get();
            return this.currentValue;
        }
        return this.currentValue;
    }

    public boolean isDefault() {
        this.getValue();
        return this.currentValue == null ? false : this.currentValue.equals(this.defaultValue);
    }

    public final void setDefault() {
        this.currentValue = this.defaultValue;
    }

    public final String getDefault() {
        return this.toString(this.defaultValue);
    }

    public final ConfigCallback<T> getCallback() {
        return this.cb;
    }

    public String getLocalisedShortDesc(BaseL10n l10n) {
        return l10n.getString(this.getShortDesc(), "default", this.getDefault());
    }

    public String getLocalisedShortDesc() {
        return this.getLocalisedShortDesc(NodeL10n.getBase());
    }

    public String getLocalisedLongDesc(BaseL10n l10n) {
        return l10n.getString(this.getLongDesc(), "default", this.getDefault());
    }

    public String getLocalisedLongDesc() {
        return this.getLocalisedLongDesc(NodeL10n.getBase());
    }

    public HTMLNode getShortDescNode(FredPluginConfigurable plugin) {
        return plugin == null ? NodeL10n.getBase().getHTMLNode(this.getShortDesc(), new String[]{"default"}, new String[]{this.getDefault()}) : new HTMLNode("#", plugin.getString(this.getShortDesc()));
    }

    public HTMLNode getShortDescNode() {
        return this.getShortDescNode(null);
    }

    public HTMLNode getLongDescNode(FredPluginConfigurable plugin) {
        return plugin == null ? NodeL10n.getBase().getHTMLNode(this.getLongDesc(), new String[]{"default"}, new String[]{this.getDefault()}) : new HTMLNode("#", plugin.getString(this.getLongDesc()));
    }

    public HTMLNode getLongDescNode() {
        return this.getLongDescNode(null);
    }

    public static enum DataType {
        STRING,
        NUMBER,
        BOOLEAN,
        STRING_ARRAY;

    }
}

