/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Random;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.AESLightEngine;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.OCBBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;

public class AEADOutputStream
extends FilterOutputStream {
    private final AEADBlockCipher cipher;
    static final int MAC_SIZE_BITS = 128;
    static final int MAC_SIZE_BYTES = 16;
    static final int AES_BLOCK_SIZE = 16;
    public static final int AES_OVERHEAD = 32;

    public AEADOutputStream(OutputStream os, byte[] key, byte[] nonce, BlockCipher hashCipher, BlockCipher mainCipher) throws IOException {
        super(os);
        os.write(nonce);
        this.cipher = new OCBBlockCipher(hashCipher, mainCipher);
        KeyParameter keyParam = new KeyParameter(key);
        AEADParameters params = new AEADParameters(keyParam, 128, nonce);
        this.cipher.init(true, (CipherParameters)params);
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int offset, int length) throws IOException {
        byte[] output = new byte[this.cipher.getUpdateOutputSize(length)];
        this.cipher.processBytes(buf, offset, length, output, 0);
        this.out.write(output);
    }

    @Override
    public void close() throws IOException {
        byte[] output = new byte[this.cipher.getOutputSize(0)];
        try {
            this.cipher.doFinal(output, 0);
        }
        catch (InvalidCipherTextException e) {
            throw new RuntimeException("Impossible: " + (Object)((Object)e));
        }
        this.out.write(output);
        this.out.close();
    }

    public static AEADOutputStream createAES(OutputStream os, byte[] key, SecureRandom random) throws IOException {
        return AEADOutputStream.innerCreateAES(os, key, random);
    }

    static AEADOutputStream innerCreateAES(OutputStream os, byte[] key, Random random) throws IOException {
        AESEngine mainCipher = new AESEngine();
        AESLightEngine hashCipher = new AESLightEngine();
        byte[] nonce = new byte[mainCipher.getBlockSize()];
        random.nextBytes(nonce);
        nonce[0] = (byte)(nonce[0] & 0x7F);
        return new AEADOutputStream(os, key, nonce, (BlockCipher)hashCipher, (BlockCipher)mainCipher);
    }

    public String toString() {
        return "AEADOutputStream:" + this.out.toString();
    }
}

