/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.Util;
import freenet.node.Node;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.OOMHandler;
import freenet.support.OOMHook;
import freenet.support.io.Closer;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.ArrayList;
import org.tanukisoftware.wrapper.WrapperManager;

public class SHA256 {
    private static volatile boolean logMINOR;
    private static final int HASH_SIZE = 32;
    private static final int MESSAGE_DIGESTS_TO_CACHE = 16;
    private static final ArrayList<MessageDigest> digests;
    private static final Provider mdProvider;
    private static boolean noCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hash(InputStream is, MessageDigest md) throws IOException {
        try {
            byte[] buf = new byte[4096];
            int readBytes = is.read(buf);
            while (readBytes > -1) {
                md.update(buf, 0, readBytes);
                readBytes = is.read(buf);
            }
            is.close();
        }
        finally {
            Closer.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageDigest getMessageDigest() {
        try {
            MessageDigest md = null;
            ArrayList<MessageDigest> arrayList = digests;
            synchronized (arrayList) {
                int x = digests.size();
                md = x == 0 ? null : digests.remove(x - 1);
            }
            if (md == null) {
                md = MessageDigest.getInstance("SHA-256", mdProvider);
            }
            return md;
        }
        catch (NoSuchAlgorithmException e2) {
            Logger.error(Node.class, "Check your JVM settings especially the JCE!" + e2);
            System.err.println("Check your JVM settings especially the JCE!" + e2);
            e2.printStackTrace();
            WrapperManager.stop((int)255);
            throw new RuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnMessageDigest(MessageDigest md256) {
        if (md256 == null) {
            return;
        }
        String algo = md256.getAlgorithm();
        if (!algo.equals("SHA-256") && !algo.equals("SHA256")) {
            throw new IllegalArgumentException("Should be SHA-256 but is " + algo);
        }
        md256.reset();
        ArrayList<MessageDigest> arrayList = digests;
        synchronized (arrayList) {
            int mdPoolSize = digests.size();
            if (mdPoolSize > 16 || noCache) {
                if (logMINOR) {
                    Logger.normal(SHA256.class, "Throwing away a SHA256 MessageDigest (" + mdPoolSize + '>' + 16 + ')');
                }
                return;
            }
            digests.add(md256);
        }
    }

    public static byte[] digest(byte[] data) {
        MessageDigest md = SHA256.getMessageDigest();
        byte[] hash = md.digest(data);
        SHA256.returnMessageDigest(md);
        return hash;
    }

    public static int getDigestLength() {
        return 32;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        digests = new ArrayList();
        mdProvider = Util.mdProviders.get("SHA-256");
        noCache = false;
        OOMHandler.addOOMHook(new OOMHook(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleLowMemory() throws Exception {
                ArrayList arrayList = digests;
                synchronized (arrayList) {
                    digests.clear();
                }
                noCache = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleOutOfMemory() throws Exception {
                ArrayList arrayList = digests;
                synchronized (arrayList) {
                    digests.clear();
                }
                noCache = true;
            }
        });
    }
}

