/*
 * Decompiled with CFR 0.152.
 */
package freenet.l10n;

import freenet.support.io.Closer;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;

public final class ISO639_3 {
    private final Map<String, LanguageCode> allLanguagesCache = Collections.unmodifiableMap(ISO639_3.loadFromTabFile());

    private static Hashtable<String, LanguageCode> loadFromTabFile() {
        Hashtable<String, LanguageCode> codes = new Hashtable<String, LanguageCode>(15410);
        InputStream in = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            in = ISO639_3.class.getClassLoader().getResourceAsStream("freenet/l10n/iso-639-3_20100707.tab");
            if (in == null) {
                throw new RuntimeException("Could not open the language codes resource");
            }
            isr = new InputStreamReader(in, "UTF-8");
            br = new BufferedReader(isr);
            String[] headerTokens = br.readLine().split("[\t]");
            if (!(headerTokens[0].equals("\ufeffId") && headerTokens[1].equals("Part2B") && headerTokens[2].equals("Part2T") && headerTokens[3].equals("Part1") && headerTokens[4].equals("Scope") && headerTokens[5].equals("Language_Type") && headerTokens[6].equals("Ref_Name") && headerTokens[7].equals("Comment"))) {
                throw new RuntimeException("File header does not match the expected header.");
            }
            String line = br.readLine();
            while (line != null) {
                if ((line = line.trim()).length() != 0) {
                    String[] tokens = line.split("[\t]");
                    if (tokens.length != 8 && tokens.length != 7) {
                        throw new RuntimeException("Line with invalid token amount: " + line);
                    }
                    LanguageCode newCode = new LanguageCode(tokens[0].toCharArray(), tokens[1].toCharArray(), tokens[2].toCharArray(), tokens[3].toCharArray(), LanguageCode.Scope.fromTabFile(tokens[4]), LanguageCode.Type.fromTabFile(tokens[5]), tokens[6], tokens.length == 8 ? tokens[7] : null);
                    if (codes.put(newCode.id, newCode) != null) {
                        throw new RuntimeException("Duplicate language code: " + newCode);
                    }
                }
                line = br.readLine();
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Closer.close(br);
                Closer.close(isr);
                Closer.close(in);
                throw throwable;
            }
        }
        Closer.close(br);
        Closer.close(isr);
        Closer.close(in);
        return codes;
    }

    public final Map<String, LanguageCode> getLanguages() {
        return this.allLanguagesCache;
    }

    public final Hashtable<String, LanguageCode> getLanguagesByScopeAndType(LanguageCode.Scope scope, LanguageCode.Type type) {
        Map<String, LanguageCode> all = this.getLanguages();
        Hashtable<String, LanguageCode> result = new Hashtable<String, LanguageCode>();
        for (LanguageCode c : all.values()) {
            if (!c.scope.equals((Object)scope) || !c.type.equals((Object)type)) continue;
            result.put(c.id, c);
        }
        return result;
    }

    public final LanguageCode getMultilingualCode() {
        return this.getLanguages().get("mul");
    }

    public static void main(String[] args) {
        for (LanguageCode c : ISO639_3.loadFromTabFile().values()) {
            System.out.println(c);
        }
    }

    public static final class LanguageCode
    implements Comparable<LanguageCode> {
        public final String id;
        public final String part2B;
        public final String part2T;
        public final String part1;
        public final Scope scope;
        public final Type type;
        public final String referenceName;
        public final String comment;

        private LanguageCode(char[] myId, char[] myPart2B, char[] myPart2T, char[] myPart1, Scope myScope, Type myType, String myReferenceName, String myComment) {
            if (myId == null) {
                throw new NullPointerException();
            }
            if (myId.length > 3) {
                throw new IllegalArgumentException();
            }
            if (myPart2B != null && myPart2B.length > 3) {
                throw new IllegalArgumentException();
            }
            if (myPart2T != null && myPart2T.length > 3) {
                throw new IllegalArgumentException();
            }
            if (myPart1 != null && myPart1.length > 2) {
                throw new IllegalArgumentException();
            }
            if (myScope == null) {
                throw new NullPointerException();
            }
            if (myType == null) {
                throw new NullPointerException();
            }
            if (myReferenceName == null) {
                throw new NullPointerException();
            }
            if (myReferenceName.length() > 150) {
                throw new IllegalArgumentException();
            }
            if (myComment != null && myComment.length() > 150) {
                throw new IllegalArgumentException();
            }
            this.id = new String(myId).toLowerCase();
            this.part2B = new String(myPart2B).toLowerCase();
            this.part2T = new String(myPart2T).toLowerCase();
            this.part1 = new String(myPart1).toLowerCase();
            this.scope = myScope;
            this.type = myType;
            this.referenceName = myReferenceName;
            this.comment = myComment;
        }

        public boolean equals(LanguageCode other) {
            return this.id.equals(other.id);
        }

        public boolean equals(Object o) {
            if (!(o instanceof LanguageCode)) {
                return false;
            }
            return this.equals((LanguageCode)o);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        @Override
        public int compareTo(LanguageCode o) {
            return this.id.compareTo(o.id);
        }

        public String toString() {
            return new String(this.id) + " = " + this.referenceName + " (scope: " + (Object)((Object)this.scope) + "; type: " + (Object)((Object)this.type) + ")";
        }

        public static enum Type {
            Ancient,
            Constructed,
            Extinct,
            Historical,
            Living,
            Special;


            private static Type fromTabFile(String abbreviation) {
                if (abbreviation.equals("A")) {
                    return Ancient;
                }
                if (abbreviation.equals("C")) {
                    return Constructed;
                }
                if (abbreviation.equals("E")) {
                    return Extinct;
                }
                if (abbreviation.equals("H")) {
                    return Historical;
                }
                if (abbreviation.equals("L")) {
                    return Living;
                }
                if (abbreviation.equals("S")) {
                    return Special;
                }
                throw new IllegalArgumentException("Unknwon type abbreviation: " + abbreviation);
            }
        }

        public static enum Scope {
            Individual,
            Macrolanguage,
            Special;


            private static Scope fromTabFile(String abbreviation) {
                if (abbreviation.equals("I")) {
                    return Individual;
                }
                if (abbreviation.equals("M")) {
                    return Macrolanguage;
                }
                if (abbreviation.equals("S")) {
                    return Special;
                }
                throw new IllegalArgumentException("Unknown scope abbreviation: " + abbreviation);
            }
        }
    }
}

