/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.OOMHandler;

public class DNSRequester
implements Runnable {
    final Node node;
    private long lastLogTime;
    static boolean DISABLE = false;
    private static volatile boolean logMINOR;

    DNSRequester(Node node) {
        this.node = node;
    }

    void start() {
        Logger.normal(this, "Starting DNSRequester");
        System.out.println("Starting DNSRequester");
        this.node.executor.execute(this, "DNSRequester thread for " + this.node.getDarknetPortNumber());
    }

    @Override
    public void run() {
        Logger.OSThread.logPID(this);
        while (true) {
            try {
                while (true) {
                    this.realRun();
                }
            }
            catch (OutOfMemoryError e) {
                OOMHandler.handleOOM(e);
                System.err.println("Will retry above failed operation...");
                continue;
            }
            catch (Throwable t) {
                Logger.error(this, "Caught in DNSRequester: " + t, t);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realRun() {
        PeerNode[] nodes = this.node.peers.myPeers();
        long now = System.currentTimeMillis();
        if (now - this.lastLogTime > 1000L) {
            if (logMINOR) {
                Logger.minor(this, "Processing DNS Requests (log rate-limited)");
            }
            this.lastLogTime = now;
        }
        for (PeerNode pn : nodes) {
            if (pn.isConnected()) continue;
            pn.maybeUpdateHandshakeIPs(false);
        }
        try {
            DNSRequester dNSRequester = this;
            synchronized (dNSRequester) {
                this.wait(10000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceRun() {
        DNSRequester dNSRequester = this;
        synchronized (dNSRequester) {
            this.notifyAll();
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

