/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.BlockCipher;
import freenet.crypt.DHGroup;
import freenet.crypt.DSA;
import freenet.crypt.DSAGroup;
import freenet.crypt.DSASignature;
import freenet.crypt.DiffieHellman;
import freenet.crypt.DiffieHellmanLightContext;
import freenet.crypt.ECDH;
import freenet.crypt.ECDHLightContext;
import freenet.crypt.ECDSA;
import freenet.crypt.Global;
import freenet.crypt.HMAC;
import freenet.crypt.KeyAgreementSchemeContext;
import freenet.crypt.PCFBMode;
import freenet.crypt.SHA256;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.Util;
import freenet.crypt.ciphers.Rijndael;
import freenet.io.AddressTracker;
import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.IncomingPacketFilter;
import freenet.io.comm.PacketSocketHandler;
import freenet.io.comm.Peer;
import freenet.io.comm.PeerContext;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.io.comm.SocketHandler;
import freenet.l10n.NodeL10n;
import freenet.node.DarknetPeerNode;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.NodeCrypto;
import freenet.node.OpennetManager;
import freenet.node.OutgoingPacketMangler;
import freenet.node.PeerNode;
import freenet.node.PrioRunnable;
import freenet.node.SeedClientPeerNode;
import freenet.node.useralerts.UserAlert;
import freenet.support.ByteArrayWrapper;
import freenet.support.Fields;
import freenet.support.HexUtil;
import freenet.support.LRUMap;
import freenet.support.Logger;
import freenet.support.SerialExecutor;
import freenet.support.SimpleFieldSet;
import freenet.support.TimeUtil;
import freenet.support.io.FileUtil;
import freenet.support.io.InetAddressComparator;
import freenet.support.io.NativeThread;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import net.i2p.util.NativeBigInteger;

public class FNPPacketMangler
implements OutgoingPacketMangler {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private final Node node;
    private final NodeCrypto crypto;
    private final PacketSocketHandler sock;
    private final HashMap<ByteArrayWrapper, byte[]> authenticatorCache;
    private static final byte[] JFK_PREFIX_INITIATOR;
    private static final byte[] JFK_PREFIX_RESPONDER;
    public static final int DH_GENERATION_INTERVAL = 30000;
    public static final int DH_CONTEXT_BUFFER_SIZE = 20;
    private final LinkedList<DiffieHellmanLightContext> dhContextFIFO = new LinkedList();
    private DiffieHellmanLightContext dhContextToBePrunned = null;
    private static final DHGroup dhGroupToUse;
    private long jfkDHLastGenerationTimestamp = 0L;
    private final LinkedList<ECDHLightContext> ecdhContextFIFO = new LinkedList();
    private ECDHLightContext ecdhContextToBePrunned;
    private static final ECDH.Curves ecdhCurveToUse;
    private long jfkECDHLastGenerationTimestamp = 0L;
    private static final int RANDOM_BYTES_LENGTH = 12;
    private static final int HASH_LENGTH;
    private static final int TRANSIENT_KEY_SIZE;
    private final byte[] transientKey = new byte[TRANSIENT_KEY_SIZE];
    public static final long TRANSIENT_KEY_REKEYING_MIN_INTERVAL;
    public static final long SESSION_KEY_REKEYING_INTERVAL;
    public static final long MAX_SESSION_KEY_REKEYING_DELAY;
    public static final int AMOUNT_OF_BYTES_ALLOWED_BEFORE_WE_REKEY = 0x40000000;
    private final Runnable transientKeyRekeyer = new Runnable(){

        @Override
        public void run() {
            FNPPacketMangler.this.maybeResetTransientKey();
        }
    };
    private static final int HEADERS_LENGTH_MINIMUM;
    public static final int HEADERS_LENGTH_ONE_MESSAGE;
    private long lastConnectivityStatusUpdate;
    private AddressTracker.Status lastConnectivityStatus;
    static final byte SETUP_OPENNET_SEEDNODE = 1;
    private final SerialExecutor authHandlingThread = new SerialExecutor(NativeThread.HIGH_PRIORITY, 1000);
    private long lastLoggedNoContexts = -1L;
    private static long LOG_NO_CONTEXTS_INTERVAL;
    private final LRUMap<InetAddress, Long> throttleRekeysByIP = LRUMap.createSafeMap(InetAddressComparator.COMPARATOR);
    private static final int REKEY_BY_IP_TABLE_SIZE = 1024;
    private static final int MAX_NONCES_PER_PEER = 10;
    static UserAlert BCPROV_LOAD_FAILED;
    private long timeLastReset = -1L;

    public FNPPacketMangler(Node node, NodeCrypto crypt, PacketSocketHandler sock) {
        this.node = node;
        this.crypto = crypt;
        this.sock = sock;
        this.authenticatorCache = new HashMap();
    }

    public void start() {
        int i;
        this.maybeResetTransientKey();
        for (i = 0; i < 20; ++i) {
            this._fillJFKDHFIFO();
        }
        for (i = 0; i < 20; ++i) {
            this._fillJFKECDHFIFO();
        }
        this.authHandlingThread.start(this.node.executor, "FNP incoming auth packet handler thread");
    }

    public IncomingPacketFilter.DECODED process(byte[] buf, int offset, int length, Peer peer, long now) {
        PeerNode opn = this.node.peers.getByPeer(peer);
        return this.process(buf, offset, length, peer, opn, now);
    }

    public IncomingPacketFilter.DECODED process(byte[] buf, int offset, int length, Peer peer, PeerNode opn, long now) {
        boolean didntTryOldOpennetPeers;
        boolean wantAnonAuthChangeIP;
        if (opn != null && opn.getOutgoingMangler() != this) {
            Logger.error(this, "Apparently contacted by " + opn + ") on " + this, (Throwable)new Exception("error"));
            opn = null;
        }
        boolean wantAnonAuth = this.crypto.wantAnonAuth();
        if (opn != null) {
            if (logMINOR) {
                Logger.minor(this, "Trying exact match");
            }
            if (length > 32 + HASH_LENGTH + 2 && !this.node.isStopping()) {
                if (this.tryProcessAuth(buf, offset, length, opn, peer, false, now)) {
                    return IncomingPacketFilter.DECODED.DECODED;
                }
                if (this.tryProcessAuthAnonReply(buf, offset, length, opn, peer, now)) {
                    return IncomingPacketFilter.DECODED.DECODED;
                }
            }
        }
        PeerNode[] peers = this.crypto.getPeerNodes();
        if (this.node.isStopping()) {
            return IncomingPacketFilter.DECODED.SHUTTING_DOWN;
        }
        if (length > 32 + HASH_LENGTH + 2) {
            for (PeerNode pn : peers) {
                if (pn == opn) continue;
                if (logDEBUG) {
                    Logger.debug(this, "Trying auth with " + pn);
                }
                if (this.tryProcessAuth(buf, offset, length, pn, peer, false, now)) {
                    return IncomingPacketFilter.DECODED.DECODED;
                }
                if (!pn.handshakeUnknownInitiator() || !this.tryProcessAuthAnonReply(buf, offset, length, pn, peer, now)) continue;
                return IncomingPacketFilter.DECODED.DECODED;
            }
        }
        boolean bl = wantAnonAuthChangeIP = wantAnonAuth && this.crypto.wantAnonAuthChangeIP();
        if (wantAnonAuth && wantAnonAuthChangeIP && this.checkAnonAuthChangeIP(opn, buf, offset, length, peer, now)) {
            return IncomingPacketFilter.DECODED.DECODED;
        }
        OpennetManager opennet = this.node.getOpennet();
        if (opennet != null) {
            if (opennet.wantPeer(null, false, true, true, OpennetManager.ConnectionType.RECONNECT)) {
                for (PeerNode oldPeer : opennet.getOldPeers()) {
                    if (!this.tryProcessAuth(buf, offset, length, oldPeer, peer, true, now)) continue;
                    return IncomingPacketFilter.DECODED.DECODED;
                }
                didntTryOldOpennetPeers = false;
            } else {
                didntTryOldOpennetPeers = true;
            }
        } else {
            didntTryOldOpennetPeers = false;
        }
        if (wantAnonAuth && this.tryProcessAuthAnon(buf, offset, length, peer)) {
            return IncomingPacketFilter.DECODED.DECODED;
        }
        if (wantAnonAuth && !wantAnonAuthChangeIP && this.checkAnonAuthChangeIP(opn, buf, offset, length, peer, now)) {
            return IncomingPacketFilter.DECODED.DECODED;
        }
        if (logMINOR && this.crypto.isOpennet && wantAnonAuth) {
            if (!didntTryOldOpennetPeers) {
                Logger.minor(this, "Unmatchable packet from " + peer);
            }
        } else {
            Logger.normal(this, "Unmatchable packet from " + peer);
        }
        if (!didntTryOldOpennetPeers) {
            return IncomingPacketFilter.DECODED.NOT_DECODED;
        }
        return IncomingPacketFilter.DECODED.DIDNT_WANT_OPENNET;
    }

    private boolean checkAnonAuthChangeIP(PeerNode opn, byte[] buf, int offset, int length, Peer peer, long now) {
        PeerNode[] anonPeers = this.crypto.getAnonSetupPeerNodes();
        if (length > 32 + HASH_LENGTH + 3) {
            for (PeerNode pn : anonPeers) {
                if (pn == opn || !this.tryProcessAuthAnonReply(buf, offset, length, pn, peer, now)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean tryProcessAuth(byte[] buf, int offset, int length, PeerNode pn, Peer peer, boolean oldOpennetPeer, long now) {
        int ivLength;
        int digestLength;
        BlockCipher authKey = pn.incomingSetupCipher;
        if (logDEBUG) {
            Logger.debug(this, "Decrypt key: " + HexUtil.bytesToHex(pn.incomingSetupKey) + " for " + peer + " : " + pn + " in tryProcessAuth");
        }
        if (length < (digestLength = HASH_LENGTH) + (ivLength = PCFBMode.lengthIV(authKey)) + 4) {
            if (logMINOR) {
                if (buf.length < length) {
                    if (logDEBUG) {
                        Logger.debug(this, "The packet is smaller than the decrypted size: it's probably the wrong tracker (" + buf.length + '<' + length + ')');
                    }
                } else {
                    Logger.minor(this, "Too short: " + length + " should be at least " + (digestLength + ivLength + 4));
                }
            }
            return false;
        }
        PCFBMode pcfb = PCFBMode.create(authKey, buf, offset);
        byte[] hash = Arrays.copyOfRange(buf, offset + ivLength, offset + ivLength + digestLength);
        pcfb.blockDecipher(hash, 0, hash.length);
        int dataStart = ivLength + digestLength + offset + 2;
        int byte1 = pcfb.decipher(buf[dataStart - 2]) & 0xFF;
        int byte2 = pcfb.decipher(buf[dataStart - 1]) & 0xFF;
        int dataLength = (byte1 << 8) + byte2;
        if (logDEBUG) {
            Logger.debug(this, "Data length: " + dataLength + " (1 = " + byte1 + " 2 = " + byte2 + ')');
        }
        if (dataLength > length - (ivLength + hash.length + 2)) {
            if (logDEBUG) {
                Logger.debug(this, "Invalid data length " + dataLength + " (" + (length - (ivLength + hash.length + 2)) + ") in tryProcessAuth");
            }
            return false;
        }
        byte[] payload = Arrays.copyOfRange(buf, dataStart, dataStart + dataLength);
        pcfb.blockDecipher(payload, 0, payload.length);
        byte[] realHash = SHA256.digest(payload);
        if (MessageDigest.isEqual(realHash, hash)) {
            this.processDecryptedAuth(payload, pn, peer, oldOpennetPeer);
            pn.reportIncomingBytes(length);
            return true;
        }
        if (logDEBUG) {
            Logger.debug(this, "Incorrect hash in tryProcessAuth for " + peer + " (length=" + dataLength + "): \nreal hash=" + HexUtil.bytesToHex(realHash) + "\n bad hash=" + HexUtil.bytesToHex(hash));
        }
        return false;
    }

    private boolean tryProcessAuthAnon(byte[] buf, int offset, int length, Peer peer) {
        int digestLength = HASH_LENGTH;
        BlockCipher authKey = this.crypto.getAnonSetupCipher();
        int ivLength = PCFBMode.lengthIV(authKey);
        if (length < digestLength + ivLength + 5) {
            if (logMINOR) {
                Logger.minor(this, "Too short: " + length + " should be at least " + (digestLength + ivLength + 5));
            }
            return false;
        }
        PCFBMode pcfb = PCFBMode.create(authKey, buf, offset);
        byte[] hash = Arrays.copyOfRange(buf, offset + ivLength, offset + ivLength + digestLength);
        pcfb.blockDecipher(hash, 0, hash.length);
        int dataStart = ivLength + digestLength + offset + 2;
        int byte1 = pcfb.decipher(buf[dataStart - 2]) & 0xFF;
        int byte2 = pcfb.decipher(buf[dataStart - 1]) & 0xFF;
        int dataLength = (byte1 << 8) + byte2;
        if (logMINOR) {
            Logger.minor(this, "Data length: " + dataLength + " (1 = " + byte1 + " 2 = " + byte2 + ')');
        }
        if (dataLength > length - (ivLength + hash.length + 2)) {
            if (logMINOR) {
                Logger.minor(this, "Invalid data length " + dataLength + " (" + (length - (ivLength + hash.length + 2)) + ") in tryProcessAuthAnon");
            }
            return false;
        }
        byte[] payload = Arrays.copyOfRange(buf, dataStart, dataStart + dataLength);
        pcfb.blockDecipher(payload, 0, payload.length);
        byte[] realHash = SHA256.digest(payload);
        if (MessageDigest.isEqual(realHash, hash)) {
            this.processDecryptedAuthAnon(payload, peer);
            return true;
        }
        if (logMINOR) {
            Logger.minor(this, "Incorrect hash in tryProcessAuthAnon for " + peer + " (length=" + dataLength + "): \nreal hash=" + HexUtil.bytesToHex(realHash) + "\n bad hash=" + HexUtil.bytesToHex(hash));
        }
        return false;
    }

    private boolean tryProcessAuthAnonReply(byte[] buf, int offset, int length, PeerNode pn, Peer peer, long now) {
        int digestLength = HASH_LENGTH;
        BlockCipher authKey = pn.anonymousInitiatorSetupCipher;
        int ivLength = PCFBMode.lengthIV(authKey);
        if (length < digestLength + ivLength + 5) {
            if (logDEBUG) {
                Logger.debug(this, "Too short: " + length + " should be at least " + (digestLength + ivLength + 5));
            }
            return false;
        }
        PCFBMode pcfb = PCFBMode.create(authKey, buf, offset);
        byte[] hash = Arrays.copyOfRange(buf, offset + ivLength, offset + ivLength + digestLength);
        pcfb.blockDecipher(hash, 0, hash.length);
        int dataStart = ivLength + digestLength + offset + 2;
        int byte1 = pcfb.decipher(buf[dataStart - 2]) & 0xFF;
        int byte2 = pcfb.decipher(buf[dataStart - 1]) & 0xFF;
        int dataLength = (byte1 << 8) + byte2;
        if (logDEBUG) {
            Logger.minor(this, "Data length: " + dataLength + " (1 = " + byte1 + " 2 = " + byte2 + ')');
        }
        if (dataLength > length - (ivLength + hash.length + 2)) {
            if (logDEBUG) {
                Logger.debug(this, "Invalid data length " + dataLength + " (" + (length - (ivLength + hash.length + 2)) + ") in tryProcessAuth");
            }
            return false;
        }
        byte[] payload = Arrays.copyOfRange(buf, dataStart, dataStart + dataLength);
        pcfb.blockDecipher(payload, 0, payload.length);
        byte[] realHash = SHA256.digest(payload);
        if (MessageDigest.isEqual(realHash, hash)) {
            this.processDecryptedAuthAnonReply(payload, peer, pn);
            return true;
        }
        if (logDEBUG) {
            Logger.debug(this, "Incorrect hash in tryProcessAuth for " + peer + " (length=" + dataLength + "): \nreal hash=" + HexUtil.bytesToHex(realHash) + "\n bad hash=" + HexUtil.bytesToHex(hash));
        }
        return false;
    }

    private void processDecryptedAuthAnon(final byte[] payload, final Peer replyTo) {
        if (logMINOR) {
            Logger.minor(this, "Processing decrypted auth packet from " + replyTo + " length " + payload.length);
        }
        byte version = payload[0];
        final byte negType = payload[1];
        final byte packetType = payload[2];
        final byte setupType = payload[3];
        if (logMINOR) {
            Logger.minor(this, "Received anonymous auth packet (phase=" + packetType + ", v=" + version + ", nt=" + negType + ", setup type=" + setupType + ") from " + replyTo + "");
        }
        if (version != 1) {
            Logger.error(this, "Decrypted auth packet but invalid version: " + version);
            return;
        }
        if (negType != 6 && negType != 7 && negType != 8 && negType != 9 && negType != 10) {
            if (negType > 10) {
                Logger.error(this, "Unknown neg type: " + negType);
            } else {
                Logger.warning(this, "Received a setup packet with unsupported obsolete neg type: " + negType);
            }
            return;
        }
        if (setupType != 1) {
            Logger.error(this, "Unknown setup type " + negType);
            return;
        }
        if (packetType == 0 || packetType == 2) {
            this.authHandlingThread.execute(new Runnable(){

                @Override
                public void run() {
                    if (packetType == 0) {
                        FNPPacketMangler.this.processJFKMessage1(payload, 4, null, replyTo, true, setupType, negType);
                    } else if (packetType == 2) {
                        FNPPacketMangler.this.processJFKMessage3(payload, 4, null, replyTo, false, true, setupType, negType);
                    }
                }
            });
        } else {
            Logger.error(this, "Invalid phase " + packetType + " for anonymous-initiator (we are the responder) from " + replyTo);
        }
    }

    private void processDecryptedAuthAnonReply(final byte[] payload, final Peer replyTo, final PeerNode pn) {
        if (logMINOR) {
            Logger.minor(this, "Processing decrypted auth packet from " + replyTo + " for " + pn + " length " + payload.length);
        }
        byte version = payload[0];
        final byte negType = payload[1];
        final byte packetType = payload[2];
        final byte setupType = payload[3];
        if (logMINOR) {
            Logger.minor(this, "Received anonymous auth packet (phase=" + packetType + ", v=" + version + ", nt=" + negType + ", setup type=" + setupType + ") from " + replyTo + "");
        }
        if (version != 1) {
            Logger.error(this, "Decrypted auth packet but invalid version: " + version);
            return;
        }
        if (negType != 6 && negType != 7 && negType != 8 && negType != 9 && negType != 10) {
            if (negType > 10) {
                Logger.error(this, "Unknown neg type: " + negType);
            } else {
                Logger.warning(this, "Received a setup packet with unsupported obsolete neg type: " + negType);
            }
            return;
        }
        if (setupType != 1) {
            Logger.error(this, "Unknown setup type " + negType);
            return;
        }
        if (packetType == 1 || packetType == 3) {
            this.authHandlingThread.execute(new Runnable(){

                @Override
                public void run() {
                    if (packetType == 1) {
                        FNPPacketMangler.this.processJFKMessage2(payload, 4, pn, replyTo, true, setupType, negType);
                    } else if (packetType == 3) {
                        FNPPacketMangler.this.processJFKMessage4(payload, 4, pn, replyTo, false, true, setupType, negType);
                    }
                }
            });
        } else {
            Logger.error(this, "Invalid phase " + packetType + " for anonymous-initiator (we are the initiator) from " + replyTo);
        }
    }

    private void processDecryptedAuth(final byte[] payload, final PeerNode pn, final Peer replyTo, final boolean oldOpennetPeer) {
        if (logMINOR) {
            Logger.minor(this, "Processing decrypted auth packet from " + replyTo + " for " + pn);
        }
        if (pn.isDisabled()) {
            if (logMINOR) {
                Logger.minor(this, "Won't connect to a disabled peer (" + pn + ')');
            }
            return;
        }
        final byte negType = payload[1];
        final byte packetType = payload[2];
        byte version = payload[0];
        if (logMINOR) {
            long now = System.currentTimeMillis();
            long last = pn.lastSentPacketTime();
            String delta = "never";
            if (last > 0L) {
                delta = TimeUtil.formatTime(now - last, 2, true) + " ago";
            }
            Logger.minor(this, "Received auth packet for " + pn.getPeer() + " (phase=" + packetType + ", v=" + version + ", nt=" + negType + ") (last packet sent " + delta + ") from " + replyTo + "");
        }
        if (version != 1) {
            Logger.error(this, "Decrypted auth packet but invalid version: " + version);
            return;
        }
        if (negType >= 0 && negType < 6) {
            Logger.warning(this, "Old neg type " + negType + " not supported");
            return;
        }
        if (negType == 6 || negType == 7 || negType == 8 || negType == 9 || negType == 10) {
            if (packetType < 0 || packetType > 3) {
                Logger.error(this, "Unknown PacketType" + packetType + "from" + replyTo + "from" + pn);
                return;
            }
        } else {
            Logger.error(this, "Decrypted auth packet but unknown negotiation type " + negType + " from " + replyTo + " possibly from " + pn);
            return;
        }
        this.authHandlingThread.execute(new Runnable(){

            @Override
            public void run() {
                if (packetType == 0) {
                    FNPPacketMangler.this.processJFKMessage1(payload, 3, pn, replyTo, false, -1, negType);
                } else if (packetType == 1) {
                    FNPPacketMangler.this.processJFKMessage2(payload, 3, pn, replyTo, false, -1, negType);
                } else if (packetType == 2) {
                    FNPPacketMangler.this.processJFKMessage3(payload, 3, pn, replyTo, oldOpennetPeer, false, -1, negType);
                } else if (packetType == 3) {
                    FNPPacketMangler.this.processJFKMessage4(payload, 3, pn, replyTo, oldOpennetPeer, false, -1, negType);
                }
            }
        });
    }

    private void processJFKMessage1(byte[] payload, int offset, PeerNode pn, Peer replyTo, boolean unknownInitiator, int setupType, int negType) {
        byte[] expectedIdentityHash;
        int nonceSize;
        long t1 = System.currentTimeMillis();
        int modulusLength = this.getModulusLength(negType);
        int n = nonceSize = negType < 9 ? this.getNonceSize(negType) : HASH_LENGTH;
        if (logMINOR) {
            Logger.minor(this, "Got a JFK(1) message, processing it - " + pn);
        }
        if (payload.length < nonceSize + modulusLength + 3 + (unknownInitiator ? 32 : 0)) {
            Logger.error(this, "Packet too short from " + pn + ": " + payload.length + " after decryption in JFK(1), should be " + (nonceSize + modulusLength));
            return;
        }
        byte[] nonceInitiator = new byte[nonceSize];
        System.arraycopy(payload, offset, nonceInitiator, 0, nonceSize);
        byte[] hisExponential = Arrays.copyOfRange(payload, offset += nonceSize, offset + modulusLength);
        if (unknownInitiator && !MessageDigest.isEqual(expectedIdentityHash = Arrays.copyOfRange(payload, offset += modulusLength, offset + 32), this.crypto.identityHash)) {
            Logger.error(this, "Invalid unknown-initiator JFK(1), IDr' is " + HexUtil.bytesToHex(expectedIdentityHash) + " should be " + HexUtil.bytesToHex(this.crypto.identityHash));
            return;
        }
        if (this.throttleRekey(pn, replyTo)) {
            return;
        }
        if (negType >= 8 || DiffieHellman.checkDHExponentialValidity(this.getClass(), new NativeBigInteger(1, hisExponential))) {
            try {
                this.sendJFKMessage2(nonceInitiator, hisExponential, pn, replyTo, unknownInitiator, setupType, negType);
            }
            catch (NoContextsException e) {
                this.handleNoContextsException(e, NoContextsException.CONTEXT.REPLYING);
                return;
            }
        } else {
            Logger.error(this, "We can't accept the exponential " + pn + " sent us!! REDFLAG: IT CAN'T HAPPEN UNLESS AGAINST AN ACTIVE ATTACKER!!");
        }
        long t2 = System.currentTimeMillis();
        if (t2 - t1 > 500L) {
            Logger.error(this, "Message1 timeout error:Processing packet for " + pn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNoContextsException(NoContextsException e, NoContextsException.CONTEXT context) {
        if (this.node.getUptime() < TimeUnit.SECONDS.toMillis(30L)) {
            Logger.warning(this, "No contexts available, unable to handle or send packet (" + (Object)((Object)context) + ") on " + this);
            return;
        }
        Logger.warning(this, "No contexts available " + (Object)((Object)context) + " - running out of entropy or severe CPU usage problems?");
        long now = System.currentTimeMillis();
        FNPPacketMangler fNPPacketMangler = this;
        synchronized (fNPPacketMangler) {
            if (now < this.lastLoggedNoContexts + LOG_NO_CONTEXTS_INTERVAL) {
                return;
            }
            this.lastLoggedNoContexts = now;
        }
        this.logLoudErrorNoContexts();
    }

    private void logLoudErrorNoContexts() {
        System.err.println("FREENET IS HAVING PROBLEMS CONNECTING: Either your CPU is overloaded or it is having trouble reading from the random number generator");
        System.err.println("If the problem is CPU usage, please shut down whatever applications are hogging the CPU.");
        if (FileUtil.detectedOS.isUnix) {
            File f = new File("/dev/hwrng");
            if (f.exists()) {
                System.err.println("Installing \"rngd\" might help (e.g. apt-get install rng-tools).");
            }
            System.err.println("The best solution is to install a hardware random number generator, or use turbid or similar software to take random data from an unconnected sound card.");
            System.err.println("The quick workaround is to add \"wrapper.java.additional.4=-Djava.security.egd=file:///dev/urandom\" to your wrapper.conf.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean throttleRekey(PeerNode pn, Peer replyTo) {
        if (pn != null) {
            return pn.throttleRekey();
        }
        long now = System.currentTimeMillis();
        InetAddress addr = replyTo.getAddress();
        LRUMap<InetAddress, Long> lRUMap = this.throttleRekeysByIP;
        synchronized (lRUMap) {
            Long l = this.throttleRekeysByIP.get(addr);
            if (l == null || l != null && now > l) {
                this.throttleRekeysByIP.push(addr, now);
            }
            while (this.throttleRekeysByIP.size() > 1024 || !this.throttleRekeysByIP.isEmpty() && this.throttleRekeysByIP.peekValue() < now - 1000L) {
                this.throttleRekeysByIP.popKey();
            }
            if (l != null && now - l < 1000L) {
                Logger.error(this, "Two JFK(1)'s initiated by same IP within 1000ms");
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendJFKMessage1(PeerNode pn, Peer replyTo, boolean unknownInitiator, int setupType, int negType) throws NoContextsException {
        if (logMINOR) {
            Logger.minor(this, "Sending a JFK(1) message to " + replyTo + " for " + pn.getPeer());
        }
        long now = System.currentTimeMillis();
        int modulusLength = this.getModulusLength(negType);
        int nonceSize = this.getNonceSize(negType);
        KeyAgreementSchemeContext ctx = pn.getKeyAgreementSchemeContext();
        if (negType < 8) {
            if (ctx == null || !(ctx instanceof DiffieHellmanLightContext) || pn.jfkContextLifetime + 600000L < now) {
                pn.jfkContextLifetime = now;
                ctx = this.getLightDiffieHellmanContext();
                pn.setKeyAgreementSchemeContext(ctx);
            }
        } else if (ctx == null || !(ctx instanceof ECDHLightContext) || pn.jfkContextLifetime + 600000L < now) {
            pn.jfkContextLifetime = now;
            ctx = this.getECDHLightContext();
            pn.setKeyAgreementSchemeContext(ctx);
        }
        int offset = 0;
        byte[] nonce = new byte[nonceSize];
        byte[] myExponential = ctx.getPublicKeyNetworkFormat();
        this.node.random.nextBytes(nonce);
        PeerNode peerNode = pn;
        synchronized (peerNode) {
            pn.jfkNoncesSent.add(nonce);
            if (pn.jfkNoncesSent.size() > 10) {
                pn.jfkNoncesSent.removeFirst();
            }
        }
        int nonceSizeHashed = negType > 8 ? HASH_LENGTH : nonceSize;
        byte[] message1 = new byte[nonceSizeHashed + modulusLength + (unknownInitiator ? 32 : 0)];
        System.arraycopy(negType > 8 ? SHA256.digest(nonce) : nonce, 0, message1, offset, nonceSizeHashed);
        System.arraycopy(myExponential, 0, message1, offset += nonceSizeHashed, modulusLength);
        if (unknownInitiator) {
            System.arraycopy(pn.identityHash, 0, message1, offset += modulusLength, pn.identityHash.length);
            this.sendAnonAuthPacket(1, negType, 0, setupType, message1, pn, replyTo, pn.anonymousInitiatorSetupCipher);
        } else {
            this.sendAuthPacket(1, negType, 0, message1, pn, replyTo);
        }
        long t2 = System.currentTimeMillis();
        if (t2 - now > 500L) {
            Logger.error(this, "Message1 timeout error:Sending packet for " + pn.getPeer());
        }
    }

    private void sendJFKMessage2(byte[] nonceInitator, byte[] hisExponential, PeerNode pn, Peer replyTo, boolean unknownInitiator, int setupType, int negType) throws NoContextsException {
        byte[] sig;
        if (logMINOR) {
            Logger.minor(this, "Sending a JFK(2) message to " + pn);
        }
        int modulusLength = this.getModulusLength(negType);
        int nonceSize = this.getNonceSize(negType);
        KeyAgreementSchemeContext ctx = negType < 8 ? this.getLightDiffieHellmanContext() : this.getECDHLightContext();
        byte[] myNonce = new byte[nonceSize];
        this.node.random.nextBytes(myNonce);
        byte[] myExponential = ctx.getPublicKeyNetworkFormat();
        byte[] byArray = sig = negType < 9 ? ctx.dsaSig : ctx.ecdsaSig;
        if (sig.length != this.getSignatureLength(negType)) {
            throw new IllegalStateException("This shouldn't happen: please report! We are attempting to send " + sig.length + " bytes of signature in JFK2! " + pn.getPeer());
        }
        byte[] authenticator = HMAC.macWithSHA256(this.getTransientKey(), this.assembleJFKAuthenticator(myExponential, hisExponential, myNonce, nonceInitator, replyTo.getAddress().getAddress()), HASH_LENGTH);
        if (logDEBUG) {
            Logger.debug(this, "We are using the following HMAC : " + HexUtil.bytesToHex(authenticator));
        }
        if (logDEBUG) {
            Logger.debug(this, "We have Ni' : " + HexUtil.bytesToHex(nonceInitator));
        }
        byte[] message2 = new byte[nonceInitator.length + nonceSize + modulusLength + sig.length + HASH_LENGTH];
        int offset = 0;
        System.arraycopy(nonceInitator, 0, message2, offset, nonceInitator.length);
        System.arraycopy(myNonce, 0, message2, offset += nonceInitator.length, myNonce.length);
        System.arraycopy(myExponential, 0, message2, offset += myNonce.length, modulusLength);
        System.arraycopy(sig, 0, message2, offset += modulusLength, sig.length);
        System.arraycopy(authenticator, 0, message2, offset += sig.length, HASH_LENGTH);
        if (unknownInitiator) {
            this.sendAnonAuthPacket(1, negType, 1, setupType, message2, pn, replyTo, this.crypto.anonSetupCipher);
        } else {
            this.sendAuthPacket(1, negType, 1, message2, pn, replyTo);
        }
    }

    private byte[] assembleJFKAuthenticator(byte[] gR, byte[] gI, byte[] nR, byte[] nI, byte[] address) {
        byte[] authData = new byte[gR.length + gI.length + nR.length + nI.length + address.length];
        int offset = 0;
        System.arraycopy(gR, 0, authData, offset, gR.length);
        System.arraycopy(gI, 0, authData, offset += gR.length, gI.length);
        System.arraycopy(nR, 0, authData, offset += gI.length, nR.length);
        System.arraycopy(nI, 0, authData, offset += nR.length, nI.length);
        System.arraycopy(address, 0, authData, offset += nI.length, address.length);
        return authData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJFKMessage2(byte[] payload, int inputOffset, PeerNode pn, Peer replyTo, boolean unknownInitiator, int setupType, int negType) {
        int expectedLength;
        int nonceSizeHashed;
        long t1 = System.currentTimeMillis();
        int modulusLength = this.getModulusLength(negType);
        int nonceSize = this.getNonceSize(negType);
        int n = nonceSizeHashed = negType > 8 ? HASH_LENGTH : nonceSize;
        if (logMINOR) {
            Logger.minor(this, "Got a JFK(2) message, processing it - " + pn.getPeer());
        }
        if (payload.length < (expectedLength = nonceSizeHashed + nonceSize + modulusLength + HASH_LENGTH * 2) + 3) {
            Logger.error(this, "Packet too short from " + pn.getPeer() + ": " + payload.length + " after decryption in JFK(2), should be " + (expectedLength + 3));
            return;
        }
        byte[] nonceInitiator = new byte[nonceSizeHashed];
        System.arraycopy(payload, inputOffset, nonceInitiator, 0, nonceSizeHashed);
        byte[] nonceResponder = new byte[nonceSize];
        System.arraycopy(payload, inputOffset += nonceSizeHashed, nonceResponder, 0, nonceSize);
        byte[] hisExponential = Arrays.copyOfRange(payload, inputOffset += nonceSize, inputOffset + modulusLength);
        int sigLength = this.getSignatureLength(negType);
        byte[] sig = new byte[sigLength];
        System.arraycopy(payload, inputOffset += modulusLength, sig, 0, sigLength);
        byte[] authenticator = Arrays.copyOfRange(payload, inputOffset += sigLength, inputOffset + HASH_LENGTH);
        inputOffset += HASH_LENGTH;
        byte[] message3 = null;
        HashMap<ByteArrayWrapper, byte[]> hashMap = this.authenticatorCache;
        synchronized (hashMap) {
            message3 = this.authenticatorCache.get(new ByteArrayWrapper(authenticator));
        }
        if (message3 != null) {
            Logger.normal(this, "We replayed a message from the cache (shouldn't happen often) - " + pn.getPeer());
            this.sendAuthPacket(1, negType, 3, message3, pn, replyTo);
            return;
        }
        byte[] myNi = null;
        PeerNode peerNode = pn;
        synchronized (peerNode) {
            for (byte[] buf : pn.jfkNoncesSent) {
                if (!MessageDigest.isEqual(nonceInitiator, negType > 8 ? SHA256.digest(buf) : buf)) continue;
                myNi = buf;
            }
        }
        if (myNi == null) {
            if (this.shouldLogErrorInHandshake(t1)) {
                Logger.normal(this, "We received an unexpected JFK(2) message from " + pn.getPeer() + " (time since added: " + pn.timeSinceAddedOrRestarted() + " time last receive:" + pn.lastReceivedPacketTime() + ')');
            }
            return;
        }
        if (negType < 8) {
            NativeBigInteger _hisExponential = new NativeBigInteger(1, hisExponential);
            if (!DiffieHellman.checkDHExponentialValidity(this.getClass(), _hisExponential)) {
                Logger.error(this, "We can't accept the exponential " + pn.getPeer() + " sent us!! REDFLAG: IT CAN'T HAPPEN UNLESS AGAINST AN ACTIVE ATTACKER!!");
                return;
            }
        }
        if (negType < 9) {
            byte[] r = new byte[32];
            byte[] s = new byte[32];
            System.arraycopy(sig, 0, r, 0, 32);
            System.arraycopy(sig, 32, s, 0, 32);
            DSASignature remoteSignature = new DSASignature(new NativeBigInteger(1, r), new NativeBigInteger(1, s));
            byte[] locallyExpectedExponentials = this.assembleDHParams(hisExponential, pn.peerCryptoGroup);
            if (!DSA.verify(pn.peerPubKey, remoteSignature, new NativeBigInteger(1, SHA256.digest(locallyExpectedExponentials)), false)) {
                Logger.error(this, "The signature verification has failed in JFK(2)!! " + pn.getPeer());
                return;
            }
        } else if (!ECDSA.verify(ECDSA.Curves.P256, pn.peerECDSAPubKey(), sig, new byte[][]{hisExponential})) {
            if (pn.peerECDSAPubKeyHash() == null) {
                Logger.error(this, "Peer attempting negType " + negType + " with ECDSA but no ECDSA key known: " + pn.userToString());
                return;
            }
            Logger.error(this, "The ECDSA signature verification has failed in JFK(2)!! " + pn.getPeer());
            if (logDEBUG) {
                Logger.debug(this, "Expected signature on " + HexUtil.bytesToHex(hisExponential) + " with " + HexUtil.bytesToHex(pn.peerECDSAPubKeyHash()) + " signature " + HexUtil.bytesToHex(sig));
            }
            return;
        }
        pn.receivedPacket(true, false);
        this.sendJFKMessage3(1, negType, 3, myNi, nonceResponder, hisExponential, authenticator, pn, replyTo, unknownInitiator, setupType);
        long t2 = System.currentTimeMillis();
        if (t2 - t1 > 500L) {
            Logger.error(this, "Message2 timeout error:Processing packet for " + pn.getPeer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJFKMessage3(byte[] payload, int inputOffset, PeerNode pn, Peer replyTo, boolean oldOpennetPeer, boolean unknownInitiator, int setupType, int negType) {
        long t2;
        int ourInitialMsgID;
        int theirInitialMsgID;
        byte[] computedExponential;
        KeyAgreementSchemeContext ctx;
        long t1 = System.currentTimeMillis();
        int modulusLength = this.getModulusLength(negType);
        int nonceSize = this.getNonceSize(negType);
        if (logMINOR) {
            Logger.minor(this, "Got a JFK(3) message, processing it - " + pn);
        }
        Rijndael c = null;
        try {
            c = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            throw new RuntimeException(e);
        }
        int expectedLength = nonceSize * 2 + modulusLength * 2 + HASH_LENGTH + HASH_LENGTH + (c.getBlockSize() >> 3) + HASH_LENGTH + 8 + 8 + 1;
        if (payload.length < expectedLength + 3) {
            Logger.error(this, "Packet too short from " + pn + ": " + payload.length + " after decryption in JFK(3), should be " + (expectedLength + 3));
            return;
        }
        byte[] nonceInitiator = new byte[nonceSize];
        System.arraycopy(payload, inputOffset, nonceInitiator, 0, nonceSize);
        inputOffset += nonceSize;
        if (logDEBUG) {
            Logger.debug(this, "We are receiving Ni : " + HexUtil.bytesToHex(nonceInitiator));
        }
        byte[] nonceInitiatorHashed = negType > 8 ? SHA256.digest(nonceInitiator) : nonceInitiator;
        byte[] nonceResponder = new byte[nonceSize];
        System.arraycopy(payload, inputOffset, nonceResponder, 0, nonceSize);
        byte[] initiatorExponential = Arrays.copyOfRange(payload, inputOffset += nonceSize, inputOffset + modulusLength);
        byte[] responderExponential = Arrays.copyOfRange(payload, inputOffset += modulusLength, inputOffset + modulusLength);
        byte[] authenticator = Arrays.copyOfRange(payload, inputOffset += modulusLength, inputOffset + HASH_LENGTH);
        inputOffset += HASH_LENGTH;
        if (!HMAC.verifyWithSHA256(this.getTransientKey(), this.assembleJFKAuthenticator(responderExponential, initiatorExponential, nonceResponder, nonceInitiatorHashed, replyTo.getAddress().getAddress()), authenticator)) {
            if (this.shouldLogErrorInHandshake(t1)) {
                if (logDEBUG) {
                    Logger.debug(this, "We received the following HMAC : " + HexUtil.bytesToHex(authenticator));
                }
                if (logDEBUG) {
                    Logger.debug(this, "We have Ni' : " + HexUtil.bytesToHex(nonceInitiatorHashed));
                }
                Logger.normal(this, "The HMAC doesn't match; let's discard the packet (either we rekeyed or we are victim of forgery) - JFK3 - " + pn);
            }
            return;
        }
        byte[] message4 = null;
        HashMap<ByteArrayWrapper, byte[]> hashMap = this.authenticatorCache;
        synchronized (hashMap) {
            message4 = this.authenticatorCache.get(new ByteArrayWrapper(authenticator));
        }
        if (message4 != null) {
            Logger.normal(this, "We replayed a message from the cache (shouldn't happen often) - " + pn);
            if (unknownInitiator) {
                this.sendAnonAuthPacket(1, negType, 3, setupType, message4, null, replyTo, this.crypto.anonSetupCipher);
            } else {
                this.sendAuthPacket(1, negType, 3, message4, pn, replyTo);
            }
            return;
        }
        if (logDEBUG) {
            Logger.debug(this, "No message4 found for " + HexUtil.bytesToHex(authenticator) + " responderExponential " + Fields.hashCode(responderExponential) + " initiatorExponential " + Fields.hashCode(initiatorExponential) + " nonceResponder " + Fields.hashCode(nonceResponder) + " nonceInitiator " + Fields.hashCode(nonceInitiatorHashed) + " address " + HexUtil.bytesToHex(replyTo.getAddress().getAddress()));
        }
        byte[] hmac = Arrays.copyOfRange(payload, inputOffset, inputOffset + HASH_LENGTH);
        inputOffset += HASH_LENGTH;
        if (negType < 8) {
            NativeBigInteger _hisExponential = new NativeBigInteger(1, initiatorExponential);
            NativeBigInteger _ourExponential = new NativeBigInteger(1, responderExponential);
            ctx = this.findContextByExponential(_ourExponential);
            if (ctx == null) {
                Logger.error(this, "WTF? the HMAC verified but we don't know about that exponential! SHOULDN'T HAPPEN! - JFK3 - " + pn);
                return;
            }
            computedExponential = ((DiffieHellmanLightContext)ctx).getHMACKey(_hisExponential);
        } else {
            ECPublicKey initiatorKey = ECDH.getPublicKey(initiatorExponential, ecdhCurveToUse);
            ECPublicKey responderKey = ECDH.getPublicKey(responderExponential, ecdhCurveToUse);
            ctx = this.findECDHContextByPubKey(responderKey);
            if (ctx == null) {
                Logger.error(this, "WTF? the HMAC verified but we don't know about that exponential! SHOULDN'T HAPPEN! - JFK3 - " + pn);
                return;
            }
            computedExponential = ((ECDHLightContext)ctx).getHMACKey(initiatorKey);
        }
        if (logDEBUG) {
            Logger.debug(this, "The shared Master secret is : " + HexUtil.bytesToHex(computedExponential) + " for " + pn);
        }
        byte[] outgoingKey = this.computeJFKSharedKey(computedExponential, nonceInitiatorHashed, nonceResponder, "7");
        byte[] incommingKey = this.computeJFKSharedKey(computedExponential, nonceInitiatorHashed, nonceResponder, "0");
        byte[] Ke = this.computeJFKSharedKey(computedExponential, nonceInitiatorHashed, nonceResponder, "1");
        byte[] Ka = this.computeJFKSharedKey(computedExponential, nonceInitiatorHashed, nonceResponder, "2");
        byte[] hmacKey = this.computeJFKSharedKey(computedExponential, nonceInitiatorHashed, nonceResponder, "3");
        byte[] ivKey = this.computeJFKSharedKey(computedExponential, nonceInitiatorHashed, nonceResponder, "4");
        byte[] ivNonce = this.computeJFKSharedKey(computedExponential, nonceInitiatorHashed, nonceResponder, "5");
        byte[] sharedData = this.computeJFKSharedKey(computedExponential, nonceInitiatorHashed, nonceResponder, "6");
        Arrays.fill(computedExponential, (byte)0);
        int theirInitialSeqNum = (sharedData[0] & 0xFF) << 24 | (sharedData[1] & 0xFF) << 16 | (sharedData[2] & 0xFF) << 8 | sharedData[3] & 0xFF;
        int ourInitialSeqNum = (sharedData[4] & 0xFF) << 24 | (sharedData[5] & 0xFF) << 16 | (sharedData[6] & 0xFF) << 8 | sharedData[7] & 0xFF;
        if (negType >= 7) {
            theirInitialMsgID = unknownInitiator ? this.getInitialMessageID(this.crypto.myIdentity) : this.getInitialMessageID(pn.identity, this.crypto.myIdentity);
            ourInitialMsgID = unknownInitiator ? this.getInitialMessageID(this.crypto.myIdentity) : this.getInitialMessageID(this.crypto.myIdentity, pn.identity);
        } else {
            theirInitialMsgID = (sharedData[8] & 0xFF) << 24 | (sharedData[9] & 0xFF) << 16 | (sharedData[10] & 0xFF) << 8 | sharedData[11] & 0xFF;
            ourInitialMsgID = (sharedData[12] & 0xFF) << 24 | (sharedData[13] & 0xFF) << 16 | (sharedData[14] & 0xFF) << 8 | sharedData[15] & 0xFF;
        }
        if (logMINOR) {
            Logger.minor(this, "Their initial message ID: " + theirInitialMsgID + " ours " + ourInitialMsgID);
        }
        c.initialize(Ke);
        int ivLength = PCFBMode.lengthIV(c);
        int decypheredPayloadOffset = 0;
        byte[] decypheredPayload = Arrays.copyOf(JFK_PREFIX_INITIATOR, JFK_PREFIX_INITIATOR.length + payload.length - inputOffset);
        System.arraycopy(payload, inputOffset, decypheredPayload, decypheredPayloadOffset += JFK_PREFIX_INITIATOR.length, decypheredPayload.length - decypheredPayloadOffset);
        if (!HMAC.verifyWithSHA256(Ka, decypheredPayload, hmac)) {
            Logger.error(this, "The inner-HMAC doesn't match; let's discard the packet JFK(3) - " + pn);
            return;
        }
        PCFBMode pk = PCFBMode.create(c, decypheredPayload, decypheredPayloadOffset);
        pk.blockDecipher(decypheredPayload, decypheredPayloadOffset += ivLength, decypheredPayload.length - decypheredPayloadOffset);
        int sigLength = this.getSignatureLength(negType);
        byte[] sig = new byte[sigLength];
        System.arraycopy(decypheredPayload, decypheredPayloadOffset, sig, 0, sigLength);
        byte[] data = new byte[decypheredPayload.length - (decypheredPayloadOffset += sigLength)];
        System.arraycopy(decypheredPayload, decypheredPayloadOffset, data, 0, decypheredPayload.length - decypheredPayloadOffset);
        int ptr = 0;
        long trackerID = Fields.bytesToLong(data, ptr);
        if (trackerID < 0L) {
            trackerID = -1L;
        }
        long bootID = Fields.bytesToLong(data, ptr += 8);
        byte[] hisRef = Arrays.copyOfRange(data, ptr += 8, data.length);
        if (unknownInitiator) {
            pn = this.getPeerNodeFromUnknownInitiator(hisRef, setupType, pn, replyTo);
        }
        if (pn == null) {
            if (unknownInitiator) {
                Logger.normal(this, "Rejecting... unable to construct PeerNode");
            } else {
                Logger.error(this, "PeerNode is null and unknownInitiator is false!");
            }
            return;
        }
        byte[] toVerify = this.assembleDHParams(nonceInitiatorHashed, nonceResponder, initiatorExponential, responderExponential, this.crypto.getIdentity(negType, false), data);
        if (negType < 9) {
            byte[] r = new byte[32];
            System.arraycopy(sig, 0, r, 0, 32);
            byte[] s = new byte[32];
            System.arraycopy(sig, 32, s, 0, 32);
            DSASignature remoteSignature = new DSASignature(new NativeBigInteger(1, r), new NativeBigInteger(1, s));
            if (!DSA.verify(pn.peerPubKey, remoteSignature, new NativeBigInteger(1, SHA256.digest(toVerify)), false)) {
                Logger.error(this, "The signature verification has failed!! JFK(3) - " + pn.getPeer());
                return;
            }
        } else if (!ECDSA.verify(ECDSA.Curves.P256, pn.peerECDSAPubKey(), sig, new byte[][]{toVerify})) {
            Logger.error(this, "The ECDSA signature verification has failed!! JFK(3) - " + pn.getPeer());
            return;
        }
        pn.receivedPacket(true, false);
        Rijndael outgoingCipher = null;
        Rijndael incommingCipher = null;
        Rijndael ivCipher = null;
        try {
            outgoingCipher = new Rijndael(256, 256);
            incommingCipher = new Rijndael(256, 256);
            ivCipher = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            throw new RuntimeException(e);
        }
        outgoingCipher.initialize(outgoingKey);
        incommingCipher.initialize(incommingKey);
        ivCipher.initialize(ivKey);
        boolean dontWant = false;
        if (oldOpennetPeer) {
            OpennetManager opennet = this.node.getOpennet();
            if (opennet == null) {
                Logger.normal(this, "Dumping incoming old-opennet peer as opennet just turned off: " + pn + ".");
                return;
            }
            if (!opennet.wantPeer(pn, false, false, true, OpennetManager.ConnectionType.RECONNECT)) {
                Logger.normal(this, "No longer want peer " + pn + " - dumping it after connecting");
                dontWant = true;
                opennet.purgeOldOpennetPeer(pn);
            }
        }
        if (!dontWant && !this.crypto.allowConnection(pn, replyTo.getFreenetAddress())) {
            if (pn instanceof DarknetPeerNode) {
                Logger.error(this, "Dropping peer " + pn + " because don't want connection due to others on the same IP address!");
                System.out.println("Disconnecting permanently from your friend \"" + ((DarknetPeerNode)pn).getName() + "\" because other peers are using the same IP address!");
            }
            Logger.normal(this, "Rejecting connection because already have something with the same IP");
            dontWant = true;
        }
        long newTrackerID = pn.completedHandshake(bootID, hisRef, 0, hisRef.length, outgoingCipher, outgoingKey, incommingCipher, incommingKey, replyTo, true, negType, trackerID, false, false, hmacKey, ivCipher, ivNonce, ourInitialSeqNum, theirInitialSeqNum, ourInitialMsgID, theirInitialMsgID);
        pn.setAcknowledgeType(negType);
        if (newTrackerID > 0L) {
            this.sendJFKMessage4(1, negType, 3, nonceInitiatorHashed, nonceResponder, initiatorExponential, responderExponential, c, Ke, Ka, authenticator, hisRef, pn, replyTo, unknownInitiator, setupType, newTrackerID, newTrackerID == trackerID);
            if (dontWant) {
                this.node.peers.disconnectAndRemove(pn, true, true, true);
            } else {
                pn.maybeSendInitialMessages();
            }
        } else {
            Logger.error(this, "Handshake failure! with " + pn.getPeer());
        }
        if (logMINOR) {
            Logger.minor(this, "Seed client connected with negtype " + negType);
        }
        if ((t2 = System.currentTimeMillis()) - t1 > 500L) {
            Logger.error(this, "Message3 Processing packet for " + pn.getPeer() + " took " + TimeUtil.formatTime(t2 - t1, 3, true));
        }
    }

    private PeerNode getPeerNodeFromUnknownInitiator(byte[] hisRef, int setupType, PeerNode pn, Peer from) {
        if (setupType == 1) {
            SeedClientPeerNode seed;
            OpennetManager om = this.node.getOpennet();
            if (om == null) {
                Logger.error(this, "Opennet disabled, ignoring seednode connect attempt");
                return null;
            }
            SimpleFieldSet ref = OpennetManager.validateNoderef(hisRef, 0, hisRef.length, null, true);
            if (ref == null) {
                Logger.error(this, "Invalid noderef");
                return null;
            }
            try {
                seed = new SeedClientPeerNode(ref, this.node, this.crypto, this.node.peers, false, true, this.crypto.packetMangler);
            }
            catch (FSParseException e) {
                Logger.error(this, "Invalid seed client noderef: " + e + " from " + from, (Throwable)e);
                return null;
            }
            catch (PeerParseException e) {
                Logger.error(this, "Invalid seed client noderef: " + e + " from " + from, (Throwable)e);
                return null;
            }
            catch (ReferenceSignatureVerificationException e) {
                Logger.error(this, "Invalid seed client noderef: " + e + " from " + from, (Throwable)e);
                return null;
            }
            if (((PeerNode)seed).equals(pn)) {
                Logger.normal(this, "Already connected to seednode");
                return pn;
            }
            this.node.peers.addPeer(seed);
            return seed;
        }
        Logger.error(this, "Unknown setup type");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processJFKMessage4(byte[] payload, int inputOffset, PeerNode pn, Peer replyTo, boolean oldOpennetPeer, boolean unknownInitiator, int setupType, int negType) {
        long t1 = System.currentTimeMillis();
        int modulusLength = this.getModulusLength(negType);
        int signLength = this.getSignatureLength(negType);
        if (logMINOR) {
            Logger.minor(this, "Got a JFK(4) message, processing it - " + pn.getPeer());
        }
        if (pn.jfkMyRef == null) {
            String error = "Got a JFK(4) message but no pn.jfkMyRef for " + pn;
            if (this.node.getUptime() < TimeUnit.SECONDS.toMillis(60L)) {
                Logger.minor(this, error);
            } else {
                Logger.error(this, error);
            }
        }
        Rijndael c = null;
        try {
            c = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            throw new RuntimeException(e);
        }
        int expectedLength = HASH_LENGTH + (c.getBlockSize() >> 3) + signLength + 9 + 8 + 1;
        if (payload.length - inputOffset < expectedLength + 3) {
            Logger.error(this, "Packet too short from " + pn.getPeer() + ": " + payload.length + " after decryption in JFK(4), should be " + (expectedLength + 3));
            return false;
        }
        byte[] jfkBuffer = pn.getJFKBuffer();
        if (jfkBuffer == null) {
            Logger.normal(this, "We have already handled this message... might be a replay or a bug - " + pn);
            return false;
        }
        byte[] hmac = Arrays.copyOfRange(payload, inputOffset, inputOffset + HASH_LENGTH);
        c.initialize(pn.jfkKe);
        int ivLength = PCFBMode.lengthIV(c);
        int decypheredPayloadOffset = 0;
        byte[] decypheredPayload = Arrays.copyOf(JFK_PREFIX_RESPONDER, JFK_PREFIX_RESPONDER.length + payload.length - (inputOffset += HASH_LENGTH));
        System.arraycopy(payload, inputOffset, decypheredPayload, decypheredPayloadOffset += JFK_PREFIX_RESPONDER.length, payload.length - inputOffset);
        if (!HMAC.verifyWithSHA256(pn.jfkKa, decypheredPayload, hmac)) {
            Logger.normal(this, "The digest-HMAC doesn't match; let's discard the packet - " + pn.getPeer());
            return false;
        }
        byte[] message4Timestamp = null;
        HashMap<ByteArrayWrapper, byte[]> hashMap = this.authenticatorCache;
        synchronized (hashMap) {
            ByteArrayWrapper hmacBAW = new ByteArrayWrapper(hmac);
            message4Timestamp = this.authenticatorCache.get(hmacBAW);
            if (message4Timestamp == null) {
                this.authenticatorCache.put(hmacBAW, Fields.longToBytes(t1));
            }
        }
        if (message4Timestamp != null) {
            Logger.normal(this, "We got a replayed message4 (first handled at " + TimeUtil.formatTime(t1 - Fields.bytesToLong(message4Timestamp)) + ") from - " + pn);
            return true;
        }
        PCFBMode pk = PCFBMode.create(c, decypheredPayload, decypheredPayloadOffset);
        pk.blockDecipher(decypheredPayload, decypheredPayloadOffset += ivLength, decypheredPayload.length - decypheredPayloadOffset);
        byte[] sig = new byte[signLength];
        System.arraycopy(decypheredPayload, decypheredPayloadOffset, sig, 0, signLength);
        byte[] data = new byte[decypheredPayload.length - (decypheredPayloadOffset += signLength)];
        System.arraycopy(decypheredPayload, decypheredPayloadOffset, data, 0, decypheredPayload.length - decypheredPayloadOffset);
        int ptr = 0;
        long trackerID = Fields.bytesToLong(data, ptr);
        ptr += 8;
        boolean reusedTracker = data[ptr++] != 0;
        long bootID = Fields.bytesToLong(data, ptr);
        byte[] hisRef = Arrays.copyOfRange(data, ptr += 8, data.length);
        int dataLen = hisRef.length + 8 + 9;
        int nonceSize = this.getNonceSize(negType);
        int nonceSizeHashed = negType > 8 ? HASH_LENGTH : nonceSize;
        byte[] identity = this.crypto.getIdentity(negType, unknownInitiator);
        byte[] locallyGeneratedText = new byte[nonceSizeHashed + nonceSize + modulusLength * 2 + identity.length + dataLen + pn.jfkMyRef.length];
        int bufferOffset = nonceSizeHashed + nonceSize + modulusLength * 2;
        System.arraycopy(jfkBuffer, 0, locallyGeneratedText, 0, bufferOffset);
        System.arraycopy(identity, 0, locallyGeneratedText, bufferOffset, identity.length);
        System.arraycopy(data, 0, locallyGeneratedText, bufferOffset += identity.length, dataLen);
        System.arraycopy(pn.jfkMyRef, 0, locallyGeneratedText, bufferOffset += dataLen, pn.jfkMyRef.length);
        if (negType < 9) {
            byte[] r = new byte[32];
            System.arraycopy(sig, 0, r, 0, 32);
            byte[] s = new byte[32];
            System.arraycopy(sig, 32, s, 0, 32);
            DSASignature remoteSignature = new DSASignature(new NativeBigInteger(1, r), new NativeBigInteger(1, s));
            byte[] messageHash = SHA256.digest(locallyGeneratedText);
            if (!DSA.verify(pn.peerPubKey, remoteSignature, new NativeBigInteger(1, messageHash), false)) {
                String error = "The signature verification has failed!! JFK(4) -" + pn.getPeer() + " message hash " + HexUtil.bytesToHex(messageHash) + " length " + locallyGeneratedText.length + " hisRef " + hisRef.length + " hash " + Fields.hashCode(hisRef) + " myRef " + pn.jfkMyRef.length + " hash " + Fields.hashCode(pn.jfkMyRef) + " boot ID " + bootID;
                Logger.error(this, error);
                return true;
            }
        } else if (!ECDSA.verify(ECDSA.Curves.P256, pn.peerECDSAPubKey(), sig, new byte[][]{locallyGeneratedText})) {
            Logger.error(this, "The ECDSA signature verification has failed!! JFK(4) - " + pn.getPeer() + " length " + locallyGeneratedText.length + " hisRef " + hisRef.length + " hash " + Fields.hashCode(hisRef) + " myRef " + pn.jfkMyRef.length + " hash " + Fields.hashCode(pn.jfkMyRef) + " boot ID " + bootID);
            return true;
        }
        pn.receivedPacket(true, false);
        boolean dontWant = false;
        if (oldOpennetPeer) {
            OpennetManager opennet = this.node.getOpennet();
            if (opennet == null) {
                Logger.normal(this, "Dumping incoming old-opennet peer as opennet just turned off: " + pn + ".");
                return true;
            }
            if (!opennet.wantPeer(pn, false, false, true, OpennetManager.ConnectionType.RECONNECT)) {
                Logger.normal(this, "No longer want peer " + pn + " - dumping it after connecting");
                dontWant = true;
                opennet.purgeOldOpennetPeer(pn);
            }
        }
        if (!dontWant && !this.crypto.allowConnection(pn, replyTo.getFreenetAddress())) {
            Logger.normal(this, "Rejecting connection because already have something with the same IP");
            dontWant = true;
        }
        pn.setAcknowledgeType(negType);
        Rijndael ivCipher = null;
        Rijndael outgoingCipher = null;
        Rijndael incommingCipher = null;
        try {
            ivCipher = new Rijndael(256, 256);
            outgoingCipher = new Rijndael(256, 256);
            incommingCipher = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            throw new RuntimeException(e);
        }
        outgoingCipher.initialize(pn.outgoingKey);
        incommingCipher.initialize(pn.incommingKey);
        ivCipher.initialize(pn.ivKey);
        long newTrackerID = pn.completedHandshake(bootID, hisRef, 0, hisRef.length, outgoingCipher, pn.outgoingKey, incommingCipher, pn.incommingKey, replyTo, false, negType, trackerID, true, reusedTracker, pn.hmacKey, ivCipher, pn.ivNonce, pn.ourInitialSeqNum, pn.theirInitialSeqNum, pn.ourInitialMsgID, pn.theirInitialMsgID);
        if (newTrackerID >= 0L) {
            if (dontWant) {
                this.node.peers.disconnectAndRemove(pn, true, true, true);
            } else {
                pn.maybeSendInitialMessages();
            }
        } else {
            Logger.error(this, "Handshake failed!");
        }
        pn.setJFKBuffer(null);
        pn.jfkKa = null;
        pn.jfkKe = null;
        pn.outgoingKey = null;
        pn.incommingKey = null;
        pn.hmacKey = null;
        pn.ivKey = null;
        pn.ivNonce = null;
        pn.ourInitialSeqNum = 0;
        pn.theirInitialSeqNum = 0;
        pn.ourInitialMsgID = 0;
        pn.theirInitialMsgID = 0;
        pn.setKeyAgreementSchemeContext(null);
        PeerNode peerNode = pn;
        synchronized (peerNode) {
            pn.jfkNoncesSent.clear();
        }
        long t2 = System.currentTimeMillis();
        if (t2 - t1 > 500L) {
            Logger.error(this, "Message4 timeout error:Processing packet from " + pn.getPeer());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendJFKMessage3(int version, final int negType, int phase, byte[] nonceInitiator, byte[] nonceResponder, byte[] hisExponential, byte[] authenticator, final PeerNode pn, final Peer replyTo, final boolean unknownInitiator, final int setupType) {
        byte[] computedExponential;
        byte[] sig;
        if (logMINOR) {
            Logger.minor(this, "Sending a JFK(3) message to " + pn.getPeer());
        }
        int modulusLength = this.getModulusLength(negType);
        int signLength = this.getSignatureLength(negType);
        int nonceSize = this.getNonceSize(negType);
        byte[] nonceInitiatorHashed = negType > 8 ? SHA256.digest(nonceInitiator) : nonceInitiator;
        long t1 = System.currentTimeMillis();
        Rijndael c = null;
        try {
            c = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            throw new RuntimeException(e);
        }
        KeyAgreementSchemeContext ctx = pn.getKeyAgreementSchemeContext();
        if (ctx == null) {
            return;
        }
        byte[] ourExponential = ctx.getPublicKeyNetworkFormat();
        pn.jfkMyRef = unknownInitiator ? this.crypto.myCompressedHeavySetupRef() : this.crypto.myCompressedSetupRef();
        byte[] data = new byte[16 + pn.jfkMyRef.length];
        int ptr = 0;
        long trackerID = pn.getReusableTrackerID();
        System.arraycopy(Fields.longToBytes(trackerID), 0, data, ptr, 8);
        ptr += 8;
        if (logMINOR) {
            Logger.minor(this, "Sending tracker ID " + trackerID + " in JFK(3)");
        }
        System.arraycopy(Fields.longToBytes(pn.getOutgoingBootID()), 0, data, ptr, 8);
        System.arraycopy(pn.jfkMyRef, 0, data, ptr += 8, pn.jfkMyRef.length);
        final byte[] message3 = new byte[nonceSize * 2 + modulusLength * 2 + HASH_LENGTH + HASH_LENGTH + (c.getBlockSize() >> 3) + signLength + data.length];
        int offset = 0;
        System.arraycopy(nonceInitiator, 0, message3, offset, nonceSize);
        offset += nonceSize;
        if (logDEBUG) {
            Logger.debug(this, "We are sending Ni : " + HexUtil.bytesToHex(nonceInitiator));
        }
        System.arraycopy(nonceResponder, 0, message3, offset, nonceSize);
        System.arraycopy(ourExponential, 0, message3, offset += nonceSize, ourExponential.length);
        System.arraycopy(hisExponential, 0, message3, offset += ourExponential.length, hisExponential.length);
        System.arraycopy(authenticator, 0, message3, offset += hisExponential.length, HASH_LENGTH);
        offset += HASH_LENGTH;
        byte[] toSign = this.assembleDHParams(nonceInitiatorHashed, nonceResponder, ourExponential, hisExponential, pn.getIdentity(negType), data);
        pn.setJFKBuffer(toSign);
        byte[] byArray = sig = negType < 9 ? this.crypto.sign(SHA256.digest(toSign)) : this.crypto.ecdsaSign(new byte[][]{toSign});
        if (negType < 8) {
            NativeBigInteger _hisExponential = new NativeBigInteger(1, hisExponential);
            computedExponential = ((DiffieHellmanLightContext)ctx).getHMACKey(_hisExponential);
        } else {
            computedExponential = ((ECDHLightContext)ctx).getHMACKey(ECDH.getPublicKey(hisExponential, ecdhCurveToUse));
        }
        if (logDEBUG) {
            Logger.debug(this, "The shared Master secret is : " + HexUtil.bytesToHex(computedExponential) + " for " + pn);
        }
        pn.outgoingKey = this.computeJFKSharedKey(computedExponential, nonceInitiatorHashed, nonceResponder, "0");
        pn.incommingKey = this.computeJFKSharedKey(computedExponential, nonceInitiatorHashed, nonceResponder, "7");
        pn.jfkKe = this.computeJFKSharedKey(computedExponential, nonceInitiatorHashed, nonceResponder, "1");
        pn.jfkKa = this.computeJFKSharedKey(computedExponential, nonceInitiatorHashed, nonceResponder, "2");
        pn.hmacKey = this.computeJFKSharedKey(computedExponential, nonceInitiatorHashed, nonceResponder, "3");
        pn.ivKey = this.computeJFKSharedKey(computedExponential, nonceInitiatorHashed, nonceResponder, "4");
        pn.ivNonce = this.computeJFKSharedKey(computedExponential, nonceInitiatorHashed, nonceResponder, "5");
        byte[] sharedData = this.computeJFKSharedKey(computedExponential, nonceInitiatorHashed, nonceResponder, "6");
        Arrays.fill(computedExponential, (byte)0);
        pn.ourInitialSeqNum = (sharedData[0] & 0xFF) << 24 | (sharedData[1] & 0xFF) << 16 | (sharedData[2] & 0xFF) << 8 | sharedData[3] & 0xFF;
        pn.theirInitialSeqNum = (sharedData[4] & 0xFF) << 24 | (sharedData[5] & 0xFF) << 16 | (sharedData[6] & 0xFF) << 8 | sharedData[7] & 0xFF;
        if (negType >= 7) {
            pn.theirInitialMsgID = unknownInitiator ? this.getInitialMessageID(pn.identity) : this.getInitialMessageID(pn.identity, this.crypto.myIdentity);
            pn.ourInitialMsgID = unknownInitiator ? this.getInitialMessageID(pn.identity) : this.getInitialMessageID(this.crypto.myIdentity, pn.identity);
        } else {
            pn.ourInitialMsgID = (sharedData[8] & 0xFF) << 24 | (sharedData[9] & 0xFF) << 16 | (sharedData[10] & 0xFF) << 8 | sharedData[11] & 0xFF;
            pn.theirInitialMsgID = (sharedData[12] & 0xFF) << 24 | (sharedData[13] & 0xFF) << 16 | (sharedData[14] & 0xFF) << 8 | sharedData[15] & 0xFF;
        }
        if (logMINOR) {
            Logger.minor(this, "Their initial message ID: " + pn.theirInitialMsgID + " ours " + pn.ourInitialMsgID);
        }
        c.initialize(pn.jfkKe);
        int ivLength = PCFBMode.lengthIV(c);
        byte[] iv = new byte[ivLength];
        this.node.random.nextBytes(iv);
        PCFBMode pcfb = PCFBMode.create(c, iv);
        int cleartextOffset = 0;
        byte[] cleartext = new byte[JFK_PREFIX_INITIATOR.length + ivLength + sig.length + data.length];
        System.arraycopy(JFK_PREFIX_INITIATOR, 0, cleartext, cleartextOffset, JFK_PREFIX_INITIATOR.length);
        System.arraycopy(iv, 0, cleartext, cleartextOffset += JFK_PREFIX_INITIATOR.length, ivLength);
        System.arraycopy(sig, 0, cleartext, cleartextOffset += ivLength, sig.length);
        System.arraycopy(data, 0, cleartext, cleartextOffset += sig.length, data.length);
        cleartextOffset += data.length;
        int cleartextToEncypherOffset = JFK_PREFIX_INITIATOR.length + ivLength;
        pcfb.blockEncipher(cleartext, cleartextToEncypherOffset, cleartext.length - cleartextToEncypherOffset);
        byte[] hmac = HMAC.macWithSHA256(pn.jfkKa, cleartext, HASH_LENGTH);
        System.arraycopy(hmac, 0, message3, offset, HASH_LENGTH);
        System.arraycopy(iv, 0, message3, offset += HASH_LENGTH, ivLength);
        System.arraycopy(cleartext, cleartextToEncypherOffset, message3, offset += ivLength, cleartext.length - cleartextToEncypherOffset);
        HashMap<ByteArrayWrapper, byte[]> hashMap = this.authenticatorCache;
        synchronized (hashMap) {
            if (!this.maybeResetTransientKey()) {
                this.authenticatorCache.put(new ByteArrayWrapper(authenticator), message3);
            }
        }
        final long timeSent = System.currentTimeMillis();
        if (unknownInitiator) {
            this.sendAnonAuthPacket(1, negType, 2, setupType, message3, pn, replyTo, pn.anonymousInitiatorSetupCipher);
        } else {
            this.sendAuthPacket(1, negType, 2, message3, pn, replyTo);
        }
        this.node.getTicker().queueTimedJob(new Runnable(){

            @Override
            public void run() {
                if (pn.timeLastConnectionCompleted() < timeSent) {
                    if (logMINOR) {
                        Logger.minor(this, "Resending JFK(3) to " + pn + " for " + FNPPacketMangler.this.node.getDarknetPortNumber());
                    }
                    if (unknownInitiator) {
                        FNPPacketMangler.this.sendAnonAuthPacket(1, negType, 2, setupType, message3, pn, replyTo, pn.anonymousInitiatorSetupCipher);
                    } else {
                        FNPPacketMangler.this.sendAuthPacket(1, negType, 2, message3, pn, replyTo);
                    }
                }
            }
        }, TimeUnit.SECONDS.toMillis(5L));
        long t2 = System.currentTimeMillis();
        if (t2 - t1 > TimeUnit.MILLISECONDS.toMillis(500L)) {
            Logger.error(this, "Message3 timeout error:Sending packet for " + pn.getPeer());
        }
    }

    private int getInitialMessageID(byte[] identity) {
        MessageDigest md = SHA256.getMessageDigest();
        md.update(identity);
        try {
            md.update("INITIAL0".getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        byte[] hashed = md.digest();
        SHA256.returnMessageDigest(md);
        return Fields.bytesToInt(hashed, 0);
    }

    private int getInitialMessageID(byte[] identity, byte[] otherIdentity) {
        MessageDigest md = SHA256.getMessageDigest();
        md.update(identity);
        md.update(otherIdentity);
        try {
            md.update("INITIAL1".getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        byte[] hashed = md.digest();
        SHA256.returnMessageDigest(md);
        return Fields.bytesToInt(hashed, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendJFKMessage4(int version, int negType, int phase, byte[] nonceInitiatorHashed, byte[] nonceResponder, byte[] initiatorExponential, byte[] responderExponential, BlockCipher c, byte[] Ke, byte[] Ka, byte[] authenticator, byte[] hisRef, PeerNode pn, Peer replyTo, boolean unknownInitiator, int setupType, long newTrackerID, boolean sameAsOldTrackerID) {
        if (logMINOR) {
            Logger.minor(this, "Sending a JFK(4) message to " + pn.getPeer());
        }
        long t1 = System.currentTimeMillis();
        byte[] myRef = this.crypto.myCompressedSetupRef();
        byte[] data = new byte[17 + myRef.length + hisRef.length];
        int ptr = 0;
        System.arraycopy(Fields.longToBytes(newTrackerID), 0, data, ptr, 8);
        ptr += 8;
        data[ptr++] = (byte)(sameAsOldTrackerID ? 1 : 0);
        System.arraycopy(Fields.longToBytes(pn.getOutgoingBootID()), 0, data, ptr, 8);
        System.arraycopy(myRef, 0, data, ptr += 8, myRef.length);
        System.arraycopy(hisRef, 0, data, ptr += myRef.length, hisRef.length);
        byte[] params = this.assembleDHParams(nonceInitiatorHashed, nonceResponder, initiatorExponential, responderExponential, pn.getIdentity(negType), data);
        if (logMINOR) {
            Logger.minor(this, "Message length " + params.length + " myRef: " + myRef.length + " hash " + Fields.hashCode(myRef) + " hisRef: " + hisRef.length + " hash " + Fields.hashCode(hisRef) + " boot ID " + this.node.bootID);
        }
        byte[] sig = negType < 9 ? this.crypto.sign(SHA256.digest(params)) : this.crypto.ecdsaSign(new byte[][]{params});
        int ivLength = PCFBMode.lengthIV(c);
        byte[] iv = new byte[ivLength];
        this.node.random.nextBytes(iv);
        PCFBMode pk = PCFBMode.create(c, iv);
        int dataLength = data.length - hisRef.length;
        byte[] cyphertext = new byte[JFK_PREFIX_RESPONDER.length + ivLength + sig.length + dataLength];
        int cleartextOffset = 0;
        System.arraycopy(JFK_PREFIX_RESPONDER, 0, cyphertext, cleartextOffset, JFK_PREFIX_RESPONDER.length);
        System.arraycopy(iv, 0, cyphertext, cleartextOffset += JFK_PREFIX_RESPONDER.length, ivLength);
        System.arraycopy(sig, 0, cyphertext, cleartextOffset += ivLength, sig.length);
        System.arraycopy(data, 0, cyphertext, cleartextOffset += sig.length, dataLength);
        cleartextOffset += dataLength;
        int cleartextToEncypherOffset = JFK_PREFIX_RESPONDER.length + ivLength;
        pk.blockEncipher(cyphertext, cleartextToEncypherOffset, cyphertext.length - cleartextToEncypherOffset);
        byte[] hmac = HMAC.macWithSHA256(Ka, cyphertext, HASH_LENGTH);
        byte[] message4 = new byte[HASH_LENGTH + ivLength + (cyphertext.length - cleartextToEncypherOffset)];
        int offset = 0;
        System.arraycopy(hmac, 0, message4, offset, HASH_LENGTH);
        System.arraycopy(iv, 0, message4, offset += HASH_LENGTH, ivLength);
        System.arraycopy(cyphertext, cleartextToEncypherOffset, message4, offset += ivLength, cyphertext.length - cleartextToEncypherOffset);
        HashMap<ByteArrayWrapper, byte[]> hashMap = this.authenticatorCache;
        synchronized (hashMap) {
            if (!this.maybeResetTransientKey()) {
                this.authenticatorCache.put(new ByteArrayWrapper(authenticator), message4);
            }
            if (logDEBUG) {
                Logger.debug(this, "Storing JFK(4) for " + HexUtil.bytesToHex(authenticator));
            }
        }
        if (unknownInitiator) {
            this.sendAnonAuthPacket(1, negType, 3, setupType, message4, pn, replyTo, this.crypto.anonSetupCipher);
        } else {
            this.sendAuthPacket(1, negType, 3, message4, pn, replyTo);
        }
        long t2 = System.currentTimeMillis();
        if (t2 - t1 > 500L) {
            Logger.error(this, "Message4 timeout error:Sending packet for " + pn.getPeer());
        }
    }

    private void sendAuthPacket(int version, int negType, int phase, byte[] data, PeerNode pn, Peer replyTo) {
        if (pn == null) {
            throw new IllegalArgumentException("pn shouldn't be null here!");
        }
        byte[] output = new byte[data.length + 3];
        output[0] = (byte)version;
        output[1] = (byte)negType;
        output[2] = (byte)phase;
        System.arraycopy(data, 0, output, 3, data.length);
        if (logMINOR) {
            long now = System.currentTimeMillis();
            String delta = "never";
            long last = pn.lastSentPacketTime();
            delta = TimeUtil.formatTime(now - last, 2, true) + " ago";
            Logger.minor(this, "Sending auth packet for " + String.valueOf(pn.getPeer()) + " (phase=" + phase + ", ver=" + version + ", nt=" + negType + ") (last packet sent " + delta + ") to " + replyTo + " data.length=" + data.length + " to " + replyTo);
        }
        this.sendAuthPacket(output, pn.outgoingSetupCipher, pn, replyTo, false);
    }

    private void sendAnonAuthPacket(int version, int negType, int phase, int setupType, byte[] data, PeerNode pn, Peer replyTo, BlockCipher cipher) {
        byte[] output = new byte[data.length + 4];
        output[0] = (byte)version;
        output[1] = (byte)negType;
        output[2] = (byte)phase;
        output[3] = (byte)setupType;
        System.arraycopy(data, 0, output, 4, data.length);
        if (logMINOR) {
            Logger.minor(this, "Sending anon auth packet (phase=" + phase + ", ver=" + version + ", nt=" + negType + ", setup=" + setupType + ") data.length=" + data.length);
        }
        this.sendAuthPacket(output, cipher, pn, replyTo, true);
    }

    private void sendAuthPacket(byte[] output, BlockCipher cipher, PeerNode pn, Peer replyTo, boolean anonAuth) {
        int paddingLength;
        int maxPacketSize;
        int prePaddingLength;
        int length = output.length;
        if (length > this.sock.getMaxPacketSize()) {
            throw new IllegalStateException("Cannot send auth packet: too long: " + length);
        }
        byte[] iv = new byte[PCFBMode.lengthIV(cipher)];
        this.node.random.nextBytes(iv);
        byte[] hash = SHA256.digest(output);
        if (logDEBUG) {
            Logger.debug(this, "Data hash: " + HexUtil.bytesToHex(hash));
        }
        if ((prePaddingLength = iv.length + hash.length + 2 + output.length) < (maxPacketSize = this.sock.getMaxPacketSize())) {
            paddingLength = this.node.fastWeakRandom.nextInt(Math.min(100, maxPacketSize - prePaddingLength));
        } else {
            paddingLength = 0;
            Logger.error(this, "Warning: sending oversize auth packet (anonAuth=" + anonAuth + ") of " + prePaddingLength + " bytes!");
        }
        if (paddingLength < 0) {
            paddingLength = 0;
        }
        byte[] data = new byte[prePaddingLength + paddingLength];
        PCFBMode pcfb = PCFBMode.create(cipher, iv);
        System.arraycopy(iv, 0, data, 0, iv.length);
        pcfb.blockEncipher(hash, 0, hash.length);
        System.arraycopy(hash, 0, data, iv.length, hash.length);
        if (logMINOR) {
            Logger.minor(this, "Payload length: " + length + " padded length " + data.length);
        }
        data[hash.length + iv.length] = (byte)pcfb.encipher((byte)(length >> 8));
        data[hash.length + iv.length + 1] = (byte)pcfb.encipher((byte)length);
        pcfb.blockEncipher(output, 0, output.length);
        System.arraycopy(output, 0, data, hash.length + iv.length + 2, output.length);
        Util.randomBytes(this.node.fastWeakRandom, data, hash.length + iv.length + 2 + output.length, paddingLength);
        try {
            this.sendPacket(data, replyTo, pn);
            this.node.nodeStats.reportAuthBytes(data.length + this.sock.getHeadersLength(replyTo));
        }
        catch (Peer.LocalAddressException e) {
            Logger.warning(this, "Tried to send auth packet to local address: " + replyTo + " for " + pn + " - maybe you should set allowLocalAddresses for this peer??");
        }
    }

    private void sendPacket(byte[] data, Peer replyTo, PeerNode pn) throws Peer.LocalAddressException {
        Peer p;
        if (pn != null && pn.isIgnoreSource() && (p = pn.getPeer()) != null) {
            replyTo = p;
        }
        this.sock.sendPacket(data, replyTo, pn == null ? this.crypto.config.alwaysAllowLocalAddresses() : pn.allowLocalAddresses());
        if (pn != null) {
            pn.reportOutgoingBytes(data.length);
        }
        if (PeerNode.shouldThrottle(replyTo, this.node)) {
            this.node.outputThrottle.forceGrab(data.length);
        }
    }

    private boolean shouldLogErrorInHandshake(long now) {
        return now - this.node.startupTime >= (long)(Node.HANDSHAKE_TIMEOUT * 2);
    }

    byte[] preformat(byte[] buf, int offset, int length) {
        byte[] newBuf;
        if (buf != null) {
            newBuf = new byte[length + 3];
            newBuf[0] = 1;
            newBuf[1] = (byte)(length >> 8);
            newBuf[2] = (byte)length;
            System.arraycopy(buf, offset, newBuf, 3, length);
        } else {
            newBuf = new byte[]{0};
        }
        return newBuf;
    }

    protected String l10n(String key, String[] patterns, String[] values) {
        return NodeL10n.getBase().getString("FNPPacketMangler." + key, patterns, values);
    }

    protected String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("FNPPacketMangler." + key, pattern, value);
    }

    @Override
    public void sendHandshake(PeerNode pn, boolean notRegistered) {
        Peer peer;
        int negType = pn.selectNegType(this);
        if (negType == -1) {
            int[] negTypes = this.supportedNegTypes(true);
            negType = negTypes[this.node.random.nextInt(negTypes.length)];
            Logger.normal(this, "Cannot send handshake to " + pn + " because no common negTypes, choosing random negType of " + negType);
        }
        if (logMINOR) {
            Logger.minor(this, "Possibly sending handshake to " + pn + " negotiation type " + negType);
        }
        if ((peer = pn.getHandshakeIP()) == null) {
            pn.couldNotSendHandshake(notRegistered);
            return;
        }
        Peer oldPeer = peer;
        if ((peer = peer.dropHostName()) == null) {
            Logger.error(this, "No address for peer " + oldPeer + " so cannot send handshake");
            pn.couldNotSendHandshake(notRegistered);
            return;
        }
        try {
            this.sendJFKMessage1(pn, peer, pn.handshakeUnknownInitiator(), pn.handshakeSetupType(), negType);
        }
        catch (NoContextsException e) {
            this.handleNoContextsException(e, NoContextsException.CONTEXT.SENDING);
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Sending handshake to " + peer + " for " + pn);
        }
        pn.sentHandshake(notRegistered);
    }

    @Override
    public boolean isDisconnected(PeerContext context) {
        if (context == null) {
            return false;
        }
        return !context.isConnected();
    }

    @Override
    public int[] supportedNegTypes(boolean forPublic) {
        if (forPublic) {
            return new int[]{6, 7, 8, 9, 10};
        }
        return new int[]{7, 8, 9, 10};
    }

    @Override
    public SocketHandler getSocketHandler() {
        return this.sock;
    }

    @Override
    public Peer[] getPrimaryIPAddress() {
        return this.crypto.detector.getPrimaryPeers();
    }

    @Override
    public byte[] getCompressedNoderef() {
        return this.crypto.myCompressedFullRef();
    }

    @Override
    public boolean alwaysAllowLocalAddresses() {
        return this.crypto.config.alwaysAllowLocalAddresses();
    }

    private DiffieHellmanLightContext _genLightDiffieHellmanContext() {
        DiffieHellmanLightContext ctx = DiffieHellman.generateLightContext(dhGroupToUse);
        if (logDEBUG) {
            Logger.debug(this, "Signing for DiffieHellman: " + HexUtil.bytesToHex(SHA256.digest(this.assembleDHParams(ctx.getPublicKeyNetworkFormat(), this.crypto.getCryptoGroup()))) + " for " + HexUtil.bytesToHex(this.assembleDHParams(ctx.getPublicKeyNetworkFormat(), this.crypto.getCryptoGroup())));
        }
        ctx.setDSASignature(this.crypto.sign(SHA256.digest(this.assembleDHParams(ctx.getPublicKeyNetworkFormat(), this.crypto.getCryptoGroup()))));
        return ctx;
    }

    private ECDHLightContext _genECDHLightContext() {
        ECDHLightContext ctx = new ECDHLightContext(ecdhCurveToUse);
        ctx.setECDSASignature(this.crypto.ecdsaSign(new byte[][]{ctx.getPublicKeyNetworkFormat()}));
        ctx.setDSASignature(this.crypto.sign(SHA256.digest(this.assembleDHParams(ctx.getPublicKeyNetworkFormat(), this.crypto.getCryptoGroup()))));
        if (logDEBUG) {
            Logger.debug(this, "ECDSA Signature: " + HexUtil.bytesToHex(ctx.ecdsaSig) + " for " + HexUtil.bytesToHex(ctx.getPublicKeyNetworkFormat()));
        }
        return ctx;
    }

    private void _fillJFKDHFIFOOffThread() {
        this.node.executor.execute(new PrioRunnable(){

            @Override
            public void run() {
                FNPPacketMangler.this._fillJFKDHFIFO();
            }

            @Override
            public int getPriority() {
                return NativeThread.MIN_PRIORITY;
            }
        }, "DiffieHellman exponential signing");
    }

    private void _fillJFKECDHFIFOOffThread() {
        this.node.executor.execute(new PrioRunnable(){

            @Override
            public void run() {
                FNPPacketMangler.this._fillJFKECDHFIFO();
            }

            @Override
            public int getPriority() {
                return NativeThread.MIN_PRIORITY;
            }
        }, "ECDH exponential signing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _fillJFKDHFIFO() {
        LinkedList<DiffieHellmanLightContext> linkedList = this.dhContextFIFO;
        synchronized (linkedList) {
            int size = this.dhContextFIFO.size();
            if (size > 0 && size + 1 > 20) {
                DiffieHellmanLightContext result = null;
                long oldestSeen = Long.MAX_VALUE;
                for (DiffieHellmanLightContext tmp : this.dhContextFIFO) {
                    if (tmp.lifetime >= oldestSeen) continue;
                    oldestSeen = tmp.lifetime;
                    result = tmp;
                }
                this.dhContextToBePrunned = result;
                this.dhContextFIFO.remove(this.dhContextToBePrunned);
            }
            this.dhContextFIFO.addLast(this._genLightDiffieHellmanContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _fillJFKECDHFIFO() {
        LinkedList<ECDHLightContext> linkedList = this.ecdhContextFIFO;
        synchronized (linkedList) {
            int size = this.ecdhContextFIFO.size();
            if (size > 0 && size + 1 > 20) {
                ECDHLightContext result = null;
                long oldestSeen = Long.MAX_VALUE;
                for (ECDHLightContext tmp : this.ecdhContextFIFO) {
                    if (tmp.lifetime >= oldestSeen) continue;
                    oldestSeen = tmp.lifetime;
                    result = tmp;
                }
                this.ecdhContextToBePrunned = result;
                this.ecdhContextFIFO.remove(this.ecdhContextToBePrunned);
            }
            this.ecdhContextFIFO.addLast(this._genECDHLightContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiffieHellmanLightContext getLightDiffieHellmanContext() {
        long now = System.currentTimeMillis();
        DiffieHellmanLightContext result = null;
        LinkedList<DiffieHellmanLightContext> linkedList = this.dhContextFIFO;
        synchronized (linkedList) {
            result = this.dhContextFIFO.pollFirst();
            if (this.jfkDHLastGenerationTimestamp + 30000L < now) {
                this.jfkDHLastGenerationTimestamp = now;
                this._fillJFKDHFIFOOffThread();
            }
            if (result == null) {
                result = this._genLightDiffieHellmanContext();
            }
            this.dhContextFIFO.addLast(result);
        }
        if (logMINOR) {
            Logger.minor(this, "getLightDiffieHellmanContext() is serving " + result.hashCode());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ECDHLightContext getECDHLightContext() throws NoContextsException {
        long now = System.currentTimeMillis();
        ECDHLightContext result = null;
        LinkedList<ECDHLightContext> linkedList = this.ecdhContextFIFO;
        synchronized (linkedList) {
            result = this.ecdhContextFIFO.pollFirst();
            if (this.jfkECDHLastGenerationTimestamp + 30000L < now) {
                this.jfkECDHLastGenerationTimestamp = now;
                this._fillJFKECDHFIFOOffThread();
            }
            if (result == null) {
                throw new NoContextsException();
            }
            this.ecdhContextFIFO.addLast(result);
        }
        if (logMINOR) {
            Logger.minor(this, "getECDHLightContext() is serving " + result.hashCode());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiffieHellmanLightContext findContextByExponential(BigInteger exponential) {
        LinkedList<DiffieHellmanLightContext> linkedList = this.dhContextFIFO;
        synchronized (linkedList) {
            for (DiffieHellmanLightContext result : this.dhContextFIFO) {
                if (!exponential.equals(result.myExponential)) continue;
                return result;
            }
            if (this.dhContextToBePrunned != null && this.dhContextToBePrunned.myExponential.equals(exponential)) {
                return this.dhContextToBePrunned;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ECDHLightContext findECDHContextByPubKey(ECPublicKey exponential) {
        LinkedList<ECDHLightContext> linkedList = this.ecdhContextFIFO;
        synchronized (linkedList) {
            for (ECDHLightContext result : this.ecdhContextFIFO) {
                if (!exponential.equals(result.getPublicKey())) continue;
                return result;
            }
            if (this.ecdhContextToBePrunned != null && this.ecdhContextToBePrunned.getPublicKey().equals(exponential)) {
                return this.ecdhContextToBePrunned;
            }
        }
        return null;
    }

    private byte[] assembleDHParams(byte[] exponential, DSAGroup group) {
        byte[] _myGroup = group.getP().toByteArray();
        byte[] toSign = new byte[exponential.length + _myGroup.length];
        System.arraycopy(exponential, 0, toSign, 0, exponential.length);
        System.arraycopy(_myGroup, 0, toSign, exponential.length, _myGroup.length);
        return toSign;
    }

    private byte[] assembleDHParams(byte[] nonceInitiator, byte[] nonceResponder, byte[] initiatorExponential, byte[] responderExponential, byte[] id, byte[] sa) {
        byte[] result = new byte[nonceInitiator.length + nonceResponder.length + initiatorExponential.length + responderExponential.length + id.length + sa.length];
        int offset = 0;
        System.arraycopy(nonceInitiator, 0, result, offset, nonceInitiator.length);
        System.arraycopy(nonceResponder, 0, result, offset += nonceInitiator.length, nonceResponder.length);
        System.arraycopy(initiatorExponential, 0, result, offset += nonceResponder.length, initiatorExponential.length);
        System.arraycopy(responderExponential, 0, result, offset += initiatorExponential.length, responderExponential.length);
        System.arraycopy(id, 0, result, offset += responderExponential.length, id.length);
        System.arraycopy(sa, 0, result, offset += id.length, sa.length);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getTransientKey() {
        HashMap<ByteArrayWrapper, byte[]> hashMap = this.authenticatorCache;
        synchronized (hashMap) {
            return this.transientKey;
        }
    }

    private byte[] computeJFKSharedKey(byte[] exponential, byte[] nI, byte[] nR, String what) {
        assert ("0".equals(what) || "1".equals(what) || "2".equals(what) || "3".equals(what) || "4".equals(what) || "5".equals(what) || "6".equals(what) || "7".equals(what));
        byte[] number = null;
        try {
            number = what.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
        byte[] toHash = new byte[nI.length + nR.length + number.length];
        int offset = 0;
        System.arraycopy(nI, 0, toHash, offset, nI.length);
        System.arraycopy(nR, 0, toHash, offset += nI.length, nR.length);
        System.arraycopy(number, 0, toHash, offset += nR.length, number.length);
        return HMAC.macWithSHA256(exponential, toHash, HASH_LENGTH);
    }

    private int getAuthenticatorCacheSize() {
        if (this.crypto.isOpennet && this.node.wantAnonAuth(true)) {
            return 5000;
        }
        return 250;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean maybeResetTransientKey() {
        long now = System.currentTimeMillis();
        boolean isCacheTooBig = true;
        int authenticatorCacheSize = 0;
        int AUTHENTICATOR_CACHE_SIZE = this.getAuthenticatorCacheSize();
        HashMap<ByteArrayWrapper, byte[]> hashMap = this.authenticatorCache;
        synchronized (hashMap) {
            authenticatorCacheSize = this.authenticatorCache.size();
            if (authenticatorCacheSize < AUTHENTICATOR_CACHE_SIZE) {
                isCacheTooBig = false;
                if (now - this.timeLastReset < TRANSIENT_KEY_REKEYING_MIN_INTERVAL) {
                    return false;
                }
            }
            this.timeLastReset = now;
            this.node.random.nextBytes(this.transientKey);
            this.authenticatorCache.clear();
        }
        this.node.getTicker().queueTimedJob(this.transientKeyRekeyer, "JFKmaybeResetTransientKey" + now, TRANSIENT_KEY_REKEYING_MIN_INTERVAL, false, false);
        Logger.normal(this, "JFK's TransientKey has been changed and the message cache flushed because " + (isCacheTooBig ? "the cache is oversized (" + authenticatorCacheSize + ')' : "it's time to rekey") + " on " + this);
        return true;
    }

    @Override
    public AddressTracker.Status getConnectivityStatus() {
        long now = System.currentTimeMillis();
        if (now - this.lastConnectivityStatusUpdate < TimeUnit.MINUTES.toMillis(3L)) {
            return this.lastConnectivityStatus;
        }
        AddressTracker.Status value = this.crypto.config.alwaysHandshakeAggressively() ? AddressTracker.Status.DEFINITELY_NATED : this.sock.getDetectedConnectivityStatus();
        this.lastConnectivityStatusUpdate = now;
        this.lastConnectivityStatus = value;
        return this.lastConnectivityStatus;
    }

    @Override
    public boolean allowConnection(PeerNode pn, FreenetInetAddress addr) {
        return this.crypto.allowConnection(pn, addr);
    }

    @Override
    public void setPortForwardingBroken() {
        this.crypto.setPortForwardingBroken();
    }

    private int getModulusLength(int negType) {
        if (negType < 8) {
            return DiffieHellman.modulusLengthInBytes();
        }
        return FNPPacketMangler.ecdhCurveToUse.modulusSize;
    }

    private int getSignatureLength(int negType) {
        if (negType < 9) {
            return 64;
        }
        return ECDSA.Curves.P256.maxSigSize;
    }

    private int getNonceSize(int negType) {
        if (negType < 9) {
            return 8;
        }
        return 16;
    }

    static {
        Logger.registerClass(FNPPacketMangler.class);
        byte[] I = null;
        byte[] R = null;
        try {
            I = "I".getBytes("UTF-8");
            R = "R".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
        JFK_PREFIX_INITIATOR = I;
        JFK_PREFIX_RESPONDER = R;
        dhGroupToUse = Global.DHgroupA;
        ecdhCurveToUse = ECDH.Curves.P256;
        TRANSIENT_KEY_SIZE = HASH_LENGTH = SHA256.getDigestLength();
        TRANSIENT_KEY_REKEYING_MIN_INTERVAL = TimeUnit.MINUTES.toMillis(30L);
        SESSION_KEY_REKEYING_INTERVAL = TimeUnit.MINUTES.toMillis(60L);
        MAX_SESSION_KEY_REKEYING_DELAY = TimeUnit.MINUTES.toMillis(5L);
        HEADERS_LENGTH_MINIMUM = 26 + HASH_LENGTH + 1;
        HEADERS_LENGTH_ONE_MESSAGE = HEADERS_LENGTH_MINIMUM + 2;
        LOG_NO_CONTEXTS_INTERVAL = TimeUnit.MINUTES.toMillis(1L);
        BCPROV_LOAD_FAILED = null;
    }

    private static class NoContextsException
    extends Exception {
        private NoContextsException() {
        }

        private static enum CONTEXT {
            SENDING,
            REPLYING;

        }
    }
}

