/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.support.Logger;
import freenet.support.OOMHandler;
import freenet.support.SizeUtil;
import freenet.support.Ticker;
import freenet.support.math.RunningAverage;
import freenet.support.math.SimpleRunningAverage;

public class MemoryChecker
implements Runnable {
    private volatile boolean goon = false;
    private final Ticker ps;
    private int aggressiveGCModificator;
    private RunningAverage avgFreeMemory;

    public MemoryChecker(Ticker ps, int modificator) {
        this.ps = ps;
        this.aggressiveGCModificator = modificator;
    }

    protected synchronized void terminate() {
        this.goon = false;
        Logger.normal(this, "Terminating Memory Checker!");
    }

    public boolean isRunning() {
        return this.goon;
    }

    public synchronized void start() {
        this.goon = true;
        Logger.normal(this, "Starting Memory Checker!");
        this.run();
    }

    @Override
    public void run() {
        int sleeptime;
        Logger.OSThread.logPID(this);
        if (!this.goon) {
            Logger.normal(this, "Goon is false ; killing MemoryChecker");
            return;
        }
        Runtime r = Runtime.getRuntime();
        long totalMemory = r.totalMemory();
        long freeMemory = r.freeMemory();
        long maxMemory = r.maxMemory();
        Logger.normal(this, "Memory in use: " + SizeUtil.formatSize(totalMemory - freeMemory));
        if (totalMemory == maxMemory || maxMemory == Long.MAX_VALUE) {
            if (this.avgFreeMemory == null) {
                this.avgFreeMemory = new SimpleRunningAverage(3, freeMemory);
            } else {
                this.avgFreeMemory.report(freeMemory);
            }
            if (this.avgFreeMemory.countReports() >= 3L && this.avgFreeMemory.currentValue() < 4194304.0) {
                Logger.normal(this, "Reached threshold, checking for low memory ...");
                System.gc();
                System.runFinalization();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                freeMemory = r.freeMemory();
                this.avgFreeMemory.report(freeMemory);
                if (freeMemory < 0x400000L) {
                    Logger.error(this, "Memory too low, trying to free some");
                    OOMHandler.lowMemory();
                }
            }
        }
        if ((sleeptime = this.aggressiveGCModificator) <= 0) {
            this.ps.queueTimedJob(this, 30000L);
            return;
        }
        this.ps.queueTimedJob(this, 120L * (long)sleeptime);
        if (this.aggressiveGCModificator > 0) {
            boolean logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            long beforeGCUsedMemory = r.totalMemory() - r.freeMemory();
            if (logMINOR) {
                Logger.minor(this, "Memory in use before GC: " + beforeGCUsedMemory);
            }
            long beforeGCTime = System.currentTimeMillis();
            System.gc();
            System.runFinalization();
            long afterGCTime = System.currentTimeMillis();
            long afterGCUsedMemory = r.totalMemory() - r.freeMemory();
            if (logMINOR) {
                Logger.minor(this, "Memory in use after GC: " + afterGCUsedMemory);
                Logger.minor(this, "GC completed after " + (afterGCTime - beforeGCTime) + "ms and \"recovered\" " + (beforeGCUsedMemory - afterGCUsedMemory) + " bytes, leaving " + afterGCUsedMemory + " bytes used");
            }
        }
    }
}

