/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.xfer.PacketThrottle;
import freenet.node.BasePeerNode;
import freenet.node.NPFPacket;
import freenet.node.NewPacketFormat;
import freenet.node.SessionKey;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SentTimes;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class NewPacketFormatKeyContext {
    public int firstSeqNumUsed = -1;
    public int nextSeqNum;
    public int highestReceivedSeqNum;
    public byte[][] seqNumWatchList = null;
    public int watchListPointer = 0;
    public int watchListOffset = 0;
    private final TreeMap<Integer, Long> acks = new TreeMap();
    private final HashMap<Integer, NewPacketFormat.SentPacket> sentPackets = new HashMap();
    private static final int MAX_SENT_TIMES = 16384;
    private final SentTimes sentTimes = new SentTimes(16384);
    private final Object sequenceNumberLock = new Object();
    private static final int REKEY_THRESHOLD = 100;
    static final int MAX_ACK_DELAY = 200;
    private static final int MIN_RTT_FOR_RETRANSMIT = 250;
    private int maxSeenInFlight;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;

    NewPacketFormatKeyContext(int ourFirstSeqNum, int theirFirstSeqNum) {
        this.nextSeqNum = ourFirstSeqNum &= Integer.MAX_VALUE;
        this.watchListOffset = theirFirstSeqNum &= Integer.MAX_VALUE;
        this.highestReceivedSeqNum = theirFirstSeqNum - 1;
        if (this.highestReceivedSeqNum == -1) {
            this.highestReceivedSeqNum = Integer.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canAllocateSeqNum() {
        Object object = this.sequenceNumberLock;
        synchronized (object) {
            return this.nextSeqNum != this.firstSeqNumUsed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int allocateSequenceNumber(BasePeerNode pn) {
        Object object = this.sequenceNumberLock;
        synchronized (object) {
            if (this.firstSeqNumUsed == -1) {
                this.firstSeqNumUsed = this.nextSeqNum;
                if (logMINOR) {
                    Logger.minor(this, "First seqnum used for " + this + " is " + this.firstSeqNumUsed);
                }
            } else {
                if (this.nextSeqNum == this.firstSeqNumUsed) {
                    Logger.error(this, "Blocked because we haven't rekeyed yet");
                    pn.startRekeying();
                    return -1;
                }
                if (this.firstSeqNumUsed > this.nextSeqNum) {
                    if (this.firstSeqNumUsed - this.nextSeqNum < 100) {
                        pn.startRekeying();
                    }
                } else if (0x80000000L - (long)this.nextSeqNum + (long)this.firstSeqNumUsed < 100L) {
                    pn.startRekeying();
                }
            }
            int seqNum = this.nextSeqNum++;
            if (this.nextSeqNum < 0) {
                this.nextSeqNum = 0;
            }
            return seqNum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(int ack, BasePeerNode pn, SessionKey key) {
        int maxSize;
        long rtt;
        boolean lostBeforeAcked = false;
        boolean validAck = false;
        HashMap<Integer, NewPacketFormat.SentPacket> hashMap = this.sentPackets;
        synchronized (hashMap) {
            NewPacketFormat.SentPacket sent;
            if (logDEBUG) {
                Logger.debug(this, "Acknowledging packet " + ack + " from " + pn);
            }
            if ((sent = this.sentPackets.remove(ack)) != null) {
                rtt = sent.acked(key);
                maxSize = this.maxSeenInFlight * 2 + 10;
                this.sentTimes.removeTime(ack);
                validAck = true;
            } else {
                if (logDEBUG) {
                    Logger.debug(this, "Already acked or lost " + ack);
                }
                lostBeforeAcked = true;
                long l = this.sentTimes.removeTime(ack);
                if (l < 0L) {
                    if (logDEBUG) {
                        Logger.debug(this, "No time for " + ack + " - maybe acked twice?");
                    }
                    return;
                }
                rtt = System.currentTimeMillis() - l;
                maxSize = this.maxSeenInFlight * 2 + 10;
            }
        }
        int rt = (int)Math.min(rtt, Integer.MAX_VALUE);
        PacketThrottle throttle = null;
        if (pn != null) {
            pn.reportPing(rt);
            throttle = pn.getThrottle();
            if (validAck) {
                pn.receivedAck(System.currentTimeMillis());
            }
        }
        if (throttle != null) {
            throttle.setRoundTripTime(rt);
            if (!lostBeforeAcked) {
                throttle.notifyOfPacketAcknowledged(maxSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queueAck(int seqno) {
        TreeMap<Integer, Long> treeMap = this.acks;
        synchronized (treeMap) {
            if (!this.acks.containsKey(seqno)) {
                this.acks.put(seqno, System.currentTimeMillis());
                return this.acks.size();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sent(int sequenceNumber, int length) {
        HashMap<Integer, NewPacketFormat.SentPacket> hashMap = this.sentPackets;
        synchronized (hashMap) {
            NewPacketFormat.SentPacket sentPacket = this.sentPackets.get(sequenceNumber);
            if (sentPacket != null) {
                sentPacket.sent(length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddedAcks addAcks(NPFPacket packet, int maxPacketSize, long now, boolean useCumulativeAcks) {
        boolean mustSend = false;
        HashMap<Integer, Long> moved = null;
        int numAcks = 0;
        packet.setAcknowledgeType(useCumulativeAcks);
        TreeMap<Integer, Long> treeMap = this.acks;
        synchronized (treeMap) {
            Iterator<Map.Entry<Integer, Long>> it = this.acks.entrySet().iterator();
            while (it.hasNext() && packet.getLength() < maxPacketSize) {
                Map.Entry<Integer, Long> entry = it.next();
                int ack = entry.getKey();
                if (logDEBUG) {
                    Logger.debug(this, "Trying to ack " + ack);
                }
                if (!packet.addAck(ack, maxPacketSize)) {
                    if (!logDEBUG) break;
                    Logger.debug(this, "Can't add ack " + ack);
                    break;
                }
                if (entry.getValue() + 200L < now) {
                    mustSend = true;
                }
                if (moved == null) {
                    moved = new HashMap<Integer, Long>();
                }
                moved.put(ack, entry.getValue());
                ++numAcks;
                it.remove();
            }
        }
        if (numAcks == 0) {
            return null;
        }
        return new AddedAcks(mustSend, moved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countSentPackets() {
        HashMap<Integer, NewPacketFormat.SentPacket> hashMap = this.sentPackets;
        synchronized (hashMap) {
            return this.sentPackets.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sent(NewPacketFormat.SentPacket sentPacket, int seqNum, int length) {
        HashMap<Integer, NewPacketFormat.SentPacket> hashMap = this.sentPackets;
        synchronized (hashMap) {
            if (!sentPacket.messages.isEmpty()) {
                this.sentTimes.add(seqNum, System.currentTimeMillis());
            }
            sentPacket.sent(length);
            this.sentPackets.put(seqNum, sentPacket);
            int inFlight = this.sentPackets.size();
            if (inFlight > this.maxSeenInFlight) {
                this.maxSeenInFlight = inFlight;
                if (logDEBUG) {
                    Logger.debug(this, "Max seen in flight new record: " + this.maxSeenInFlight + " for " + this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long timeCheckForLostPackets(double averageRTT) {
        long timeCheck = Long.MAX_VALUE;
        HashMap<Integer, NewPacketFormat.SentPacket> hashMap = this.sentPackets;
        synchronized (hashMap) {
            double avgRtt = Math.max(250.0, averageRTT);
            for (Map.Entry<Integer, NewPacketFormat.SentPacket> e : this.sentPackets.entrySet()) {
                NewPacketFormat.SentPacket s = e.getValue();
                long t = (long)((double)s.getSentTime() + (avgRtt + 220.00000000000003));
                if (t >= timeCheck) continue;
                timeCheck = t;
            }
        }
        return timeCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForLostPackets(double averageRTT, long curTime, BasePeerNode pn) {
        int bigLostCount = 0;
        int count = 0;
        HashMap<Integer, NewPacketFormat.SentPacket> hashMap = this.sentPackets;
        synchronized (hashMap) {
            double avgRtt = Math.max(250.0, averageRTT);
            Iterator<Map.Entry<Integer, NewPacketFormat.SentPacket>> it = this.sentPackets.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, NewPacketFormat.SentPacket> e = it.next();
                NewPacketFormat.SentPacket s = e.getValue();
                if ((double)s.getSentTime() < (double)curTime - (avgRtt + 220.00000000000003)) {
                    if (logMINOR) {
                        Logger.minor(this, "Assuming packet " + e.getKey() + " has been lost. " + "Delay " + (curTime - s.getSentTime()) + "ms, " + "threshold " + (avgRtt + 220.00000000000003) + "ms");
                    }
                    s.lost();
                    it.remove();
                    ++bigLostCount;
                    continue;
                }
                ++count;
            }
            if (count > 0 && logMINOR) {
                Logger.minor(this, "" + count + " packets in flight with threshold " + (avgRtt + 220.00000000000003) + "ms");
            }
        }
        if (bigLostCount != 0 && pn != null) {
            PacketThrottle throttle = pn.getThrottle();
            if (throttle != null) {
                for (int i = 0; i < bigLostCount; ++i) {
                    throttle.notifyOfPacketLost();
                }
            }
            pn.backoffOnResend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long timeCheckForAcks() {
        long ret = Long.MAX_VALUE;
        TreeMap<Integer, Long> treeMap = this.acks;
        synchronized (treeMap) {
            for (Long l : this.acks.values()) {
                long timeout = l + 200L;
                if (ret <= timeout) continue;
                ret = timeout;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected() {
        HashMap<Integer, NewPacketFormat.SentPacket> hashMap = this.sentPackets;
        synchronized (hashMap) {
            for (Map.Entry<Integer, NewPacketFormat.SentPacket> e : this.sentPackets.entrySet()) {
                NewPacketFormat.SentPacket s = e.getValue();
                s.lost();
            }
            this.sentPackets.clear();
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }

    class AddedAcks {
        final boolean anyUrgentAcks;
        private final HashMap<Integer, Long> moved;

        public AddedAcks(boolean mustSend, HashMap<Integer, Long> moved) {
            this.anyUrgentAcks = mustSend;
            this.moved = moved;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abort() {
            TreeMap treeMap = NewPacketFormatKeyContext.this.acks;
            synchronized (treeMap) {
                NewPacketFormatKeyContext.this.acks.putAll(this.moved);
            }
        }
    }
}

