/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.config.Configuration;
import com.db4o.config.GlobalOnlyConfigException;
import com.db4o.defragment.AvailableClassFilter;
import com.db4o.defragment.BTreeIDMapping;
import com.db4o.defragment.ContextIDMapping;
import com.db4o.defragment.Defragment;
import com.db4o.defragment.DefragmentConfig;
import com.db4o.defragment.StoredClassFilter;
import com.db4o.diagnostic.ClassHasNoFields;
import com.db4o.diagnostic.Diagnostic;
import com.db4o.diagnostic.DiagnosticBase;
import com.db4o.diagnostic.DiagnosticListener;
import com.db4o.ext.Db4oException;
import com.db4o.io.IoAdapter;
import com.db4o.io.RandomAccessFileAdapter;
import freenet.client.FECJob;
import freenet.client.FECQueue;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.async.DatastoreCheckerItem;
import freenet.client.async.InsertCompressor;
import freenet.client.async.PersistentCooldownQueueItem;
import freenet.client.async.RegisterMe;
import freenet.client.async.SplitFileInserterSegment;
import freenet.clients.http.SimpleToadletServer;
import freenet.config.EnumerableOptionCallback;
import freenet.config.FreenetFilePersistentConfig;
import freenet.config.InvalidConfigValueException;
import freenet.config.NodeNeedRestartException;
import freenet.config.PersistentConfig;
import freenet.config.SubConfig;
import freenet.crypt.DSAPublicKey;
import freenet.crypt.EncryptingIoAdapter;
import freenet.crypt.RandomSource;
import freenet.crypt.Yarrow;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.IOStatisticCollector;
import freenet.io.comm.Message;
import freenet.io.comm.MessageCore;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.Peer;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.io.comm.UdpSocketHandler;
import freenet.io.xfer.PartiallyReceivedBlock;
import freenet.keys.CHKBlock;
import freenet.keys.CHKVerifyException;
import freenet.keys.ClientCHK;
import freenet.keys.ClientCHKBlock;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.ClientSSK;
import freenet.keys.ClientSSKBlock;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.KeyVerifyException;
import freenet.keys.NodeCHK;
import freenet.keys.NodeSSK;
import freenet.keys.SSKBlock;
import freenet.keys.SSKVerifyException;
import freenet.l10n.BaseL10n;
import freenet.l10n.NodeL10n;
import freenet.node.Announcer;
import freenet.node.CHKInsertSender;
import freenet.node.DNSRequester;
import freenet.node.DarknetPeerNode;
import freenet.node.DatabaseKey;
import freenet.node.FSParseException;
import freenet.node.FailureTable;
import freenet.node.InsertTag;
import freenet.node.Location;
import freenet.node.LocationManager;
import freenet.node.LoggingConfigHandler;
import freenet.node.MasterKeys;
import freenet.node.MasterKeysFileSizeException;
import freenet.node.MasterKeysWrongPasswordException;
import freenet.node.NodeClientCore;
import freenet.node.NodeCrypto;
import freenet.node.NodeCryptoConfig;
import freenet.node.NodeDispatcher;
import freenet.node.NodeGetPubkey;
import freenet.node.NodeIPDetector;
import freenet.node.NodeInitException;
import freenet.node.NodeStarter;
import freenet.node.NodeStats;
import freenet.node.NodeToNodeMessageListener;
import freenet.node.OpennetDisabledException;
import freenet.node.OpennetManager;
import freenet.node.OpennetPeerNode;
import freenet.node.PacketSender;
import freenet.node.PeerManager;
import freenet.node.PeerNode;
import freenet.node.ProgramDirectory;
import freenet.node.RequestClient;
import freenet.node.RequestSender;
import freenet.node.RequestTag;
import freenet.node.RequestTracker;
import freenet.node.SSKInsertSender;
import freenet.node.SecurityLevels;
import freenet.node.SeedServerTestPeerNode;
import freenet.node.SemiOrderedShutdownHook;
import freenet.node.TimeSkewDetectorCallback;
import freenet.node.UptimeEstimator;
import freenet.node.Version;
import freenet.node.fcp.FCPClient;
import freenet.node.probe.Listener;
import freenet.node.probe.Type;
import freenet.node.stats.DataStoreInstanceType;
import freenet.node.stats.DataStoreKeyType;
import freenet.node.stats.DataStoreStats;
import freenet.node.stats.DataStoreType;
import freenet.node.stats.NotAvailNodeStoreStats;
import freenet.node.stats.StoreCallbackStats;
import freenet.node.updater.NodeUpdateManager;
import freenet.node.useralerts.MeaningfulNodeNameUserAlert;
import freenet.node.useralerts.NotEnoughNiceLevelsUserAlert;
import freenet.node.useralerts.SimpleUserAlert;
import freenet.node.useralerts.TimeSkewDetectedUserAlert;
import freenet.node.useralerts.UserAlert;
import freenet.pluginmanager.ForwardPort;
import freenet.pluginmanager.PluginDownLoaderOfficialHTTPS;
import freenet.pluginmanager.PluginManager;
import freenet.pluginmanager.PluginStore;
import freenet.store.BlockMetadata;
import freenet.store.CHKStore;
import freenet.store.CachingFreenetStore;
import freenet.store.FreenetStore;
import freenet.store.KeyCollisionException;
import freenet.store.NullFreenetStore;
import freenet.store.PubkeyStore;
import freenet.store.RAMFreenetStore;
import freenet.store.SSKStore;
import freenet.store.SlashdotStore;
import freenet.store.StorableBlock;
import freenet.store.StoreCallback;
import freenet.store.saltedhash.SaltedHashFreenetStore;
import freenet.support.Executor;
import freenet.support.Fields;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.OOMHandler;
import freenet.support.PrioritizedTicker;
import freenet.support.ShortBuffer;
import freenet.support.SimpleFieldSet;
import freenet.support.SizeUtil;
import freenet.support.Ticker;
import freenet.support.TokenBucket;
import freenet.support.api.StringCallback;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import freenet.support.io.NativeThread;
import freenet.support.io.PersistentBlobTempBucketTag;
import freenet.support.math.MersenneTwister;
import freenet.support.transport.ip.HostnameSyntaxException;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.tanukisoftware.wrapper.WrapperManager;

public class Node
implements TimeSkewDetectorCallback {
    volatile CHKStore oldCHK;
    volatile PubkeyStore oldPK;
    volatile SSKStore oldSSK;
    volatile CHKStore oldCHKCache;
    volatile PubkeyStore oldPKCache;
    volatile SSKStore oldSSKCache;
    volatile CHKStore oldCHKClientCache;
    volatile PubkeyStore oldPKClientCache;
    volatile SSKStore oldSSKClientCache;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private static MeaningfulNodeNameUserAlert nodeNameUserAlert;
    private static TimeSkewDetectedUserAlert timeSkewDetectedUserAlert;
    private final File dbFile;
    private final File dbFileCrypt;
    private boolean defragDatabaseOnStartup;
    private boolean defragOnce;
    public ObjectContainer db;
    public long nodeDBHandle;
    private boolean autoChangeDatabaseEncryption;
    private DatabaseKey databaseKey;
    public final NodeStats nodeStats;
    public final PersistentConfig config;
    static File logDir;
    static long maxLogSize;
    public static LoggingConfigHandler logConfigHandler;
    public static final int PACKETS_IN_BLOCK = 32;
    public static final int PACKET_SIZE = 1024;
    public static final double DECREMENT_AT_MIN_PROB = 0.25;
    public static final double DECREMENT_AT_MAX_PROB = 0.5;
    public static final long KEEPALIVE_INTERVAL;
    public static final long MAX_PEER_INACTIVITY;
    public static final int HANDSHAKE_TIMEOUT;
    public static final int MIN_TIME_BETWEEN_HANDSHAKE_SENDS;
    public static final int RANDOMIZED_TIME_BETWEEN_HANDSHAKE_SENDS;
    public static final int MIN_TIME_BETWEEN_VERSION_PROBES;
    public static final int RANDOMIZED_TIME_BETWEEN_VERSION_PROBES;
    public static final int MIN_TIME_BETWEEN_VERSION_SENDS;
    public static final int RANDOMIZED_TIME_BETWEEN_VERSION_SENDS;
    public static final int MIN_TIME_BETWEEN_BURSTING_HANDSHAKE_BURSTS;
    public static final int RANDOMIZED_TIME_BETWEEN_BURSTING_HANDSHAKE_BURSTS;
    public static final int MIN_BURSTING_HANDSHAKE_BURST_SIZE = 1;
    public static final int RANDOMIZED_BURSTING_HANDSHAKE_BURST_SIZE = 3;
    public static final long ALARM_TIME;
    static final long MIN_INTERVAL_BETWEEN_INCOMING_SWAP_REQUESTS;
    static final long MIN_INTERVAL_BETWEEN_INCOMING_PROBE_REQUESTS;
    public static final int SYMMETRIC_KEY_LENGTH = 32;
    private final ProgramDirectory storeDir;
    private String storeType;
    private boolean storeUseSlotFilters;
    private boolean storeSaltHashResizeOnStart;
    public static final int sizePerKey = 34988;
    private long maxTotalKeys;
    long maxCacheKeys;
    long maxStoreKeys;
    private long maxTotalDatastoreSize;
    private boolean storeForceBigShrinks;
    private final SemiOrderedShutdownHook shutdownHook;
    private CHKStore chkDatastore;
    private SSKStore sskDatastore;
    private PubkeyStore pubKeyDatastore;
    private String clientCacheType;
    private boolean clientCacheAwaitingPassword;
    private boolean databaseAwaitingPassword;
    long maxClientCacheKeys;
    private long maxTotalClientCacheSize;
    private byte[] cachedClientCacheKey;
    private CHKStore chkDatacache;
    private SSKStore sskDatacache;
    private PubkeyStore pubKeyDatacache;
    private CHKStore chkClientcache;
    private SSKStore sskClientcache;
    private PubkeyStore pubKeyClientcache;
    private long maxSlashdotCacheSize;
    private int maxSlashdotCacheKeys;
    static final long PURGE_INTERVAL;
    private CHKStore chkSlashdotcache;
    private SlashdotStore<CHKBlock> chkSlashdotcacheStore;
    private SSKStore sskSlashdotcache;
    private SlashdotStore<SSKBlock> sskSlashdotcacheStore;
    private PubkeyStore pubKeySlashdotcache;
    private SlashdotStore<DSAPublicKey> pubKeySlashdotcacheStore;
    private boolean useSlashdotCache;
    private boolean writeLocalToDatastore;
    final NodeGetPubkey getPubKey;
    public final FetchContext arkFetcherContext;
    public final NodeIPDetector ipDetector;
    boolean disableProbabilisticHTLs;
    public final RequestTracker tracker;
    public long swapIdentifier;
    private String myName;
    public final LocationManager lm;
    public final PeerManager peers;
    final ProgramDirectory nodeDir;
    final ProgramDirectory cfgDir;
    final ProgramDirectory userDir;
    final ProgramDirectory runDir;
    final ProgramDirectory pluginDir;
    final File masterKeysFile;
    final File extraPeerDataDir;
    public final RandomSource random;
    public final SecureRandom secureRandom;
    public final Random fastWeakRandom;
    final MessageCore usm;
    NodeCrypto darknetCrypto;
    private boolean showFriendsVisibilityAlert;
    private final NodeCryptoConfig opennetCryptoConfig;
    OpennetManager opennet;
    private volatile boolean isAllowedToConnectToSeednodes;
    private int maxOpennetPeers;
    private boolean acceptSeedConnections;
    private boolean passOpennetRefsThroughDarknet;
    public final Executor executor;
    public final PacketSender ps;
    public final PrioritizedTicker ticker;
    final DNSRequester dnsr;
    final NodeDispatcher dispatcher;
    public final UptimeEstimator uptime;
    public final TokenBucket outputThrottle;
    public boolean throttleLocalData;
    private int outputBandwidthLimit;
    private int inputBandwidthLimit;
    boolean inputLimitDefault;
    final boolean enableARKs;
    final boolean enablePerNodeFailureTables;
    final boolean enableULPRDataPropagation;
    final boolean enableSwapping;
    private volatile boolean publishOurPeersLocation;
    private volatile boolean routeAccordingToOurPeersLocation;
    boolean enableSwapQueueing;
    boolean enablePacketCoalescing;
    public static final short DEFAULT_MAX_HTL = 18;
    private short maxHTL;
    private boolean skipWrapperWarning;
    private int maxPacketSize;
    public static final boolean IGNORE_LOW_BACKOFF_DEFAULT = false;
    public static final long LOW_BACKOFF;
    public static final boolean PREFER_INSERT_DEFAULT = false;
    public static final boolean FORK_ON_CACHEABLE_DEFAULT = true;
    public final IOStatisticCollector collector;
    public static final int N2N_MESSAGE_TYPE_FPROXY = 1;
    public static final int N2N_MESSAGE_TYPE_DIFFNODEREF = 2;
    public static final int N2N_TEXT_MESSAGE_TYPE_USERALERT = 1;
    public static final int N2N_TEXT_MESSAGE_TYPE_FILE_OFFER = 2;
    public static final int N2N_TEXT_MESSAGE_TYPE_FILE_OFFER_ACCEPTED = 3;
    public static final int N2N_TEXT_MESSAGE_TYPE_FILE_OFFER_REJECTED = 4;
    public static final int N2N_TEXT_MESSAGE_TYPE_BOOKMARK = 5;
    public static final int N2N_TEXT_MESSAGE_TYPE_DOWNLOAD = 6;
    public static final int EXTRA_PEER_DATA_TYPE_N2NTM = 1;
    public static final int EXTRA_PEER_DATA_TYPE_PEER_NOTE = 2;
    public static final int EXTRA_PEER_DATA_TYPE_QUEUED_TO_SEND_N2NM = 3;
    public static final int EXTRA_PEER_DATA_TYPE_BOOKMARK = 4;
    public static final int EXTRA_PEER_DATA_TYPE_DOWNLOAD = 5;
    public static final int PEER_NOTE_TYPE_PRIVATE_DARKNET_COMMENT = 1;
    public final long lastBootID;
    public final long bootID;
    public final long startupTime;
    private SimpleToadletServer toadlets;
    public final NodeClientCore clientCore;
    final FailureTable failureTable;
    public int lastVersion;
    public final NodeUpdateManager nodeUpdater;
    public final SecurityLevels securityLevels;
    public final PluginManager pluginManager;
    public final InetAddress localhostAddress;
    public final FreenetInetAddress fLocalhostAddress;
    private static NodeStarter nodeStarter;
    private boolean hasStarted;
    private boolean isStopping;
    static final int MIN_UPTIME_STORE_KEY = 40;
    private volatile boolean isPRNGReady;
    private boolean storePreallocate;
    private boolean enableRoutedPing;
    private static final int minimumBandwidth = 5120;
    private final Object writeNodeFileSync;
    private boolean databaseEncrypted;
    private volatile boolean notEnoughSpaceForAutoCrypt;
    private volatile boolean notEnoughSpaceIsCrypt;
    private volatile boolean notEnoughSpaceRenameFailed;
    private volatile File renameFailedFrom;
    private volatile File renameFailedTo;
    private volatile long notEnoughSpaceMinimumSpace;
    private final UserAlert masterPasswordUserAlert;
    private long cachingFreenetStoreMaxSize;
    private long cachingFreenetStorePeriod;
    private static boolean jvmHasGCJCharConversionBug;
    long timeLastDumpedHits;
    final boolean decrementAtMax;
    final boolean decrementAtMin;
    static final int SIGNATURE_PARAMETER_LENGTH = 32;
    private Map<Integer, NodeToNodeMessageListener> n2nmListeners;
    private NodeToNodeMessageListener diffNoderefListener;
    private NodeToNodeMessageListener fproxyN2NMListener;
    private volatile Object statsSync;
    private long totalPayloadSent;
    private SimpleUserAlert alertMTUTooSmall;
    public final RequestClient nonPersistentClientBulk;
    public final RequestClient nonPersistentClientRT;
    private boolean enteredPassword;
    private UserAlert visibilityAlert;

    private <T extends StorableBlock> void migrateOldStore(StoreCallback<T> old, StoreCallback<T> newStore, boolean canReadClientCache) {
        FreenetStore<T> store = old.getStore();
        if (store instanceof RAMFreenetStore) {
            RAMFreenetStore ramstore = (RAMFreenetStore)store;
            try {
                ramstore.migrateTo(newStore, canReadClientCache);
            }
            catch (IOException e) {
                Logger.error(this, "Caught migrating old store: " + e, (Throwable)e);
            }
            ramstore.clear();
        } else if (store instanceof SaltedHashFreenetStore) {
            Logger.error(this, "Migrating from from a saltedhashstore not fully supported yet: will not keep old keys");
        }
    }

    public <T extends StorableBlock> void closeOldStore(StoreCallback<T> old) {
        FreenetStore<T> store = old.getStore();
        if (store instanceof SaltedHashFreenetStore) {
            SaltedHashFreenetStore saltstore = (SaltedHashFreenetStore)store;
            saltstore.close();
            saltstore.destruct();
        }
    }

    public static int getMinimumBandwidth() {
        return 5120;
    }

    private InvalidConfigValueException lowBandwidthLimit(int limit) {
        return new InvalidConfigValueException(this.l10n("bandwidthMinimum", new String[]{"limit", "minimum"}, new String[]{Integer.toString(limit), Integer.toString(5120)}));
    }

    public void startProbe(byte htl, long uid, Type type, Listener listener) {
        this.dispatcher.probe.start(htl, uid, type, listener);
    }

    private void readNodeFile(String filename) throws IOException {
        String verString;
        FileInputStream fis = new FileInputStream(filename);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
        BufferedReader br = new BufferedReader(isr);
        SimpleFieldSet fs = new SimpleFieldSet(br, false, true);
        br.close();
        String[] udp = fs.getAll("physical.udp");
        if (udp != null && udp.length > 0) {
            for (String udpAddr : udp) {
                Peer p;
                try {
                    p = new Peer(udpAddr, false, true);
                }
                catch (HostnameSyntaxException e) {
                    Logger.error(this, "Invalid hostname or IP Address syntax error while parsing our darknet node reference: " + udpAddr);
                    System.err.println("Invalid hostname or IP Address syntax error while parsing our darknet node reference: " + udpAddr);
                    continue;
                }
                catch (PeerParseException e) {
                    throw (IOException)new IOException().initCause(e);
                }
                if (p.getPort() != this.getDarknetPortNumber()) continue;
                this.ipDetector.setOldIPAddress(p.getFreenetAddress());
                break;
            }
        }
        this.darknetCrypto.readCrypto(fs);
        this.swapIdentifier = Fields.bytesToLong(this.darknetCrypto.identityHashHash);
        String loc = fs.get("location");
        double locD = Location.getLocation(loc);
        if (locD == -1.0) {
            throw new IOException("Invalid location: " + loc);
        }
        this.lm.setLocation(locD);
        this.myName = fs.get("myName");
        if (this.myName == null) {
            this.myName = this.newName();
        }
        if ((verString = fs.get("version")) == null) {
            Logger.error(this, "No version!");
            System.err.println("No version!");
        } else {
            this.lastVersion = Version.getArbitraryBuildNumber(verString, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeStore(String val) throws InvalidConfigValueException {
        String suffix = this.getStoreSuffix();
        if (val.equals("salt-hash")) {
            try {
                this.initSaltHashFS(suffix, true, null);
            }
            catch (NodeInitException e) {
                Logger.error(this, "Unable to create new store", (Throwable)e);
                System.err.println("Unable to create new store: " + e);
                e.printStackTrace();
                throw new InvalidConfigValueException("Unable to create new store: " + e);
            }
        } else {
            this.initRAMFS();
        }
        Node node = this;
        synchronized (node) {
            this.storeType = val;
        }
    }

    private String newName() {
        return "Freenet node with no name #" + this.random.nextLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeNodeFile() {
        Object object = this.writeNodeFileSync;
        synchronized (object) {
            this.writeNodeFile(this.nodeDir.file("node-" + this.getDarknetPortNumber()), this.nodeDir.file("node-" + this.getDarknetPortNumber() + ".bak"));
        }
    }

    public void writeOpennetFile() {
        OpennetManager om = this.opennet;
        if (om != null) {
            om.writeFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNodeFile(File orig, File backup) {
        SimpleFieldSet fs = this.darknetCrypto.exportPrivateFieldSet();
        if (orig.exists()) {
            backup.delete();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(backup);
            fs.writeTo(fos);
            fos.close();
            fos = null;
            FileUtil.renameTo(backup, orig);
        }
        catch (IOException ioe) {
            try {
                Logger.error(this, "IOE :" + ioe.getMessage(), (Throwable)ioe);
            }
            catch (Throwable throwable) {
                Closer.close(fos);
                throw throwable;
            }
            Closer.close(fos);
            return;
        }
        Closer.close(fos);
    }

    private void initNodeFileSettings() {
        Logger.normal(this, "Creating new node file from scratch");
        this.darknetCrypto.initCrypto();
        this.swapIdentifier = Fields.bytesToLong(this.darknetCrypto.identityHashHash);
        this.myName = this.newName();
    }

    public static void main(String[] args) throws IOException {
        NodeStarter.main(args);
    }

    public boolean isUsingWrapper() {
        return nodeStarter != null && WrapperManager.isControlledByNativeWrapper();
    }

    public NodeStarter getNodeStarter() {
        return nodeStarter;
    }

    /*
     * Exception decompiling
     */
    Node(PersistentConfig config, RandomSource r, RandomSource weakRandom, LoggingConfigHandler lc, NodeStarter ns, Executor executor) throws NodeInitException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deleteOldBDBIndexStoreFiles() {
        File[] list;
        File dbDir = this.storeDir.file("database-" + this.getDarknetPortNumber());
        FileUtil.removeAll(dbDir);
        File dir = this.storeDir.dir();
        for (File f : list = dir.listFiles()) {
            String name = f.getName();
            if (!f.isFile() || !name.toLowerCase().matches("((chk)|(ssk)|(pubkey))-[0-9]*\\.((store)|(cache))(\\.((keys)|(lru)))?")) continue;
            System.out.println("Deleting old datastore file \"" + f + "\"");
            try {
                FileUtil.secureDelete(f);
            }
            catch (IOException e) {
                System.err.println("Failed to delete old datastore file \"" + f + "\": " + e);
                e.printStackTrace();
            }
        }
    }

    private void fixCertsFiles() {
        File certs = new File("startssl.pem");
        this.fixCertsFile(certs);
        if (FileUtil.detectedOS.isWindows) {
            certs = new File("updater", "startssl.pem");
            this.fixCertsFile(certs);
        }
    }

    private void fixCertsFile(File certs) {
        long oldLength = certs.exists() ? certs.length() : -1L;
        try {
            File tmpFile = File.createTempFile("startssl.pem", ".tmp", new File("."));
            PluginDownLoaderOfficialHTTPS.writeCertsTo(tmpFile);
            if (FileUtil.renameTo(tmpFile, certs)) {
                long newLength = certs.length();
                if (newLength != oldLength) {
                    System.err.println("Updated " + certs + " so that update scripts will work");
                }
            } else if (certs.length() != tmpFile.length()) {
                System.err.println("Cannot update " + certs + " : last-resort update scripts (in particular update.cmd on Windows) may not work");
                File manual = new File("startssl.pem.new");
                manual.delete();
                if (tmpFile.renameTo(manual)) {
                    System.err.println("Please delete " + certs + " and rename " + manual + " over it");
                } else {
                    tmpFile.delete();
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public ProgramDirectory setupProgramDir(SubConfig installConfig, String cfgKey, String defaultValue, String shortdesc, String longdesc, String moveErrMsg, SubConfig oldConfig) throws NodeInitException {
        ProgramDirectory dir = new ProgramDirectory(moveErrMsg);
        int sortOrder = ProgramDirectory.nextOrder();
        installConfig.register(cfgKey, defaultValue, sortOrder, true, true, shortdesc, longdesc, dir.getStringCallback());
        String dirName = installConfig.getString(cfgKey);
        try {
            dir.move(dirName);
        }
        catch (IOException e) {
            throw new NodeInitException(15, "could not set up directory: " + longdesc);
        }
        return dir;
    }

    protected ProgramDirectory setupProgramDir(SubConfig installConfig, String cfgKey, String defaultValue, String shortdesc, String longdesc, SubConfig oldConfig) throws NodeInitException {
        return this.setupProgramDir(installConfig, cfgKey, defaultValue, shortdesc, longdesc, null, oldConfig);
    }

    public void lateSetupDatabase(DatabaseKey databaseKey) throws MasterKeysWrongPasswordException, MasterKeysFileSizeException, IOException {
        if (this.db != null) {
            return;
        }
        System.out.println("Starting late database initialisation");
        this.setupDatabase(databaseKey);
        this.nodeDBHandle = this.darknetCrypto.getNodeHandle(this.db);
        if (this.db != null) {
            this.db.commit();
            if (logMINOR) {
                Logger.minor(this, "COMMITTED");
            }
            try {
                if (!this.clientCore.lateInitDatabase(this.nodeDBHandle, this.db)) {
                    this.failLateInitDatabase();
                }
            }
            catch (NodeInitException e) {
                this.failLateInitDatabase();
            }
        }
    }

    private void failLateInitDatabase() {
        System.err.println("Failed late initialisation of database, closing...");
        this.db.close();
        this.db = null;
    }

    private Configuration getNewDatabaseConfiguration(DatabaseKey databaseKey) {
        Configuration dbConfig = Db4o.newConfiguration();
        dbConfig.freespace().useBTreeSystem();
        dbConfig.objectClass(PersistentCooldownQueueItem.class).objectField("key").indexed(true);
        dbConfig.objectClass(PersistentCooldownQueueItem.class).objectField("keyAsBytes").indexed(true);
        dbConfig.objectClass(PersistentCooldownQueueItem.class).objectField("time").indexed(true);
        dbConfig.objectClass(RegisterMe.class).objectField("core").indexed(true);
        dbConfig.objectClass(RegisterMe.class).objectField("priority").indexed(true);
        dbConfig.objectClass(PersistentCooldownQueueItem.class).objectField("time").indexed(true);
        dbConfig.objectClass(FECJob.class).objectField("priority").indexed(true);
        dbConfig.objectClass(FECJob.class).objectField("addedTime").indexed(true);
        dbConfig.objectClass(FECJob.class).objectField("queue").indexed(true);
        dbConfig.objectClass(InsertCompressor.class).objectField("nodeDBHandle").indexed(true);
        dbConfig.objectClass(FCPClient.class).objectField("name").indexed(true);
        dbConfig.objectClass(DatastoreCheckerItem.class).objectField("prio").indexed(true);
        dbConfig.objectClass(DatastoreCheckerItem.class).objectField("getter").indexed(true);
        dbConfig.objectClass(PersistentBlobTempBucketTag.class).objectField("index").indexed(true);
        dbConfig.objectClass(PersistentBlobTempBucketTag.class).objectField("bucket").indexed(true);
        dbConfig.objectClass(PersistentBlobTempBucketTag.class).objectField("factory").indexed(true);
        dbConfig.objectClass(PersistentBlobTempBucketTag.class).objectField("isFree").indexed(true);
        dbConfig.objectClass(FetchException.class).cascadeOnDelete(true);
        dbConfig.objectClass(PluginStore.class).cascadeOnDelete(true);
        dbConfig.messageLevel(1);
        dbConfig.activationDepth(1);
        dbConfig.automaticShutDown(false);
        dbConfig.blockSize(8);
        dbConfig.diagnostic().addListener((DiagnosticListener)new DB4ODiagnosticListener());
        dbConfig.exceptionsOnNotStorable(true);
        System.err.println("Optimise native queries: " + dbConfig.optimizeNativeQueries());
        System.err.println("Query activation depth: " + dbConfig.activationDepth());
        if (databaseKey != null) {
            IoAdapter baseAdapter = dbConfig.io();
            try {
                dbConfig.io((IoAdapter)databaseKey.createEncryptingDb4oAdapter(baseAdapter));
            }
            catch (GlobalOnlyConfigException e) {
                System.err.println("Caught " + (Object)((Object)e) + " opening encrypted database.");
                e.printStackTrace();
                WrapperManager.restart();
                throw e;
            }
        }
        return dbConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupDatabase(DatabaseKey databaseKey) throws MasterKeysWrongPasswordException, MasterKeysFileSizeException, IOException {
        ObjectContainer database;
        block78: {
            File dbFileBackup = new File(this.dbFile.getPath() + ".tmp");
            File dbFileCryptBackup = new File(this.dbFileCrypt.getPath() + ".tmp");
            if (dbFileBackup.exists() && !this.dbFile.exists() && !dbFileBackup.renameTo(this.dbFile)) {
                throw new IOException("Database backup file " + dbFileBackup + " exists but cannot be renamed to " + this.dbFile + ". Not loading database, please fix permissions problems!");
            }
            if (dbFileCryptBackup.exists() && !this.dbFileCrypt.exists() && !dbFileCryptBackup.renameTo(this.dbFileCrypt)) {
                throw new IOException("Database backup file " + dbFileCryptBackup + " exists but cannot be renamed to " + this.dbFileCrypt + ". Not loading database, please fix permissions problems!");
            }
            try {
                Node bytes2;
                long read;
                byte[] buf;
                long length;
                File tempFile;
                Object adapter;
                RandomAccessFileAdapter baseAdapter;
                Object keys;
                Node node;
                if (this.securityLevels.getPhysicalThreatLevel() == SecurityLevels.PHYSICAL_THREAT_LEVEL.MAXIMUM) {
                    databaseKey = DatabaseKey.createRandom(this.random);
                    node = this;
                    synchronized (node) {
                        this.databaseKey = databaseKey;
                    }
                    FileUtil.secureDelete(this.dbFileCrypt);
                    FileUtil.secureDelete(this.dbFile);
                    database = this.openCryptDatabase(databaseKey);
                    node = this;
                    synchronized (node) {
                        this.databaseEncrypted = true;
                        break block78;
                    }
                }
                if (this.dbFile.exists() && this.securityLevels.getPhysicalThreatLevel() == SecurityLevels.PHYSICAL_THREAT_LEVEL.LOW) {
                    this.maybeDefragmentDatabase(this.dbFile, null);
                    database = Db4o.openFile((Configuration)this.getNewDatabaseConfiguration(null), (String)this.dbFile.toString());
                    node = this;
                    synchronized (node) {
                        this.databaseEncrypted = false;
                        break block78;
                    }
                }
                if (this.dbFileCrypt.exists() && this.securityLevels.getPhysicalThreatLevel() == SecurityLevels.PHYSICAL_THREAT_LEVEL.LOW && this.autoChangeDatabaseEncryption && this.enoughSpaceForAutoChangeEncryption(this.dbFileCrypt, false)) {
                    int bytes2;
                    if (databaseKey == null) {
                        try {
                            keys = MasterKeys.read(this.masterKeysFile, this.random, "");
                        }
                        catch (MasterKeysWrongPasswordException e) {
                            System.err.println("Unable to decrypt the node.db4o. Please enter the correct password and set the physical security level to LOW via the GUI.");
                            this.securityLevels.setThreatLevel(SecurityLevels.PHYSICAL_THREAT_LEVEL.HIGH);
                            throw e;
                        }
                        databaseKey = ((MasterKeys)keys).createDatabaseKey(this.random);
                        Node e = this;
                        synchronized (e) {
                            this.databaseKey = databaseKey;
                        }
                        ((MasterKeys)keys).clearAll();
                    }
                    System.err.println("Decrypting the old node.db4o.crypt ...");
                    baseAdapter = new RandomAccessFileAdapter();
                    adapter = databaseKey.createEncryptingDb4oAdapter((IoAdapter)baseAdapter);
                    tempFile = new File(this.dbFile.getPath() + ".tmp");
                    tempFile.deleteOnExit();
                    FileOutputStream fos = new FileOutputStream(tempFile);
                    EncryptingIoAdapter readAdapter = (EncryptingIoAdapter)((EncryptingIoAdapter)((Object)adapter)).open(this.dbFileCrypt.toString(), false, 0L, true);
                    length = readAdapter.getLength();
                    WrapperManager.signalStarting((int)((int)Math.min(TimeUnit.DAYS.toMillis(1L), TimeUnit.MINUTES.toMillis(5L) + length)));
                    buf = new byte[65536];
                    for (read = 0L; read < length; read += (long)bytes2) {
                        bytes2 = (int)Math.min((long)buf.length, length - read);
                        if ((bytes2 = readAdapter.read(buf, bytes2)) < 0) {
                            throw new EOFException();
                        }
                        fos.write(buf, 0, bytes2);
                    }
                    fos.close();
                    readAdapter.close();
                    if (FileUtil.renameTo(tempFile, this.dbFile)) {
                        this.dbFileCrypt.delete();
                        database = Db4o.openFile((Configuration)this.getNewDatabaseConfiguration(null), (String)this.dbFile.toString());
                        System.err.println("Completed decrypting the old node.db4o.crypt.");
                        bytes2 = this;
                        synchronized (bytes2) {
                            this.databaseEncrypted = false;
                            break block78;
                        }
                    }
                    bytes2 = this;
                    synchronized (bytes2) {
                        this.notEnoughSpaceIsCrypt = false;
                        this.notEnoughSpaceForAutoCrypt = true;
                        this.notEnoughSpaceRenameFailed = true;
                        this.renameFailedFrom = tempFile;
                        this.renameFailedTo = this.dbFile;
                        this.databaseEncrypted = true;
                    }
                    database = this.openCryptDatabase(databaseKey);
                    break block78;
                }
                if (this.dbFile.exists() && this.securityLevels.getPhysicalThreatLevel() != SecurityLevels.PHYSICAL_THREAT_LEVEL.LOW && this.autoChangeDatabaseEncryption && this.enoughSpaceForAutoChangeEncryption(this.dbFile, true)) {
                    int bytes32;
                    this.maybeDefragmentDatabase(this.dbFile, null);
                    if (databaseKey == null) {
                        keys = MasterKeys.read(this.masterKeysFile, this.random, "");
                        databaseKey = ((MasterKeys)keys).createDatabaseKey(this.random);
                        adapter = this;
                        synchronized (adapter) {
                            this.databaseKey = databaseKey;
                        }
                        ((MasterKeys)keys).clearAll();
                    }
                    System.err.println("Encrypting the old node.db4o ...");
                    baseAdapter = new RandomAccessFileAdapter();
                    adapter = databaseKey.createEncryptingDb4oAdapter((IoAdapter)baseAdapter);
                    tempFile = new File(this.dbFileCrypt.getPath() + ".tmp");
                    tempFile.delete();
                    tempFile.deleteOnExit();
                    EncryptingIoAdapter readAdapter = (EncryptingIoAdapter)((EncryptingIoAdapter)((Object)adapter)).open(tempFile.getPath(), false, 0L, false);
                    FileInputStream fis = new FileInputStream(this.dbFile);
                    length = this.dbFile.length();
                    WrapperManager.signalStarting((int)((int)Math.min(TimeUnit.DAYS.toMillis(1L), TimeUnit.MINUTES.toMillis(5L) + length)));
                    buf = new byte[65536];
                    for (read = 0L; read < length; read += (long)bytes32) {
                        bytes32 = (int)Math.min((long)buf.length, length - read);
                        if ((bytes32 = fis.read(buf, 0, bytes32)) < 0) {
                            throw new EOFException();
                        }
                        readAdapter.write(buf, bytes32);
                    }
                    fis.close();
                    readAdapter.close();
                    if (FileUtil.renameTo(tempFile, this.dbFileCrypt)) {
                        FileUtil.secureDelete(this.dbFile);
                        System.err.println("Completed encrypting the old node.db4o.");
                        database = this.openCryptDatabase(databaseKey);
                        bytes2 = this;
                        synchronized (bytes2) {
                            this.databaseEncrypted = true;
                            break block78;
                        }
                    }
                    Node bytes32 = this;
                    synchronized (bytes32) {
                        this.notEnoughSpaceIsCrypt = true;
                        this.notEnoughSpaceForAutoCrypt = true;
                        this.notEnoughSpaceRenameFailed = true;
                        this.renameFailedFrom = tempFile;
                        this.renameFailedTo = this.dbFileCrypt;
                    }
                    throw new IOException("Unable to encrypt the old node.db4o.crypt because cannot rename database file");
                }
                if (this.dbFileCrypt.exists() && !this.dbFile.exists() || this.securityLevels.getPhysicalThreatLevel() == SecurityLevels.PHYSICAL_THREAT_LEVEL.NORMAL || this.securityLevels.getPhysicalThreatLevel() == SecurityLevels.PHYSICAL_THREAT_LEVEL.HIGH && databaseKey != null) {
                    if (databaseKey == null) {
                        keys = MasterKeys.read(this.masterKeysFile, this.random, "");
                        databaseKey = ((MasterKeys)keys).createDatabaseKey(this.random);
                        adapter = this;
                        synchronized (adapter) {
                            this.databaseKey = databaseKey;
                        }
                        ((MasterKeys)keys).clearAll();
                    }
                    database = this.openCryptDatabase(databaseKey);
                    keys = this;
                    synchronized (keys) {
                        this.databaseEncrypted = true;
                        break block78;
                    }
                }
                this.maybeDefragmentDatabase(this.dbFile, null);
                database = Db4o.openFile((Configuration)this.getNewDatabaseConfiguration(null), (String)this.dbFile.toString());
                keys = this;
                synchronized (keys) {
                    this.databaseEncrypted = false;
                }
            }
            catch (Db4oException e) {
                database = null;
                System.err.println("Failed to open database: " + (Object)((Object)e));
                e.printStackTrace();
            }
        }
        if (logDEBUG && database != null) {
            try {
                System.err.println("DUMPING DATABASE CONTENTS:");
                ObjectSet contents = database.queryByExample(new Object());
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                for (Object o : contents) {
                    String name = o.getClass().getName();
                    if (map.get(name) != null) {
                        map.put(name, (Integer)map.get(name) + 1);
                    } else {
                        map.put(name, 1);
                    }
                    try {
                        Logger.minor(this, "DATABASE: " + o.getClass() + ":" + o + ":" + database.ext().getID(o));
                    }
                    catch (Throwable t) {
                        Logger.minor(this, "CAUGHT " + t + " FOR CLASS " + o.getClass());
                    }
                    database.deactivate(o, 1);
                }
                int total = 0;
                for (Map.Entry entry : map.entrySet()) {
                    System.err.println((String)entry.getKey() + " : " + entry.getValue());
                    total += ((Integer)entry.getValue()).intValue();
                }
                ObjectSet segments = database.query(SplitFileInserterSegment.class);
                for (SplitFileInserterSegment seg : segments) {
                    try {
                        database.activate((Object)seg, 1);
                        boolean finished = seg.isFinished();
                        boolean cancelled = seg.isCancelled(database);
                        boolean empty = seg.isEmpty(database);
                        boolean encoded = seg.isEncoded();
                        boolean started = seg.isStarted();
                        System.out.println("Segment " + seg + " finished=" + finished + " cancelled=" + cancelled + " empty=" + empty + " encoded=" + encoded + " size=" + seg.countDataBlocks() + " data " + seg.countCheckBlocks() + " check started=" + started);
                        if (!finished && !encoded) {
                            System.out.println("Not finished and not encoded: " + seg);
                            seg.checkHasDataBlocks(true, database);
                        }
                        database.deactivate((Object)seg, 1);
                    }
                    catch (Throwable t) {
                        System.out.println("Caught " + t + " processing segment");
                        t.printStackTrace();
                    }
                }
                FECQueue.dump(database, 7);
                System.gc();
                System.runFinalization();
                System.gc();
                System.runFinalization();
                System.err.println("END DATABASE DUMP: " + total + " objects");
            }
            catch (Db4oException e) {
                System.err.println("Unable to dump database contents. Treating as corrupt database.");
                e.printStackTrace();
                try {
                    database.rollback();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    database.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                database = null;
            }
            catch (IllegalArgumentException e) {
                System.err.println("Unable to dump database contents. Treating as corrupt database.");
                e.printStackTrace();
                try {
                    database.rollback();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    database.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                database = null;
            }
        }
        this.db = database;
    }

    private boolean enoughSpaceForAutoChangeEncryption(File file, boolean isCrypt) {
        long freeSpace = FileUtil.getFreeSpace(file);
        if (freeSpace == -1L) {
            return true;
        }
        long minSpace = (long)((double)file.length() * 1.1) + 0xA00000L;
        if (freeSpace < minSpace) {
            System.err.println(this.l10n(isCrypt ? "notEnoughSpaceToAutoEncrypt" : "notEnoughSpaceToAutoDecrypt", new String[]{"size", "file"}, new String[]{SizeUtil.formatSize(minSpace), this.dbFile.getAbsolutePath()}));
            if (this.clientCore != null && this.clientCore.alerts != null) {
                this.createAutoCryptFailedUserAlert();
            } else {
                this.notEnoughSpaceIsCrypt = isCrypt;
                this.notEnoughSpaceForAutoCrypt = true;
                this.notEnoughSpaceMinimumSpace = minSpace;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectContainer openCryptDatabase(DatabaseKey databaseKey) throws IOException {
        this.maybeDefragmentDatabase(this.dbFileCrypt, databaseKey);
        ObjectContainer database = Db4o.openFile((Configuration)this.getNewDatabaseConfiguration(databaseKey), (String)this.dbFileCrypt.toString());
        Node node = this;
        synchronized (node) {
            this.databaseAwaitingPassword = false;
        }
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeDefragmentDatabase(File databaseFile, DatabaseKey databaseKey) throws IOException {
        File tmpFile;
        File backupFile;
        block18: {
            Node node = this;
            synchronized (node) {
                if (!this.defragDatabaseOnStartup) {
                    return;
                }
            }
            ObjectContainer database = Db4o.openFile((Configuration)this.getNewDatabaseConfiguration(databaseKey), (String)databaseFile.toString());
            while (!database.close()) {
            }
            if (!databaseFile.exists()) {
                return;
            }
            long length = databaseFile.length();
            WrapperManager.signalStarting((int)((int)Math.min(TimeUnit.DAYS.toMillis(1L), TimeUnit.MINUTES.toMillis(5L) + length)));
            System.err.println("Defragmenting persistent downloads database.");
            backupFile = new File(databaseFile.getPath() + ".tmp");
            FileUtil.secureDelete(backupFile);
            tmpFile = new File(databaseFile.getPath() + ".map");
            FileUtil.secureDelete(tmpFile);
            DefragmentConfig config = new DefragmentConfig(databaseFile.getPath(), backupFile.getPath(), (ContextIDMapping)new BTreeIDMapping(tmpFile.getPath()));
            config.storedClassFilter((StoredClassFilter)new AvailableClassFilter());
            config.db4oConfig(this.getNewDatabaseConfiguration(databaseKey));
            try {
                Defragment.defrag((DefragmentConfig)config);
            }
            catch (IOException e) {
                if (backupFile.exists()) {
                    System.err.println("Defrag failed. Trying to preserve original database file.");
                    FileUtil.secureDelete(databaseFile);
                    if (!backupFile.renameTo(databaseFile)) {
                        System.err.println("Unable to rename backup file back to database file! Restarting on the assumption that it didn't get closed...");
                        WrapperManager.restart();
                        throw e;
                    }
                }
            }
            catch (Db4oException e) {
                if (!backupFile.exists()) break block18;
                System.err.println("Defrag failed. Trying to preserve original database file.");
                FileUtil.secureDelete(databaseFile);
                if (backupFile.renameTo(databaseFile)) break block18;
                System.err.println("Unable to rename backup file back to database file! Restarting on the assumption that it didn't get closed...");
                WrapperManager.restart();
                throw e;
            }
        }
        System.err.println("Finalising defragmentation...");
        long oldSize = backupFile.length();
        long newSize = databaseFile.length();
        if (newSize <= 0L) {
            System.err.println("DEFRAG PRODUCED AN EMPTY FILE! Trying to restore old database file...");
            databaseFile.delete();
            if (!tmpFile.renameTo(databaseFile)) {
                System.err.println("Unable to restore old database file but it should be in " + tmpFile);
                throw new IOException("Defrag produced an empty file; Unable to restore old database file but it should be in " + tmpFile);
            }
        } else {
            double change = 100.0 * ((double)(oldSize - newSize) / (double)oldSize);
            FileUtil.secureDelete(tmpFile);
            FileUtil.secureDelete(backupFile);
            System.err.println("Defragment completed. " + SizeUtil.formatSize(oldSize) + " (" + oldSize + ") -> " + SizeUtil.formatSize(newSize) + " (" + newSize + ") (" + (int)change + "% shrink)");
        }
        Node node = this;
        synchronized (node) {
            if (!this.defragOnce) {
                return;
            }
            this.defragDatabaseOnStartup = false;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                Node.this.config.store();
            }
        }, "Store config");
    }

    public void killMasterKeysFile() throws IOException {
        MasterKeys.killMasterKeys(this.masterKeysFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClientCacheAwaitingPassword() {
        this.createPasswordUserAlert();
        Node node = this;
        synchronized (node) {
            this.clientCacheAwaitingPassword = true;
        }
    }

    private void createPasswordUserAlert() {
        this.clientCore.alerts.register(this.masterPasswordUserAlert);
    }

    private void createAutoCryptFailedUserAlert() {
        String text;
        String title;
        boolean isCrypt = this.notEnoughSpaceIsCrypt;
        if (this.notEnoughSpaceRenameFailed) {
            title = isCrypt ? this.l10n("failedToRenameEncryptingTitle") : this.l10n("failedToRenameDecryptingTitle");
            text = this.l10n(isCrypt ? "failedToRenameEncrypting" : "failedToRenameDecrypting", new String[]{"fromfile", "tofile"}, new String[]{this.renameFailedFrom.getAbsolutePath(), this.renameFailedTo.getAbsolutePath()});
        } else {
            title = isCrypt ? this.l10n("notEnoughSpaceToAutoEncryptTitle") : this.l10n("notEnoughSpaceToAutoDecryptTitle");
            text = this.l10n(isCrypt ? "notEnoughSpaceToAutoEncrypt" : "notEnoughSpaceToAutoDecrypt", new String[]{"size", "file"}, new String[]{SizeUtil.formatSize(this.notEnoughSpaceMinimumSpace), this.dbFile.getAbsolutePath()});
        }
        this.clientCore.alerts.register(new SimpleUserAlert(true, title, text, title, (short)(!isCrypt && this.db != null ? 2 : 1)));
    }

    private void initRAMClientCacheFS() {
        this.chkClientcache = new CHKStore();
        new RAMFreenetStore<CHKBlock>(this.chkClientcache, (int)Math.min(Integer.MAX_VALUE, this.maxClientCacheKeys));
        this.pubKeyClientcache = new PubkeyStore();
        new RAMFreenetStore<DSAPublicKey>(this.pubKeyClientcache, (int)Math.min(Integer.MAX_VALUE, this.maxClientCacheKeys));
        this.sskClientcache = new SSKStore(this.getPubKey);
        new RAMFreenetStore<SSKBlock>(this.sskClientcache, (int)Math.min(Integer.MAX_VALUE, this.maxClientCacheKeys));
    }

    private void initNoClientCacheFS() {
        this.chkClientcache = new CHKStore();
        new NullFreenetStore<CHKBlock>(this.chkClientcache);
        this.pubKeyClientcache = new PubkeyStore();
        new NullFreenetStore<DSAPublicKey>(this.pubKeyClientcache);
        this.sskClientcache = new SSKStore(this.getPubKey);
        new NullFreenetStore<SSKBlock>(this.sskClientcache);
    }

    private String getStoreSuffix() {
        return "-" + this.getDarknetPortNumber();
    }

    private void finishInitSaltHashFS(String suffix, NodeClientCore clientCore) {
        if (clientCore.alerts == null) {
            throw new NullPointerException();
        }
        this.chkDatastore.getStore().setUserAlertManager(clientCore.alerts);
        this.chkDatacache.getStore().setUserAlertManager(clientCore.alerts);
        this.pubKeyDatastore.getStore().setUserAlertManager(clientCore.alerts);
        this.pubKeyDatacache.getStore().setUserAlertManager(clientCore.alerts);
        this.sskDatastore.getStore().setUserAlertManager(clientCore.alerts);
        this.sskDatacache.getStore().setUserAlertManager(clientCore.alerts);
    }

    private void initRAMFS() {
        this.chkDatastore = new CHKStore();
        new RAMFreenetStore<CHKBlock>(this.chkDatastore, (int)Math.min(Integer.MAX_VALUE, this.maxStoreKeys));
        this.chkDatacache = new CHKStore();
        new RAMFreenetStore<CHKBlock>(this.chkDatacache, (int)Math.min(Integer.MAX_VALUE, this.maxCacheKeys));
        this.pubKeyDatastore = new PubkeyStore();
        new RAMFreenetStore<DSAPublicKey>(this.pubKeyDatastore, (int)Math.min(Integer.MAX_VALUE, this.maxStoreKeys));
        this.pubKeyDatacache = new PubkeyStore();
        this.getPubKey.setDataStore(this.pubKeyDatastore, this.pubKeyDatacache);
        new RAMFreenetStore<DSAPublicKey>(this.pubKeyDatacache, (int)Math.min(Integer.MAX_VALUE, this.maxCacheKeys));
        this.sskDatastore = new SSKStore(this.getPubKey);
        new RAMFreenetStore<SSKBlock>(this.sskDatastore, (int)Math.min(Integer.MAX_VALUE, this.maxStoreKeys));
        this.sskDatacache = new SSKStore(this.getPubKey);
        new RAMFreenetStore<SSKBlock>(this.sskDatacache, (int)Math.min(Integer.MAX_VALUE, this.maxCacheKeys));
    }

    private void initSaltHashFS(final String suffix, boolean dontResizeOnStart, byte[] masterKey) throws NodeInitException {
        try {
            final CHKStore chkDatastore = new CHKStore();
            final FreenetStore<CHKBlock> chkDataFS = this.makeStore("CHK", true, chkDatastore, dontResizeOnStart, masterKey);
            final CHKStore chkDatacache = new CHKStore();
            final FreenetStore<CHKBlock> chkCacheFS = this.makeStore("CHK", false, chkDatacache, dontResizeOnStart, masterKey);
            ((SaltedHashFreenetStore)chkCacheFS.getUnderlyingStore()).setAltStore((SaltedHashFreenetStore)chkDataFS.getUnderlyingStore());
            final PubkeyStore pubKeyDatastore = new PubkeyStore();
            final FreenetStore<DSAPublicKey> pubkeyDataFS = this.makeStore("PUBKEY", true, pubKeyDatastore, dontResizeOnStart, masterKey);
            final PubkeyStore pubKeyDatacache = new PubkeyStore();
            final FreenetStore<DSAPublicKey> pubkeyCacheFS = this.makeStore("PUBKEY", false, pubKeyDatacache, dontResizeOnStart, masterKey);
            ((SaltedHashFreenetStore)pubkeyCacheFS.getUnderlyingStore()).setAltStore((SaltedHashFreenetStore)pubkeyDataFS.getUnderlyingStore());
            final SSKStore sskDatastore = new SSKStore(this.getPubKey);
            final FreenetStore<SSKBlock> sskDataFS = this.makeStore("SSK", true, sskDatastore, dontResizeOnStart, masterKey);
            final SSKStore sskDatacache = new SSKStore(this.getPubKey);
            final FreenetStore<SSKBlock> sskCacheFS = this.makeStore("SSK", false, sskDatacache, dontResizeOnStart, masterKey);
            ((SaltedHashFreenetStore)sskCacheFS.getUnderlyingStore()).setAltStore((SaltedHashFreenetStore)sskDataFS.getUnderlyingStore());
            boolean delay = chkDataFS.start(this.ticker, false) | chkCacheFS.start(this.ticker, false) | pubkeyDataFS.start(this.ticker, false) | pubkeyCacheFS.start(this.ticker, false) | sskDataFS.start(this.ticker, false) | sskCacheFS.start(this.ticker, false);
            if (delay) {
                System.err.println("Delayed init of datastore");
                this.initRAMFS();
                final MigrateOldStoreData migrate = new MigrateOldStoreData(false);
                this.getTicker().queueTimedJob(new Runnable(){

                    @Override
                    public void run() {
                        System.err.println("Starting delayed init of datastore");
                        try {
                            chkDataFS.start(Node.this.ticker, true);
                            chkCacheFS.start(Node.this.ticker, true);
                            pubkeyDataFS.start(Node.this.ticker, true);
                            pubkeyCacheFS.start(Node.this.ticker, true);
                            sskDataFS.start(Node.this.ticker, true);
                            sskCacheFS.start(Node.this.ticker, true);
                        }
                        catch (IOException e) {
                            Logger.error(this, "Failed to start datastore: " + e, (Throwable)e);
                            System.err.println("Failed to start datastore: " + e);
                            e.printStackTrace();
                            return;
                        }
                        Node.this.chkDatastore = chkDatastore;
                        Node.this.chkDatacache = chkDatacache;
                        Node.this.pubKeyDatastore = pubKeyDatastore;
                        Node.this.pubKeyDatacache = pubKeyDatacache;
                        Node.this.getPubKey.setDataStore(pubKeyDatastore, pubKeyDatacache);
                        Node.this.sskDatastore = sskDatastore;
                        Node.this.sskDatacache = sskDatacache;
                        Node.this.finishInitSaltHashFS(suffix, Node.this.clientCore);
                        System.err.println("Finishing delayed init of datastore");
                        migrate.run();
                    }
                }, "Start store", 0L, true, false);
            } else {
                this.chkDatastore = chkDatastore;
                this.chkDatacache = chkDatacache;
                this.pubKeyDatastore = pubKeyDatastore;
                this.pubKeyDatacache = pubKeyDatacache;
                this.getPubKey.setDataStore(pubKeyDatastore, pubKeyDatacache);
                this.sskDatastore = sskDatastore;
                this.sskDatacache = sskDatacache;
                this.getTicker().queueTimedJob(new Runnable(){

                    @Override
                    public void run() {
                        Node.this.chkDatastore = chkDatastore;
                        Node.this.chkDatacache = chkDatacache;
                        Node.this.pubKeyDatastore = pubKeyDatastore;
                        Node.this.pubKeyDatacache = pubKeyDatacache;
                        Node.this.getPubKey.setDataStore(pubKeyDatastore, pubKeyDatacache);
                        Node.this.sskDatastore = sskDatastore;
                        Node.this.sskDatacache = sskDatacache;
                        Node.this.finishInitSaltHashFS(suffix, Node.this.clientCore);
                    }
                }, "Start store", 0L, true, false);
            }
        }
        catch (IOException e) {
            System.err.println("Could not open store: " + e);
            e.printStackTrace();
            throw new NodeInitException(3, e.getMessage());
        }
    }

    private void initSaltHashClientCacheFS(String suffix, boolean dontResizeOnStart, byte[] clientCacheMasterKey) throws NodeInitException {
        try {
            final CHKStore chkClientcache = new CHKStore();
            final FreenetStore<CHKBlock> chkDataFS = this.makeClientcache("CHK", true, chkClientcache, dontResizeOnStart, clientCacheMasterKey);
            final PubkeyStore pubKeyClientcache = new PubkeyStore();
            final FreenetStore<DSAPublicKey> pubkeyDataFS = this.makeClientcache("PUBKEY", true, pubKeyClientcache, dontResizeOnStart, clientCacheMasterKey);
            final SSKStore sskClientcache = new SSKStore(this.getPubKey);
            final FreenetStore<SSKBlock> sskDataFS = this.makeClientcache("SSK", true, sskClientcache, dontResizeOnStart, clientCacheMasterKey);
            boolean delay = chkDataFS.start(this.ticker, false) | pubkeyDataFS.start(this.ticker, false) | sskDataFS.start(this.ticker, false);
            if (delay) {
                System.err.println("Delayed init of client-cache");
                this.initRAMClientCacheFS();
                final MigrateOldStoreData migrate = new MigrateOldStoreData(true);
                this.getTicker().queueTimedJob(new Runnable(){

                    @Override
                    public void run() {
                        System.err.println("Starting delayed init of client-cache");
                        try {
                            chkDataFS.start(Node.this.ticker, true);
                            pubkeyDataFS.start(Node.this.ticker, true);
                            sskDataFS.start(Node.this.ticker, true);
                        }
                        catch (IOException e) {
                            Logger.error(this, "Failed to start client-cache: " + e, (Throwable)e);
                            System.err.println("Failed to start client-cache: " + e);
                            e.printStackTrace();
                            return;
                        }
                        Node.this.chkClientcache = chkClientcache;
                        Node.this.pubKeyClientcache = pubKeyClientcache;
                        Node.this.getPubKey.setLocalDataStore(pubKeyClientcache);
                        Node.this.sskClientcache = sskClientcache;
                        System.err.println("Finishing delayed init of client-cache");
                        migrate.run();
                    }
                }, "Migrate store", 0L, true, false);
            } else {
                this.chkClientcache = chkClientcache;
                this.pubKeyClientcache = pubKeyClientcache;
                this.getPubKey.setLocalDataStore(pubKeyClientcache);
                this.sskClientcache = sskClientcache;
            }
        }
        catch (IOException e) {
            System.err.println("Could not open store: " + e);
            e.printStackTrace();
            throw new NodeInitException(3, e.getMessage());
        }
    }

    private <T extends StorableBlock> FreenetStore<T> makeClientcache(String type, boolean isStore, StoreCallback<T> cb, boolean dontResizeOnStart, byte[] clientCacheMasterKey) throws IOException {
        FreenetStore<T> store = this.makeStore(type, "clientcache", this.maxClientCacheKeys, cb, dontResizeOnStart, clientCacheMasterKey);
        return store;
    }

    private <T extends StorableBlock> FreenetStore<T> makeStore(String type, boolean isStore, StoreCallback<T> cb, boolean dontResizeOnStart, byte[] clientCacheMasterKey) throws IOException {
        String store = isStore ? "store" : "cache";
        long maxKeys = isStore ? this.maxStoreKeys : this.maxCacheKeys;
        return this.makeStore(type, store, maxKeys, cb, dontResizeOnStart, clientCacheMasterKey);
    }

    private <T extends StorableBlock> FreenetStore<T> makeStore(String type, String store, long maxKeys, StoreCallback<T> cb, boolean lateStart, byte[] clientCacheMasterKey) throws IOException {
        Logger.normal(this, "Initializing " + type + " Data" + store);
        System.out.println("Initializing " + type + " Data" + store + " (" + this.maxStoreKeys + " keys)");
        SaltedHashFreenetStore<T> fs = SaltedHashFreenetStore.construct(this.getStoreDir(), type + "-" + store, cb, this.random, maxKeys, this.storeUseSlotFilters, this.shutdownHook, this.storePreallocate, this.storeSaltHashResizeOnStart && !lateStart, lateStart ? this.ticker : null, clientCacheMasterKey);
        cb.setStore(fs);
        if (this.cachingFreenetStoreMaxSize > 0L) {
            return new CachingFreenetStore<T>(cb, this.cachingFreenetStoreMaxSize, this.cachingFreenetStorePeriod, fs, this.ticker);
        }
        return fs;
    }

    public void start(boolean noSwaps) throws NodeInitException {
        this.peers.tryReadPeers(this.nodeDir.file("peers-" + this.getDarknetPortNumber()).getPath(), this.darknetCrypto, null, false, false);
        this.peers.updatePMUserAlert();
        this.dispatcher.start(this.nodeStats);
        this.dnsr.start();
        this.peers.start();
        this.nodeStats.start();
        this.uptime.start();
        this.failureTable.start();
        this.darknetCrypto.start();
        if (this.opennet != null) {
            this.opennet.start();
        }
        this.ps.start(this.nodeStats);
        this.ticker.start();
        this.scheduleVersionTransition();
        this.usm.start(this.ticker);
        if (this.isUsingWrapper()) {
            Logger.normal(this, "Using wrapper correctly: " + nodeStarter);
            System.out.println("Using wrapper correctly: " + nodeStarter);
        } else {
            Logger.error(this, "NOT using wrapper (at least not correctly).  Your freenet-ext.jar <http://downloads.freenetproject.org/alpha/freenet-ext.jar> and/or wrapper.conf <https://emu.freenetproject.org/svn/trunk/apps/installer/installclasspath/config/wrapper.conf> need to be updated.");
            System.out.println("NOT using wrapper (at least not correctly).  Your freenet-ext.jar <http://downloads.freenetproject.org/alpha/freenet-ext.jar> and/or wrapper.conf <https://emu.freenetproject.org/svn/trunk/apps/installer/installclasspath/config/wrapper.conf> need to be updated.");
        }
        Logger.normal(this, "Freenet 0.7.5 Build #" + Version.buildNumber() + " r" + Version.cvsRevision());
        System.out.println("Freenet 0.7.5 Build #" + Version.buildNumber() + " r" + Version.cvsRevision());
        Logger.normal(this, "FNP port is on " + this.darknetCrypto.getBindTo() + ':' + this.getDarknetPortNumber());
        System.out.println("FNP port is on " + this.darknetCrypto.getBindTo() + ':' + this.getDarknetPortNumber());
        this.ipDetector.start();
        this.lm.start();
        try {
            Logger.normal(this, "Starting the node updater");
            this.nodeUpdater.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NodeInitException(21, "Could not start Updater: " + e);
        }
        this.checkForEvilJVMBugs();
        if (!NativeThread.HAS_ENOUGH_NICE_LEVELS) {
            this.clientCore.alerts.register(new NotEnoughNiceLevelsUserAlert());
        }
        this.clientCore.start(this.config);
        this.tracker.startDeadUIDChecker();
        if (this.config instanceof FreenetFilePersistentConfig) {
            FreenetFilePersistentConfig cfg = (FreenetFilePersistentConfig)this.config;
            cfg.finishedInit(this.ticker);
            cfg.setHasNodeStarted();
        }
        this.config.store();
        this.peers.readExtraPeerData();
        Logger.normal(this, "Started node");
        this.hasStarted = true;
    }

    private void scheduleVersionTransition() {
        long transition;
        long now = System.currentTimeMillis();
        if (now < (transition = Version.transitionTime())) {
            this.ticker.queueTimedJob(new Runnable(){

                @Override
                public void run() {
                    Logger.OSThread.logPID(this);
                    for (PeerNode pn : Node.this.peers.myPeers()) {
                        pn.updateVersionRoutablity();
                    }
                }
            }, transition - now);
        }
    }

    private void checkForEvilJVMBugs() {
        String jvmVendor = System.getProperty("java.vm.vendor");
        String jvmSpecVendor = System.getProperty("java.specification.vendor", "");
        String javaVersion = System.getProperty("java.version");
        String jvmName = System.getProperty("java.vm.name");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        boolean isOpenJDK = false;
        if (logMINOR) {
            Logger.minor(this, "JVM vendor: " + jvmVendor + ", JVM name: " + jvmName + ", JVM version: " + javaVersion + ", OS name: " + osName + ", OS version: " + osVersion);
        }
        if (jvmName.startsWith("OpenJDK ")) {
            isOpenJDK = true;
        }
        if (!isOpenJDK && (jvmVendor.startsWith("Sun ") || jvmVendor.startsWith("Oracle ")) || jvmVendor.startsWith("The FreeBSD Foundation") && (jvmSpecVendor.startsWith("Sun ") || jvmSpecVendor.startsWith("Oracle ")) || jvmVendor.startsWith("Apple ")) {
            boolean is150 = javaVersion.startsWith("1.5.0_");
            boolean is160 = javaVersion.startsWith("1.6.0_");
            if (is150 || is160) {
                String[] split = javaVersion.split("_");
                String secondPart = split[1];
                if (secondPart.indexOf("-") != -1) {
                    split = secondPart.split("-");
                    secondPart = split[0];
                }
                int subver = Integer.parseInt(secondPart);
                Logger.minor(this, "JVM version: " + javaVersion + " subver: " + subver + " from " + secondPart);
            }
        } else if (!jvmVendor.startsWith("Apple ") && !jvmVendor.startsWith("\"Apple ") && !isOpenJDK && jvmVendor.startsWith("Free Software Foundation")) {
            try {
                javaVersion = System.getProperty("java.version").split(" ")[0].replaceAll("[.]", "");
                int jvmVersionInt = Integer.parseInt(javaVersion);
                if (jvmVersionInt <= 422 && jvmVersionInt >= 100) {
                    jvmHasGCJCharConversionBug = true;
                }
            }
            catch (Throwable t) {
                Logger.error(this, "GCJ version check is broken!", t);
            }
            this.clientCore.alerts.register(new SimpleUserAlert(true, this.l10n("usingGCJTitle"), this.l10n("usingGCJ"), this.l10n("usingGCJTitle"), 2));
        }
        if (!this.isUsingWrapper() && !this.skipWrapperWarning) {
            this.clientCore.alerts.register(new SimpleUserAlert(true, this.l10n("notUsingWrapperTitle"), this.l10n("notUsingWrapper"), this.l10n("notUsingWrapperShort"), 2));
        }
    }

    public static boolean checkForGCJCharConversionBug() {
        return jvmHasGCJCharConversionBug;
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("Node." + key);
    }

    private String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("Node." + key, pattern, value);
    }

    private String l10n(String key, String[] pattern, String[] value) {
        return NodeL10n.getBase().getString("Node." + key, pattern, value);
    }

    public SimpleFieldSet exportVolatileFieldSet() {
        return this.nodeStats.exportVolatileFieldSet();
    }

    public int routedPing(double loc2, byte[] pubKeyHash) {
        long uid = this.random.nextLong();
        int initialX = this.random.nextInt();
        Message m = DMT.createFNPRoutedPing(uid, loc2, this.maxHTL, initialX, pubKeyHash);
        Logger.normal(this, "Message: " + m);
        this.dispatcher.handleRouted(m, null);
        MessageFilter mf1 = MessageFilter.create().setField("uid", uid).setType(DMT.FNPRoutedPong).setTimeout(5000L);
        try {
            m = this.usm.waitFor(mf1, null);
        }
        catch (DisconnectedException e) {
            Logger.normal(this, "Disconnected in waiting for pong");
            return -1;
        }
        if (m == null) {
            return -1;
        }
        if (m.getSpec() == DMT.FNPRoutedRejected) {
            return -1;
        }
        return m.getInt("counter") - initialX;
    }

    private KeyBlock makeRequestLocal(Key key, long uid, boolean canReadClientCache, boolean canWriteClientCache, boolean canWriteDatastore, boolean offersOnly) {
        KeyBlock kb = null;
        if (key instanceof NodeCHK) {
            kb = this.fetch(key, false, canReadClientCache, canWriteClientCache, canWriteDatastore, null);
        } else if (key instanceof NodeSSK) {
            NodeSSK sskKey = (NodeSSK)key;
            DSAPublicKey pubKey = sskKey.getPubKey();
            if (pubKey == null) {
                pubKey = this.getPubKey.getKey(sskKey.getPubKeyHash(), canReadClientCache, offersOnly, null);
                if (logMINOR) {
                    Logger.minor(this, "Fetched pubkey: " + pubKey);
                }
                try {
                    sskKey.setPubKey(pubKey);
                }
                catch (SSKVerifyException e) {
                    Logger.error(this, "Error setting pubkey: " + e, (Throwable)e);
                }
            }
            if (pubKey != null) {
                if (logMINOR) {
                    Logger.minor(this, "Got pubkey: " + pubKey);
                }
                kb = this.fetch(sskKey, canReadClientCache, canWriteClientCache, canWriteDatastore, false, null);
            } else if (logMINOR) {
                Logger.minor(this, "Not found because no pubkey: " + uid);
            }
        } else {
            throw new IllegalStateException("Unknown key type: " + key.getClass());
        }
        if (kb != null) {
            if (this.clientCore != null && this.clientCore.requestStarters != null) {
                if (kb instanceof CHKBlock) {
                    this.clientCore.requestStarters.chkFetchSchedulerBulk.tripPendingKey(kb);
                    this.clientCore.requestStarters.chkFetchSchedulerRT.tripPendingKey(kb);
                } else {
                    this.clientCore.requestStarters.sskFetchSchedulerBulk.tripPendingKey(kb);
                    this.clientCore.requestStarters.sskFetchSchedulerRT.tripPendingKey(kb);
                }
            }
            this.failureTable.onFound(kb);
            return kb;
        }
        return null;
    }

    public Object makeRequestSender(Key key, short htl, long uid, RequestTag tag, PeerNode source, boolean localOnly, boolean ignoreStore, boolean offersOnly, boolean canReadClientCache, boolean canWriteClientCache, boolean realTimeFlag) {
        RequestSender sender;
        KeyBlock kb;
        boolean canWriteDatastore = this.canWriteDatastoreRequest(htl);
        if (logMINOR) {
            Logger.minor(this, "makeRequestSender(" + key + ',' + htl + ',' + uid + ',' + source + ") on " + this.getDarknetPortNumber());
        }
        if (!ignoreStore && (kb = this.makeRequestLocal(key, uid, canReadClientCache, canWriteClientCache, canWriteDatastore, offersOnly)) != null) {
            return kb;
        }
        if (localOnly) {
            return null;
        }
        if (logMINOR) {
            Logger.minor(this, "Not in store locally");
        }
        RequestSender requestSender = sender = key instanceof NodeCHK ? this.tracker.getTransferringRequestSenderByKey((NodeCHK)key, realTimeFlag) : null;
        if (sender != null) {
            if (logMINOR) {
                Logger.minor(this, "Data already being transferred: " + sender);
            }
            sender.setTransferCoalesced();
            tag.setSender(sender, true);
            return sender;
        }
        if (htl == 0) {
            if (logMINOR) {
                Logger.minor(this, "No HTL");
            }
            return null;
        }
        sender = new RequestSender(key, null, htl, uid, tag, this, source, offersOnly, canWriteClientCache, canWriteDatastore, realTimeFlag);
        tag.setSender(sender, false);
        sender.start();
        if (logMINOR) {
            Logger.minor(this, "Created new sender: " + sender);
        }
        return sender;
    }

    boolean canWriteDatastoreRequest(short htl) {
        return htl <= this.maxHTL - 2;
    }

    boolean canWriteDatastoreInsert(short htl) {
        return htl <= this.maxHTL - 3;
    }

    public KeyBlock fetch(Key key, boolean canReadClientCache, boolean canWriteClientCache, boolean canWriteDatastore, boolean forULPR, BlockMetadata meta) {
        if (key instanceof NodeSSK) {
            return this.fetch((NodeSSK)key, false, canReadClientCache, canWriteClientCache, canWriteDatastore, forULPR, meta);
        }
        if (key instanceof NodeCHK) {
            return this.fetch((NodeCHK)key, false, canReadClientCache, canWriteClientCache, canWriteDatastore, forULPR, meta);
        }
        throw new IllegalArgumentException();
    }

    public SSKBlock fetch(NodeSSK key, boolean dontPromote, boolean canReadClientCache, boolean canWriteClientCache, boolean canWriteDatastore, boolean forULPR, BlockMetadata meta) {
        boolean ignoreOldBlocks;
        SSKBlock block;
        double loc = key.toNormalizedDouble();
        double dist = Location.distance(this.lm.getLocation(), loc);
        if (canReadClientCache) {
            try {
                block = this.sskClientcache.fetch(key, dontPromote || !canWriteClientCache, canReadClientCache, forULPR, false, meta);
                if (block != null) {
                    this.nodeStats.avgClientCacheSSKSuccess.report(loc);
                    if (dist > this.nodeStats.furthestClientCacheSSKSuccess) {
                        this.nodeStats.furthestClientCacheSSKSuccess = dist;
                    }
                    if (logDEBUG) {
                        Logger.debug(this, "Found key " + key + " in client-cache");
                    }
                    return block;
                }
            }
            catch (IOException e) {
                Logger.error(this, "Could not read from client cache: " + e, (Throwable)e);
            }
        }
        if (forULPR || this.useSlashdotCache || canReadClientCache) {
            try {
                block = this.sskSlashdotcache.fetch(key, dontPromote, canReadClientCache, forULPR, false, meta);
                if (block != null) {
                    this.nodeStats.avgSlashdotCacheSSKSuccess.report(loc);
                    if (dist > this.nodeStats.furthestSlashdotCacheSSKSuccess) {
                        this.nodeStats.furthestSlashdotCacheSSKSuccess = dist;
                    }
                    if (logDEBUG) {
                        Logger.debug(this, "Found key " + key + " in slashdot-cache");
                    }
                    return block;
                }
            }
            catch (IOException e) {
                Logger.error(this, "Could not read from slashdot/ULPR cache: " + e, (Throwable)e);
            }
        }
        boolean bl = ignoreOldBlocks = !this.writeLocalToDatastore;
        if (canReadClientCache) {
            ignoreOldBlocks = false;
        }
        if (logMINOR) {
            this.dumpStoreHits();
        }
        try {
            SSKStore store;
            this.nodeStats.avgRequestLocation.report(loc);
            SSKBlock block2 = this.sskDatastore.fetch(key, dontPromote || !canWriteDatastore, canReadClientCache, forULPR, ignoreOldBlocks, meta);
            if (block2 == null && (store = this.oldSSK) != null) {
                block2 = store.fetch(key, dontPromote || !canWriteDatastore, canReadClientCache, forULPR, ignoreOldBlocks, meta);
            }
            if (block2 != null) {
                this.nodeStats.avgStoreSSKSuccess.report(loc);
                if (dist > this.nodeStats.furthestStoreSSKSuccess) {
                    this.nodeStats.furthestStoreSSKSuccess = dist;
                }
                if (logDEBUG) {
                    Logger.debug(this, "Found key " + key + " in store");
                }
                return block2;
            }
            block2 = this.sskDatacache.fetch(key, dontPromote || !canWriteDatastore, canReadClientCache, forULPR, ignoreOldBlocks, meta);
            if (block2 == null && (store = this.oldSSKCache) != null) {
                block2 = store.fetch(key, dontPromote || !canWriteDatastore, canReadClientCache, forULPR, ignoreOldBlocks, meta);
            }
            if (block2 != null) {
                this.nodeStats.avgCacheSSKSuccess.report(loc);
                if (dist > this.nodeStats.furthestCacheSSKSuccess) {
                    this.nodeStats.furthestCacheSSKSuccess = dist;
                }
            }
            if (logDEBUG) {
                Logger.debug(this, "Found key " + key + " in cache");
            }
            return block2;
        }
        catch (IOException e) {
            Logger.error(this, "Cannot fetch data: " + e, (Throwable)e);
            return null;
        }
    }

    public CHKBlock fetch(NodeCHK key, boolean dontPromote, boolean canReadClientCache, boolean canWriteClientCache, boolean canWriteDatastore, boolean forULPR, BlockMetadata meta) {
        boolean ignoreOldBlocks;
        CHKBlock block;
        double loc = key.toNormalizedDouble();
        double dist = Location.distance(this.lm.getLocation(), loc);
        if (canReadClientCache) {
            try {
                block = this.chkClientcache.fetch(key, dontPromote || !canWriteClientCache, false, meta);
                if (block != null) {
                    this.nodeStats.avgClientCacheCHKSuccess.report(loc);
                    if (dist > this.nodeStats.furthestClientCacheCHKSuccess) {
                        this.nodeStats.furthestClientCacheCHKSuccess = dist;
                    }
                    return block;
                }
            }
            catch (IOException e) {
                Logger.error(this, "Could not read from client cache: " + e, (Throwable)e);
            }
        }
        if (forULPR || this.useSlashdotCache || canReadClientCache) {
            try {
                block = this.chkSlashdotcache.fetch(key, dontPromote, false, meta);
                if (block != null) {
                    this.nodeStats.avgSlashdotCacheCHKSucess.report(loc);
                    if (dist > this.nodeStats.furthestSlashdotCacheCHKSuccess) {
                        this.nodeStats.furthestSlashdotCacheCHKSuccess = dist;
                    }
                    return block;
                }
            }
            catch (IOException e) {
                Logger.error(this, "Could not read from slashdot/ULPR cache: " + e, (Throwable)e);
            }
        }
        boolean bl = ignoreOldBlocks = !this.writeLocalToDatastore;
        if (canReadClientCache) {
            ignoreOldBlocks = false;
        }
        if (logMINOR) {
            this.dumpStoreHits();
        }
        try {
            CHKStore store;
            this.nodeStats.avgRequestLocation.report(loc);
            CHKBlock block2 = this.chkDatastore.fetch(key, dontPromote || !canWriteDatastore, ignoreOldBlocks, meta);
            if (block2 == null && (store = this.oldCHK) != null) {
                block2 = store.fetch(key, dontPromote || !canWriteDatastore, ignoreOldBlocks, meta);
            }
            if (block2 != null) {
                this.nodeStats.avgStoreCHKSuccess.report(loc);
                if (dist > this.nodeStats.furthestStoreCHKSuccess) {
                    this.nodeStats.furthestStoreCHKSuccess = dist;
                }
                return block2;
            }
            block2 = this.chkDatacache.fetch(key, dontPromote || !canWriteDatastore, ignoreOldBlocks, meta);
            if (block2 == null && (store = this.oldCHKCache) != null) {
                block2 = store.fetch(key, dontPromote || !canWriteDatastore, ignoreOldBlocks, meta);
            }
            if (block2 != null) {
                this.nodeStats.avgCacheCHKSuccess.report(loc);
                if (dist > this.nodeStats.furthestCacheCHKSuccess) {
                    this.nodeStats.furthestCacheCHKSuccess = dist;
                }
            }
            return block2;
        }
        catch (IOException e) {
            Logger.error(this, "Cannot fetch data: " + e, (Throwable)e);
            return null;
        }
    }

    CHKStore getChkDatacache() {
        return this.chkDatacache;
    }

    CHKStore getChkDatastore() {
        return this.chkDatastore;
    }

    SSKStore getSskDatacache() {
        return this.sskDatacache;
    }

    SSKStore getSskDatastore() {
        return this.sskDatastore;
    }

    CHKStore getChkSlashdotCache() {
        return this.chkSlashdotcache;
    }

    CHKStore getChkClientCache() {
        return this.chkClientcache;
    }

    SSKStore getSskSlashdotCache() {
        return this.sskSlashdotcache;
    }

    SSKStore getSskClientCache() {
        return this.sskClientcache;
    }

    public Map<DataStoreInstanceType, DataStoreStats> getDataStoreStats() {
        LinkedHashMap<DataStoreInstanceType, DataStoreStats> map = new LinkedHashMap<DataStoreInstanceType, DataStoreStats>();
        map.put(new DataStoreInstanceType(DataStoreKeyType.CHK, DataStoreType.STORE), new StoreCallbackStats(this.chkDatastore, this.nodeStats.chkStoreStats()));
        map.put(new DataStoreInstanceType(DataStoreKeyType.CHK, DataStoreType.CACHE), new StoreCallbackStats(this.chkDatacache, this.nodeStats.chkCacheStats()));
        map.put(new DataStoreInstanceType(DataStoreKeyType.CHK, DataStoreType.SLASHDOT), new StoreCallbackStats(this.chkSlashdotcache, this.nodeStats.chkSlashDotCacheStats()));
        map.put(new DataStoreInstanceType(DataStoreKeyType.CHK, DataStoreType.CLIENT), new StoreCallbackStats(this.chkClientcache, this.nodeStats.chkClientCacheStats()));
        map.put(new DataStoreInstanceType(DataStoreKeyType.SSK, DataStoreType.STORE), new StoreCallbackStats(this.sskDatastore, this.nodeStats.sskStoreStats()));
        map.put(new DataStoreInstanceType(DataStoreKeyType.SSK, DataStoreType.CACHE), new StoreCallbackStats(this.sskDatacache, this.nodeStats.sskCacheStats()));
        map.put(new DataStoreInstanceType(DataStoreKeyType.SSK, DataStoreType.SLASHDOT), new StoreCallbackStats(this.sskSlashdotcache, this.nodeStats.sskSlashDotCacheStats()));
        map.put(new DataStoreInstanceType(DataStoreKeyType.SSK, DataStoreType.CLIENT), new StoreCallbackStats(this.sskClientcache, this.nodeStats.sskClientCacheStats()));
        map.put(new DataStoreInstanceType(DataStoreKeyType.PUB_KEY, DataStoreType.STORE), new StoreCallbackStats(this.pubKeyDatastore, new NotAvailNodeStoreStats()));
        map.put(new DataStoreInstanceType(DataStoreKeyType.PUB_KEY, DataStoreType.CACHE), new StoreCallbackStats(this.pubKeyDatacache, new NotAvailNodeStoreStats()));
        map.put(new DataStoreInstanceType(DataStoreKeyType.PUB_KEY, DataStoreType.SLASHDOT), new StoreCallbackStats(this.pubKeySlashdotcache, new NotAvailNodeStoreStats()));
        map.put(new DataStoreInstanceType(DataStoreKeyType.PUB_KEY, DataStoreType.CLIENT), new StoreCallbackStats(this.pubKeyClientcache, new NotAvailNodeStoreStats()));
        return map;
    }

    public long getMaxTotalKeys() {
        return this.maxTotalKeys;
    }

    public void dumpStoreHits() {
        long now = System.currentTimeMillis();
        if (now - this.timeLastDumpedHits <= 5000L) {
            return;
        }
        this.timeLastDumpedHits = now;
        Logger.minor(this, "Distribution of hits and misses over stores:\nCHK Datastore: " + this.chkDatastore.hits() + '/' + (this.chkDatastore.hits() + this.chkDatastore.misses()) + '/' + this.chkDatastore.keyCount() + "\nCHK Datacache: " + this.chkDatacache.hits() + '/' + (this.chkDatacache.hits() + this.chkDatacache.misses()) + '/' + this.chkDatacache.keyCount() + "\nSSK Datastore: " + this.sskDatastore.hits() + '/' + (this.sskDatastore.hits() + this.sskDatastore.misses()) + '/' + this.sskDatastore.keyCount() + "\nSSK Datacache: " + this.sskDatacache.hits() + '/' + (this.sskDatacache.hits() + this.sskDatacache.misses()) + '/' + this.sskDatacache.keyCount());
    }

    public void storeShallow(CHKBlock block, boolean canWriteClientCache, boolean canWriteDatastore, boolean forULPR) {
        this.store(block, false, canWriteClientCache, canWriteDatastore, forULPR);
    }

    public void store(KeyBlock block, boolean deep, boolean canWriteClientCache, boolean canWriteDatastore, boolean forULPR) throws KeyCollisionException {
        if (block instanceof CHKBlock) {
            this.store((CHKBlock)block, deep, canWriteClientCache, canWriteDatastore, forULPR);
        } else if (block instanceof SSKBlock) {
            this.store((SSKBlock)block, deep, false, canWriteClientCache, canWriteDatastore, forULPR);
        } else {
            throw new IllegalArgumentException("Unknown keytype ");
        }
    }

    private void store(CHKBlock block, boolean deep, boolean canWriteClientCache, boolean canWriteDatastore, boolean forULPR) {
        try {
            double loc = block.getKey().toNormalizedDouble();
            if (canWriteClientCache) {
                this.chkClientcache.put(block, false);
                this.nodeStats.avgClientCacheCHKLocation.report(loc);
            }
            if ((forULPR || this.useSlashdotCache) && !canWriteDatastore && !this.writeLocalToDatastore) {
                this.chkSlashdotcache.put(block, false);
                this.nodeStats.avgSlashdotCacheCHKLocation.report(loc);
            }
            if (canWriteDatastore || this.writeLocalToDatastore) {
                if (deep) {
                    this.chkDatastore.put(block, !canWriteDatastore);
                    this.nodeStats.avgStoreCHKLocation.report(loc);
                }
                this.chkDatacache.put(block, !canWriteDatastore);
                this.nodeStats.avgCacheCHKLocation.report(loc);
            }
            if (canWriteDatastore || forULPR || this.useSlashdotCache) {
                this.failureTable.onFound(block);
            }
        }
        catch (IOException e) {
            Logger.error(this, "Cannot store data: " + e, (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            OOMHandler.handleOOM(e);
        }
        catch (Throwable t) {
            System.err.println(t);
            t.printStackTrace();
            Logger.error(this, "Caught " + t + " storing data", t);
        }
        if (this.clientCore != null && this.clientCore.requestStarters != null) {
            this.clientCore.requestStarters.chkFetchSchedulerBulk.tripPendingKey(block);
            this.clientCore.requestStarters.chkFetchSchedulerRT.tripPendingKey(block);
        }
    }

    public void storeInsert(SSKBlock block, boolean deep, boolean overwrite, boolean canWriteClientCache, boolean canWriteDatastore) throws KeyCollisionException {
        this.store(block, deep, overwrite, canWriteClientCache, canWriteDatastore, false);
    }

    public void storeShallow(SSKBlock block, boolean canWriteClientCache, boolean canWriteDatastore, boolean fromULPR) throws KeyCollisionException {
        this.store(block, false, canWriteClientCache, canWriteDatastore, fromULPR);
    }

    public void store(SSKBlock block, boolean deep, boolean overwrite, boolean canWriteClientCache, boolean canWriteDatastore, boolean forULPR) throws KeyCollisionException {
        try {
            double loc = block.getKey().toNormalizedDouble();
            this.getPubKey.cacheKey(block.getKey().getPubKeyHash(), block.getKey().getPubKey(), deep, canWriteClientCache, canWriteDatastore, forULPR || this.useSlashdotCache, this.writeLocalToDatastore);
            if (canWriteClientCache) {
                this.sskClientcache.put(block, overwrite, false);
                this.nodeStats.avgClientCacheSSKLocation.report(loc);
            }
            if ((forULPR || this.useSlashdotCache) && !canWriteDatastore && !this.writeLocalToDatastore) {
                this.sskSlashdotcache.put(block, overwrite, false);
                this.nodeStats.avgSlashdotCacheSSKLocation.report(loc);
            }
            if (canWriteDatastore || this.writeLocalToDatastore) {
                if (deep) {
                    this.sskDatastore.put(block, overwrite, !canWriteDatastore);
                    this.nodeStats.avgStoreSSKLocation.report(loc);
                }
                this.sskDatacache.put(block, overwrite, !canWriteDatastore);
                this.nodeStats.avgCacheSSKLocation.report(loc);
            }
            if (canWriteDatastore || forULPR || this.useSlashdotCache) {
                this.failureTable.onFound(block);
            }
        }
        catch (IOException e) {
            Logger.error(this, "Cannot store data: " + e, (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            OOMHandler.handleOOM(e);
        }
        catch (KeyCollisionException e) {
            throw e;
        }
        catch (Throwable t) {
            System.err.println(t);
            t.printStackTrace();
            Logger.error(this, "Caught " + t + " storing data", t);
        }
        if (this.clientCore != null && this.clientCore.requestStarters != null) {
            this.clientCore.requestStarters.sskFetchSchedulerBulk.tripPendingKey(block);
            this.clientCore.requestStarters.sskFetchSchedulerRT.tripPendingKey(block);
        }
    }

    public short decrementHTL(PeerNode source, short htl) {
        if (source != null) {
            return source.decrementHTL(htl);
        }
        if (htl >= this.maxHTL) {
            htl = this.maxHTL;
        }
        if (htl <= 0) {
            return 0;
        }
        if (htl == this.maxHTL) {
            if (this.decrementAtMax || this.disableProbabilisticHTLs) {
                htl = (short)(htl - 1);
            }
            return htl;
        }
        if (htl == 1) {
            if (this.decrementAtMin || this.disableProbabilisticHTLs) {
                htl = (short)(htl - 1);
            }
            return htl;
        }
        htl = (short)(htl - 1);
        return htl;
    }

    public CHKInsertSender makeInsertSender(NodeCHK key, short htl, long uid, InsertTag tag, PeerNode source, byte[] headers, PartiallyReceivedBlock prb, boolean fromStore, boolean canWriteClientCache, boolean forkOnCacheable, boolean preferInsert, boolean ignoreLowBackoff, boolean realTimeFlag) {
        if (logMINOR) {
            Logger.minor(this, "makeInsertSender(" + key + ',' + htl + ',' + uid + ',' + source + ",...," + fromStore);
        }
        CHKInsertSender is = null;
        is = new CHKInsertSender(key, uid, tag, headers, htl, source, this, prb, fromStore, canWriteClientCache, forkOnCacheable, preferInsert, ignoreLowBackoff, realTimeFlag);
        is.start();
        return is;
    }

    public SSKInsertSender makeInsertSender(SSKBlock block, short htl, long uid, InsertTag tag, PeerNode source, boolean fromStore, boolean canWriteClientCache, boolean canWriteDatastore, boolean forkOnCacheable, boolean preferInsert, boolean ignoreLowBackoff, boolean realTimeFlag) {
        NodeSSK key = block.getKey();
        if (key.getPubKey() == null) {
            throw new IllegalArgumentException("No pub key when inserting");
        }
        this.getPubKey.cacheKey(key.getPubKeyHash(), key.getPubKey(), false, canWriteClientCache, canWriteDatastore, false, this.writeLocalToDatastore);
        Logger.minor(this, "makeInsertSender(" + key + ',' + htl + ',' + uid + ',' + source + ",...," + fromStore);
        SSKInsertSender is = null;
        is = new SSKInsertSender(block, uid, tag, htl, source, this, fromStore, canWriteClientCache, forkOnCacheable, preferInsert, ignoreLowBackoff, realTimeFlag);
        is.start();
        return is;
    }

    public String getStatus() {
        StringBuilder sb = new StringBuilder();
        if (this.peers != null) {
            sb.append(this.peers.getStatus());
        } else {
            sb.append("No peers yet");
        }
        sb.append(this.tracker.getNumTransferringRequestSenders());
        sb.append('\n');
        return sb.toString();
    }

    public String getTMCIPeerList() {
        StringBuilder sb = new StringBuilder();
        if (this.peers != null) {
            sb.append(this.peers.getTMCIPeerList());
        } else {
            sb.append("No peers yet");
        }
        return sb.toString();
    }

    public ClientKeyBlock fetchKey(ClientKey key, boolean canReadClientCache, boolean canWriteClientCache, boolean canWriteDatastore) throws KeyVerifyException {
        if (key instanceof ClientCHK) {
            return this.fetch((ClientCHK)key, canReadClientCache, canWriteClientCache, canWriteDatastore);
        }
        if (key instanceof ClientSSK) {
            return this.fetch((ClientSSK)key, canReadClientCache, canWriteClientCache, canWriteDatastore);
        }
        throw new IllegalStateException("Don't know what to do with " + key);
    }

    public ClientKeyBlock fetch(ClientSSK clientSSK, boolean canReadClientCache, boolean canWriteClientCache, boolean canWriteDatastore) throws SSKVerifyException {
        DSAPublicKey key = clientSSK.getPubKey();
        if (key == null) {
            key = this.getPubKey.getKey(clientSSK.pubKeyHash, canReadClientCache, false, null);
        }
        if (key == null) {
            return null;
        }
        clientSSK.setPublicKey(key);
        SSKBlock block = this.fetch((NodeSSK)clientSSK.getNodeKey(true), false, canReadClientCache, canWriteClientCache, canWriteDatastore, false, null);
        if (block == null) {
            if (logMINOR) {
                Logger.minor(this, "Could not find key for " + clientSSK);
            }
            return null;
        }
        this.getPubKey.cacheKey(clientSSK.pubKeyHash, key, false, canWriteClientCache, canWriteDatastore, false, this.writeLocalToDatastore);
        return ClientSSKBlock.construct(block, clientSSK);
    }

    private ClientKeyBlock fetch(ClientCHK clientCHK, boolean canReadClientCache, boolean canWriteClientCache, boolean canWriteDatastore) throws CHKVerifyException {
        CHKBlock block = this.fetch(clientCHK.getNodeCHK(), false, canReadClientCache, canWriteClientCache, canWriteDatastore, false, null);
        if (block == null) {
            return null;
        }
        return new ClientCHKBlock(block, clientCHK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(int reason) {
        try {
            this.park();
            System.out.println("Goodbye.");
            System.out.println(reason);
        }
        finally {
            System.exit(reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(String reason) {
        try {
            this.park();
            System.out.println("Goodbye. from " + this + " (" + reason + ')');
        }
        finally {
            System.exit(0);
        }
    }

    public boolean isStopping() {
        return this.isStopping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void park() {
        Node node = this;
        synchronized (node) {
            if (this.isStopping) {
                return;
            }
            this.isStopping = true;
        }
        try {
            Message msg = DMT.createFNPDisconnect(false, false, -1, new ShortBuffer(new byte[0]));
            this.peers.localBroadcast(msg, true, false, this.peers.ctrDisconn);
        }
        catch (Throwable t) {
            try {
                Logger.error(this, "Failed to tell peers we are going down: " + t, t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.config.store();
        Yarrow myRandom = (Yarrow)this.random;
        myRandom.write_seed(myRandom.seedfile, true);
    }

    public NodeUpdateManager getNodeUpdater() {
        return this.nodeUpdater;
    }

    public DarknetPeerNode[] getDarknetConnections() {
        return this.peers.getDarknetPeers();
    }

    public boolean addPeerConnection(PeerNode pn) {
        boolean retval = this.peers.addPeer(pn);
        this.peers.writePeersUrgent(pn.isOpennet());
        return retval;
    }

    public void removePeerConnection(PeerNode pn) {
        this.peers.disconnectAndRemove(pn, true, false, false);
    }

    public void onConnectedPeer() {
        if (logMINOR) {
            Logger.minor(this, "onConnectedPeer()");
        }
        this.ipDetector.onConnectedPeer();
    }

    public int getFNPPort() {
        return this.getDarknetPortNumber();
    }

    public boolean isOudated() {
        return this.peers.isOutdated();
    }

    public synchronized void registerNodeToNodeMessageListener(int type, NodeToNodeMessageListener listener) {
        this.n2nmListeners.put(type, listener);
    }

    public void receivedNodeToNodeMessage(Message m, PeerNode src) {
        int type = (Integer)m.getObject("nodeToNodeMessageType");
        ShortBuffer messageData = (ShortBuffer)m.getObject("nodeToNodeMessageData");
        this.receivedNodeToNodeMessage(src, type, messageData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedNodeToNodeMessage(PeerNode src, int type, ShortBuffer messageData, boolean partingMessage) {
        boolean fromDarknet = src instanceof DarknetPeerNode;
        NodeToNodeMessageListener listener = null;
        Node node = this;
        synchronized (node) {
            listener = this.n2nmListeners.get(type);
        }
        if (listener == null) {
            Logger.error(this, "Unknown n2nm ID: " + type + " - discarding packet length " + messageData.getLength());
            return;
        }
        listener.handleMessage(messageData.getData(), fromDarknet, src, type);
    }

    public void handleNodeToNodeTextMessageSimpleFieldSet(SimpleFieldSet fs, DarknetPeerNode source, int fileNumber) throws FSParseException {
        if (logMINOR) {
            Logger.minor(this, "Got node to node message: \n" + fs);
        }
        int overallType = fs.getInt("n2nType");
        fs.removeValue("n2nType");
        if (overallType == 1) {
            this.handleFproxyNodeToNodeTextMessageSimpleFieldSet(fs, source, fileNumber);
        } else {
            Logger.error(this, "Received unknown node to node message type '" + overallType + "' from " + source.getPeer());
        }
    }

    private void handleFproxyNodeToNodeTextMessageSimpleFieldSet(SimpleFieldSet fs, DarknetPeerNode source, int fileNumber) throws FSParseException {
        int type = fs.getInt("type");
        if (type == 1) {
            source.handleFproxyN2NTM(fs, fileNumber);
        } else if (type == 2) {
            source.handleFproxyFileOffer(fs, fileNumber);
        } else if (type == 3) {
            source.handleFproxyFileOfferAccepted(fs, fileNumber);
        } else if (type == 4) {
            source.handleFproxyFileOfferRejected(fs, fileNumber);
        } else if (type == 5) {
            source.handleFproxyBookmarkFeed(fs, fileNumber);
        } else if (type == 6) {
            source.handleFproxyDownloadFeed(fs, fileNumber);
        } else {
            Logger.error(this, "Received unknown fproxy node to node message sub-type '" + type + "' from " + source.getPeer());
        }
    }

    public String getMyName() {
        return this.myName;
    }

    public MessageCore getUSM() {
        return this.usm;
    }

    public LocationManager getLocationManager() {
        return this.lm;
    }

    public int getSwaps() {
        return LocationManager.swaps;
    }

    public int getNoSwaps() {
        return LocationManager.noSwaps;
    }

    public int getStartedSwaps() {
        return LocationManager.startedSwaps;
    }

    public int getSwapsRejectedAlreadyLocked() {
        return LocationManager.swapsRejectedAlreadyLocked;
    }

    public int getSwapsRejectedNowhereToGo() {
        return LocationManager.swapsRejectedNowhereToGo;
    }

    public int getSwapsRejectedRateLimit() {
        return LocationManager.swapsRejectedRateLimit;
    }

    public int getSwapsRejectedRecognizedID() {
        return LocationManager.swapsRejectedRecognizedID;
    }

    public PeerNode[] getPeerNodes() {
        return this.peers.myPeers();
    }

    public PeerNode[] getConnectedPeers() {
        return this.peers.connectedPeers();
    }

    public PeerNode getPeerNode(String nodeIdentifier) {
        for (PeerNode pn : this.peers.myPeers()) {
            Peer peer = pn.getPeer();
            String nodeIpAndPort = "";
            if (peer != null) {
                nodeIpAndPort = peer.toString();
            }
            String identity = pn.getIdentityString();
            if (pn instanceof DarknetPeerNode) {
                DarknetPeerNode dpn = (DarknetPeerNode)pn;
                String name = dpn.myName;
                if (!identity.equals(nodeIdentifier) && !nodeIpAndPort.equals(nodeIdentifier) && !name.equals(nodeIdentifier)) continue;
                return pn;
            }
            if (!identity.equals(nodeIdentifier) && !nodeIpAndPort.equals(nodeIdentifier)) continue;
            return pn;
        }
        return null;
    }

    public boolean isHasStarted() {
        return this.hasStarted;
    }

    public void queueRandomReinsert(KeyBlock block) {
        this.clientCore.queueRandomReinsert(block);
    }

    public String getExtraPeerDataDir() {
        return this.extraPeerDataDir.getPath();
    }

    public boolean noConnectedPeers() {
        return !this.peers.anyConnectedPeers();
    }

    public double getLocation() {
        return this.lm.getLocation();
    }

    public double getLocationChangeSession() {
        return this.lm.getLocChangeSession();
    }

    public int getAverageOutgoingSwapTime() {
        return this.lm.getAverageSwapTime();
    }

    public long getSendSwapInterval() {
        return this.lm.getSendSwapInterval();
    }

    public int getNumberOfRemotePeerLocationsSeenInSwaps() {
        return this.lm.numberOfRemotePeerLocationsSeenInSwaps;
    }

    public boolean isAdvancedModeEnabled() {
        if (this.clientCore == null) {
            return false;
        }
        return this.clientCore.isAdvancedModeEnabled();
    }

    public boolean isFProxyJavascriptEnabled() {
        return this.clientCore.isFProxyJavascriptEnabled();
    }

    public int getNumARKFetchers() {
        int x = 0;
        for (PeerNode p : this.peers.myPeers()) {
            if (!p.isFetchingARK()) continue;
            ++x;
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sentPayload(int len) {
        Object object = this.statsSync;
        synchronized (object) {
            this.totalPayloadSent += (long)len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalPayloadSent() {
        Object object = this.statsSync;
        synchronized (object) {
            return this.totalPayloadSent;
        }
    }

    public void setName(String key) throws InvalidConfigValueException, NodeNeedRestartException {
        this.config.get("node").getOption("name").setValue(key);
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    public int getUnclaimedFIFOSize() {
        return this.usm.getUnclaimedFIFOSize();
    }

    public void connectToSeednode(SeedServerTestPeerNode node) throws OpennetDisabledException, FSParseException, PeerParseException, ReferenceSignatureVerificationException {
        this.peers.addPeer(node, false, false);
    }

    public void connect(Node node, DarknetPeerNode.FRIEND_TRUST trust, DarknetPeerNode.FRIEND_VISIBILITY visibility) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException {
        this.peers.connect(node.darknetCrypto.exportPublicFieldSet(), this.darknetCrypto.packetMangler, trust, visibility);
    }

    public short maxHTL() {
        return this.maxHTL;
    }

    public int getDarknetPortNumber() {
        return this.darknetCrypto.portNumber;
    }

    public synchronized int getOutputBandwidthLimit() {
        return this.outputBandwidthLimit;
    }

    public synchronized int getInputBandwidthLimit() {
        if (this.inputLimitDefault) {
            return this.outputBandwidthLimit * 4;
        }
        return this.inputBandwidthLimit;
    }

    public synchronized long getStoreSize() {
        return this.maxTotalDatastoreSize;
    }

    @Override
    public synchronized void setTimeSkewDetectedUserAlert() {
        if (timeSkewDetectedUserAlert == null) {
            timeSkewDetectedUserAlert = new TimeSkewDetectedUserAlert();
            this.clientCore.alerts.register(timeSkewDetectedUserAlert);
        }
    }

    public File getNodeDir() {
        return this.nodeDir.dir();
    }

    public File getCfgDir() {
        return this.cfgDir.dir();
    }

    public File getUserDir() {
        return this.userDir.dir();
    }

    public File getRunDir() {
        return this.runDir.dir();
    }

    public File getStoreDir() {
        return this.storeDir.dir();
    }

    public File getPluginDir() {
        return this.pluginDir.dir();
    }

    public ProgramDirectory nodeDir() {
        return this.nodeDir;
    }

    public ProgramDirectory cfgDir() {
        return this.cfgDir;
    }

    public ProgramDirectory userDir() {
        return this.userDir;
    }

    public ProgramDirectory runDir() {
        return this.runDir;
    }

    public ProgramDirectory storeDir() {
        return this.storeDir;
    }

    public ProgramDirectory pluginDir() {
        return this.pluginDir;
    }

    public DarknetPeerNode createNewDarknetNode(SimpleFieldSet fs, DarknetPeerNode.FRIEND_TRUST trust, DarknetPeerNode.FRIEND_VISIBILITY visibility) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException {
        return new DarknetPeerNode(fs, this, this.darknetCrypto, this.peers, false, this.darknetCrypto.packetMangler, trust, visibility);
    }

    public OpennetPeerNode createNewOpennetNode(SimpleFieldSet fs) throws FSParseException, OpennetDisabledException, PeerParseException, ReferenceSignatureVerificationException {
        if (this.opennet == null) {
            throw new OpennetDisabledException("Opennet is not currently enabled");
        }
        return new OpennetPeerNode(fs, this, this.opennet.crypto, this.opennet, this.peers, false, this.opennet.crypto.packetMangler);
    }

    public SeedServerTestPeerNode createNewSeedServerTestPeerNode(SimpleFieldSet fs) throws FSParseException, OpennetDisabledException, PeerParseException, ReferenceSignatureVerificationException {
        if (this.opennet == null) {
            throw new OpennetDisabledException("Opennet is not currently enabled");
        }
        return new SeedServerTestPeerNode(fs, this, this.opennet.crypto, this.peers, true, this.opennet.crypto.packetMangler);
    }

    public OpennetPeerNode addNewOpennetNode(SimpleFieldSet fs, OpennetManager.ConnectionType connectionType) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException {
        if (this.opennet == null) {
            return null;
        }
        return this.opennet.addNewOpennetNode(fs, connectionType, false);
    }

    public byte[] getOpennetPubKeyHash() {
        return this.opennet.crypto.pubKeyHash;
    }

    public byte[] getDarknetPubKeyHash() {
        return this.darknetCrypto.pubKeyHash;
    }

    public synchronized boolean isOpennetEnabled() {
        return this.opennet != null;
    }

    public SimpleFieldSet exportDarknetPublicFieldSet() {
        return this.darknetCrypto.exportPublicFieldSet();
    }

    public SimpleFieldSet exportOpennetPublicFieldSet() {
        return this.opennet.crypto.exportPublicFieldSet();
    }

    public SimpleFieldSet exportDarknetPrivateFieldSet() {
        return this.darknetCrypto.exportPrivateFieldSet();
    }

    public SimpleFieldSet exportOpennetPrivateFieldSet() {
        return this.opennet.crypto.exportPrivateFieldSet();
    }

    public synchronized boolean dontDetect() {
        if (!this.darknetCrypto.getBindTo().isRealInternetAddress(false, true, false)) {
            return false;
        }
        return this.opennet == null || !this.opennet.crypto.getBindTo().isRealInternetAddress(false, true, false);
    }

    public int getOpennetFNPPort() {
        if (this.opennet == null) {
            return -1;
        }
        return this.opennet.crypto.portNumber;
    }

    public OpennetManager getOpennet() {
        return this.opennet;
    }

    public synchronized boolean passOpennetRefsThroughDarknet() {
        return this.passOpennetRefsThroughDarknet;
    }

    public Set<ForwardPort> getPublicInterfacePorts() {
        NodeCrypto crypto;
        HashSet<ForwardPort> set = new HashSet<ForwardPort>();
        set.add(new ForwardPort("darknet", false, 17, this.darknetCrypto.portNumber));
        if (this.opennet != null && (crypto = this.opennet.crypto) != null) {
            set.add(new ForwardPort("opennet", false, 17, crypto.portNumber));
        }
        return set;
    }

    public long getUptime() {
        return System.currentTimeMillis() - this.usm.getStartedTime();
    }

    public synchronized UdpSocketHandler[] getPacketSocketHandlers() {
        if (this.opennet != null) {
            return new UdpSocketHandler[]{this.darknetCrypto.socket, this.opennet.crypto.socket};
        }
        return new UdpSocketHandler[]{this.darknetCrypto.socket};
    }

    public int getMaxOpennetPeers() {
        return this.maxOpennetPeers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAddedValidIP() {
        Announcer announcer;
        OpennetManager om;
        Node node = this;
        synchronized (node) {
            om = this.opennet;
        }
        if (om != null && (announcer = om.announcer) != null) {
            announcer.maybeSendAnnouncement();
        }
    }

    public boolean isSeednode() {
        return this.acceptSeedConnections;
    }

    public boolean wantAnonAuth(boolean isOpennet) {
        if (isOpennet) {
            return this.opennet != null && this.acceptSeedConnections;
        }
        return false;
    }

    public boolean wantAnonAuthChangeIP(boolean isOpennet) {
        return !isOpennet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean opennetDefinitelyPortForwarded() {
        OpennetManager om;
        Node node = this;
        synchronized (node) {
            om = this.opennet;
        }
        if (om == null) {
            return false;
        }
        NodeCrypto crypto = om.crypto;
        if (crypto == null) {
            return false;
        }
        return crypto.definitelyPortForwarded();
    }

    public boolean darknetDefinitelyPortForwarded() {
        if (this.darknetCrypto == null) {
            return false;
        }
        return this.darknetCrypto.definitelyPortForwarded();
    }

    public boolean hasKey(Key key, boolean canReadClientCache, boolean forULPR) {
        if (key instanceof NodeCHK) {
            return this.fetch((NodeCHK)key, true, canReadClientCache, false, false, forULPR, null) != null;
        }
        return this.fetch((NodeSSK)key, true, canReadClientCache, false, false, forULPR, null) != null;
    }

    public void setLocation(double loc) {
        this.lm.setLocation(loc);
    }

    public boolean peersWantKey(Key key) {
        return this.failureTable.peersWantKey(key, null);
    }

    public void setDispatcherHook(NodeDispatcher.NodeDispatcherCallback cb) {
        this.dispatcher.setHook(cb);
    }

    public boolean shallWePublishOurPeersLocation() {
        return this.publishOurPeersLocation;
    }

    public boolean shallWeRouteAccordingToOurPeersLocation() {
        return this.routeAccordingToOurPeersLocation;
    }

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Not storing Node in database", (Throwable)new Exception("error"));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMasterPassword(String password, boolean inFirstTimeWizard) throws AlreadySetPasswordException, MasterKeysWrongPasswordException, MasterKeysFileSizeException, IOException {
        Node node = this;
        synchronized (node) {
            if (this.enteredPassword) {
                throw new AlreadySetPasswordException();
            }
        }
        if (this.securityLevels.getPhysicalThreatLevel() == SecurityLevels.PHYSICAL_THREAT_LEVEL.MAXIMUM) {
            Logger.error(this, "Setting password while physical threat level is at MAXIMUM???");
        }
        MasterKeys keys = MasterKeys.read(this.masterKeysFile, this.random, password);
        try {
            this.setPasswordInner(keys, inFirstTimeWizard);
        }
        finally {
            keys.clearAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPasswordInner(MasterKeys keys, boolean inFirstTimeWizard) throws MasterKeysWrongPasswordException, MasterKeysFileSizeException, IOException {
        boolean wantClientCache = false;
        boolean wantDatabase = false;
        Node node = this;
        synchronized (node) {
            this.enteredPassword = true;
            if (!this.clientCacheAwaitingPassword) {
                if (inFirstTimeWizard) {
                    this.cachedClientCacheKey = (byte[])keys.clientCacheMasterKey.clone();
                    this.ticker.queueTimedJob(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Node node = Node.this;
                            synchronized (node) {
                                MasterKeys.clear(Node.this.cachedClientCacheKey);
                                Node.access$1702(Node.this, null);
                            }
                        }
                    }, TimeUnit.MINUTES.toMillis(10L));
                }
            } else {
                wantClientCache = true;
            }
            wantDatabase = this.db == null;
        }
        if (wantClientCache) {
            this.activatePasswordedClientCache(keys);
        }
        if (wantDatabase) {
            this.lateSetupDatabase(keys.createDatabaseKey(this.random));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activatePasswordedClientCache(MasterKeys keys) {
        Node node = this;
        synchronized (node) {
            if (this.clientCacheType.equals("ram")) {
                System.err.println("RAM client cache cannot be passworded!");
                return;
            }
            if (!this.clientCacheType.equals("salt-hash")) {
                System.err.println("Unknown client cache type, cannot activate passworded store: " + this.clientCacheType);
                return;
            }
        }
        MigrateOldStoreData migrate = new MigrateOldStoreData(true);
        String suffix = this.getStoreSuffix();
        try {
            this.initSaltHashClientCacheFS(suffix, true, keys.clientCacheMasterKey);
        }
        catch (NodeInitException e) {
            Logger.error(this, "Unable to activate passworded client cache", (Throwable)e);
            System.err.println("Unable to activate passworded client cache: " + e);
            e.printStackTrace();
            return;
        }
        Node node2 = this;
        synchronized (node2) {
            this.clientCacheAwaitingPassword = false;
        }
        this.executor.execute(migrate, "Migrate data from previous store");
    }

    public void changeMasterPassword(String oldPassword, String newPassword, boolean inFirstTimeWizard) throws MasterKeysWrongPasswordException, MasterKeysFileSizeException, IOException, AlreadySetPasswordException {
        if (this.securityLevels.getPhysicalThreatLevel() == SecurityLevels.PHYSICAL_THREAT_LEVEL.MAXIMUM) {
            Logger.error(this, "Changing password while physical threat level is at MAXIMUM???");
        }
        if (this.masterKeysFile.exists()) {
            MasterKeys keys = MasterKeys.read(this.masterKeysFile, this.random, oldPassword);
            keys.changePassword(this.masterKeysFile, newPassword, this.random);
            this.setPasswordInner(keys, inFirstTimeWizard);
            keys.clearAll();
        } else {
            this.setMasterPassword(newPassword, inFirstTimeWizard);
        }
    }

    public synchronized File getMasterPasswordFile() {
        return this.masterKeysFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void panic() {
        try {
            this.db.close();
        }
        catch (Throwable t) {
            // empty catch block
        }
        Node t = this;
        synchronized (t) {
            this.db = null;
        }
        try {
            FileUtil.secureDelete(this.dbFile);
            FileUtil.secureDelete(this.dbFileCrypt);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.dbFile.delete();
        this.dbFileCrypt.delete();
    }

    public void finishPanic() {
        WrapperManager.restart();
        System.exit(0);
    }

    public boolean awaitingPassword() {
        if (this.clientCacheAwaitingPassword) {
            return true;
        }
        return this.databaseAwaitingPassword;
    }

    public boolean isDatabaseEncrypted() {
        return this.databaseEncrypted;
    }

    public boolean hasDatabase() {
        return this.db != null;
    }

    public String getDatabasePath() throws IOException {
        if (this.isDatabaseEncrypted()) {
            return this.dbFileCrypt.getCanonicalPath();
        }
        return this.dbFile.getCanonicalPath();
    }

    public synchronized boolean autoChangeDatabaseEncryption() {
        return this.autoChangeDatabaseEncryption;
    }

    public boolean shouldStoreDeep(Key key, PeerNode source, PeerNode[] routedTo) {
        double myLoc = this.getLocation();
        double target = key.toNormalizedDouble();
        double myDist = Location.distance(myLoc, target);
        if (logMINOR) {
            Logger.minor(this, "Should store for " + key + " ?");
        }
        if (source != null && !source.isLowUptime() && Location.distance(source, target) < myDist) {
            if (logMINOR) {
                Logger.minor(this, "Not storing because source is closer to target for " + key + " : " + source);
            }
            return false;
        }
        for (PeerNode pn : routedTo) {
            if (Location.distance(pn, target) < myDist && !pn.isLowUptime()) {
                if (logMINOR) {
                    Logger.minor(this, "Not storing because peer " + pn + " is closer to target for " + key + " his loc " + pn.getLocation() + " my loc " + myLoc + " target is " + target);
                }
                return false;
            }
            if (!logMINOR) continue;
            Logger.minor(this, "Should store maybe, peer " + pn + " loc = " + pn.getLocation() + " my loc is " + myLoc + " target is " + target + " low uptime is " + pn.isLowUptime());
        }
        if (logMINOR) {
            Logger.minor(this, "Should store returning true for " + key + " target=" + target + " myLoc=" + myLoc + " peers: " + routedTo.length);
        }
        return true;
    }

    public boolean getWriteLocalToDatastore() {
        return this.writeLocalToDatastore;
    }

    public boolean getUseSlashdotCache() {
        return this.useSlashdotCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createVisibilityAlert() {
        Node node = this;
        synchronized (node) {
            if (this.showFriendsVisibilityAlert) {
                return;
            }
            this.showFriendsVisibilityAlert = true;
        }
        this.getTicker().queueTimedJob(new Runnable(){

            @Override
            public void run() {
                Node.this.config.store();
            }
        }, 0L);
        this.registerFriendsVisibilityAlert();
    }

    private void registerFriendsVisibilityAlert() {
        if (this.clientCore == null || this.clientCore.alerts == null) {
            this.getTicker().queueTimedJob(new Runnable(){

                @Override
                public void run() {
                    Node.this.registerFriendsVisibilityAlert();
                }
            }, 0L);
            return;
        }
        this.clientCore.alerts.register(this.visibilityAlert);
    }

    private void unregisterFriendsVisibilityAlert() {
        this.clientCore.alerts.unregister(this.visibilityAlert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinimumMTU() {
        int detected;
        int mtu;
        Node node = this;
        synchronized (node) {
            mtu = this.maxPacketSize;
        }
        if (this.ipDetector != null && (detected = this.ipDetector.getMinimumDetectedMTU()) < mtu) {
            return detected;
        }
        return mtu;
    }

    public void updateMTU() {
        this.darknetCrypto.socket.calculateMaxPacketSize();
        OpennetManager om = this.opennet;
        if (om != null) {
            om.crypto.socket.calculateMaxPacketSize();
        }
    }

    public static boolean isTestnetEnabled() {
        return false;
    }

    public MersenneTwister createRandom() {
        byte[] buf = new byte[16];
        this.random.nextBytes(buf);
        return new MersenneTwister(buf);
    }

    public boolean enableNewLoadManagement(boolean realTimeFlag) {
        NodeStats stats = this.nodeStats;
        if (stats == null) {
            Logger.error(this, "Calling enableNewLoadManagement before Node constructor completes! FIX THIS!", (Throwable)new Exception("error"));
            return false;
        }
        return stats.enableNewLoadManagement(realTimeFlag);
    }

    public boolean enableRoutedPing() {
        return this.enableRoutedPing;
    }

    public boolean updateIsUrgent() {
        OpennetManager om = this.getOpennet();
        if (om != null && om.announcer != null && om.announcer.isWaitingForUpdater()) {
            return true;
        }
        return this.peers.getPeerNodeStatusSize(3, true) > 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPluginStoreKey(String storeIdentifier) {
        DatabaseKey key;
        Node node = this;
        synchronized (node) {
            key = this.databaseKey;
        }
        if (key != null) {
            return key.getPluginStoreKey(storeIdentifier);
        }
        return null;
    }

    private void checkOutputBandwidthLimit(int obwLimit) throws InvalidConfigValueException {
        if (obwLimit <= 0) {
            throw new InvalidConfigValueException(this.l10n("bwlimitMustBePositive"));
        }
        if (obwLimit < 5120) {
            throw this.lowBandwidthLimit(obwLimit);
        }
    }

    private void checkInputBandwidthLimit(int ibwLimit) throws InvalidConfigValueException {
        if (ibwLimit == -1) {
            return;
        }
        if (ibwLimit <= 1) {
            throw new InvalidConfigValueException(this.l10n("bandwidthLimitMustBePositiveOrMinusOne"));
        }
        if (ibwLimit < 5120) {
            throw this.lowBandwidthLimit(ibwLimit);
        }
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    static /* synthetic */ byte[] access$1702(Node x0, byte[] x1) {
        x0.cachedClientCacheKey = x1;
        return x1;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
        KEEPALIVE_INTERVAL = TimeUnit.SECONDS.toMillis(7L);
        MAX_PEER_INACTIVITY = TimeUnit.SECONDS.toMillis(35L);
        HANDSHAKE_TIMEOUT = (int)TimeUnit.MILLISECONDS.toMillis(4800L);
        MIN_TIME_BETWEEN_HANDSHAKE_SENDS = HANDSHAKE_TIMEOUT * 2;
        RANDOMIZED_TIME_BETWEEN_HANDSHAKE_SENDS = HANDSHAKE_TIMEOUT * 2;
        MIN_TIME_BETWEEN_VERSION_PROBES = HANDSHAKE_TIMEOUT * 4;
        RANDOMIZED_TIME_BETWEEN_VERSION_PROBES = HANDSHAKE_TIMEOUT * 2;
        MIN_TIME_BETWEEN_VERSION_SENDS = HANDSHAKE_TIMEOUT * 4;
        RANDOMIZED_TIME_BETWEEN_VERSION_SENDS = HANDSHAKE_TIMEOUT * 2;
        MIN_TIME_BETWEEN_BURSTING_HANDSHAKE_BURSTS = HANDSHAKE_TIMEOUT * 24;
        RANDOMIZED_TIME_BETWEEN_BURSTING_HANDSHAKE_BURSTS = HANDSHAKE_TIMEOUT * 36;
        ALARM_TIME = TimeUnit.MINUTES.toMillis(1L);
        MIN_INTERVAL_BETWEEN_INCOMING_SWAP_REQUESTS = TimeUnit.MILLISECONDS.toMillis(900L);
        MIN_INTERVAL_BETWEEN_INCOMING_PROBE_REQUESTS = TimeUnit.MILLISECONDS.toMillis(1000L);
        PURGE_INTERVAL = TimeUnit.SECONDS.toMillis(60L);
        LOW_BACKOFF = TimeUnit.SECONDS.toMillis(30L);
        jvmHasGCJCharConversionBug = false;
    }

    public static class AlreadySetPasswordException
    extends Exception {
        private static final long serialVersionUID = -7328456475029374032L;
    }

    private static class DB4ODiagnosticListener
    implements DiagnosticListener {
        private static volatile boolean logDEBUG;

        private DB4ODiagnosticListener() {
        }

        public void onDiagnostic(Diagnostic arg0) {
            if (!logDEBUG) {
                return;
            }
            if (arg0 instanceof ClassHasNoFields) {
                return;
            }
            if (arg0 instanceof DiagnosticBase) {
                DiagnosticBase d = (DiagnosticBase)arg0;
                Logger.debug(this, "Diagnostic: " + d.getClass() + " : " + d.problem() + " : " + d.solution() + " : " + d.reason(), (Throwable)new Exception("debug"));
            } else {
                Logger.debug(this, "Diagnostic: " + arg0 + " : " + arg0.getClass(), (Throwable)new Exception("debug"));
            }
        }

        static {
            Logger.registerLogThresholdCallback(new LogThresholdCallback(){

                @Override
                public void shouldUpdate() {
                    logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
                }
            });
        }
    }

    private static class L10nCallback
    extends StringCallback
    implements EnumerableOptionCallback {
        private L10nCallback() {
        }

        @Override
        public String get() {
            return NodeL10n.getBase().getSelectedLanguage().fullName;
        }

        @Override
        public void set(String val) throws InvalidConfigValueException {
            if (val == null || this.get().equalsIgnoreCase(val)) {
                return;
            }
            try {
                NodeL10n.getBase().setLanguage(BaseL10n.LANGUAGE.mapToLanguage(val));
            }
            catch (MissingResourceException e) {
                throw new InvalidConfigValueException(e.getLocalizedMessage());
            }
            PluginManager.setLanguage(NodeL10n.getBase().getSelectedLanguage());
        }

        @Override
        public String[] getPossibleValues() {
            return BaseL10n.LANGUAGE.valuesWithFullNames();
        }
    }

    private class ClientCacheTypeCallback
    extends StringCallback
    implements EnumerableOptionCallback {
        private ClientCacheTypeCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String get() {
            Node node = Node.this;
            synchronized (node) {
                return Node.this.clientCacheType;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(String val) throws InvalidConfigValueException, NodeNeedRestartException {
            boolean found = false;
            for (String string : this.getPossibleValues()) {
                if (!string.equals(val)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new InvalidConfigValueException("Invalid store type");
            }
            ClientCacheTypeCallback clientCacheTypeCallback = this;
            synchronized (clientCacheTypeCallback) {
                String suffix = Node.this.getStoreSuffix();
                if (val.equals("salt-hash")) {
                    byte[] key;
                    Node node = Node.this;
                    synchronized (node) {
                        key = Node.this.cachedClientCacheKey;
                        Node.access$1702(Node.this, null);
                    }
                    if (key == null) {
                        Object var6_11 = null;
                        try {
                            if (Node.this.securityLevels.physicalThreatLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.MAXIMUM) {
                                key = new byte[32];
                                Node.this.random.nextBytes(key);
                            } else {
                                MasterKeys masterKeys = MasterKeys.read(Node.this.masterKeysFile, Node.this.random, "");
                                key = masterKeys.clientCacheMasterKey;
                                masterKeys.clearAllNotClientCacheKey();
                            }
                        }
                        catch (MasterKeysWrongPasswordException e1) {
                            Node.this.setClientCacheAwaitingPassword();
                            Node node2 = Node.this;
                            synchronized (node2) {
                                Node.this.clientCacheType = val;
                            }
                            throw new InvalidConfigValueException("You must enter the password");
                        }
                        catch (MasterKeysFileSizeException e1) {
                            throw new InvalidConfigValueException("Master keys file corrupted (too " + e1.sizeToString() + ")");
                        }
                        catch (IOException e1) {
                            throw new InvalidConfigValueException("Master keys file cannot be accessed: " + e1);
                        }
                    }
                    try {
                        Node.this.initSaltHashClientCacheFS(suffix, true, key);
                    }
                    catch (NodeInitException nodeInitException) {
                        Logger.error(this, "Unable to create new store", (Throwable)nodeInitException);
                        System.err.println("Unable to create new store: " + nodeInitException);
                        nodeInitException.printStackTrace();
                        throw new InvalidConfigValueException("Unable to create new store: " + nodeInitException);
                    }
                    finally {
                        MasterKeys.clear(key);
                    }
                }
                if (val.equals("ram")) {
                    Node.this.initRAMClientCacheFS();
                } else {
                    Node.this.initNoClientCacheFS();
                }
                Node node = Node.this;
                synchronized (node) {
                    Node.this.clientCacheType = val;
                }
            }
        }

        @Override
        public String[] getPossibleValues() {
            return new String[]{"salt-hash", "ram", "none"};
        }
    }

    private class StoreTypeCallback
    extends StringCallback
    implements EnumerableOptionCallback {
        private StoreTypeCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String get() {
            Node node = Node.this;
            synchronized (node) {
                return Node.this.storeType;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(String val) throws InvalidConfigValueException, NodeNeedRestartException {
            String type;
            boolean found = false;
            for (String p : this.getPossibleValues()) {
                if (!p.equals(val)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new InvalidConfigValueException("Invalid store type");
            }
            Object object = Node.this;
            synchronized (object) {
                type = Node.this.storeType;
            }
            if (type.equals("ram")) {
                object = this;
                synchronized (object) {
                    Node.this.makeStore(val);
                }
            }
            object = Node.this;
            synchronized (object) {
                Node.this.storeType = val;
            }
            throw new NodeNeedRestartException("Store type cannot be changed on the fly");
        }

        @Override
        public String[] getPossibleValues() {
            return new String[]{"salt-hash", "ram"};
        }
    }

    public class NodeNameCallback
    extends StringCallback {
        NodeNameCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String get() {
            String name;
            NodeNameCallback nodeNameCallback = this;
            synchronized (nodeNameCallback) {
                name = Node.this.myName;
            }
            if (name.startsWith("Node id|") || name.equals("MyFirstFreenetNode") || name.startsWith("Freenet node with no name #")) {
                Node.this.clientCore.alerts.register(nodeNameUserAlert);
            } else {
                Node.this.clientCore.alerts.unregister(nodeNameUserAlert);
            }
            return name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(String val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            if (val.length() > 128) {
                throw new InvalidConfigValueException("The given node name is too long (" + val + ')');
            }
            if ("".equals(val)) {
                val = "~none~";
            }
            NodeNameCallback nodeNameCallback = this;
            synchronized (nodeNameCallback) {
                Node.this.myName = val;
            }
            SimpleFieldSet fs = new SimpleFieldSet(true);
            fs.putSingle("myName", Node.this.myName);
            Node.this.peers.locallyBroadcastDiffNodeRef(fs, true, false);
            this.get();
        }
    }

    public class MigrateOldStoreData
    implements Runnable {
        private final boolean clientCache;

        public MigrateOldStoreData(boolean clientCache) {
            this.clientCache = clientCache;
            if (clientCache) {
                Node.this.oldCHKClientCache = Node.this.chkClientcache;
                Node.this.oldPKClientCache = Node.this.pubKeyClientcache;
                Node.this.oldSSKClientCache = Node.this.sskClientcache;
            } else {
                Node.this.oldCHK = Node.this.chkDatastore;
                Node.this.oldPK = Node.this.pubKeyDatastore;
                Node.this.oldSSK = Node.this.sskDatastore;
                Node.this.oldCHKCache = Node.this.chkDatastore;
                Node.this.oldPKCache = Node.this.pubKeyDatastore;
                Node.this.oldSSKCache = Node.this.sskDatastore;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.err.println("Migrating old " + (this.clientCache ? "client cache" : "datastore"));
            if (this.clientCache) {
                StoreCallback old;
                Node.this.migrateOldStore(Node.this.oldCHKClientCache, Node.this.chkClientcache, true);
                Node node = Node.this;
                synchronized (node) {
                    old = Node.this.oldCHKClientCache;
                    Node.this.oldCHKClientCache = null;
                }
                Node.this.closeOldStore(old);
                Node.this.migrateOldStore(Node.this.oldPKClientCache, Node.this.pubKeyClientcache, true);
                node = Node.this;
                synchronized (node) {
                    old = Node.this.oldPKClientCache;
                    Node.this.oldPKClientCache = null;
                }
                Node.this.closeOldStore(old);
                Node.this.migrateOldStore(Node.this.oldSSKClientCache, Node.this.sskClientcache, true);
                node = Node.this;
                synchronized (node) {
                    old = Node.this.oldSSKClientCache;
                    Node.this.oldSSKClientCache = null;
                }
                Node.this.closeOldStore(old);
            } else {
                Node.this.migrateOldStore(Node.this.oldCHK, Node.this.chkDatastore, false);
                Node.this.oldCHK = null;
                Node.this.migrateOldStore(Node.this.oldPK, Node.this.pubKeyDatastore, false);
                Node.this.oldPK = null;
                Node.this.migrateOldStore(Node.this.oldSSK, Node.this.sskDatastore, false);
                Node.this.oldSSK = null;
                Node.this.migrateOldStore(Node.this.oldCHKCache, Node.this.chkDatacache, false);
                Node.this.oldCHKCache = null;
                Node.this.migrateOldStore(Node.this.oldPKCache, Node.this.pubKeyDatacache, false);
                Node.this.oldPKCache = null;
                Node.this.migrateOldStore(Node.this.oldSSKCache, Node.this.sskDatacache, false);
                Node.this.oldSSKCache = null;
            }
            System.err.println("Finished migrating old " + (this.clientCache ? "client cache" : "datastore"));
        }
    }
}

