/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Predicate;
import freenet.client.async.DBJob;
import freenet.client.async.DBJobRunner;
import freenet.client.async.DatabaseDisabledException;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class NodeRestartJobsQueue {
    private final long nodeDBHandle;
    private static volatile boolean logMINOR;
    private Set<DBJob>[] dbJobs;
    private Set<DBJob>[] dbJobsEarly;

    public NodeRestartJobsQueue(long nodeDBHandle2) {
        this.nodeDBHandle = nodeDBHandle2;
        this.dbJobs = new Set[9];
        this.dbJobsEarly = new Set[9];
        for (int i = 0; i < this.dbJobs.length; ++i) {
            this.dbJobs[i] = new HashSet<DBJob>();
            this.dbJobsEarly[i] = new HashSet<DBJob>();
        }
    }

    public static NodeRestartJobsQueue init(final long nodeDBHandle, ObjectContainer container) {
        ObjectSet results = container.query((Predicate)new Predicate<NodeRestartJobsQueue>(){

            public boolean match(NodeRestartJobsQueue arg0) {
                return arg0.nodeDBHandle == nodeDBHandle;
            }
        });
        if (results.hasNext()) {
            System.err.println("Found old restart jobs queue");
            NodeRestartJobsQueue queue = (NodeRestartJobsQueue)results.next();
            container.activate((Object)queue, 1);
            queue.onInit(container);
            return queue;
        }
        NodeRestartJobsQueue queue = new NodeRestartJobsQueue(nodeDBHandle);
        container.store((Object)queue);
        System.err.println("Created new restart jobs queue");
        return queue;
    }

    private void onInit(ObjectContainer container) {
    }

    public synchronized void queueRestartJob(DBJob job, int priority, ObjectContainer container, boolean early) {
        if (logMINOR) {
            Logger.minor(this, "Queueing restart job " + job + " at priority " + priority + " early=" + early);
        }
        Set<DBJob> jobs = early ? this.dbJobsEarly[priority] : this.dbJobs[priority];
        container.store((Object)job);
        container.activate(jobs, 1);
        if (jobs.add(job)) {
            container.ext().store(jobs, 1);
        }
        container.deactivate(jobs, 1);
    }

    public synchronized void removeRestartJob(DBJob job, int priority, ObjectContainer container) {
        boolean jobWasActive = container.ext().isActive((Object)job);
        if (!jobWasActive) {
            container.activate((Object)job, 1);
        }
        container.activate(this.dbJobs[priority], 1);
        container.activate(this.dbJobsEarly[priority], 1);
        if (!this.dbJobs[priority].remove(job) && !this.dbJobsEarly[priority].remove(job)) {
            container.deactivate(this.dbJobs[priority], 1);
            container.deactivate(this.dbJobsEarly[priority], 1);
            int found = 0;
            for (int i = 0; i < this.dbJobs.length; ++i) {
                if (i == priority) continue;
                container.activate(this.dbJobs[i], 1);
                container.activate(this.dbJobsEarly[i], 1);
                if (this.dbJobs[i].remove(job)) {
                    container.ext().store(this.dbJobs[i], 1);
                    ++found;
                }
                if (this.dbJobsEarly[i].remove(job)) {
                    container.ext().store(this.dbJobsEarly[i], 1);
                    ++found;
                }
                container.deactivate(this.dbJobs[i], 1);
                container.deactivate(this.dbJobsEarly[i], 1);
            }
            if (found > 0) {
                Logger.error(this, "Job " + job + " not in specified priority " + priority + " found in " + found + " other priorities when removing");
            } else {
                Logger.error(this, "Job " + job + " not found when removing it");
            }
        } else {
            container.ext().store(this.dbJobs[priority], 1);
            container.deactivate(this.dbJobs[priority], 1);
            container.ext().store(this.dbJobsEarly[priority], 1);
            container.deactivate(this.dbJobsEarly[priority], 1);
        }
        if (!jobWasActive) {
            container.deactivate((Object)job, 1);
        }
    }

    synchronized RestartDBJob[] getEarlyRestartDatabaseJobs(ObjectContainer container) {
        ArrayList<RestartDBJob> list = new ArrayList<RestartDBJob>();
        for (int i = this.dbJobsEarly.length - 1; i >= 0; --i) {
            container.activate(this.dbJobsEarly[i], 1);
            if (!this.dbJobsEarly[i].isEmpty()) {
                System.err.println("Adding " + this.dbJobsEarly[i].size() + " early restart jobs at priority " + i);
            }
            for (DBJob job : this.dbJobsEarly[i]) {
                list.add(new RestartDBJob(job, i));
            }
            container.deactivate(this.dbJobsEarly[i], 1);
        }
        return list.toArray(new RestartDBJob[list.size()]);
    }

    void addLateRestartDatabaseJobs(DBJobRunner runner, ObjectContainer container) throws DatabaseDisabledException {
        for (int i = this.dbJobsEarly.length - 1; i >= 0; --i) {
            container.activate(this.dbJobs[i], 1);
            if (!this.dbJobs[i].isEmpty()) {
                System.err.println("Adding " + this.dbJobs[i].size() + " restart jobs at priority " + i);
            }
            Iterator<DBJob> it = this.dbJobs[i].iterator();
            while (it.hasNext()) {
                DBJob job = it.next();
                if (job == null) {
                    Logger.error(this, "Late restart job removed without telling the NodeRestartJobsQueue on priority " + i + "!");
                    it.remove();
                    container.ext().store(this.dbJobs[i], 2);
                    continue;
                }
                container.activate((Object)job, 1);
                runner.queue(job, i, false);
            }
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    static class RestartDBJob {
        DBJob job;
        int prio;

        public RestartDBJob(DBJob job2, int i) {
            this.job = job2;
            this.prio = i;
        }
    }
}

