/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.Persistable;
import freenet.node.SemiOrderedShutdownHook;
import freenet.support.Logger;
import freenet.support.OOMHandler;
import freenet.support.SimpleFieldSet;
import freenet.support.Ticker;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

class Persister
implements Runnable {
    private static volatile boolean logMINOR;
    static final long PERIOD;
    final Persistable persistable;
    private final Ticker ps;
    File persistTemp;
    File persistTarget;
    private boolean started;

    Persister(Persistable t, File persistTemp, File persistTarget, Ticker ps) {
        this.persistable = t;
        this.persistTemp = persistTemp;
        this.persistTarget = persistTarget;
        this.ps = ps;
    }

    protected Persister(Persistable t, Ticker ps) {
        this.persistable = t;
        this.ps = ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interrupt() {
        Persister persister = this;
        synchronized (persister) {
            this.notifyAll();
        }
    }

    @Override
    public void run() {
        Logger.OSThread.logPID(this);
        try {
            this.persistThrottle();
        }
        catch (OutOfMemoryError e) {
            OOMHandler.handleOOM(e);
            System.err.println("Will restart ThrottlePersister...");
        }
        catch (Throwable t) {
            Logger.error(this, "Caught in ThrottlePersister: " + t, t);
            System.err.println("Caught in ThrottlePersister: " + t);
            t.printStackTrace();
            System.err.println("Will restart ThrottlePersister...");
        }
        this.ps.queueTimedJob(this, PERIOD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void persistThrottle() {
        if (logMINOR) {
            Logger.minor(this, "Trying to persist throttles...");
        }
        SimpleFieldSet fs = this.persistable.persistThrottlesToFieldSet();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.persistTemp);
            fs.writeToBigBuffer(fos);
            fos.close();
            FileUtil.renameTo(this.persistTemp, this.persistTarget);
        }
        catch (FileNotFoundException e) {
            Logger.error(this, "Could not store throttle data to disk: " + e, (Throwable)e);
            Closer.close(fos);
        }
        catch (IOException e2) {
            this.persistTemp.delete();
            {
                catch (Throwable throwable) {
                    Closer.close(fos);
                    throw throwable;
                }
            }
            Closer.close(fos);
        }
        Closer.close(fos);
    }

    public SimpleFieldSet read() {
        SimpleFieldSet throttleFS;
        block5: {
            throttleFS = null;
            try {
                throttleFS = SimpleFieldSet.readFrom(this.persistTarget, false, true);
            }
            catch (IOException e) {
                try {
                    throttleFS = SimpleFieldSet.readFrom(this.persistTemp, false, true);
                }
                catch (FileNotFoundException e1) {
                }
                catch (IOException e1) {
                    if (this.persistTarget.length() <= 0L && this.persistTemp.length() <= 0L) break block5;
                    Logger.error(this, "Could not read " + this.persistTarget + " (" + e + ") and could not read " + this.persistTemp + " either (" + e1 + ')');
                }
            }
        }
        return throttleFS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Persister persister = this;
        synchronized (persister) {
            if (this.started) {
                Logger.error(this, "Already started: " + this, (Throwable)new Exception("debug"));
                return;
            }
            this.started = true;
        }
        SemiOrderedShutdownHook.get().addEarlyJob(new Thread(){

            @Override
            public void run() {
                System.out.println("Writing " + Persister.this.persistTarget + " on shutdown");
                Persister.this.persistThrottle();
            }
        });
        this.run();
    }

    static {
        Logger.registerClass(Persister.class);
        PERIOD = TimeUnit.MINUTES.toMillis(15L);
    }
}

