/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.l10n.NodeL10n;
import freenet.node.SeedClientPeerNode;
import freenet.support.HTMLNode;
import freenet.support.LRUMap;
import freenet.support.io.InetAddressComparator;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class SeedAnnounceTracker {
    private final LRUMap<InetAddress, TrackerItem> itemsByIP = LRUMap.createSafeMap(InetAddressComparator.COMPARATOR);
    final int MAX_SIZE = 100000;
    static final long RESET_TIME = TimeUnit.HOURS.toMillis(2L);
    private long lastReset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acceptAnnounce(SeedClientPeerNode source, Random fastRandom) {
        InetAddress addr = source.getPeer().getAddress();
        int ver = source.getVersionNumber();
        boolean badVersion = source.isUnroutableOlderVersion();
        long now = System.currentTimeMillis();
        SeedAnnounceTracker seedAnnounceTracker = this;
        synchronized (seedAnnounceTracker) {
            TrackerItem item;
            if (this.lastReset - now > RESET_TIME) {
                this.itemsByIP.clear();
                this.lastReset = now;
            }
            if ((item = this.itemsByIP.get(addr)) == null) {
                item = new TrackerItem(addr);
            } else if (item.totalSentRefs > 5 && badVersion) {
                if (fastRandom.nextInt(5) != 0) {
                    return false;
                }
            } else if (item.totalSentRefs > 10 && fastRandom.nextInt(4) != 0) {
                return false;
            }
            item.acceptedAnnounce();
            item.setVersion(ver);
            this.itemsByIP.push(addr, item);
            while (this.itemsByIP.size() > 100000) {
                this.itemsByIP.popKey();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rejectedAnnounce(SeedClientPeerNode source) {
        InetAddress addr = source.getPeer().getAddress();
        int ver = source.getVersionNumber();
        SeedAnnounceTracker seedAnnounceTracker = this;
        synchronized (seedAnnounceTracker) {
            TrackerItem item = this.itemsByIP.get(addr);
            if (item == null) {
                item = new TrackerItem(addr);
            }
            item.rejectedAnnounce();
            item.setVersion(ver);
            this.itemsByIP.push(addr, item);
            while (this.itemsByIP.size() > 100000) {
                this.itemsByIP.popKey();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectSeed(SeedClientPeerNode source) {
        InetAddress addr = source.getPeer().getAddress();
        int ver = source.getVersionNumber();
        SeedAnnounceTracker seedAnnounceTracker = this;
        synchronized (seedAnnounceTracker) {
            TrackerItem item = this.itemsByIP.get(addr);
            if (item == null) {
                item = new TrackerItem(addr);
            }
            item.connected();
            item.setVersion(ver);
            this.itemsByIP.push(addr, item);
            while (this.itemsByIP.size() > 100000) {
                this.itemsByIP.popKey();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completedAnnounce(SeedClientPeerNode source, int forwardedRefs) {
        InetAddress addr = source.getPeer().getAddress();
        int ver = source.getVersionNumber();
        SeedAnnounceTracker seedAnnounceTracker = this;
        synchronized (seedAnnounceTracker) {
            TrackerItem item = this.itemsByIP.get(addr);
            if (item == null) {
                item = new TrackerItem(addr);
            }
            item.completed(forwardedRefs);
            item.setVersion(ver);
            this.itemsByIP.push(addr, item);
            while (this.itemsByIP.size() > 100000) {
                this.itemsByIP.popKey();
            }
        }
    }

    public void drawSeedStats(HTMLNode content) {
        TrackerItem[] topItems = this.getTopTrackerItems(20);
        if (topItems.length == 0) {
            return;
        }
        HTMLNode table = content.addChild("table", "border", "0");
        HTMLNode row = table.addChild("tr");
        row.addChild("th", this.l10nStats("seedTableIP"));
        row.addChild("th", this.l10nStats("seedTableConnections"));
        row.addChild("th", this.l10nStats("seedTableAnnouncements"));
        row.addChild("th", this.l10nStats("seedTableAccepted"));
        row.addChild("th", this.l10nStats("seedTableCompleted"));
        row.addChild("th", this.l10nStats("seedTableForwarded"));
        row.addChild("th", this.l10nStats("seedTableVersion"));
        for (TrackerItem item : topItems) {
            row = table.addChild("tr");
            row.addChild("td", item.addr.getHostAddress());
            row.addChild("td", Integer.toString(item.totalSeedConnects));
            row.addChild("td", Integer.toString(item.totalAnnounceRequests));
            row.addChild("td", Integer.toString(item.totalAcceptedAnnounceRequests));
            row.addChild("td", Integer.toString(item.totalCompletedAnnounceRequests));
            row.addChild("td", Integer.toString(item.totalSentRefs));
            row.addChild("td", Integer.toString(item.lastVersion));
        }
    }

    private synchronized TrackerItem[] getTopTrackerItems(int count) {
        TrackerItem[] items = new TrackerItem[this.itemsByIP.size()];
        this.itemsByIP.valuesToArray((TrackerItem[])items);
        Arrays.sort(items, new Comparator<TrackerItem>(){

            @Override
            public int compare(TrackerItem arg0, TrackerItem arg1) {
                int b;
                int a = Math.max(arg0.totalAnnounceRequests, arg0.totalSeedConnects);
                if (a > (b = Math.max(arg1.totalAnnounceRequests, arg1.totalSeedConnects))) {
                    return 1;
                }
                if (b > a) {
                    return -1;
                }
                if (arg0.totalAcceptedAnnounceRequests > arg1.totalAcceptedAnnounceRequests) {
                    return 1;
                }
                if (arg0.totalAcceptedAnnounceRequests < arg1.totalAcceptedAnnounceRequests) {
                    return -1;
                }
                return 0;
            }
        });
        int topLength = Math.min(count, items.length);
        return Arrays.copyOfRange(items, items.length - topLength, items.length);
    }

    private String l10nStats(String key) {
        return NodeL10n.getBase().getString("StatisticsToadlet." + key);
    }

    private class TrackerItem {
        private final InetAddress addr;
        private int totalSeedConnects;
        private int totalAnnounceRequests;
        private int totalAcceptedAnnounceRequests;
        private int totalCompletedAnnounceRequests;
        private int totalSentRefs;
        private int lastVersion;

        private TrackerItem(InetAddress addr) {
            this.addr = addr;
        }

        public void acceptedAnnounce() {
            ++this.totalAnnounceRequests;
            ++this.totalAcceptedAnnounceRequests;
        }

        public void rejectedAnnounce() {
            ++this.totalAnnounceRequests;
        }

        public void connected() {
            ++this.totalSeedConnects;
        }

        public void setVersion(int ver) {
            if (ver <= 0) {
                return;
            }
            this.lastVersion = ver;
        }

        public void completed(int forwardedRefs) {
            ++this.totalCompletedAnnounceRequests;
            this.totalSentRefs += forwardedRefs;
        }
    }
}

