/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.ClientRequester;
import freenet.keys.ClientKey;
import freenet.keys.Key;
import freenet.node.BaseSendableGet;
import freenet.node.LowLevelGetException;
import freenet.node.RequestScheduler;
import freenet.node.SendableGetRequestSender;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestSender;
import freenet.support.Logger;
import freenet.support.io.NativeThread;

public abstract class SendableGet
extends BaseSendableGet {
    public final ClientRequester parent;
    static final SendableGetRequestSender sender = new SendableGetRequestSender();

    public abstract ClientKey getKey(Object var1, ObjectContainer var2);

    @Override
    public Key getNodeKey(SendableRequestItem token, ObjectContainer container) {
        ClientKey key = this.getKey(token, container);
        if (key == null) {
            return null;
        }
        return key.getNodeKey(true);
    }

    public abstract Key[] listKeys(ObjectContainer var1);

    public abstract FetchContext getContext(ObjectContainer var1);

    public abstract void onFailure(LowLevelGetException var1, Object var2, ObjectContainer var3, ClientContext var4);

    public SendableGet(ClientRequester parent, boolean realTimeFlag) {
        super(parent.persistent(), realTimeFlag);
        this.parent = parent;
    }

    @Override
    public SendableRequestSender getSender(ObjectContainer container, ClientContext context) {
        return sender;
    }

    @Override
    public ClientRequestScheduler getScheduler(ObjectContainer container, ClientContext context) {
        if (this.isSSK()) {
            return context.getSskFetchScheduler(this.realTimeFlag);
        }
        return context.getChkFetchScheduler(this.realTimeFlag);
    }

    public abstract long getCooldownWakeup(Object var1, ObjectContainer var2, ClientContext var3);

    public abstract long getCooldownWakeupByKey(Key var1, ObjectContainer var2, ClientContext var3);

    @Override
    public void internalError(Throwable t, RequestScheduler sched, ObjectContainer container, ClientContext context, boolean persistent) {
        Logger.error(this, "Internal error on " + this + " : " + t, t);
        sched.callFailure(this, new LowLevelGetException(3, t.getMessage(), t), NativeThread.MAX_PRIORITY, persistent);
    }

    public abstract void requeueAfterCooldown(Key var1, long var2, ObjectContainer var4, ClientContext var5);

    @Override
    public final boolean isInsert() {
        return false;
    }

    @Override
    public void removeFrom(ObjectContainer container, ClientContext context) {
        container.delete((Object)this);
    }

    @Override
    public boolean isStorageBroken(ObjectContainer container) {
        if (!container.ext().isActive((Object)this)) {
            throw new IllegalStateException("Must be activated first!");
        }
        if (!this.persistent) {
            Logger.error(this, "Not persistent?!");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(ObjectContainer container, ClientContext context, short oldPrio) {
        super.unregister(container, context, oldPrio);
        ClientRequestScheduler clientRequestScheduler = this.getScheduler(container, context);
        synchronized (clientRequestScheduler) {
            context.cooldownTracker.removeCachedWakeup(this, this.persistent, container);
        }
        context.checker.removeRequest(this, this.persistent, container, context, oldPrio == -1 ? this.getPriorityClass(container) : oldPrio);
    }
}

