/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.ClientRequester;
import freenet.client.async.PersistentChosenBlock;
import freenet.client.async.PersistentChosenRequest;
import freenet.node.KeysFetchingLocally;
import freenet.node.RequestClient;
import freenet.node.RequestScheduler;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestSender;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.RandomGrabArray;
import freenet.support.RandomGrabArrayItem;
import java.util.List;

public abstract class SendableRequest
implements RandomGrabArrayItem {
    private final int hashCode;
    protected final boolean realTimeFlag;
    private static volatile boolean logMINOR;
    protected RandomGrabArray parentGrabArray;
    protected final boolean persistent;

    protected SendableRequest() {
        this.hashCode = 0;
        this.persistent = false;
        this.realTimeFlag = false;
    }

    SendableRequest(boolean persistent, boolean realTimeFlag) {
        this.persistent = persistent;
        this.realTimeFlag = realTimeFlag;
        int oid = super.hashCode();
        if (oid == 0) {
            oid = 1;
        }
        this.hashCode = oid;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public abstract short getPriorityClass(ObjectContainer var1);

    public abstract SendableRequestItem chooseKey(KeysFetchingLocally var1, ObjectContainer var2, ClientContext var3);

    public abstract long countAllKeys(ObjectContainer var1, ClientContext var2);

    public abstract long countSendableKeys(ObjectContainer var1, ClientContext var2);

    public abstract SendableRequestSender getSender(ObjectContainer var1, ClientContext var2);

    public abstract boolean isCancelled(ObjectContainer var1);

    public abstract RequestClient getClient(ObjectContainer var1);

    @Override
    public final boolean persistent() {
        return this.persistent;
    }

    public abstract ClientRequester getClientRequest();

    @Override
    public synchronized RandomGrabArray getParentGrabArray() {
        return this.parentGrabArray;
    }

    private synchronized RandomGrabArray grabParentGrabArray(ObjectContainer container) {
        RandomGrabArray ret = this.parentGrabArray;
        this.parentGrabArray = null;
        if (this.persistent()) {
            container.store((Object)this);
        }
        return ret;
    }

    @Override
    public boolean knowsParentGrabArray() {
        return true;
    }

    @Override
    public synchronized void setParentGrabArray(RandomGrabArray parent, ObjectContainer container) {
        this.parentGrabArray = parent;
        if (this.persistent()) {
            container.store((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(ObjectContainer container, ClientContext context, short oldPrio) {
        RandomGrabArray arr = this.grabParentGrabArray(container);
        if (arr != null) {
            if (this.persistent) {
                container.activate((Object)arr, 1);
            }
            ClientRequestScheduler clientRequestScheduler = this.getScheduler(container, context);
            synchronized (clientRequestScheduler) {
                arr.remove(this, container, context);
            }
        } else if (logMINOR) {
            Logger.minor(this, "Cannot unregister " + this + " : not registered", (Throwable)new Exception("debug"));
        }
        ClientRequester cr = this.getClientRequest();
        if (this.persistent) {
            container.activate((Object)cr, 1);
        }
        this.getScheduler(container, context).removeFromAllRequestsByClientRequest(cr, this, true, container);
    }

    public abstract ClientRequestScheduler getScheduler(ObjectContainer var1, ClientContext var2);

    public abstract boolean isSSK();

    public abstract boolean isInsert();

    public abstract void internalError(Throwable var1, RequestScheduler var2, ObjectContainer var3, ClientContext var4, boolean var5);

    public abstract List<PersistentChosenBlock> makeBlocks(PersistentChosenRequest var1, RequestScheduler var2, KeysFetchingLocally var3, ObjectContainer var4, ClientContext var5);

    @Override
    public boolean isStorageBroken(ObjectContainer container) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCooldown(ObjectContainer container, ClientContext context, boolean definitelyExists) {
        ClientRequestScheduler sched;
        if (this.persistent && !container.ext().isStored((Object)this)) {
            if (definitelyExists) {
                Logger.error(this, "Clear cooldown on persistent request " + this + " but already removed");
            } else if (this.hashCode != 0) {
                Logger.normal(this, "Clear cooldown on persistent request " + this + " but already removed");
            } else {
                Logger.minor(this, "Clear cooldown on persistent request " + this + " but already removed");
            }
            return;
        }
        RandomGrabArray rga = this.getParentGrabArray();
        ClientRequestScheduler clientRequestScheduler = sched = this.getScheduler(container, context);
        synchronized (clientRequestScheduler) {
            context.cooldownTracker.clearCachedWakeup(this, this.persistent, container);
            if (rga != null) {
                context.cooldownTracker.clearCachedWakeup(rga, this.persistent, container);
            }
        }
        sched.wakeStarter();
    }

    public boolean realTimeFlag() {
        return this.realTimeFlag;
    }

    public final String toString() {
        if (this.hashCode != 0 && !this.persistent) {
            return this.transientToString();
        }
        return super.toString();
    }

    protected final String objectToString() {
        return super.toString();
    }

    protected String transientToString() {
        return super.toString();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

