/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.node.DarknetPeerNode;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.OpennetDisabledException;
import freenet.node.PeerNode;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.PeerMessage;
import freenet.support.MediaType;
import freenet.support.SimpleFieldSet;
import freenet.support.io.Closer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;

public class AddPeer
extends FCPMessage {
    public static final String NAME = "AddPeer";
    SimpleFieldSet fs;
    final String identifier;
    final DarknetPeerNode.FRIEND_TRUST trust;
    final DarknetPeerNode.FRIEND_VISIBILITY visibility;

    public AddPeer(SimpleFieldSet fs) throws MessageInvalidException {
        this.fs = fs;
        this.identifier = fs.get("Identifier");
        fs.removeValue("Identifier");
        try {
            this.trust = DarknetPeerNode.FRIEND_TRUST.valueOf(fs.get("Trust"));
            fs.removeValue("Trust");
        }
        catch (NullPointerException e) {
            throw new MessageInvalidException(5, "AddPeer requires Trust", this.identifier, false);
        }
        catch (IllegalArgumentException e) {
            throw new MessageInvalidException(8, "Invalid Trust value on AddPeer", this.identifier, false);
        }
        try {
            this.visibility = DarknetPeerNode.FRIEND_VISIBILITY.valueOf(fs.get("Visibility"));
            fs.removeValue("Visibility");
        }
        catch (NullPointerException e) {
            throw new MessageInvalidException(5, "AddPeer requires Visibility", this.identifier, false);
        }
        catch (IllegalArgumentException e) {
            throw new MessageInvalidException(8, "Invalid Visibility value on AddPeer", this.identifier, false);
        }
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return new SimpleFieldSet(true);
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder getReferenceFromURL(URL url) throws IOException {
        StringBuilder stringBuilder;
        StringBuilder ref = new StringBuilder(1024);
        InputStream is = null;
        try {
            String line;
            URLConnection uc = url.openConnection();
            is = uc.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(is, MediaType.getCharsetRobustOrUTF(uc.getContentType())));
            while ((line = in.readLine()) != null) {
                ref.append(line).append('\n');
            }
            stringBuilder = ref;
        }
        catch (Throwable throwable) {
            Closer.close(is);
            throw throwable;
        }
        Closer.close(is);
        return stringBuilder;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        PeerNode pn;
        if (!handler.hasFullAccess()) {
            throw new MessageInvalidException(24, "AddPeer requires full access", this.identifier, false);
        }
        String urlString = this.fs.get("URL");
        String fileString = this.fs.get("File");
        StringBuilder ref = null;
        if (urlString != null) {
            try {
                URL url = new URL(urlString);
                ref = AddPeer.getReferenceFromURL(url);
            }
            catch (MalformedURLException e) {
                throw new MessageInvalidException(20, "Error parsing ref URL <" + urlString + ">: " + e.getMessage(), this.identifier, false);
            }
            catch (IOException e) {
                throw new MessageInvalidException(20, "IO error while retrieving ref URL <" + urlString + ">: " + e.getMessage(), this.identifier, false);
            }
            ref = new StringBuilder(ref.toString().trim());
            if ("".equals(ref.toString())) {
                throw new MessageInvalidException(21, "Error parsing ref from URL <" + urlString + '>', this.identifier, false);
            }
            try {
                this.fs = new SimpleFieldSet(ref.toString(), false, true, true);
            }
            catch (IOException e) {
                throw new MessageInvalidException(21, "Error parsing ref from URL <" + urlString + ">: " + e.getMessage(), this.identifier, false);
            }
        }
        if (fileString != null) {
            File f = new File(fileString);
            if (!f.isFile()) {
                throw new MessageInvalidException(23, "The given ref file path <" + fileString + "> is not a file", this.identifier, false);
            }
            try {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
                ref = new StringBuilder(1024);
                while ((line = in.readLine()) != null) {
                    line = line.trim();
                    ref.append(line).append('\n');
                }
                in.close();
            }
            catch (FileNotFoundException e) {
                throw new MessageInvalidException(9, "File not found when retrieving ref file <" + fileString + ">: " + e.getMessage(), this.identifier, false);
            }
            catch (IOException e) {
                throw new MessageInvalidException(22, "IO error while retrieving ref file <" + fileString + ">: " + e.getMessage(), this.identifier, false);
            }
            ref = new StringBuilder(ref.toString().trim());
            if ("".equals(ref.toString())) {
                throw new MessageInvalidException(21, "Error parsing ref from file <" + fileString + '>', this.identifier, false);
            }
            try {
                this.fs = new SimpleFieldSet(ref.toString(), false, true, true);
            }
            catch (IOException e) {
                throw new MessageInvalidException(21, "Error parsing ref from file <" + fileString + ">: " + e.getMessage(), this.identifier, false);
            }
        }
        this.fs.setEndMarker("End");
        boolean isOpennetRef = this.fs.getBoolean("opennet", false);
        if (isOpennetRef) {
            try {
                pn = node.createNewOpennetNode(this.fs);
            }
            catch (FSParseException e) {
                throw new MessageInvalidException(21, "Error parsing ref: " + e.getMessage(), this.identifier, false);
            }
            catch (OpennetDisabledException e) {
                throw new MessageInvalidException(30, "Error adding ref: " + e.getMessage(), this.identifier, false);
            }
            catch (PeerParseException e) {
                throw new MessageInvalidException(21, "Error parsing ref: " + e.getMessage(), this.identifier, false);
            }
            catch (ReferenceSignatureVerificationException e) {
                throw new MessageInvalidException(27, "Error adding ref: " + e.getMessage(), this.identifier, false);
            }
            if (Arrays.equals(pn.getPubKeyHash(), node.getOpennetPubKeyHash())) {
                throw new MessageInvalidException(28, "Node cannot peer with itself", this.identifier, false);
            }
            if (!node.addPeerConnection(pn)) {
                throw new MessageInvalidException(29, "Node already has a peer with that identity", this.identifier, false);
            }
            System.out.println("Added opennet peer: " + pn);
        } else {
            try {
                pn = node.createNewDarknetNode(this.fs, this.trust, this.visibility);
            }
            catch (FSParseException e) {
                throw new MessageInvalidException(21, "Error parsing ref: " + e.getMessage(), this.identifier, false);
            }
            catch (PeerParseException e) {
                throw new MessageInvalidException(21, "Error parsing ref: " + e.getMessage(), this.identifier, false);
            }
            catch (ReferenceSignatureVerificationException e) {
                throw new MessageInvalidException(27, "Error adding ref: " + e.getMessage(), this.identifier, false);
            }
            if (Arrays.equals(pn.getPubKeyHash(), node.getDarknetPubKeyHash())) {
                throw new MessageInvalidException(28, "Node cannot peer with itself", this.identifier, false);
            }
            if (!node.addPeerConnection(pn)) {
                throw new MessageInvalidException(29, "Node already has a peer with that identity", this.identifier, false);
            }
            System.out.println("Added darknet peer: " + pn);
        }
        handler.outputHandler.queue(new PeerMessage(pn, true, true, this.identifier));
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }
}

