/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.node.RequestStarter;
import freenet.node.fcp.BaseDataCarryingMessage;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPServer;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.BucketTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;

public class ClientGetMessage
extends BaseDataCarryingMessage {
    public static final String NAME = "ClientGet";
    final boolean ignoreDS;
    final boolean dsOnly;
    final FreenetURI uri;
    final String identifier;
    final int verbosity;
    final short returnType;
    final short persistenceType;
    final long maxSize;
    final long maxTempSize;
    final int maxRetries;
    final short priorityClass;
    final File diskFile;
    final File tempFile;
    final String clientToken;
    final boolean global;
    final boolean binaryBlob;
    final String[] allowedMIMETypes;
    public boolean writeToClientCache;
    final String charset;
    final boolean filterData;
    final boolean realTimeFlag;
    final boolean ignoreUSKDatehints;
    private Bucket initialMetadata;
    private final long initialMetadataLength;
    static final short RETURN_TYPE_DIRECT = 0;
    static final short RETURN_TYPE_NONE = 1;
    static final short RETURN_TYPE_DISK = 2;
    static final short RETURN_TYPE_CHUNKED = 3;
    private static volatile boolean logMINOR;

    public ClientGetMessage(SimpleFieldSet fs) throws MessageInvalidException {
        String priorityString;
        int defaultPriority;
        this.clientToken = fs.get("ClientToken");
        this.global = fs.getBoolean("Global", false);
        this.ignoreDS = fs.getBoolean("IgnoreDS", false);
        this.dsOnly = fs.getBoolean("DSOnly", false);
        this.identifier = fs.get("Identifier");
        this.allowedMIMETypes = fs.getAll("AllowedMIMETypes");
        this.filterData = fs.getBoolean("FilterData", false);
        this.charset = fs.get("Charset");
        if (this.identifier == null) {
            throw new MessageInvalidException(5, "No Identifier", null, this.global);
        }
        try {
            this.uri = new FreenetURI(fs.get("URI"));
        }
        catch (MalformedURLException e) {
            throw new MessageInvalidException(4, e.getMessage(), this.identifier, this.global);
        }
        String verbosityString = fs.get("Verbosity");
        if (verbosityString == null) {
            this.verbosity = 0;
        } else {
            try {
                this.verbosity = Integer.parseInt(verbosityString, 10);
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing Verbosity field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        String returnTypeString = fs.get("ReturnType");
        this.returnType = this.parseReturnTypeFCP(returnTypeString);
        if (this.returnType == 0) {
            this.diskFile = null;
            this.tempFile = null;
            defaultPriority = 2;
        } else if (this.returnType == 1) {
            this.diskFile = null;
            this.tempFile = null;
            defaultPriority = 5;
        } else if (this.returnType == 2) {
            defaultPriority = 4;
            String filename = fs.get("Filename");
            if (filename == null) {
                throw new MessageInvalidException(5, "Missing Filename", this.identifier, this.global);
            }
            this.diskFile = new File(filename);
            String tempFilename = fs.get("TempFilename");
            if (tempFilename == null) {
                tempFilename = filename + ".freenet-tmp";
            }
            this.tempFile = new File(tempFilename);
            if (!this.diskFile.getAbsoluteFile().getParentFile().equals(this.tempFile.getAbsoluteFile().getParentFile())) {
                throw new MessageInvalidException(11, null, this.identifier, this.global);
            }
            if (this.tempFile.exists()) {
                throw new MessageInvalidException(10, "Temp file exists", this.identifier, this.global);
            }
            if (this.diskFile.exists()) {
                throw new MessageInvalidException(10, null, this.identifier, this.global);
            }
            try {
                if (!(this.tempFile.createNewFile() || this.tempFile.exists() && this.tempFile.canRead() && this.tempFile.canWrite())) {
                    throw new MessageInvalidException(12, "Could not create temp file " + this.tempFile, this.identifier, this.global);
                }
                this.tempFile.delete();
            }
            catch (IOException e) {
                throw new MessageInvalidException(12, e.getMessage(), this.identifier, this.global);
            }
        } else {
            throw new MessageInvalidException(3, "Unknown return-type", this.identifier, this.global);
        }
        String maxSizeString = fs.get("MaxSize");
        if (maxSizeString == null) {
            this.maxSize = Long.MAX_VALUE;
        } else {
            try {
                this.maxSize = Long.parseLong(maxSizeString, 10);
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing MaxSize field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        String maxTempSizeString = fs.get("MaxTempSize");
        if (maxTempSizeString == null) {
            this.maxTempSize = Long.MAX_VALUE;
        } else {
            try {
                this.maxTempSize = Long.parseLong(maxTempSizeString, 10);
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing MaxSize field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        String maxRetriesString = fs.get("MaxRetries");
        if (maxRetriesString == null) {
            this.maxRetries = 0;
        } else {
            try {
                this.maxRetries = Integer.parseInt(maxRetriesString, 10);
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing MaxSize field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "max retries=" + this.maxRetries);
        }
        if ((priorityString = fs.get("PriorityClass")) == null) {
            this.priorityClass = (short)defaultPriority;
        } else {
            try {
                this.priorityClass = Short.parseShort(priorityString);
                if (!RequestStarter.isValidPriorityClass(this.priorityClass)) {
                    throw new MessageInvalidException(8, "Invalid priority class " + this.priorityClass + " - range is " + 6 + " to " + 0, this.identifier, this.global);
                }
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing PriorityClass field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        String persistenceString = fs.get("Persistence");
        if (persistenceString == null || persistenceString.equalsIgnoreCase("connection")) {
            this.persistenceType = 0;
        } else if (persistenceString.equalsIgnoreCase("reboot")) {
            this.persistenceType = 1;
        } else if (persistenceString.equalsIgnoreCase("forever")) {
            this.persistenceType = (short)2;
        } else {
            throw new MessageInvalidException(6, "Error parsing Persistence field: " + persistenceString, this.identifier, this.global);
        }
        if (this.global && this.persistenceType == 0) {
            throw new MessageInvalidException(16, "Global requests must be persistent", this.identifier, this.global);
        }
        this.writeToClientCache = fs.getBoolean("WriteToClientCache", this.persistenceType == 0);
        this.binaryBlob = fs.getBoolean("BinaryBlob", false);
        this.realTimeFlag = fs.getBoolean("RealTimeFlag", false);
        this.initialMetadataLength = fs.getLong("InitialMetadata.DataLength", 0L);
        this.ignoreUSKDatehints = fs.getBoolean("IgnoreUSKDatehints", false);
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.put("IgnoreDS", this.ignoreDS);
        fs.putSingle("URI", this.uri.toString(false, false));
        fs.put("FilterData", this.filterData);
        fs.putSingle("Charset", this.charset);
        fs.putSingle("Identifier", this.identifier);
        fs.put("Verbosity", this.verbosity);
        fs.putSingle("ReturnType", this.getReturnTypeString());
        fs.put("MaxSize", this.maxSize);
        fs.put("MaxTempSize", this.maxTempSize);
        fs.put("MaxRetries", this.maxRetries);
        fs.put("BinaryBlob", this.binaryBlob);
        return fs;
    }

    private String getReturnTypeString() {
        return ClientGetMessage.returnTypeString(this.returnType);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) {
        handler.startClientGet(this);
    }

    public static String returnTypeString(short type) {
        switch (type) {
            case 0: {
                return "direct";
            }
            case 1: {
                return "none";
            }
            case 2: {
                return "disk";
            }
            case 3: {
                return "chunked";
            }
        }
        return Short.toString(type);
    }

    short parseReturnTypeFCP(String string) throws MessageInvalidException {
        try {
            return ClientGetMessage.parseReturnType(string);
        }
        catch (NumberFormatException e) {
            throw new MessageInvalidException(8, "Unable to parse ReturnType " + string + " : " + e, this.identifier, this.global);
        }
    }

    public static short parseReturnType(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equalsIgnoreCase("direct")) {
            return 0;
        }
        if (string.equalsIgnoreCase("none")) {
            return 1;
        }
        if (string.equalsIgnoreCase("disk")) {
            return 2;
        }
        if (string.equalsIgnoreCase("chunked")) {
            return 3;
        }
        return Short.parseShort(string);
    }

    public static short parseValidReturnType(String string) {
        short s = ClientGetMessage.parseReturnType(string);
        if (s == 0 || s == 1 || s == 2) {
            return s;
        }
        throw new IllegalArgumentException("Invalid or unsupported return type: " + ClientGetMessage.returnTypeString(s));
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        this.uri.removeFrom(container);
        container.delete((Object)this.diskFile);
        container.delete((Object)this.tempFile);
        container.delete((Object)this);
    }

    @Override
    long dataLength() {
        return this.initialMetadataLength;
    }

    @Override
    public void readFrom(InputStream is, BucketFactory bf, FCPServer server) throws IOException, MessageInvalidException {
        if (this.initialMetadataLength == 0L) {
            return;
        }
        Bucket data = bf.makeBucket(this.initialMetadataLength);
        BucketTools.copyFrom(data, is, this.initialMetadataLength);
        this.initialMetadata = data;
    }

    @Override
    protected void writeData(OutputStream os) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Bucket getInitialMetadata() {
        return this.initialMetadata;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

