/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutCallback;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.events.ClientEvent;
import freenet.client.events.ClientEventListener;
import freenet.client.events.ExpectedHashesEvent;
import freenet.client.events.FinishedCompressionEvent;
import freenet.client.events.SimpleEventProducer;
import freenet.client.events.SplitfileProgressEvent;
import freenet.client.events.StartedCompressionEvent;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import freenet.node.fcp.ClientRequest;
import freenet.node.fcp.ExpectedHashes;
import freenet.node.fcp.FCPClient;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPConnectionOutputHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.FCPServer;
import freenet.node.fcp.FinishedCompressionMessage;
import freenet.node.fcp.GeneratedMetadataMessage;
import freenet.node.fcp.PersistentRequestRemovedMessage;
import freenet.node.fcp.PutFailedMessage;
import freenet.node.fcp.PutFetchableMessage;
import freenet.node.fcp.PutSuccessfulMessage;
import freenet.node.fcp.RequestStatusCache;
import freenet.node.fcp.SimpleProgressMessage;
import freenet.node.fcp.StartedCompressionMessage;
import freenet.node.fcp.URIGeneratedMessage;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.NativeThread;
import java.net.MalformedURLException;

public abstract class ClientPutBase
extends ClientRequest
implements ClientPutCallback,
ClientEventListener {
    final InsertContext ctx;
    final boolean getCHKOnly;
    private static final int VERBOSITY_SPLITFILE_PROGRESS = 1;
    private static final int VERBOSITY_EXPECTED_HASHES = 8;
    private static final int VERBOSITY_PUT_FETCHABLE = 256;
    private static final int VERBOSITY_COMPRESSION_START_END = 512;
    protected boolean succeeded;
    protected PutFailedMessage putFailedMessage;
    protected FreenetURI generatedURI;
    protected FCPMessage progressMessage;
    protected final boolean earlyEncode;
    protected final FreenetURI publicURI;
    private Bucket generatedMetadata;
    public static final String SALT = "Salt";
    public static final String FILE_HASH = "FileHash";
    private static volatile boolean logMINOR;

    protected ClientPutBase() {
        this.publicURI = null;
        this.getCHKOnly = false;
        this.earlyEncode = false;
        this.ctx = null;
    }

    public ClientPutBase(FreenetURI uri, String identifier, int verbosity, String charset, FCPConnectionHandler handler, short priorityClass, short persistenceType, String clientToken, boolean global, boolean getCHKOnly, boolean dontCompress, boolean localRequestOnly, int maxRetries, boolean earlyEncode, boolean canWriteClientCache, boolean forkOnCacheable, String compressorDescriptor, int extraInsertsSingleBlock, int extraInsertsSplitfileHeader, boolean realTimeFlag, InsertContext.CompatibilityMode compatibilityMode, boolean ignoreUSKDatehints, FCPServer server, ObjectContainer container) throws MalformedURLException {
        super(uri, identifier, verbosity, charset, handler, priorityClass, persistenceType, realTimeFlag, clientToken, global, container);
        this.getCHKOnly = getCHKOnly;
        this.ctx = new InsertContext(server.defaultInsertContext, new SimpleEventProducer());
        this.ctx.dontCompress = dontCompress;
        this.ctx.eventProducer.addEventListener(this);
        this.ctx.maxInsertRetries = maxRetries;
        this.ctx.canWriteClientCache = canWriteClientCache;
        this.ctx.compressorDescriptor = compressorDescriptor;
        this.ctx.forkOnCacheable = forkOnCacheable;
        this.ctx.extraInsertsSingleBlock = extraInsertsSingleBlock;
        this.ctx.extraInsertsSplitfileHeaderBlock = extraInsertsSplitfileHeader;
        this.ctx.setCompatibilityMode(compatibilityMode);
        this.ctx.localRequestOnly = localRequestOnly;
        this.earlyEncode = earlyEncode;
        this.ctx.ignoreUSKDatehints = ignoreUSKDatehints;
        this.publicURI = this.uri.deriveRequestURIFromInsertURI();
    }

    static FreenetURI checkEmptySSK(FreenetURI uri, String filename, ClientContext context) {
        if ("SSK".equals(uri.getKeyType()) && uri.getDocName() == null && uri.getRoutingKey() == null) {
            if (filename == null || filename.equals("")) {
                filename = "key";
            }
            InsertableClientSSK key = InsertableClientSSK.createRandom(context.random, "");
            return key.getInsertURI().setDocName(filename);
        }
        return uri;
    }

    public ClientPutBase(FreenetURI uri, String identifier, int verbosity, String charset, FCPConnectionHandler handler, FCPClient client, short priorityClass, short persistenceType, String clientToken, boolean global, boolean getCHKOnly, boolean dontCompress, int maxRetries, boolean earlyEncode, boolean canWriteClientCache, boolean forkOnCacheable, boolean localRequestOnly, int extraInsertsSingleBlock, int extraInsertsSplitfileHeader, boolean realTimeFlag, String compressorDescriptor, InsertContext.CompatibilityMode compatMode, boolean ignoreUSKDatehints, FCPServer server, ObjectContainer container) throws MalformedURLException {
        super(uri, identifier, verbosity, charset, handler, client, priorityClass, persistenceType, realTimeFlag, clientToken, global, container);
        this.getCHKOnly = getCHKOnly;
        this.ctx = new InsertContext(server.defaultInsertContext, new SimpleEventProducer());
        this.ctx.dontCompress = dontCompress;
        this.ctx.eventProducer.addEventListener(this);
        this.ctx.maxInsertRetries = maxRetries;
        this.ctx.canWriteClientCache = canWriteClientCache;
        this.ctx.compressorDescriptor = compressorDescriptor;
        this.ctx.forkOnCacheable = forkOnCacheable;
        this.ctx.extraInsertsSingleBlock = extraInsertsSingleBlock;
        this.ctx.extraInsertsSplitfileHeaderBlock = extraInsertsSplitfileHeader;
        this.ctx.localRequestOnly = localRequestOnly;
        this.ctx.setCompatibilityMode(compatMode);
        this.ctx.ignoreUSKDatehints = ignoreUSKDatehints;
        this.earlyEncode = earlyEncode;
        this.publicURI = this.uri.deriveRequestURIFromInsertURI();
    }

    @Override
    public void onLostConnection(ObjectContainer container, ClientContext context) {
        if (this.persistenceType == 0) {
            this.cancel(container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(BaseClientPutter state, ObjectContainer container) {
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            this.succeeded = true;
            this.finished = true;
            this.completionTime = System.currentTimeMillis();
            if (this.generatedURI == null) {
                Logger.error(this, "No generated URI in onSuccess() for " + this + " from " + state);
            }
        }
        this.finish(container);
        this.trySendFinalMessage(null, container);
        if (this.client != null) {
            this.client.notifySuccess(this, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(InsertException e, BaseClientPutter state, ObjectContainer container) {
        if (this.finished) {
            return;
        }
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            this.finished = true;
            this.completionTime = System.currentTimeMillis();
            this.putFailedMessage = new PutFailedMessage(e, this.identifier, this.global);
        }
        if (this.persistenceType == 2) {
            container.store((Object)this);
        }
        this.finish(container);
        this.trySendFinalMessage(null, container);
        if (this.client != null) {
            this.client.notifyFailure(this, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onGeneratedURI(FreenetURI uri, BaseClientPutter state, ObjectContainer container) {
        RequestStatusCache cache;
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            if (this.generatedURI != null) {
                if (!uri.equals(this.generatedURI)) {
                    Logger.error(this, "onGeneratedURI(" + uri + ',' + state + ") but already set generatedURI to " + this.generatedURI);
                } else if (logMINOR) {
                    Logger.minor(this, "onGeneratedURI() twice with same value: " + this.generatedURI + " -> " + uri);
                }
            } else {
                this.generatedURI = uri;
            }
        }
        if (this.persistenceType == 2) {
            container.store((Object)this);
        }
        this.trySendGeneratedURIMessage(null, container);
        if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
            FreenetURI u = uri;
            if (this.persistenceType == 2) {
                u = u.clone();
            }
            cache.gotFinalURI(this.identifier, uri);
        }
    }

    public FreenetURI getGeneratedURI(ObjectContainer container) {
        if (this.generatedURI == null) {
            return null;
        }
        if (this.persistenceType == 2) {
            container.activate((Object)this.generatedURI, Integer.MAX_VALUE);
            FreenetURI ret = this.generatedURI.clone();
            container.deactivate((Object)this.generatedURI, 1);
            return ret;
        }
        return this.generatedURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onGeneratedMetadata(Bucket metadata, BaseClientPutter state, ObjectContainer container) {
        boolean delete = false;
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            if (this.generatedURI != null) {
                Logger.error(this, "Got generated metadata but already have URI on " + this + " from " + state);
            }
            if (this.generatedMetadata != null) {
                Logger.error(this, "Already got generated metadata from " + state + " on " + this);
                delete = true;
            } else {
                this.generatedMetadata = metadata;
            }
        }
        if (delete) {
            metadata.free();
            metadata.removeFrom(container);
        } else {
            if (this.persistenceType == 2) {
                metadata.storeTo(container);
                container.store((Object)this);
            }
            this.trySendGeneratedMetadataMessage(metadata, null, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestWasRemoved(ObjectContainer container, ClientContext context) {
        Bucket meta;
        if (!this.finished) {
            ClientPutBase clientPutBase = this;
            synchronized (clientPutBase) {
                this.finished = true;
                InsertException cancelled = new InsertException(10);
                this.putFailedMessage = new PutFailedMessage(cancelled, this.identifier, this.global);
            }
            this.trySendFinalMessage(null, container);
        }
        PersistentRequestRemovedMessage msg = new PersistentRequestRemovedMessage(this.getIdentifier(), this.global);
        if (this.persistenceType == 0) {
            this.origHandler.outputHandler.queue(msg);
        } else {
            this.client.queueClientRequestMessage(msg, 0, container);
        }
        this.freeData(container);
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            meta = this.generatedMetadata;
            this.generatedMetadata = null;
        }
        if (meta != null) {
            meta.free();
            if (this.persistenceType == 2) {
                meta.removeFrom(container);
            }
        }
        if (this.persistenceType == 2) {
            FCPMessage progress;
            FreenetURI pubURI;
            FreenetURI uri;
            PutFailedMessage pfm;
            container.activate((Object)this.ctx, 2);
            this.ctx.removeFrom(container);
            ClientPutBase clientPutBase2 = this;
            synchronized (clientPutBase2) {
                pfm = this.putFailedMessage;
                this.putFailedMessage = null;
                uri = this.generatedURI;
                this.generatedURI = null;
                pubURI = this.publicURI;
                progress = this.progressMessage;
                this.progressMessage = null;
            }
            if (pfm != null) {
                container.activate((Object)pfm, 5);
                pfm.removeFrom(container);
            }
            if (uri != null) {
                container.activate((Object)uri, 5);
                uri.removeFrom(container);
            }
            if (progress != null) {
                container.activate((Object)progress, 1);
                progress.removeFrom(container);
            }
            if (pubURI != null) {
                container.activate((Object)pubURI, 5);
                pubURI.removeFrom(container);
            }
        }
        super.requestWasRemoved(container, context);
    }

    @Override
    public void receive(final ClientEvent ce, ObjectContainer container, ClientContext context) {
        if (this.finished) {
            return;
        }
        if (this.persistenceType == 2 && container == null) {
            try {
                context.jobRunner.queue(new DBJob(){

                    @Override
                    public boolean run(ObjectContainer container, ClientContext context) {
                        container.activate((Object)ClientPutBase.this, 1);
                        ClientPutBase.this.receive(ce, container, context);
                        container.deactivate((Object)ClientPutBase.this, 1);
                        return false;
                    }
                }, NativeThread.NORM_PRIORITY, false);
            }
            catch (DatabaseDisabledException e) {
                // empty catch block
            }
            return;
        }
        if (ce instanceof SplitfileProgressEvent) {
            RequestStatusCache cache;
            if ((this.verbosity & 1) == 1) {
                SimpleProgressMessage progress = new SimpleProgressMessage(this.identifier, this.global, (SplitfileProgressEvent)ce);
                this.lastActivity = System.currentTimeMillis();
                this.trySendProgressMessage(progress, 1, null, container, context);
            }
            if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                cache.updateStatus(this.identifier, (SplitfileProgressEvent)ce);
            }
        } else if (ce instanceof StartedCompressionEvent) {
            if ((this.verbosity & 0x200) == 512) {
                StartedCompressionMessage msg = new StartedCompressionMessage(this.identifier, this.global, ((StartedCompressionEvent)ce).codec);
                this.trySendProgressMessage(msg, 512, null, container, context);
                this.onStartCompressing();
            }
        } else if (ce instanceof FinishedCompressionEvent) {
            if ((this.verbosity & 0x200) == 512) {
                FinishedCompressionMessage msg = new FinishedCompressionMessage(this.identifier, this.global, (FinishedCompressionEvent)ce);
                this.trySendProgressMessage(msg, 512, null, container, context);
                this.onStopCompressing();
            }
        } else if (ce instanceof ExpectedHashesEvent && (this.verbosity & 8) == 8) {
            ExpectedHashes msg = new ExpectedHashes((ExpectedHashesEvent)ce, this.identifier, this.global);
            this.trySendProgressMessage(msg, 8, null, container, context);
        }
    }

    protected abstract void onStopCompressing();

    protected abstract void onStartCompressing();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFetchable(BaseClientPutter putter, ObjectContainer container) {
        if (this.finished) {
            return;
        }
        if ((this.verbosity & 0x100) == 256) {
            FreenetURI temp;
            ClientPutBase clientPutBase = this;
            synchronized (clientPutBase) {
                temp = this.generatedURI;
            }
            PutFetchableMessage msg = new PutFetchableMessage(this.identifier, this.global, temp);
            this.trySendProgressMessage(msg, 256, null, container, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySendFinalMessage(FCPConnectionOutputHandler handler, ObjectContainer container) {
        FCPMessage msg;
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            FreenetURI uri = this.generatedURI;
            if (this.persistenceType == 2 && uri != null) {
                container.activate((Object)uri, 5);
                uri = uri.clone();
            }
            if (this.succeeded) {
                msg = new PutSuccessfulMessage(this.identifier, this.global, uri, this.startupTime, this.completionTime);
            } else {
                if (this.persistenceType == 2) {
                    container.activate((Object)this.putFailedMessage, 5);
                }
                msg = this.putFailedMessage;
            }
        }
        if (msg == null) {
            Logger.error(this, "Trying to send null message on " + this, (Throwable)new Exception("error"));
        } else {
            if (this.persistenceType == 0 && handler == null) {
                handler = this.origHandler.outputHandler;
            }
            if (handler != null) {
                handler.queue(msg);
            } else {
                this.client.queueClientRequestMessage(msg, 0, container);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySendGeneratedURIMessage(FCPConnectionOutputHandler handler, ObjectContainer container) {
        URIGeneratedMessage msg;
        if (this.persistenceType == 2) {
            container.activate((Object)this.client, 1);
            container.activate((Object)this.generatedURI, 5);
        }
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            msg = new URIGeneratedMessage(this.generatedURI, this.identifier, this.isGlobalQueue());
        }
        if (this.persistenceType == 0 && handler == null) {
            handler = this.origHandler.outputHandler;
        }
        if (handler != null) {
            handler.queue(msg);
        } else {
            this.client.queueClientRequestMessage(msg, 0, container);
        }
    }

    private void trySendGeneratedMetadataMessage(Bucket metadata, FCPConnectionOutputHandler handler, ObjectContainer container) {
        GeneratedMetadataMessage msg = new GeneratedMetadataMessage(this.identifier, this.global, metadata);
        if (this.persistenceType == 0 && handler == null) {
            handler = this.origHandler.outputHandler;
        }
        if (handler != null) {
            handler.queue(msg);
        } else {
            this.client.queueClientRequestMessage(msg, 0, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void trySendProgressMessage(final FCPMessage msg, final int verbosity, FCPConnectionOutputHandler handler, ObjectContainer container, ClientContext context) {
        block14: {
            if (this.persistenceType == 2) {
                if (container != null) {
                    FCPMessage oldProgress = null;
                    ClientPutBase clientPutBase = this;
                    // MONITORENTER : clientPutBase
                    if (this.persistenceType != 0) {
                        oldProgress = this.progressMessage;
                        this.progressMessage = msg;
                    }
                    // MONITOREXIT : clientPutBase
                    if (oldProgress != null) {
                        container.activate((Object)oldProgress, 1);
                        oldProgress.removeFrom(container);
                    }
                    container.store((Object)this);
                    break block14;
                } else {
                    final FCPConnectionOutputHandler h = handler;
                    try {
                        context.jobRunner.queue(new DBJob(){

                            @Override
                            public boolean run(ObjectContainer container, ClientContext context) {
                                container.activate((Object)ClientPutBase.this, 1);
                                ClientPutBase.this.trySendProgressMessage(msg, verbosity, h, container, context);
                                container.deactivate((Object)ClientPutBase.this, 1);
                                return false;
                            }
                        }, NativeThread.NORM_PRIORITY, false);
                        return;
                    }
                    catch (DatabaseDisabledException e) {
                        // empty catch block
                    }
                    return;
                }
            }
            ClientPutBase clientPutBase = this;
            // MONITORENTER : clientPutBase
            if (this.persistenceType != 0) {
                this.progressMessage = msg;
            }
            // MONITOREXIT : clientPutBase
        }
        if (this.persistenceType == 0 && handler == null) {
            handler = this.origHandler.outputHandler;
        }
        if (handler != null) {
            handler.queue(msg);
            return;
        }
        this.client.queueClientRequestMessage(msg, verbosity, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPendingMessages(FCPConnectionOutputHandler handler, boolean includePersistentRequest, boolean includeData, boolean onlyData, ObjectContainer container) {
        Bucket meta;
        if (includePersistentRequest) {
            FCPMessage msg = this.persistentTagMessage(container);
            handler.queue(msg);
        }
        boolean generated = false;
        FCPMessage msg = null;
        boolean fin = false;
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            generated = this.generatedURI != null;
            msg = this.progressMessage;
            fin = this.finished;
            meta = this.generatedMetadata;
        }
        if (this.persistenceType == 2 && msg != null) {
            container.activate((Object)msg, 5);
        }
        if (generated) {
            this.trySendGeneratedURIMessage(handler, container);
        }
        if (meta != null) {
            this.trySendGeneratedMetadataMessage(meta, handler, container);
        }
        if (msg != null) {
            handler.queue(msg);
        }
        if (fin) {
            this.trySendFinalMessage(handler, container);
        }
    }

    protected abstract String getTypeName();

    @Override
    public synchronized double getSuccessFraction(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressMessage != null) {
            container.activate((Object)this.progressMessage, 2);
        }
        if (this.progressMessage != null) {
            if (this.progressMessage instanceof SimpleProgressMessage) {
                return ((SimpleProgressMessage)this.progressMessage).getFraction();
            }
            return 0.0;
        }
        return -1.0;
    }

    @Override
    public synchronized double getTotalBlocks(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressMessage != null) {
            container.activate((Object)this.progressMessage, 2);
        }
        if (this.progressMessage != null) {
            if (this.progressMessage instanceof SimpleProgressMessage) {
                return ((SimpleProgressMessage)this.progressMessage).getTotalBlocks();
            }
            return 0.0;
        }
        return -1.0;
    }

    @Override
    public synchronized double getMinBlocks(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressMessage != null) {
            container.activate((Object)this.progressMessage, 2);
        }
        if (this.progressMessage != null) {
            if (this.progressMessage instanceof SimpleProgressMessage) {
                return ((SimpleProgressMessage)this.progressMessage).getMinBlocks();
            }
            return 0.0;
        }
        return -1.0;
    }

    @Override
    public synchronized double getFailedBlocks(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressMessage != null) {
            container.activate((Object)this.progressMessage, 2);
        }
        if (this.progressMessage != null) {
            if (this.progressMessage instanceof SimpleProgressMessage) {
                return ((SimpleProgressMessage)this.progressMessage).getFailedBlocks();
            }
            return 0.0;
        }
        return -1.0;
    }

    @Override
    public synchronized double getFatalyFailedBlocks(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressMessage != null) {
            container.activate((Object)this.progressMessage, 2);
        }
        if (this.progressMessage != null) {
            if (this.progressMessage instanceof SimpleProgressMessage) {
                return ((SimpleProgressMessage)this.progressMessage).getFatalyFailedBlocks();
            }
            return 0.0;
        }
        return -1.0;
    }

    @Override
    public synchronized double getFetchedBlocks(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressMessage != null) {
            container.activate((Object)this.progressMessage, 2);
        }
        if (this.progressMessage != null) {
            if (this.progressMessage instanceof SimpleProgressMessage) {
                return ((SimpleProgressMessage)this.progressMessage).getFetchedBlocks();
            }
            return 0.0;
        }
        return -1.0;
    }

    @Override
    public synchronized boolean isTotalFinalized(ObjectContainer container) {
        if (!(this.progressMessage instanceof SimpleProgressMessage)) {
            return false;
        }
        if (this.persistenceType == 2) {
            container.activate((Object)this.progressMessage, 5);
        }
        return ((SimpleProgressMessage)this.progressMessage).isTotalFinalized();
    }

    @Override
    public synchronized String getFailureReason(boolean longDescription, ObjectContainer container) {
        if (this.putFailedMessage == null) {
            return null;
        }
        if (this.persistenceType == 2) {
            container.activate((Object)this.putFailedMessage, 5);
        }
        String s = this.putFailedMessage.shortCodeDescription;
        if (longDescription && this.putFailedMessage.extraDescription != null) {
            s = s + ": " + this.putFailedMessage.extraDescription;
        }
        return s;
    }

    public PutFailedMessage getFailureMessage(ObjectContainer container) {
        if (this.putFailedMessage == null) {
            return null;
        }
        if (this.persistenceType == 2) {
            container.activate((Object)this.putFailedMessage, 5);
        }
        return this.putFailedMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVarsRestart(ObjectContainer container) {
        FCPMessage progress;
        PutFailedMessage pfm;
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            this.finished = false;
            pfm = this.putFailedMessage;
            progress = this.progressMessage;
            this.putFailedMessage = null;
            this.progressMessage = null;
            this.started = false;
        }
        if (this.persistenceType == 2) {
            if (pfm != null) {
                container.activate((Object)pfm, 1);
                pfm.removeFrom(container);
            }
            if (progress != null) {
                container.activate((Object)progress, 1);
                progress.removeFrom(container);
            }
            container.store((Object)this);
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

