/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.DefaultMIMETypes;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientRequester;
import freenet.client.async.DefaultManifestPutter;
import freenet.client.async.ManifestElement;
import freenet.client.async.ManifestPutter;
import freenet.client.async.SimpleManifestPutter;
import freenet.client.async.TooManyFilesInsertException;
import freenet.keys.FreenetURI;
import freenet.node.fcp.ClientPutBase;
import freenet.node.fcp.ClientPutDirMessage;
import freenet.node.fcp.FCPClient;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.FCPServer;
import freenet.node.fcp.IdentifierCollisionException;
import freenet.node.fcp.PersistentPutDir;
import freenet.node.fcp.RequestStatus;
import freenet.node.fcp.RequestStatusCache;
import freenet.node.fcp.SimpleProgressMessage;
import freenet.node.fcp.UploadDirRequestStatus;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.io.FileBucket;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.util.HashMap;

public class ClientPutDir
extends ClientPutBase {
    private HashMap<String, Object> manifestElements;
    private ManifestPutter putter;
    private short manifestPutterType;
    private final String defaultName;
    private final long totalSize;
    private final int numberOfFiles;
    private final boolean wasDiskPut;
    private static volatile boolean logMINOR;
    private final byte[] overrideSplitfileCryptoKey;

    private ClientPutDir() {
        this.wasDiskPut = false;
        this.totalSize = 0L;
        this.numberOfFiles = 0;
        this.defaultName = null;
        this.overrideSplitfileCryptoKey = null;
    }

    public ClientPutDir(FCPConnectionHandler handler, ClientPutDirMessage message, HashMap<String, Object> manifestElements, boolean wasDiskPut, FCPServer server, ObjectContainer container) throws IdentifierCollisionException, MalformedURLException, TooManyFilesInsertException {
        super(ClientPutDir.checkEmptySSK(message.uri, message.targetFilename != null ? message.targetFilename : "site", server.core.clientContext), message.identifier, message.verbosity, null, handler, message.priorityClass, message.persistenceType, message.clientToken, message.global, message.getCHKOnly, message.dontCompress, message.localRequestOnly, message.maxRetries, message.earlyEncode, message.canWriteClientCache, message.forkOnCacheable, message.compressorDescriptor, message.extraInsertsSingleBlock, message.extraInsertsSplitfileHeaderBlock, message.realTimeFlag, message.compatibilityMode, message.ignoreUSKDatehints, server, container);
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        this.wasDiskPut = wasDiskPut;
        this.overrideSplitfileCryptoKey = message.overrideSplitfileCryptoKey;
        this.manifestElements = new HashMap();
        this.manifestElements.putAll(manifestElements);
        this.defaultName = message.defaultName;
        this.manifestPutterType = message.manifestPutterType;
        this.makePutter(container, server.core.clientContext);
        if (this.putter != null) {
            this.numberOfFiles = this.putter.countFiles();
            this.totalSize = this.putter.totalSize();
        } else {
            this.numberOfFiles = -1;
            this.totalSize = -1L;
        }
        if (logMINOR) {
            Logger.minor(this, "Putting dir " + this.identifier + " : " + this.priorityClass);
        }
    }

    public ClientPutDir(FCPClient client, FreenetURI uri, String identifier, int verbosity, short priorityClass, short persistenceType, String clientToken, boolean getCHKOnly, boolean dontCompress, int maxRetries, File dir, String defaultName, boolean allowUnreadableFiles, boolean includeHiddenFiles, boolean global, boolean earlyEncode, boolean canWriteClientCache, boolean forkOnCacheable, int extraInsertsSingleBlock, int extraInsertsSplitfileHeaderBlock, boolean realTimeFlag, byte[] overrideSplitfileCryptoKey, FCPServer server, ObjectContainer container) throws FileNotFoundException, IdentifierCollisionException, MalformedURLException, TooManyFilesInsertException {
        super(ClientPutDir.checkEmptySSK(uri, "site", server.core.clientContext), identifier, verbosity, null, null, client, priorityClass, persistenceType, clientToken, global, getCHKOnly, dontCompress, maxRetries, earlyEncode, canWriteClientCache, forkOnCacheable, false, extraInsertsSingleBlock, extraInsertsSplitfileHeaderBlock, realTimeFlag, null, InsertContext.CompatibilityMode.COMPAT_CURRENT, false, server, container);
        this.wasDiskPut = true;
        this.overrideSplitfileCryptoKey = overrideSplitfileCryptoKey;
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        this.manifestElements = this.makeDiskDirManifest(dir, "", allowUnreadableFiles, includeHiddenFiles);
        this.defaultName = defaultName;
        this.manifestPutterType = 0;
        this.makePutter(container, server.core.clientContext);
        if (this.putter != null) {
            this.numberOfFiles = this.putter.countFiles();
            this.totalSize = this.putter.totalSize();
        } else {
            this.numberOfFiles = -1;
            this.totalSize = -1L;
        }
        if (logMINOR) {
            Logger.minor(this, "Putting dir " + identifier + " : " + priorityClass);
        }
    }

    public ClientPutDir(FCPClient client, FreenetURI uri, String identifier, int verbosity, short priorityClass, short persistenceType, String clientToken, boolean getCHKOnly, boolean dontCompress, int maxRetries, HashMap<String, Object> elements, String defaultName, boolean global, boolean earlyEncode, boolean canWriteClientCache, boolean forkOnCacheable, int extraInsertsSingleBlock, int extraInsertsSplitfileHeaderBlock, boolean realTimeFlag, byte[] overrideSplitfileCryptoKey, FCPServer server, ObjectContainer container) throws IdentifierCollisionException, MalformedURLException, TooManyFilesInsertException {
        super(ClientPutDir.checkEmptySSK(uri, "site", server.core.clientContext), identifier, verbosity, null, null, client, priorityClass, persistenceType, clientToken, global, getCHKOnly, dontCompress, maxRetries, earlyEncode, canWriteClientCache, forkOnCacheable, false, extraInsertsSingleBlock, extraInsertsSplitfileHeaderBlock, realTimeFlag, null, InsertContext.CompatibilityMode.COMPAT_CURRENT, false, server, container);
        this.wasDiskPut = false;
        this.overrideSplitfileCryptoKey = overrideSplitfileCryptoKey;
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        this.manifestElements = elements;
        this.defaultName = defaultName;
        this.manifestPutterType = 0;
        this.makePutter(container, server.core.clientContext);
        if (this.putter != null) {
            this.numberOfFiles = this.putter.countFiles();
            this.totalSize = this.putter.totalSize();
        } else {
            this.numberOfFiles = -1;
            this.totalSize = -1L;
        }
        if (logMINOR) {
            Logger.minor(this, "Putting data from custom buckets " + identifier + " : " + priorityClass);
        }
    }

    @Override
    void register(ObjectContainer container, boolean noTags) throws IdentifierCollisionException {
        if (this.persistenceType != 0) {
            this.client.register(this, container);
        }
        if (this.persistenceType != 0 && !noTags) {
            FCPMessage msg = this.persistentTagMessage(container);
            this.client.queueClientRequestMessage(msg, 0, container);
        }
    }

    private HashMap<String, Object> makeDiskDirManifest(File dir, String prefix, boolean allowUnreadableFiles, boolean includeHiddenFiles) throws FileNotFoundException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IllegalArgumentException("No such directory");
        }
        for (File f : files) {
            if (f.isHidden() && !includeHiddenFiles) continue;
            if (f.exists() && f.canRead()) {
                if (f.isFile()) {
                    FileBucket bucket = new FileBucket(f, true, false, false, false, false);
                    if (logMINOR) {
                        Logger.minor(this, "Add file : " + f.getAbsolutePath());
                    }
                    map.put(f.getName(), new ManifestElement(f.getName(), prefix + f.getName(), bucket, DefaultMIMETypes.guessMIMEType(f.getName(), true), f.length()));
                    continue;
                }
                if (f.isDirectory()) {
                    if (logMINOR) {
                        Logger.minor(this, "Add dir : " + f.getAbsolutePath());
                    }
                    map.put(f.getName(), this.makeDiskDirManifest(f, prefix + f.getName() + "/", allowUnreadableFiles, includeHiddenFiles));
                    continue;
                }
                if (allowUnreadableFiles) continue;
                throw new FileNotFoundException("Not a file and not a directory : " + f);
            }
            if (allowUnreadableFiles) continue;
            throw new FileNotFoundException("The file does not exist or is unreadable : " + f);
        }
        return map;
    }

    private void makePutter(ObjectContainer container, ClientContext context) throws TooManyFilesInsertException {
        switch (this.manifestPutterType) {
            case 1: {
                this.putter = new DefaultManifestPutter(this, this.manifestElements, this.priorityClass, this.uri, this.defaultName, this.ctx, this.getCHKOnly, this.lowLevelClient, this.earlyEncode, this.persistenceType == 2, this.overrideSplitfileCryptoKey, container, context);
                break;
            }
            default: {
                this.putter = new SimpleManifestPutter(this, this.manifestElements, this.priorityClass, this.uri, this.defaultName, this.ctx, this.getCHKOnly, this.lowLevelClient, this.earlyEncode, this.persistenceType == 2, this.overrideSplitfileCryptoKey, container, context);
            }
        }
    }

    @Override
    public void start(ObjectContainer container, ClientContext context) {
        if (this.finished) {
            return;
        }
        if (this.started) {
            return;
        }
        try {
            RequestStatusCache cache;
            if (this.persistenceType == 2) {
                container.activate((Object)this.putter, 1);
            }
            if (this.putter != null) {
                this.putter.start(container, context);
            }
            this.started = true;
            if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                cache.updateStarted(this.identifier, true);
            }
            if (logMINOR) {
                Logger.minor(this, "Started " + this.putter + " for " + this + " persistence=" + this.persistenceType);
            }
            if (this.persistenceType != 0 && !this.finished) {
                FCPMessage msg = this.persistentTagMessage(container);
                this.client.queueClientRequestMessage(msg, 0, container);
            }
            if (this.persistenceType == 2) {
                container.store((Object)this);
            }
        }
        catch (InsertException e) {
            this.started = true;
            this.onFailure(e, null, container);
        }
    }

    @Override
    public void onLostConnection(ObjectContainer container, ClientContext context) {
        if (this.persistenceType == 0) {
            this.cancel(container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void freeData(ObjectContainer container) {
        if (logMINOR) {
            Logger.minor(this, "freeData() on " + this + " persistence type = " + this.persistenceType);
        }
        ClientPutDir clientPutDir = this;
        synchronized (clientPutDir) {
            if (this.manifestElements == null) {
                if (logMINOR) {
                    Logger.minor(this, "manifestElements = " + this.manifestElements + (this.persistenceType != 2 ? "" : " dir.active=" + container.ext().isActive((Object)this)), (Throwable)new Exception("error"));
                }
                return;
            }
        }
        if (logMINOR) {
            Logger.minor(this, "freeData() more on " + this + " persistence type = " + this.persistenceType);
        }
        if (this.persistenceType == 2) {
            container.deactivate(this.manifestElements, 1);
            container.activate(this.manifestElements, Integer.MAX_VALUE);
        }
        this.freeData(this.manifestElements, container);
        this.manifestElements = null;
        if (this.persistenceType == 2) {
            container.store((Object)this);
        }
    }

    private void freeData(HashMap<String, Object> manifestElements, ObjectContainer container) {
        if (logMINOR) {
            Logger.minor(this, "freeData() inner on " + this + " persistence type = " + this.persistenceType + " size = " + manifestElements.size());
        }
        for (Object o : manifestElements.values()) {
            if (o instanceof HashMap) {
                this.freeData((HashMap)o, container);
                continue;
            }
            ManifestElement e = (ManifestElement)o;
            if (logMINOR) {
                Logger.minor(this, "Freeing " + e);
            }
            e.freeData(container, this.persistenceType == 2);
        }
        if (this.persistenceType == 2) {
            container.delete(manifestElements);
        }
    }

    @Override
    protected ClientRequester getClientRequest() {
        return this.putter;
    }

    @Override
    protected FCPMessage persistentTagMessage(ObjectContainer container) {
        if (this.persistenceType == 2) {
            container.activate((Object)this.publicURI, 5);
            container.activate((Object)this.uri, 5);
            container.activate((Object)this.ctx, 1);
            container.activate(this.manifestElements, 5);
        }
        if (this.lowLevelClient == null) {
            Logger.error(this, "lowLevelClient == null", (Throwable)new Exception("error"));
        }
        if (this.putter == null) {
            Logger.error(this, "putter == null", (Throwable)new Exception("error"));
        }
        return new PersistentPutDir(this.identifier, this.publicURI, this.uri, this.verbosity, this.priorityClass, this.persistenceType, this.global, this.defaultName, this.manifestElements, this.clientToken, this.started, this.ctx.maxInsertRetries, this.ctx.dontCompress, this.ctx.compressorDescriptor, this.wasDiskPut, this.isRealTime(), this.putter != null ? this.putter.getSplitfileCryptoKey() : null, container);
    }

    private boolean isRealTime() {
        if (this.lowLevelClient == null) {
            Logger.error(this, "lowLevelClient == null", (Throwable)new Exception("error"));
            return false;
        }
        return this.lowLevelClient.realTimeFlag();
    }

    @Override
    protected String getTypeName() {
        return "PUTDIR";
    }

    @Override
    public boolean hasSucceeded() {
        return this.succeeded;
    }

    public FreenetURI getFinalURI(ObjectContainer container) {
        if (this.persistenceType == 2) {
            container.activate((Object)this.generatedURI, 5);
        }
        return this.generatedURI;
    }

    public int getNumberOfFiles() {
        return this.numberOfFiles;
    }

    public long getTotalDataSize() {
        return this.totalSize;
    }

    @Override
    public boolean canRestart() {
        if (!this.finished) {
            Logger.minor(this, "Cannot restart because not finished for " + this.identifier);
            return false;
        }
        if (this.succeeded) {
            Logger.minor(this, "Cannot restart because succeeded for " + this.identifier);
            return false;
        }
        return true;
    }

    @Override
    public boolean restart(ObjectContainer container, ClientContext context, boolean disableFilterData) {
        RequestStatusCache cache;
        if (!this.canRestart()) {
            return false;
        }
        this.setVarsRestart(container);
        if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
            cache.updateStarted(this.identifier, false);
        }
        try {
            this.makePutter(container, context);
        }
        catch (TooManyFilesInsertException e) {
            this.onFailure(new InsertException(e), null, container);
        }
        this.start(container, context);
        return true;
    }

    public void onFailure(FetchException e, ClientGetter state, ObjectContainer container) {
    }

    public void onSuccess(FetchResult result, ClientGetter state, ObjectContainer container) {
    }

    @Override
    public void onSuccess(BaseClientPutter state, ObjectContainer container) {
        super.onSuccess(state, container);
    }

    @Override
    public void onFailure(InsertException e, BaseClientPutter state, ObjectContainer container) {
        super.onFailure(e, state, container);
    }

    @Override
    public void onRemoveEventProducer(ObjectContainer container) {
    }

    @Override
    public void requestWasRemoved(ObjectContainer container, ClientContext context) {
        if (this.persistenceType == 2) {
            container.activate((Object)this.putter, 1);
            this.putter.removeFrom(container, context);
            this.putter = null;
        }
        super.requestWasRemoved(container, context);
    }

    @Override
    protected void onStartCompressing() {
    }

    @Override
    protected void onStopCompressing() {
    }

    @Override
    RequestStatus getStatus(ObjectContainer container) {
        FreenetURI finalURI = this.getFinalURI(container);
        if (finalURI != null) {
            finalURI = this.getFinalURI(container).clone();
        }
        int failureCode = -1;
        String failureReasonShort = null;
        String failureReasonLong = null;
        if (this.putFailedMessage != null) {
            if (this.persistenceType == 2) {
                container.activate((Object)this.putFailedMessage, 5);
            }
            failureCode = this.putFailedMessage.code;
            failureReasonShort = this.putFailedMessage.getShortFailedMessage();
            failureReasonShort = this.putFailedMessage.getLongFailedMessage();
            if (this.persistenceType == 2) {
                container.deactivate((Object)this.putFailedMessage, 5);
            }
        }
        int total = 0;
        int min = 0;
        int fetched = 0;
        int fatal = 0;
        int failed = 0;
        boolean totalFinalized = false;
        if (this.progressMessage != null) {
            if (this.persistenceType == 2) {
                container.activate((Object)this.progressMessage, 2);
            }
            if (this.progressMessage instanceof SimpleProgressMessage) {
                SimpleProgressMessage msg = (SimpleProgressMessage)this.progressMessage;
                total = (int)msg.getTotalBlocks();
                min = (int)msg.getMinBlocks();
                fetched = (int)msg.getFetchedBlocks();
                fatal = (int)msg.getFatalyFailedBlocks();
                failed = (int)msg.getFailedBlocks();
                totalFinalized = msg.isTotalFinalized();
            }
        }
        FreenetURI targetURI = this.uri;
        if (this.persistenceType == 2) {
            container.activate((Object)targetURI, Integer.MAX_VALUE);
            targetURI = targetURI.clone();
        }
        return new UploadDirRequestStatus(this.identifier, this.persistenceType, this.started, this.finished, this.succeeded, total, min, fetched, fatal, failed, totalFinalized, this.lastActivity, this.priorityClass, finalURI, targetURI, failureCode, failureReasonShort, failureReasonLong, this.totalSize, this.numberOfFiles);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

