/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import freenet.client.InsertContext;
import freenet.client.async.ManifestPutter;
import freenet.keys.FreenetURI;
import freenet.node.RequestStarter;
import freenet.node.fcp.BaseDataCarryingMessage;
import freenet.node.fcp.ClientRequest;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.HexUtil;
import freenet.support.SimpleFieldSet;
import freenet.support.compress.Compressor;
import freenet.support.compress.InvalidCompressionCodecException;
import java.net.MalformedURLException;

public abstract class ClientPutDirMessage
extends BaseDataCarryingMessage {
    final String identifier;
    final FreenetURI uri;
    final int verbosity;
    final int maxRetries;
    final boolean getCHKOnly;
    final short priorityClass;
    final short persistenceType;
    final boolean dontCompress;
    final String clientToken;
    final boolean global;
    final String defaultName;
    final boolean earlyEncode;
    final boolean canWriteClientCache;
    final String compressorDescriptor;
    public boolean forkOnCacheable;
    final int extraInsertsSingleBlock;
    final int extraInsertsSplitfileHeaderBlock;
    final InsertContext.CompatibilityMode compatibilityMode;
    final byte[] overrideSplitfileCryptoKey;
    final boolean localRequestOnly;
    final boolean realTimeFlag;
    final short manifestPutterType;
    final String targetFilename;
    final boolean ignoreUSKDatehints;

    public ClientPutDirMessage(SimpleFieldSet fs) throws MessageInvalidException {
        this.identifier = fs.get("Identifier");
        this.global = fs.getBoolean("Global", false);
        this.defaultName = fs.get("DefaultName");
        String s = fs.get("CompatibilityMode");
        InsertContext.CompatibilityMode cmode = null;
        if (s == null) {
            cmode = InsertContext.CompatibilityMode.COMPAT_CURRENT;
        } else {
            try {
                cmode = InsertContext.CompatibilityMode.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                try {
                    cmode = InsertContext.CompatibilityMode.values()[Integer.parseInt(s)];
                }
                catch (NumberFormatException e1) {
                    throw new MessageInvalidException(8, "Invalid CompatibilityMode (not a name and not a number)", this.identifier, this.global);
                }
                catch (ArrayIndexOutOfBoundsException e1) {
                    throw new MessageInvalidException(8, "Invalid CompatibilityMode (not a valid number)", this.identifier, this.global);
                }
            }
        }
        this.compatibilityMode = cmode;
        s = fs.get("OverrideSplitfileCryptoKey");
        if (s == null) {
            this.overrideSplitfileCryptoKey = null;
        } else {
            try {
                this.overrideSplitfileCryptoKey = HexUtil.hexToBytes(s);
            }
            catch (NumberFormatException e1) {
                throw new MessageInvalidException(8, "Invalid splitfile crypto key (not hex)", this.identifier, this.global);
            }
            catch (IndexOutOfBoundsException e1) {
                throw new MessageInvalidException(8, "Invalid splitfile crypto key (too short)", this.identifier, this.global);
            }
        }
        this.localRequestOnly = fs.getBoolean("LocalRequestOnly", false);
        if (this.identifier == null) {
            throw new MessageInvalidException(5, "No Identifier", null, this.global);
        }
        try {
            String u = fs.get("URI");
            if (u == null) {
                throw new MessageInvalidException(5, "No URI", this.identifier, this.global);
            }
            FreenetURI uu = new FreenetURI(u);
            String[] meta = uu.getAllMetaStrings();
            if (meta != null && meta.length == 1 && meta[0].length() == 0) {
                uu = uu.setMetaString(null);
            }
            this.uri = uu;
        }
        catch (MalformedURLException e) {
            throw new MessageInvalidException(4, e.getMessage(), this.identifier, this.global);
        }
        String verbosityString = fs.get("Verbosity");
        if (verbosityString == null) {
            this.verbosity = 0;
        } else {
            try {
                this.verbosity = Integer.parseInt(verbosityString, 10);
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing Verbosity field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        String maxRetriesString = fs.get("MaxRetries");
        if (maxRetriesString == null) {
            this.maxRetries = 0;
        } else {
            try {
                this.maxRetries = Integer.parseInt(maxRetriesString, 10);
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing MaxSize field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        this.getCHKOnly = fs.getBoolean("GetCHKOnly", false);
        String priorityString = fs.get("PriorityClass");
        if (priorityString == null) {
            this.priorityClass = (short)2;
        } else {
            try {
                this.priorityClass = Short.parseShort(priorityString);
                if (!RequestStarter.isValidPriorityClass(this.priorityClass)) {
                    throw new MessageInvalidException(8, "Invalid priority class " + this.priorityClass + " - range is " + 6 + " to " + 0, this.identifier, this.global);
                }
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing PriorityClass field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        this.dontCompress = fs.getBoolean("DontCompress", false);
        String persistenceString = fs.get("Persistence");
        if (persistenceString == null || persistenceString.equalsIgnoreCase("connection")) {
            this.persistenceType = 0;
        } else if (persistenceString.equalsIgnoreCase("reboot")) {
            this.persistenceType = 1;
        } else if (persistenceString.equalsIgnoreCase("forever")) {
            this.persistenceType = (short)2;
        } else {
            throw new MessageInvalidException(6, "Error parsing Persistence field: " + persistenceString, this.identifier, this.global);
        }
        this.canWriteClientCache = fs.getBoolean("WriteToClientCache", false);
        this.clientToken = fs.get("ClientToken");
        this.targetFilename = fs.get("TargetFilename");
        this.earlyEncode = fs.getBoolean("EarlyEncode", false);
        String codecs = fs.get("Codecs");
        if (codecs != null) {
            Compressor.COMPRESSOR_TYPE[] ca;
            try {
                ca = Compressor.COMPRESSOR_TYPE.getCompressorsArrayNoDefault(codecs);
            }
            catch (InvalidCompressionCodecException e) {
                throw new MessageInvalidException(8, e.getMessage(), this.identifier, this.global);
            }
            if (ca == null) {
                codecs = null;
            }
        }
        this.compressorDescriptor = codecs;
        this.forkOnCacheable = fs.get("ForkOnCacheable") != null ? fs.getBoolean("ForkOnCacheable", false) : true;
        this.extraInsertsSingleBlock = fs.getInt("ExtraInsertsSingleBlock", 2);
        this.extraInsertsSplitfileHeaderBlock = fs.getInt("ExtraInsertsSplitfileHeaderBlock", 2);
        this.realTimeFlag = fs.getBoolean("RealTimeFlag", false);
        String manifestPutter = fs.get("ManifestPutter");
        short manifestType = this.persistenceType == 2 ? (short)0 : 1;
        if ("simple".equalsIgnoreCase(manifestPutter)) {
            manifestType = 0;
        } else if ("default".equalsIgnoreCase(manifestPutter)) {
            manifestType = 1;
        } else if (manifestPutter != null) {
            throw new MessageInvalidException(8, "Invalid ManifestPutter value: " + manifestPutter, this.identifier, this.global);
        }
        this.manifestPutterType = manifestType;
        if (this.manifestPutterType != 0 && this.persistenceType != 0 && this.persistenceType != 1) {
            throw new MessageInvalidException(8, "Only Connection or Reboot persistenace can only be used with the default ManifestPutter", this.identifier, this.global);
        }
        this.ignoreUSKDatehints = fs.getBoolean("IgnoreUSKDatehints", false);
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        sfs.putSingle("URI", this.uri.toString());
        sfs.putSingle("Identifier", this.identifier);
        sfs.put("Verbosity", this.verbosity);
        sfs.put("MaxRetries", this.maxRetries);
        sfs.putSingle("ClientToken", this.clientToken);
        sfs.put("GetCHKOnly", this.getCHKOnly);
        sfs.put("PriorityClass", this.priorityClass);
        sfs.putSingle("PersistenceType", ClientRequest.persistenceTypeString(this.persistenceType));
        sfs.put("DontCompress", this.dontCompress);
        if (this.compressorDescriptor != null) {
            sfs.putSingle("Codecs", this.compressorDescriptor);
        }
        sfs.put("Global", this.global);
        sfs.putSingle("DefaultName", this.defaultName);
        sfs.putSingle("ManifestPutter", ManifestPutter.manifestPutterTypeString(this.manifestPutterType));
        return sfs;
    }
}

