/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import freenet.client.FetchException;
import freenet.client.InsertContext;
import freenet.keys.FreenetURI;
import freenet.node.fcp.RequestStatus;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import java.io.File;

public class DownloadRequestStatus
extends RequestStatus {
    private int failureCode;
    private String failureReasonShort;
    private String failureReasonLong;
    private String mimeType;
    private long dataSize;
    private final File destFilename;
    private InsertContext.CompatibilityMode[] detectedCompatModes;
    private byte[] detectedSplitfileKey;
    private FreenetURI uri;
    boolean filterData;
    Bucket dataShadow;
    public final boolean overriddenDataType;
    private boolean detectedDontCompress;

    synchronized void setFinished(boolean success, long dataSize, String mimeType, int failureCode, String failureReasonLong, String failureReasonShort, Bucket dataShadow, boolean filtered) {
        this.setFinished(success);
        if (mimeType == null && (failureCode == 32 || failureCode == 33)) {
            Logger.error(this, "MIME type is null but failure code is " + FetchException.getMessage(failureCode) + " for " + this.getIdentifier() + " : " + this.uri, (Throwable)new Exception("error"));
        }
        this.dataSize = dataSize;
        this.mimeType = mimeType;
        this.failureCode = failureCode;
        this.failureReasonLong = failureReasonLong;
        this.failureReasonShort = failureReasonShort;
        this.dataShadow = dataShadow;
        this.filterData = filtered;
    }

    DownloadRequestStatus(String identifier, short persistence, boolean started, boolean finished, boolean success, int total, int min, int fetched, int fatal, int failed, boolean totalFinalized, long last, short prio, int failureCode, String mime, long size, File dest, InsertContext.CompatibilityMode[] compat, byte[] splitfileKey, FreenetURI uri, String failureReasonShort, String failureReasonLong, boolean overriddenDataType, Bucket dataShadow, boolean filterData, boolean dontCompress) {
        super(identifier, persistence, started, finished, success, total, min, fetched, fatal, failed, totalFinalized, last, prio);
        if (this.mimeType == null && (failureCode == 32 || failureCode == 33)) {
            Logger.error(this, "MIME type is null but failure code is " + FetchException.getMessage(failureCode) + " for " + identifier + " : " + uri, (Throwable)new Exception("error"));
        }
        this.overriddenDataType = overriddenDataType;
        this.failureCode = failureCode;
        this.mimeType = mime;
        this.dataSize = size;
        this.destFilename = dest;
        this.detectedCompatModes = compat;
        this.detectedSplitfileKey = splitfileKey;
        this.uri = uri;
        this.failureReasonShort = failureReasonShort;
        this.failureReasonLong = failureReasonLong;
        this.dataShadow = dataShadow;
        this.filterData = filterData;
        this.detectedDontCompress = dontCompress;
    }

    public final boolean toTempSpace() {
        return this.destFilename == null;
    }

    public int getFailureCode() {
        return this.failureCode;
    }

    public String getMIMEType() {
        return this.mimeType;
    }

    @Override
    public long getDataSize() {
        return this.dataSize;
    }

    public File getDestFilename() {
        return this.destFilename;
    }

    public InsertContext.CompatibilityMode[] getCompatibilityMode() {
        return this.detectedCompatModes;
    }

    public byte[] getOverriddenSplitfileCryptoKey() {
        return this.detectedSplitfileKey;
    }

    @Override
    public FreenetURI getURI() {
        return this.uri;
    }

    @Override
    public String getFailureReason(boolean longDescription) {
        if (longDescription) {
            return this.failureReasonLong;
        }
        return this.failureReasonShort;
    }

    synchronized void updateDetectedCompatModes(InsertContext.CompatibilityMode[] compatModes, boolean dontCompress) {
        this.detectedCompatModes = compatModes;
        this.detectedDontCompress = dontCompress;
    }

    synchronized void updateDetectedSplitfileKey(byte[] splitfileKey) {
        this.detectedSplitfileKey = splitfileKey;
    }

    synchronized void updateExpectedMIME(String foundDataMimeType) {
        this.mimeType = foundDataMimeType;
    }

    synchronized void updateExpectedDataLength(long dataLength) {
        this.dataSize = dataLength;
    }

    public synchronized Bucket getDataShadow() {
        return this.dataShadow;
    }

    synchronized void redirect(FreenetURI redirect) {
        this.uri = redirect;
    }

    public synchronized boolean detectedDontCompress() {
        return this.detectedDontCompress;
    }

    @Override
    public String getPreferredFilename() {
        if (this.destFilename != null) {
            return this.destFilename.getName();
        }
        if (this.uri != null && (this.uri.hasMetaStrings() || this.uri.getDocName() != null)) {
            return this.uri.getPreferredFilename();
        }
        return null;
    }
}

