/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.TooManyFilesInsertException;
import freenet.node.RequestClient;
import freenet.node.fcp.ClientGet;
import freenet.node.fcp.ClientGetMessage;
import freenet.node.fcp.ClientPut;
import freenet.node.fcp.ClientPutDir;
import freenet.node.fcp.ClientPutDirMessage;
import freenet.node.fcp.ClientPutMessage;
import freenet.node.fcp.ClientRequest;
import freenet.node.fcp.FCPClient;
import freenet.node.fcp.FCPConnectionInputHandler;
import freenet.node.fcp.FCPConnectionOutputHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.FCPServer;
import freenet.node.fcp.IdentifierCollisionException;
import freenet.node.fcp.IdentifierCollisionMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.ProtocolErrorMessage;
import freenet.node.fcp.SubscribeUSK;
import freenet.support.HexUtil;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.BucketFactory;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import freenet.support.io.NativeThread;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class FCPConnectionHandler
implements Closeable {
    final FCPServer server;
    final Socket sock;
    final FCPConnectionInputHandler inputHandler;
    final Map<String, SubscribeUSK> uskSubscriptions;
    public final FCPConnectionOutputHandler outputHandler;
    private boolean isClosed;
    private boolean inputClosed;
    private boolean outputClosed;
    private String clientName;
    private FCPClient rebootClient;
    private FCPClient foreverClient;
    final BucketFactory bf;
    final HashMap<String, ClientRequest> requestsByIdentifier;
    protected final String connectionIdentifier;
    private static volatile boolean logMINOR;
    private boolean killedDupe;
    private final HashMap<String, DirectoryAccess> checkedDirectories = new HashMap();
    private final HashMap<File, DDACheckJob> inTestDirectories = new HashMap();
    public final RequestClient connectionRequestClientBulk = new RequestClient(){

        @Override
        public boolean persistent() {
            return false;
        }

        @Override
        public void removeFrom(ObjectContainer container) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean realTimeFlag() {
            return false;
        }
    };
    public final RequestClient connectionRequestClientRT = new RequestClient(){

        @Override
        public boolean persistent() {
            return false;
        }

        @Override
        public void removeFrom(ObjectContainer container) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean realTimeFlag() {
            return true;
        }
    };

    public FCPConnectionHandler(Socket s, FCPServer server) {
        this.sock = s;
        this.server = server;
        this.isClosed = false;
        this.bf = server.core.tempBucketFactory;
        this.requestsByIdentifier = new HashMap();
        this.uskSubscriptions = new HashMap<String, SubscribeUSK>();
        this.inputHandler = new FCPConnectionInputHandler(this);
        this.outputHandler = new FCPConnectionOutputHandler(this);
        byte[] identifier = new byte[16];
        server.node.random.nextBytes(identifier);
        this.connectionIdentifier = HexUtil.bytesToHex(identifier);
    }

    void start() {
        this.inputHandler.start();
        this.outputHandler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        boolean dupe;
        SubscribeUSK[] uskSubscriptions2;
        ClientRequest[] requests;
        if (this.rebootClient != null) {
            this.rebootClient.onLostConnection(this);
        }
        if (this.foreverClient != null) {
            this.foreverClient.onLostConnection(this);
        }
        FCPConnectionHandler fCPConnectionHandler = this;
        synchronized (fCPConnectionHandler) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            requests = new ClientRequest[this.requestsByIdentifier.size()];
            requests = this.requestsByIdentifier.values().toArray(requests);
            this.requestsByIdentifier.clear();
            uskSubscriptions2 = this.uskSubscriptions.values().toArray(new SubscribeUSK[this.uskSubscriptions.size()]);
            dupe = this.killedDupe;
        }
        for (ClientRequest req : requests) {
            req.onLostConnection(null, this.server.core.clientContext);
        }
        for (SubscribeUSK sub : uskSubscriptions2) {
            sub.unsubscribe();
        }
        if (!dupe) {
            try {
                this.server.core.clientContext.jobRunner.queue(new DBJob(){

                    @Override
                    public boolean run(ObjectContainer container, ClientContext context) {
                        if (FCPConnectionHandler.this.rebootClient != null && !FCPConnectionHandler.this.rebootClient.hasPersistentRequests(null)) {
                            FCPConnectionHandler.this.server.unregisterClient(FCPConnectionHandler.this.rebootClient, null);
                        }
                        if (FCPConnectionHandler.this.foreverClient != null) {
                            if (!container.ext().isStored((Object)FCPConnectionHandler.this.foreverClient)) {
                                Logger.normal(this, "foreverClient is not stored in the database in lost connection non-dupe callback; not deleting it");
                                return false;
                            }
                            container.activate((Object)FCPConnectionHandler.this.foreverClient, 1);
                            if (!FCPConnectionHandler.this.foreverClient.hasPersistentRequests(container)) {
                                FCPConnectionHandler.this.server.unregisterClient(FCPConnectionHandler.this.foreverClient, container);
                            }
                            container.deactivate((Object)FCPConnectionHandler.this.foreverClient, 1);
                        }
                        return false;
                    }
                }, NativeThread.NORM_PRIORITY, false);
            }
            catch (DatabaseDisabledException e) {
                // empty catch block
            }
        }
        this.outputHandler.onClosed();
    }

    synchronized void setKilledDupe() {
        this.killedDupe = true;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closedInput() {
        try {
            this.sock.shutdownInput();
        }
        catch (IOException e) {
            // empty catch block
        }
        FCPConnectionHandler e = this;
        synchronized (e) {
            this.inputClosed = true;
            if (!this.outputClosed) {
                return;
            }
        }
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closedOutput() {
        try {
            this.sock.shutdownOutput();
        }
        catch (IOException e) {
            // empty catch block
        }
        FCPConnectionHandler e = this;
        synchronized (e) {
            this.outputClosed = true;
            if (!this.inputClosed) {
                return;
            }
        }
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setClientName(String name) {
        this.clientName = name;
        this.rebootClient = this.server.registerRebootClient(name, this.server.core, this);
        this.rebootClient.queuePendingMessagesOnConnectionRestartAsync(this.outputHandler, null, this.server.core.clientContext);
        if (logMINOR) {
            Logger.minor(this, "Set client name: " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FCPClient createForeverClient(String name, ObjectContainer container) {
        FCPConnectionHandler fCPConnectionHandler = this;
        synchronized (fCPConnectionHandler) {
            if (this.foreverClient != null) {
                return this.foreverClient;
            }
        }
        FCPClient client = this.server.registerForeverClient(name, this.server.core, this, container);
        FCPConnectionHandler fCPConnectionHandler2 = this;
        synchronized (fCPConnectionHandler2) {
            this.foreverClient = client;
            this.notifyAll();
        }
        client.queuePendingMessagesOnConnectionRestartAsync(this.outputHandler, container, this.server.core.clientContext);
        return this.foreverClient;
    }

    public String getClientName() {
        return this.clientName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startClientGet(final ClientGetMessage message) {
        boolean success;
        final String id = message.identifier;
        final boolean global = message.global;
        ClientGet cg = null;
        boolean persistent = message.persistenceType != 0;
        FCPConnectionHandler fCPConnectionHandler = this;
        synchronized (fCPConnectionHandler) {
            block18: {
                if (this.isClosed) {
                    return;
                }
                if (persistent) {
                    success = true;
                } else {
                    boolean bl = success = !this.requestsByIdentifier.containsKey(id);
                }
                if (success) {
                    try {
                        if (!persistent) {
                            cg = new ClientGet(this, message, this.server, null);
                            this.requestsByIdentifier.put(id, cg);
                            break block18;
                        }
                        if (message.persistenceType == 2) {
                            try {
                                this.server.core.clientContext.jobRunner.queue(new DBJob(){

                                    @Override
                                    public boolean run(ObjectContainer container, ClientContext context) {
                                        ClientGet getter;
                                        try {
                                            getter = new ClientGet(FCPConnectionHandler.this, message, FCPConnectionHandler.this.server, container);
                                        }
                                        catch (IdentifierCollisionException e1) {
                                            Logger.normal(this, "Identifier collision on " + this);
                                            IdentifierCollisionMessage msg = new IdentifierCollisionMessage(id, message.global);
                                            FCPConnectionHandler.this.outputHandler.queue(msg);
                                            return false;
                                        }
                                        catch (MessageInvalidException e1) {
                                            FCPConnectionHandler.this.outputHandler.queue(new ProtocolErrorMessage(e1.protocolCode, false, e1.getMessage(), e1.ident, e1.global));
                                            return false;
                                        }
                                        try {
                                            getter.register(container, false);
                                            container.store((Object)getter);
                                        }
                                        catch (IdentifierCollisionException e) {
                                            Logger.normal(this, "Identifier collision on " + this);
                                            IdentifierCollisionMessage msg = new IdentifierCollisionMessage(id, global);
                                            FCPConnectionHandler.this.outputHandler.queue(msg);
                                            return false;
                                        }
                                        getter.start(container, context);
                                        container.deactivate((Object)getter, 1);
                                        return true;
                                    }
                                }, NativeThread.HIGH_PRIORITY - 1, false);
                            }
                            catch (DatabaseDisabledException e) {
                                this.outputHandler.queue(new ProtocolErrorMessage(33, false, "Persistence is disabled", id, global));
                                return;
                            }
                            return;
                        }
                        cg = new ClientGet(this, message, this.server, null);
                    }
                    catch (IdentifierCollisionException e) {
                        success = false;
                    }
                    catch (MessageInvalidException e) {
                        this.outputHandler.queue(new ProtocolErrorMessage(e.protocolCode, false, e.getMessage(), e.ident, e.global));
                        return;
                    }
                }
            }
        }
        if (message.persistenceType == 1) {
            try {
                cg.register(null, false);
            }
            catch (IdentifierCollisionException e) {
                success = false;
            }
        }
        if (!success) {
            Logger.normal(this, "Identifier collision on " + this);
            IdentifierCollisionMessage msg = new IdentifierCollisionMessage(id, message.global);
            this.outputHandler.queue(msg);
            return;
        }
        cg.start(null, this.server.core.clientContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startClientPut(final ClientPutMessage message) {
        if (logMINOR) {
            Logger.minor(this, "Starting insert ID=\"" + message.identifier + '\"');
        }
        final String id = message.identifier;
        final boolean global = message.global;
        ClientPut cp = null;
        boolean persistent = message.persistenceType != 0;
        FCPMessage failedMessage = null;
        FCPConnectionHandler fCPConnectionHandler = this;
        synchronized (fCPConnectionHandler) {
            boolean success;
            if (this.isClosed) {
                if (logMINOR) {
                    Logger.minor(this, "Connection is closed");
                }
                return;
            }
            if (persistent) {
                success = true;
            } else {
                boolean bl = success = !this.requestsByIdentifier.containsKey(id);
            }
            if (success) {
                if (!persistent) {
                    try {
                        cp = new ClientPut(this, message, this.server, null);
                        this.requestsByIdentifier.put(id, cp);
                    }
                    catch (IdentifierCollisionException e) {
                        success = false;
                    }
                    catch (MessageInvalidException e) {
                        this.outputHandler.queue(new ProtocolErrorMessage(e.protocolCode, false, e.getMessage(), e.ident, e.global));
                        return;
                    }
                    catch (MalformedURLException e) {
                        failedMessage = new ProtocolErrorMessage(4, true, e.getMessage(), id, message.global);
                    }
                } else {
                    if (message.persistenceType == 2) {
                        try {
                            this.server.core.clientContext.jobRunner.queue(new DBJob(){

                                @Override
                                public boolean run(ObjectContainer container, ClientContext context) {
                                    ClientPut putter;
                                    try {
                                        putter = new ClientPut(FCPConnectionHandler.this, message, FCPConnectionHandler.this.server, container);
                                    }
                                    catch (IdentifierCollisionException e) {
                                        Logger.normal(this, "Identifier collision on " + this);
                                        IdentifierCollisionMessage msg = new IdentifierCollisionMessage(id, message.global);
                                        FCPConnectionHandler.this.outputHandler.queue(msg);
                                        return false;
                                    }
                                    catch (MessageInvalidException e) {
                                        FCPConnectionHandler.this.outputHandler.queue(new ProtocolErrorMessage(e.protocolCode, false, e.getMessage(), e.ident, e.global));
                                        return false;
                                    }
                                    catch (MalformedURLException e) {
                                        FCPConnectionHandler.this.outputHandler.queue(new ProtocolErrorMessage(4, true, null, id, message.global));
                                        return false;
                                    }
                                    try {
                                        putter.register(container, false);
                                        container.store((Object)putter);
                                    }
                                    catch (IdentifierCollisionException e) {
                                        Logger.normal(this, "Identifier collision on " + this);
                                        IdentifierCollisionMessage msg = new IdentifierCollisionMessage(id, global);
                                        FCPConnectionHandler.this.outputHandler.queue(msg);
                                        return false;
                                    }
                                    putter.start(container, context);
                                    container.deactivate((Object)putter, 1);
                                    return true;
                                }
                            }, NativeThread.HIGH_PRIORITY - 1, false);
                        }
                        catch (DatabaseDisabledException e) {
                            this.outputHandler.queue(new ProtocolErrorMessage(33, false, "Persistence is disabled", id, global));
                        }
                        return;
                    }
                    try {
                        cp = new ClientPut(this, message, this.server, null);
                    }
                    catch (IdentifierCollisionException e) {
                        success = false;
                    }
                    catch (MessageInvalidException e) {
                        this.outputHandler.queue(new ProtocolErrorMessage(e.protocolCode, false, e.getMessage(), e.ident, e.global));
                        return;
                    }
                    catch (MalformedURLException e) {
                        failedMessage = new ProtocolErrorMessage(4, true, null, id, message.global);
                    }
                }
            }
            if (!success) {
                Logger.normal(this, "Identifier collision on " + this);
                failedMessage = new IdentifierCollisionMessage(id, message.global);
            }
        }
        if (message.persistenceType == 1 && cp != null) {
            try {
                cp.register(null, false);
            }
            catch (IdentifierCollisionException e) {
                failedMessage = new IdentifierCollisionMessage(id, message.global);
            }
        }
        if (failedMessage != null) {
            if (logMINOR) {
                Logger.minor(this, "Failed: " + failedMessage);
            }
            this.outputHandler.queue(failedMessage);
            if (persistent && message.persistenceType == 2) {
                final ClientPut c = cp;
                try {
                    this.server.core.clientContext.jobRunner.queue(new DBJob(){

                        @Override
                        public boolean run(ObjectContainer container, ClientContext context) {
                            if (c != null) {
                                c.freeData(container);
                            } else {
                                message.freeData(container);
                            }
                            return true;
                        }
                    }, NativeThread.HIGH_PRIORITY - 1, false);
                }
                catch (DatabaseDisabledException e) {
                    Logger.error(this, "Unable to free data for insert because database disabled: " + e, (Throwable)e);
                }
            } else if (cp != null) {
                cp.freeData(null);
            } else {
                message.freeData(null);
            }
            return;
        }
        Logger.minor(this, "Starting " + cp);
        cp.start(null, this.server.core.clientContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startClientPutDir(final ClientPutDirMessage message, final HashMap<String, Object> buckets, final boolean wasDiskPut) {
        boolean success;
        if (logMINOR) {
            Logger.minor(this, "Start ClientPutDir");
        }
        final String id = message.identifier;
        final boolean global = message.global;
        ClientPutDir cp = null;
        FCPMessage failedMessage = null;
        boolean persistent = message.persistenceType != 0;
        FCPConnectionHandler fCPConnectionHandler = this;
        synchronized (fCPConnectionHandler) {
            if (this.isClosed) {
                return;
            }
            success = !persistent ? true : !this.requestsByIdentifier.containsKey(id);
        }
        if (success) {
            if (!persistent) {
                try {
                    cp = new ClientPutDir(this, message, buckets, wasDiskPut, this.server, null);
                    fCPConnectionHandler = this;
                    synchronized (fCPConnectionHandler) {
                        this.requestsByIdentifier.put(id, cp);
                    }
                }
                catch (IdentifierCollisionException e) {
                    success = false;
                }
                catch (MalformedURLException e) {
                    failedMessage = new ProtocolErrorMessage(4, true, null, id, message.global);
                }
                catch (TooManyFilesInsertException e) {
                    failedMessage = new ProtocolErrorMessage(34, true, null, id, message.global);
                }
            } else {
                if (message.persistenceType == 2) {
                    try {
                        this.server.core.clientContext.jobRunner.queue(new DBJob(){

                            @Override
                            public boolean run(ObjectContainer container, ClientContext context) {
                                ClientPutDir putter;
                                try {
                                    putter = new ClientPutDir(FCPConnectionHandler.this, message, buckets, wasDiskPut, FCPConnectionHandler.this.server, container);
                                }
                                catch (IdentifierCollisionException e) {
                                    Logger.normal(this, "Identifier collision on " + this);
                                    IdentifierCollisionMessage msg = new IdentifierCollisionMessage(id, message.global);
                                    FCPConnectionHandler.this.outputHandler.queue(msg);
                                    return false;
                                }
                                catch (MalformedURLException e) {
                                    FCPConnectionHandler.this.outputHandler.queue(new ProtocolErrorMessage(4, true, null, id, message.global));
                                    return false;
                                }
                                catch (TooManyFilesInsertException e) {
                                    FCPConnectionHandler.this.outputHandler.queue(new ProtocolErrorMessage(34, true, null, id, message.global));
                                    return false;
                                }
                                try {
                                    putter.register(container, false);
                                    container.store((Object)putter);
                                }
                                catch (IdentifierCollisionException e) {
                                    Logger.normal(this, "Identifier collision on " + this);
                                    IdentifierCollisionMessage msg = new IdentifierCollisionMessage(id, global);
                                    FCPConnectionHandler.this.outputHandler.queue(msg);
                                    return false;
                                }
                                putter.start(container, context);
                                container.deactivate((Object)putter, 1);
                                return true;
                            }
                        }, NativeThread.HIGH_PRIORITY - 1, false);
                    }
                    catch (DatabaseDisabledException e) {
                        this.outputHandler.queue(new ProtocolErrorMessage(33, false, "Persistence is disabled", id, global));
                    }
                    return;
                }
                try {
                    cp = new ClientPutDir(this, message, buckets, wasDiskPut, this.server, null);
                }
                catch (IdentifierCollisionException e) {
                    success = false;
                }
                catch (MalformedURLException e) {
                    failedMessage = new ProtocolErrorMessage(4, true, null, id, message.global);
                }
                catch (TooManyFilesInsertException e) {
                    failedMessage = new ProtocolErrorMessage(34, true, null, id, message.global);
                }
            }
            if (!success) {
                Logger.normal(this, "Identifier collision on " + this);
                failedMessage = new IdentifierCollisionMessage(id, message.global);
            }
        }
        if (message.persistenceType == 1) {
            try {
                cp.register(null, false);
            }
            catch (IdentifierCollisionException e) {
                failedMessage = new IdentifierCollisionMessage(id, message.global);
            }
        }
        if (failedMessage != null) {
            this.outputHandler.queue(failedMessage);
            if (cp != null) {
                cp.cancel(null, this.server.core.clientContext);
            }
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Starting " + cp);
        }
        cp.start(null, this.server.core.clientContext);
    }

    public FCPClient getRebootClient() {
        return this.rebootClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FCPClient getForeverClient(ObjectContainer container) {
        FCPConnectionHandler fCPConnectionHandler = this;
        synchronized (fCPConnectionHandler) {
            if (this.foreverClient == null) {
                this.foreverClient = this.createForeverClient(this.clientName, container);
            }
            container.activate((Object)this.foreverClient, 1);
            this.foreverClient.init(container);
            return this.foreverClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishedClientRequest(ClientRequest get) {
        FCPConnectionHandler fCPConnectionHandler = this;
        synchronized (fCPConnectionHandler) {
            this.requestsByIdentifier.remove(get.getIdentifier());
        }
    }

    public boolean isGlobalSubscribed() {
        return this.rebootClient.watchGlobal;
    }

    public boolean hasFullAccess() {
        return this.server.allowedHostsFullAccess.allowed(this.sock.getInetAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean allowDDAFrom(File filename, boolean writeRequest) {
        String parentDirectory = FileUtil.getCanonicalFile(filename).getParent();
        DirectoryAccess da = null;
        HashMap<String, DirectoryAccess> hashMap = this.checkedDirectories;
        synchronized (hashMap) {
            da = this.checkedDirectories.get(parentDirectory);
        }
        if (logMINOR) {
            Logger.minor(this, "Checking DDA: " + da + " for " + parentDirectory);
        }
        if (writeRequest) {
            return da == null ? this.server.isDownloadDDAAlwaysAllowed() : da.canWrite;
        }
        return da == null ? this.server.isUploadDDAAlwaysAllowed() : da.canRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerTestDDAResult(String path, boolean read, boolean write) {
        DirectoryAccess da = new DirectoryAccess(read, write);
        HashMap<String, DirectoryAccess> hashMap = this.checkedDirectories;
        synchronized (hashMap) {
            this.checkedDirectories.put(path, da);
        }
        if (logMINOR) {
            Logger.minor(this, "DDA: read=" + read + " write=" + write + " for " + path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DDACheckJob enqueueDDACheck(String path, boolean read, boolean write) throws IllegalArgumentException {
        File directory = FileUtil.getCanonicalFile(new File(path));
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException("The specified path isn't a directory! or doesn't exist or the node doesn't have access to it!");
        }
        DDACheckJob job = null;
        HashMap<File, DDACheckJob> hashMap = this.inTestDirectories;
        synchronized (hashMap) {
            job = this.inTestDirectories.get(directory);
        }
        if (job != null) {
            throw new IllegalArgumentException("There is already a TestDDA going on for that directory!");
        }
        File writeFile = write ? new File(path, "DDACheck-" + this.server.node.fastWeakRandom.nextInt() + ".tmp") : null;
        File readFile = null;
        if (read) {
            try {
                readFile = File.createTempFile("DDACheck-", ".tmp", directory);
                readFile.deleteOnExit();
            }
            catch (IOException e) {
                readFile = null;
            }
        }
        DDACheckJob result = new DDACheckJob(this.server.node.fastWeakRandom, directory, readFile, writeFile);
        HashMap<File, DDACheckJob> hashMap2 = this.inTestDirectories;
        synchronized (hashMap2) {
            this.inTestDirectories.put(directory, result);
        }
        if (read && readFile != null && readFile.canWrite()) {
            FileOutputStream fos = null;
            BufferedOutputStream bos = null;
            try {
                fos = new FileOutputStream(result.readFilename);
                bos = new BufferedOutputStream(fos);
                bos.write(result.readContent.getBytes("UTF-8"));
                bos.flush();
            }
            catch (IOException e) {
                try {
                    Logger.error(this, "Got a IOE while creating the file (" + readFile.toString() + " ! " + e.getMessage());
                }
                catch (Throwable throwable) {
                    Closer.close(bos);
                    Closer.close(fos);
                    throw throwable;
                }
                Closer.close(bos);
                Closer.close(fos);
            }
            Closer.close(bos);
            Closer.close(fos);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DDACheckJob popDDACheck(String path) throws IllegalArgumentException {
        File directory = FileUtil.getCanonicalFile(new File(path));
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException("The specified path isn't a directory! or doesn't exist or the node doesn't have access to it!");
        }
        HashMap<File, DDACheckJob> hashMap = this.inTestDirectories;
        synchronized (hashMap) {
            return this.inTestDirectories.remove(directory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeDDAJobs() {
        HashMap<File, DDACheckJob> hashMap = this.inTestDirectories;
        synchronized (hashMap) {
            for (DDACheckJob job : this.inTestDirectories.values()) {
                if (job.readFilename == null) continue;
                job.readFilename.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientRequest removeRequestByIdentifier(String identifier, boolean kill) {
        ClientRequest req;
        FCPConnectionHandler fCPConnectionHandler = this;
        synchronized (fCPConnectionHandler) {
            req = this.requestsByIdentifier.remove(identifier);
        }
        if (req != null) {
            if (kill) {
                req.cancel(null, this.server.core.clientContext);
            }
            req.requestWasRemoved(null, this.server.core.clientContext);
        }
        return req;
    }

    ClientRequest getRebootRequest(boolean global, FCPConnectionHandler handler, String identifier) {
        if (global) {
            return handler.server.globalRebootClient.getRequest(identifier, null);
        }
        return handler.getRebootClient().getRequest(identifier, null);
    }

    ClientRequest getForeverRequest(boolean global, FCPConnectionHandler handler, String identifier, ObjectContainer container) {
        if (global) {
            return handler.server.globalForeverClient.getRequest(identifier, container);
        }
        return handler.getForeverClient(container).getRequest(identifier, container);
    }

    ClientRequest removePersistentRebootRequest(boolean global, String identifier) throws MessageInvalidException {
        FCPClient client = global ? this.server.globalRebootClient : this.getRebootClient();
        ClientRequest req = client.getRequest(identifier, null);
        if (req != null) {
            client.removeByIdentifier(identifier, true, this.server, null, this.server.core.clientContext);
        }
        return req;
    }

    ClientRequest removePersistentForeverRequest(boolean global, String identifier, ObjectContainer container) throws MessageInvalidException {
        FCPClient client = global ? this.server.globalForeverClient : this.getForeverClient(container);
        container.activate((Object)client, 1);
        ClientRequest req = client.getRequest(identifier, container);
        if (req != null) {
            client.removeByIdentifier(identifier, true, this.server, container, this.server.core.clientContext);
        }
        if (!global) {
            container.deactivate((Object)client, 1);
        }
        return req;
    }

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Not storing FCPConnectionHandler in database", (Throwable)new Exception("error"));
        return false;
    }

    public synchronized void addUSKSubscription(String identifier, SubscribeUSK subscribeUSK) throws IdentifierCollisionException {
        if (this.uskSubscriptions.containsKey(identifier)) {
            throw new IdentifierCollisionException();
        }
        this.uskSubscriptions.put(identifier, subscribeUSK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeUSK(String identifier) throws MessageInvalidException {
        SubscribeUSK sub;
        FCPConnectionHandler fCPConnectionHandler = this;
        synchronized (fCPConnectionHandler) {
            sub = this.uskSubscriptions.remove(identifier);
            if (sub == null) {
                throw new MessageInvalidException(15, "No such identifier unsubscribing", identifier, false);
            }
        }
        sub.unsubscribe();
    }

    public RequestClient connectionRequestClient(boolean realTime) {
        if (realTime) {
            return this.connectionRequestClientRT;
        }
        return this.connectionRequestClientBulk;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    public static class DDACheckJob {
        final File directory;
        final File readFilename;
        final File writeFilename;
        final String readContent;
        final String writeContent;

        DDACheckJob(Random r, File directory, File readFilename, File writeFilename) {
            this.directory = directory;
            this.readFilename = readFilename;
            this.writeFilename = writeFilename;
            byte[] random = new byte[128];
            r.nextBytes(random);
            this.readContent = HexUtil.bytesToHex(random);
            r.nextBytes(random);
            this.writeContent = HexUtil.bytesToHex(random);
        }
    }

    private static final class DirectoryAccess {
        final boolean canWrite;
        final boolean canRead;

        public DirectoryAccess(boolean canRead, boolean canWrite) {
            this.canRead = canRead;
            this.canWrite = canWrite;
        }
    }
}

