/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.ClientMetadata;
import freenet.client.DefaultMIMETypes;
import freenet.client.FetchContext;
import freenet.client.FetchResult;
import freenet.client.HighLevelSimpleClient;
import freenet.client.InsertContext;
import freenet.client.async.CacheFetchResult;
import freenet.client.async.ClientContext;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.DownloadCache;
import freenet.config.Config;
import freenet.config.InvalidConfigValueException;
import freenet.config.SubConfig;
import freenet.crypt.SSL;
import freenet.io.AllowedHosts;
import freenet.io.NetworkInterface;
import freenet.io.SSLNetworkInterface;
import freenet.keys.FreenetURI;
import freenet.l10n.NodeL10n;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.fcp.ClientGet;
import freenet.node.fcp.ClientGetMessage;
import freenet.node.fcp.ClientRequest;
import freenet.node.fcp.CloseConnectionDuplicateClientNameMessage;
import freenet.node.fcp.FCPClient;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPPersistentRoot;
import freenet.node.fcp.IdentifierCollisionException;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.NotAllowedException;
import freenet.node.fcp.RequestCompletionCallback;
import freenet.node.fcp.RequestStatus;
import freenet.node.fcp.RequestStatusCache;
import freenet.support.Base64;
import freenet.support.Logger;
import freenet.support.OOMHandler;
import freenet.support.api.BooleanCallback;
import freenet.support.api.Bucket;
import freenet.support.api.IntCallback;
import freenet.support.api.StringCallback;
import freenet.support.io.BucketTools;
import freenet.support.io.NativeThread;
import freenet.support.io.NoFreeBucket;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.tanukisoftware.wrapper.WrapperManager;

public class FCPServer
implements Runnable,
DownloadCache {
    FCPPersistentRoot persistentRoot;
    private static boolean logMINOR;
    public static final int DEFAULT_FCP_PORT = 9481;
    NetworkInterface networkInterface;
    final NodeClientCore core;
    final Node node;
    final int port;
    private static boolean ssl;
    public final boolean enabled;
    String bindTo;
    private String allowedHosts;
    AllowedHosts allowedHostsFullAccess;
    final WeakHashMap<String, FCPClient> rebootClientsByName;
    final FCPClient globalRebootClient;
    FCPClient globalForeverClient;
    final FetchContext defaultFetchContext;
    public InsertContext defaultInsertContext;
    public static final int QUEUE_MAX_RETRIES = -1;
    public static final long QUEUE_MAX_DATA_SIZE = Long.MAX_VALUE;
    private boolean assumeDownloadDDAIsAllowed;
    private boolean assumeUploadDDAIsAllowed;
    private boolean neverDropAMessage;
    private int maxMessageQueueLength;

    public FCPServer(String ipToBindTo, String allowedHosts, String allowedHostsFullAccess, int port, Node node, NodeClientCore core, boolean isEnabled, boolean assumeDDADownloadAllowed, boolean assumeDDAUploadAllowed, boolean neverDropAMessage, int maxMessageQueueLength, ObjectContainer container) throws IOException, InvalidConfigValueException {
        this.bindTo = ipToBindTo;
        this.allowedHosts = allowedHosts;
        this.allowedHostsFullAccess = new AllowedHosts(allowedHostsFullAccess);
        this.port = port;
        this.enabled = isEnabled;
        this.node = node;
        this.core = core;
        this.assumeDownloadDDAIsAllowed = assumeDDADownloadAllowed;
        this.assumeUploadDDAIsAllowed = assumeDDAUploadAllowed;
        this.neverDropAMessage = neverDropAMessage;
        this.maxMessageQueueLength = maxMessageQueueLength;
        this.rebootClientsByName = new WeakHashMap();
        HighLevelSimpleClient client = core.makeClient((short)0, false, false);
        this.defaultFetchContext = client.getFetchContext();
        this.defaultInsertContext = client.getInsertContext(false);
        this.globalRebootClient = new FCPClient("Global Queue", null, true, null, 1, null, null);
        this.globalRebootClient.setRequestStatusCache(new RequestStatusCache(), null);
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
    }

    public void load(ObjectContainer container) {
        this.persistentRoot = FCPPersistentRoot.create(this.node.nodeDBHandle, new RequestStatusCache(), container);
        this.globalForeverClient = this.persistentRoot.globalForeverClient;
    }

    private void maybeGetNetworkInterface() {
        if (this.networkInterface != null) {
            return;
        }
        NetworkInterface tempNetworkInterface = null;
        try {
            tempNetworkInterface = ssl ? SSLNetworkInterface.create(this.port, this.bindTo, this.allowedHosts, this.node.executor, true) : NetworkInterface.create(this.port, this.bindTo, this.allowedHosts, this.node.executor, true);
        }
        catch (IOException be) {
            Logger.error(this, "Couldn't bind to FCP Port " + this.bindTo + ':' + this.port + ". FCP Server not started.", (Throwable)be);
            System.out.println("Couldn't bind to FCP Port " + this.bindTo + ':' + this.port + ". FCP Server not started.");
        }
        this.networkInterface = tempNetworkInterface;
    }

    public void maybeStart() {
        if (this.enabled) {
            this.maybeGetNetworkInterface();
            Logger.normal(this, "Starting FCP server on " + this.bindTo + ':' + this.port + '.');
            System.out.println("Starting FCP server on " + this.bindTo + ':' + this.port + '.');
            if (this.networkInterface != null) {
                Thread t = new Thread((Runnable)this, "FCP server");
                t.setDaemon(true);
                t.start();
            }
        } else {
            Logger.normal(this, "Not starting FCP server as it's disabled");
            System.out.println("Not starting FCP server as it's disabled");
            this.networkInterface = null;
        }
    }

    @Override
    public void run() {
        Logger.OSThread.logPID(this);
        while (true) {
            try {
                this.networkInterface.waitBound();
                this.realRun();
            }
            catch (IOException e) {
                if (logMINOR) {
                    Logger.minor(this, "Caught " + e, (Throwable)e);
                }
            }
            catch (OutOfMemoryError e) {
                OOMHandler.handleOOM(e);
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t, t);
            }
            if (WrapperManager.hasShutdownHookBeenTriggered()) {
                return;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void realRun() throws IOException {
        if (!this.node.isHasStarted()) {
            return;
        }
        Socket s = this.networkInterface.accept();
        FCPConnectionHandler ch = new FCPConnectionHandler(s, this);
        ch.start();
    }

    public static FCPServer maybeCreate(Node node, NodeClientCore core, Config config, ObjectContainer container) throws IOException, InvalidConfigValueException {
        FCPServer fcp;
        int sortOrder;
        SubConfig fcpConfig = new SubConfig("fcp", config);
        int n = sortOrder = 0;
        sortOrder = (short)(sortOrder + 1);
        fcpConfig.register("enabled", true, n, true, false, "FcpServer.isEnabled", "FcpServer.isEnabledLong", new FCPEnabledCallback(core));
        int n2 = sortOrder;
        sortOrder = (short)(sortOrder + 1);
        fcpConfig.register("ssl", false, n2, true, true, "FcpServer.ssl", "FcpServer.sslLong", new FCPSSLCallback());
        fcpConfig.register("port", 9481, 2, true, true, "FcpServer.portNumber", "FcpServer.portNumberLong", (IntCallback)new FCPPortNumberCallback(core), false);
        int n3 = sortOrder;
        sortOrder = (short)(sortOrder + 1);
        fcpConfig.register("bindTo", "127.0.0.1,0:0:0:0:0:0:0:1", n3, true, true, "FcpServer.bindTo", "FcpServer.bindToLong", new FCPBindtoCallback(core));
        int n4 = sortOrder;
        sortOrder = (short)(sortOrder + 1);
        fcpConfig.register("allowedHosts", "127.0.0.1,0:0:0:0:0:0:0:1", n4, true, true, "FcpServer.allowedHosts", "FcpServer.allowedHostsLong", new FCPAllowedHostsCallback(core));
        int n5 = sortOrder;
        sortOrder = (short)(sortOrder + 1);
        fcpConfig.register("allowedHostsFullAccess", "127.0.0.1,0:0:0:0:0:0:0:1", n5, true, true, "FcpServer.allowedHostsFullAccess", "FcpServer.allowedHostsFullAccessLong", new FCPAllowedHostsFullAccessCallback(core));
        int n6 = sortOrder;
        sortOrder = (short)(sortOrder + 1);
        AssumeDDADownloadIsAllowedCallback cb4 = new AssumeDDADownloadIsAllowedCallback();
        fcpConfig.register("assumeDownloadDDAIsAllowed", false, n6, true, false, "FcpServer.assumeDownloadDDAIsAllowed", "FcpServer.assumeDownloadDDAIsAllowedLong", cb4);
        int n7 = sortOrder;
        sortOrder = (short)(sortOrder + 1);
        AssumeDDAUploadIsAllowedCallback cb5 = new AssumeDDAUploadIsAllowedCallback();
        fcpConfig.register("assumeUploadDDAIsAllowed", false, n7, true, false, "FcpServer.assumeUploadDDAIsAllowed", "FcpServer.assumeUploadDDAIsAllowedLong", cb5);
        int n8 = sortOrder;
        sortOrder = (short)(sortOrder + 1);
        MaxMessageQueueLengthCallback cb7 = new MaxMessageQueueLengthCallback();
        fcpConfig.register("maxMessageQueueLength", 1024, n8, true, false, "FcpServer.maxMessageQueueLength", "FcpServer.maxMessageQueueLengthLong", (IntCallback)cb7, false);
        int n9 = sortOrder;
        sortOrder = (short)(sortOrder + 1);
        NeverDropAMessageCallback cb6 = new NeverDropAMessageCallback();
        fcpConfig.register("neverDropAMessage", false, n9, true, false, "FcpServer.neverDropAMessage", "FcpServer.neverDropAMessageLong", cb6);
        if (SSL.available()) {
            ssl = fcpConfig.getBoolean("ssl");
        }
        if ((fcp = new FCPServer(fcpConfig.getString("bindTo"), fcpConfig.getString("allowedHosts"), fcpConfig.getString("allowedHostsFullAccess"), fcpConfig.getInt("port"), node, core, fcpConfig.getBoolean("enabled"), fcpConfig.getBoolean("assumeDownloadDDAIsAllowed"), fcpConfig.getBoolean("assumeUploadDDAIsAllowed"), fcpConfig.getBoolean("neverDropAMessage"), fcpConfig.getInt("maxMessageQueueLength"), container)) != null) {
            cb4.server = fcp;
            cb5.server = fcp;
            cb6.server = fcp;
            cb7.server = fcp;
        }
        fcpConfig.finishedInitialization();
        return fcp;
    }

    public boolean neverDropAMessage() {
        return this.neverDropAMessage;
    }

    public int maxMessageQueueLength() {
        return this.maxMessageQueueLength;
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("FcpServer." + key);
    }

    private static String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("FcpServer." + key, pattern, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FCPClient registerRebootClient(String name, NodeClientCore core, FCPConnectionHandler handler) {
        FCPServer fCPServer = this;
        synchronized (fCPServer) {
            FCPClient oldClient = this.rebootClientsByName.get(name);
            if (oldClient == null) {
                FCPClient client = new FCPClient(name, handler, false, null, 1, null, null);
                this.rebootClientsByName.put(name, client);
                return client;
            }
            FCPConnectionHandler oldConn = oldClient.getConnection();
            if (oldConn == null) {
                oldClient.setConnection(handler);
                return oldClient;
            }
            oldConn.setKilledDupe();
            oldConn.outputHandler.queue(new CloseConnectionDuplicateClientNameMessage());
            oldConn.close();
            oldClient.setConnection(handler);
            return oldClient;
        }
    }

    public FCPClient registerForeverClient(String name, NodeClientCore core, FCPConnectionHandler handler, ObjectContainer container) {
        return this.persistentRoot.registerForeverClient(name, core, handler, this, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterClient(FCPClient client, ObjectContainer container) {
        if (client.persistenceType == 1) {
            assert (container == null);
            FCPServer fCPServer = this;
            synchronized (fCPServer) {
                String name = client.name;
                this.rebootClientsByName.remove(name);
            }
        } else {
            this.persistentRoot.maybeUnregisterClient(client, container);
        }
    }

    public RequestStatus[] getGlobalRequests() throws DatabaseDisabledException {
        if (this.core.killedDatabase()) {
            throw new DatabaseDisabledException();
        }
        ArrayList<RequestStatus> v = new ArrayList<RequestStatus>();
        this.globalRebootClient.addPersistentRequestStatus(v);
        if (this.globalForeverClient != null) {
            this.globalForeverClient.addPersistentRequestStatus(v);
        }
        return v.toArray(new RequestStatus[v.size()]);
    }

    public boolean removeGlobalRequestBlocking(final String identifier) throws MessageInvalidException, DatabaseDisabledException {
        if (!this.globalRebootClient.removeByIdentifier(identifier, true, this, null, this.core.clientContext)) {
            final CountDownLatch done = new CountDownLatch(1);
            final AtomicBoolean success = new AtomicBoolean();
            this.core.clientContext.jobRunner.queue(new DBJob(){

                public String toString() {
                    return "FCP removeGlobalRequestBlocking";
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean run(ObjectContainer container, ClientContext context) {
                    boolean succeeded = false;
                    try {
                        succeeded = FCPServer.this.globalForeverClient.removeByIdentifier(identifier, true, FCPServer.this, container, FCPServer.this.core.clientContext);
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Caught removing identifier " + identifier + ": " + t, t);
                    }
                    finally {
                        success.set(succeeded);
                        done.countDown();
                    }
                    return true;
                }
            }, NativeThread.HIGH_PRIORITY, false);
            while (done.getCount() > 0L) {
                try {
                    done.await();
                }
                catch (InterruptedException e) {}
            }
            return success.get();
        }
        return true;
    }

    public boolean removeAllGlobalRequestsBlocking() throws DatabaseDisabledException {
        this.globalRebootClient.removeAll(null, this.core.clientContext);
        final CountDownLatch done = new CountDownLatch(1);
        final AtomicBoolean success = new AtomicBoolean();
        this.core.clientContext.jobRunner.queue(new DBJob(){

            public String toString() {
                return "FCP removeAllGlobalRequestsBlocking";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(ObjectContainer container, ClientContext context) {
                boolean succeeded = false;
                try {
                    FCPServer.this.globalForeverClient.removeAll(container, FCPServer.this.core.clientContext);
                    succeeded = true;
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught while processing panic: " + t, t);
                    System.err.println("PANIC INCOMPLETE: CAUGHT " + t);
                    t.printStackTrace();
                    System.err.println("Your requests have not been deleted!");
                }
                finally {
                    success.set(succeeded);
                    done.countDown();
                }
                return true;
            }
        }, NativeThread.HIGH_PRIORITY, false);
        while (done.getCount() > 0L) {
            try {
                done.await();
            }
            catch (InterruptedException interruptedException) {}
        }
        return success.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePersistentGlobalRequestBlocking(final FreenetURI fetchURI, final boolean filterData, final String expectedMimeType, final String persistenceTypeString, final String returnTypeString, final boolean realTimeFlag, final File downloadsDir) throws NotAllowedException, IOException, DatabaseDisabledException {
        class OutputWrapper {
            NotAllowedException ne;
            IOException ioe;
            boolean done;

            OutputWrapper() {
            }
        }
        final OutputWrapper ow = new OutputWrapper();
        this.core.clientContext.jobRunner.queue(new DBJob(){
            {
            }

            public String toString() {
                return "FCP makePersistentGlobalRequestBlocking";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(ObjectContainer container, ClientContext context) {
                NotAllowedException ne = null;
                IOException ioe = null;
                try {
                    FCPServer.this.makePersistentGlobalRequest(fetchURI, filterData, expectedMimeType, persistenceTypeString, returnTypeString, realTimeFlag, container, downloadsDir);
                    boolean bl = true;
                    return bl;
                }
                catch (NotAllowedException e) {
                    ne = e;
                    boolean bl = false;
                    return bl;
                }
                catch (IOException e) {
                    ioe = e;
                    boolean bl = false;
                    return bl;
                }
                catch (Throwable t) {
                    Logger.error(this, "Failed to make persistent request: " + t, t);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    OutputWrapper outputWrapper = ow;
                    synchronized (outputWrapper) {
                        ow.ne = ne;
                        ow.ioe = ioe;
                        ow.done = true;
                        ow.notifyAll();
                    }
                }
            }
        }, NativeThread.HIGH_PRIORITY, false);
        OutputWrapper outputWrapper = ow;
        synchronized (outputWrapper) {
            while (!ow.done) {
                try {
                    ow.wait();
                }
                catch (InterruptedException e) {}
            }
            if (ow.ioe != null) {
                throw ow.ioe;
            }
            if (ow.ne != null) {
                throw ow.ne;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modifyGlobalRequestBlocking(final String identifier, final String newToken, final short newPriority) throws DatabaseDisabledException {
        ClientRequest req = this.globalRebootClient.getRequest(identifier, null);
        if (req != null) {
            req.modifyRequest(newToken, newPriority, this, null);
            return true;
        }
        class OutputWrapper {
            boolean success;
            boolean done;

            OutputWrapper() {
            }
        }
        final OutputWrapper ow = new OutputWrapper();
        this.core.clientContext.jobRunner.queue(new DBJob(){
            {
            }

            public String toString() {
                return "FCP modifyGlobalRequestBlocking";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(ObjectContainer container, ClientContext context) {
                boolean success = false;
                try {
                    ClientRequest req = FCPServer.this.globalForeverClient.getRequest(identifier, container);
                    container.activate((Object)req, 1);
                    if (req != null) {
                        req.modifyRequest(newToken, newPriority, FCPServer.this, container);
                    }
                    container.deactivate((Object)req, 1);
                    success = true;
                }
                finally {
                    OutputWrapper outputWrapper = ow;
                    synchronized (outputWrapper) {
                        ow.success = success;
                        ow.done = true;
                        ow.notifyAll();
                    }
                }
                return true;
            }
        }, NativeThread.HIGH_PRIORITY, false);
        OutputWrapper outputWrapper = ow;
        synchronized (outputWrapper) {
            while (!ow.done) {
                try {
                    ow.wait();
                }
                catch (InterruptedException e) {}
            }
            return ow.success;
        }
    }

    public void makePersistentGlobalRequest(FreenetURI fetchURI, boolean filterData, String expectedMimeType, String persistenceTypeString, String returnTypeString, boolean realTimeFlag, ObjectContainer container) throws NotAllowedException, IOException {
        this.makePersistentGlobalRequest(fetchURI, filterData, expectedMimeType, persistenceTypeString, returnTypeString, realTimeFlag, container, this.core.getDownloadsDir());
    }

    public void makePersistentGlobalRequest(FreenetURI fetchURI, boolean filterData, String expectedMimeType, String persistenceTypeString, String returnTypeString, boolean realTimeFlag, ObjectContainer container, File downloadsDir) throws NotAllowedException, IOException {
        boolean persistence = persistenceTypeString.equalsIgnoreCase("reboot");
        short returnType = ClientGetMessage.parseReturnType(returnTypeString);
        File returnFilename = null;
        File returnTempFilename = null;
        if (returnType == 2) {
            returnFilename = this.makeReturnFilename(fetchURI, expectedMimeType, downloadsDir);
            returnTempFilename = this.makeTempReturnFilename(returnFilename);
        }
        try {
            this.innerMakePersistentGlobalRequest(fetchURI, filterData, persistence, returnType, "FProxy:" + fetchURI.getPreferredFilename(), returnFilename, returnTempFilename, realTimeFlag, container);
            return;
        }
        catch (IdentifierCollisionException ee) {
            try {
                this.innerMakePersistentGlobalRequest(fetchURI, filterData, persistence, returnType, "FProxy:" + fetchURI.getDocName(), returnFilename, returnTempFilename, realTimeFlag, container);
                return;
            }
            catch (IdentifierCollisionException e) {
                try {
                    this.innerMakePersistentGlobalRequest(fetchURI, filterData, persistence, returnType, "FProxy:" + fetchURI.toString(false, false), returnFilename, returnTempFilename, realTimeFlag, container);
                    return;
                }
                catch (IdentifierCollisionException e1) {
                    try {
                        this.innerMakePersistentGlobalRequest(fetchURI, filterData, persistence, returnType, "FProxy (" + System.currentTimeMillis() + ')', returnFilename, returnTempFilename, realTimeFlag, container);
                        return;
                    }
                    catch (IdentifierCollisionException e2) {
                        while (true) {
                            byte[] buf = new byte[8];
                            try {
                                this.core.random.nextBytes(buf);
                                String id = "FProxy:" + Base64.encode(buf);
                                this.innerMakePersistentGlobalRequest(fetchURI, filterData, persistence, returnType, id, returnFilename, returnTempFilename, realTimeFlag, container);
                                return;
                            }
                            catch (IdentifierCollisionException e3) {
                                continue;
                            }
                            break;
                        }
                    }
                }
            }
        }
    }

    private File makeTempReturnFilename(File returnFilename) {
        return new File(returnFilename.toString() + ".freenet-tmp");
    }

    private File makeReturnFilename(FreenetURI uri, String expectedMimeType, File downloadsDir) {
        String preferred;
        String ext = expectedMimeType != null && expectedMimeType.length() > 0 && !expectedMimeType.equals("application/octet-stream") ? DefaultMIMETypes.getExtension(expectedMimeType) : null;
        String extAdd = ext == null ? "" : '.' + ext;
        String preferredWithExt = preferred = uri.getPreferredFilename();
        if (ext == null || !preferredWithExt.endsWith(ext)) {
            preferredWithExt = preferredWithExt + extAdd;
        }
        File f = new File(downloadsDir, preferredWithExt);
        File f1 = new File(downloadsDir, preferredWithExt + ".freenet-tmp");
        int x = 0;
        StringBuilder sb = new StringBuilder();
        while (f.exists() || f1.exists()) {
            sb.append(preferred);
            sb.append('-');
            sb.append(x);
            sb.append(extAdd);
            f = new File(downloadsDir, sb.toString());
            f1 = new File(downloadsDir, sb.append(".freenet-tmp").toString());
            ++x;
            sb.setLength(0);
        }
        return f;
    }

    private void innerMakePersistentGlobalRequest(FreenetURI fetchURI, boolean filterData, boolean persistRebootOnly, short returnType, String id, File returnFilename, File returnTempFilename, boolean realTimeFlag, ObjectContainer container) throws IdentifierCollisionException, NotAllowedException, IOException {
        ClientGet cg = new ClientGet(persistRebootOnly ? this.globalRebootClient : this.globalForeverClient, fetchURI, this.defaultFetchContext.localRequestOnly, this.defaultFetchContext.ignoreStore, filterData, -1, -1, Long.MAX_VALUE, returnType, persistRebootOnly, id, Integer.MAX_VALUE, 4, returnFilename, returnTempFilename, null, false, realTimeFlag, this, container);
        cg.register(container, false);
        cg.start(container, this.core.clientContext);
    }

    public FCPClient getGlobalForeverClient() {
        return this.globalForeverClient;
    }

    public ClientRequest getGlobalRequest(String identifier, ObjectContainer container) {
        ClientRequest req = this.globalRebootClient.getRequest(identifier, null);
        if (req == null) {
            req = this.globalForeverClient.getRequest(identifier, container);
        }
        return req;
    }

    protected boolean isDownloadDDAAlwaysAllowed() {
        return this.assumeDownloadDDAIsAllowed;
    }

    protected boolean isUploadDDAAlwaysAllowed() {
        return this.assumeUploadDDAIsAllowed;
    }

    public void setCompletionCallback(RequestCompletionCallback cb) {
        if (this.globalForeverClient != null) {
            this.globalForeverClient.addRequestCompletionCallback(cb);
        }
        this.globalRebootClient.addRequestCompletionCallback(cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBlocking(final ClientRequest req, ObjectContainer container, ClientContext context) throws IdentifierCollisionException, DatabaseDisabledException {
        if (req.persistenceType == 1) {
            req.start(null, this.core.clientContext);
        } else if (container != null) {
            req.register(container, false);
            req.start(container, context);
            container.deactivate((Object)req, 1);
        } else {
            class OutputWrapper {
                boolean done;
                IdentifierCollisionException collided;

                OutputWrapper() {
                }
            }
            final OutputWrapper ow = new OutputWrapper();
            this.core.clientContext.jobRunner.queue(new DBJob(){
                {
                }

                public String toString() {
                    return "FCP startBlocking";
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean run(ObjectContainer container, ClientContext context) {
                    try {
                        req.register(container, false);
                        req.start(container, context);
                    }
                    catch (IdentifierCollisionException e) {
                        ow.collided = e;
                    }
                    finally {
                        OutputWrapper outputWrapper = ow;
                        synchronized (outputWrapper) {
                            ow.done = true;
                            ow.notifyAll();
                        }
                    }
                    container.deactivate((Object)req, 1);
                    return true;
                }
            }, NativeThread.HIGH_PRIORITY, false);
            OutputWrapper outputWrapper = ow;
            synchronized (outputWrapper) {
                while (!ow.done) {
                    try {
                        ow.wait();
                    }
                    catch (InterruptedException e) {}
                }
                if (ow.collided != null) {
                    throw ow.collided;
                }
                return;
            }
        }
    }

    public boolean restartBlocking(final String identifier, final boolean disableFilterData) throws DatabaseDisabledException {
        ClientRequest req = this.globalRebootClient.getRequest(identifier, null);
        if (req != null) {
            req.restart(null, this.core.clientContext, disableFilterData);
            return true;
        }
        class OutputWrapper {
            boolean done;
            boolean success;

            OutputWrapper() {
            }
        }
        final OutputWrapper ow = new OutputWrapper();
        this.core.clientContext.jobRunner.queue(new DBJob(){
            {
            }

            public String toString() {
                return "FCP restartBlocking";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(ObjectContainer container, ClientContext context) {
                boolean success = false;
                try {
                    ClientRequest req = FCPServer.this.globalForeverClient.getRequest(identifier, container);
                    if (req != null) {
                        req.restart(container, context, disableFilterData);
                        success = true;
                    }
                }
                catch (DatabaseDisabledException e) {
                    success = false;
                }
                finally {
                    OutputWrapper outputWrapper = ow;
                    synchronized (outputWrapper) {
                        ow.success = success;
                        ow.done = true;
                        ow.notifyAll();
                    }
                }
                return true;
            }
        }, NativeThread.HIGH_PRIORITY, false);
        OutputWrapper outputWrapper = ow;
        synchronized (outputWrapper) {
            while (true) {
                if (ow.done) {
                    return ow.success;
                }
                try {
                    ow.wait();
                }
                catch (InterruptedException e) {}
            }
        }
    }

    public FetchResult getCompletedRequestBlocking(final FreenetURI key) throws DatabaseDisabledException {
        ClientGet get = this.globalRebootClient.getCompletedRequest(key, null);
        if (get != null) {
            return new FetchResult(new ClientMetadata(get.getMIMEType(null)), (Bucket)new NoFreeBucket(get.getBucket(null)));
        }
        CacheFetchResult result = this.globalForeverClient.getRequestStatusCache().getShadowBucket(key, false);
        if (result != null) {
            return result;
        }
        class OutputWrapper {
            FetchResult result;
            boolean done;

            OutputWrapper() {
            }
        }
        final OutputWrapper ow = new OutputWrapper();
        this.core.clientContext.jobRunner.queue(new DBJob(){
            {
            }

            public String toString() {
                return "FCP getCompletedRequestBlocking";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(ObjectContainer container, ClientContext context) {
                CacheFetchResult result = null;
                try {
                    result = FCPServer.this.lookup(key, false, context, container, false, null);
                }
                finally {
                    OutputWrapper outputWrapper = ow;
                    synchronized (outputWrapper) {
                        ow.result = result;
                        ow.done = true;
                        ow.notifyAll();
                    }
                }
                return false;
            }
        }, NativeThread.HIGH_PRIORITY, false);
        OutputWrapper outputWrapper = ow;
        synchronized (outputWrapper) {
            while (true) {
                if (ow.done) {
                    return ow.result;
                }
                try {
                    ow.wait();
                }
                catch (InterruptedException e) {}
            }
        }
    }

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Not storing FCPServer in database", (Throwable)new Exception("error"));
        return false;
    }

    @Override
    public CacheFetchResult lookupInstant(FreenetURI key, boolean noFilter, boolean mustCopy, Bucket preferred) {
        CacheFetchResult result;
        ClientGet get = this.globalRebootClient.getCompletedRequest(key, null);
        Bucket origData = null;
        String mime = null;
        boolean filtered = false;
        if (!(get == null || noFilter && (filtered = get.filterData(null)))) {
            origData = new NoFreeBucket(get.getBucket(null));
            mime = get.getMIMEType(null);
        }
        if (origData == null && this.globalForeverClient != null && (result = this.globalForeverClient.getRequestStatusCache().getShadowBucket(key, noFilter)) != null) {
            mime = result.getMimeType();
            origData = result.asBucket();
            filtered = result.alreadyFiltered;
        }
        if (origData == null) {
            return null;
        }
        if (!mustCopy) {
            return new CacheFetchResult(new ClientMetadata(mime), origData, filtered);
        }
        Bucket newData = null;
        try {
            newData = preferred != null ? preferred : this.core.tempBucketFactory.makeBucket(origData.size());
            BucketTools.copy(origData, newData);
            if (origData.size() != newData.size()) {
                Logger.normal(this, "Maybe it disappeared under us?");
                newData.free();
                newData = null;
                return null;
            }
            return new CacheFetchResult(new ClientMetadata(mime), newData, filtered);
        }
        catch (IOException e) {
            Logger.normal(this, "Unable to copy data: " + e, (Throwable)e);
            return null;
        }
    }

    @Override
    public CacheFetchResult lookup(FreenetURI key, boolean noFilter, ClientContext context, ObjectContainer container, boolean mustCopy, Bucket preferred) {
        if (this.globalForeverClient == null) {
            return null;
        }
        ClientGet get = this.globalForeverClient.getCompletedRequest(key, container);
        container.activate((Object)get, 1);
        if (get != null) {
            boolean filtered = get.filterData(container);
            Bucket origData = get.getBucket(container);
            container.activate((Object)origData, 5);
            Bucket newData = null;
            if (!mustCopy) {
                newData = origData.createShadow();
            }
            if (newData == null) {
                try {
                    newData = preferred != null ? preferred : this.core.tempBucketFactory.makeBucket(origData.size());
                    BucketTools.copy(origData, newData);
                }
                catch (IOException e) {
                    Logger.error(this, "Unable to copy data: " + e, (Throwable)e);
                    return null;
                }
            }
            container.deactivate((Object)get, 1);
            return new CacheFetchResult(new ClientMetadata(get.getMIMEType(container)), newData, filtered);
        }
        return null;
    }

    static {
        ssl = false;
    }

    static class MaxMessageQueueLengthCallback
    extends IntCallback {
        FCPServer server;

        MaxMessageQueueLengthCallback() {
        }

        @Override
        public Integer get() {
            return this.server.maxMessageQueueLength;
        }

        @Override
        public void set(Integer val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            this.server.maxMessageQueueLength = val;
        }
    }

    static class NeverDropAMessageCallback
    extends BooleanCallback {
        FCPServer server;

        NeverDropAMessageCallback() {
        }

        @Override
        public Boolean get() {
            return this.server.neverDropAMessage;
        }

        @Override
        public void set(Boolean val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            this.server.neverDropAMessage = val;
        }
    }

    static class AssumeDDAUploadIsAllowedCallback
    extends BooleanCallback {
        FCPServer server;

        AssumeDDAUploadIsAllowedCallback() {
        }

        @Override
        public Boolean get() {
            return this.server.assumeUploadDDAIsAllowed;
        }

        @Override
        public void set(Boolean val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            this.server.assumeUploadDDAIsAllowed = val;
        }
    }

    static class AssumeDDADownloadIsAllowedCallback
    extends BooleanCallback {
        FCPServer server;

        AssumeDDADownloadIsAllowedCallback() {
        }

        @Override
        public Boolean get() {
            return this.server.assumeDownloadDDAIsAllowed;
        }

        @Override
        public void set(Boolean val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            this.server.assumeDownloadDDAIsAllowed = val;
        }
    }

    static class FCPAllowedHostsFullAccessCallback
    extends StringCallback {
        private final NodeClientCore node;

        public FCPAllowedHostsFullAccessCallback(NodeClientCore node) {
            this.node = node;
        }

        @Override
        public String get() {
            return this.node.getFCPServer().allowedHostsFullAccess.getAllowedHosts();
        }

        @Override
        public void set(String val) throws InvalidConfigValueException {
            if (!val.equals(this.get())) {
                try {
                    this.node.getFCPServer().allowedHostsFullAccess.setAllowedHosts(val);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidConfigValueException(e);
                }
            }
        }
    }

    static class FCPAllowedHostsCallback
    extends StringCallback {
        private final NodeClientCore node;

        public FCPAllowedHostsCallback(NodeClientCore node) {
            this.node = node;
        }

        @Override
        public String get() {
            FCPServer server = this.node.getFCPServer();
            if (server == null) {
                return "127.0.0.1,0:0:0:0:0:0:0:1";
            }
            NetworkInterface netIface = server.networkInterface;
            return netIface == null ? "127.0.0.1,0:0:0:0:0:0:0:1" : netIface.getAllowedHosts();
        }

        @Override
        public void set(String val) throws InvalidConfigValueException {
            if (!val.equals(this.get())) {
                try {
                    this.node.getFCPServer().networkInterface.setAllowedHosts(val);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidConfigValueException(e);
                }
            }
        }
    }

    static class FCPBindtoCallback
    extends StringCallback {
        final NodeClientCore node;

        FCPBindtoCallback(NodeClientCore node) {
            this.node = node;
        }

        @Override
        public String get() {
            return this.node.getFCPServer().bindTo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(String val) throws InvalidConfigValueException {
            String oldValue = this.get();
            if (!val.equals(oldValue)) {
                FCPServer server = this.node.getFCPServer();
                Object[] failedAddresses = server.networkInterface.setBindTo(val, true);
                if (failedAddresses != null) {
                    server.networkInterface.setBindTo(oldValue, true);
                    throw new InvalidConfigValueException(FCPServer.l10n("couldNotChangeBindTo", "failedInterfaces", Arrays.toString(failedAddresses)));
                }
                server.networkInterface.setBindTo(val, true);
                server.bindTo = val;
                NetworkInterface networkInterface = server.networkInterface;
                synchronized (networkInterface) {
                    server.networkInterface.notifyAll();
                }
            }
        }
    }

    static class FCPSSLCallback
    extends BooleanCallback {
        FCPSSLCallback() {
        }

        @Override
        public Boolean get() {
            return ssl;
        }

        @Override
        public void set(Boolean val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            if (!SSL.available()) {
                throw new InvalidConfigValueException("Enable SSL support before use ssl with FCP");
            }
            ssl = val;
            throw new InvalidConfigValueException("Cannot change SSL on the fly, please restart freenet");
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }
    }

    static class FCPEnabledCallback
    extends BooleanCallback {
        final NodeClientCore node;

        FCPEnabledCallback(NodeClientCore node) {
            this.node = node;
        }

        @Override
        public Boolean get() {
            return this.node.getFCPServer().enabled;
        }

        @Override
        public void set(Boolean val) throws InvalidConfigValueException {
            if (!this.get().equals(val)) {
                throw new InvalidConfigValueException(FCPServer.l10n("cannotStartOrStopOnTheFly"));
            }
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }
    }

    static class FCPPortNumberCallback
    extends IntCallback {
        private final NodeClientCore node;

        FCPPortNumberCallback(NodeClientCore node) {
            this.node = node;
        }

        @Override
        public Integer get() {
            return this.node.getFCPServer().port;
        }

        @Override
        public void set(Integer val) throws InvalidConfigValueException {
            if (!this.get().equals(val)) {
                throw new InvalidConfigValueException("Cannot change FCP port number on the fly");
            }
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }
    }
}

