/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.node.Node;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.MultipleDataCarryingMessage;
import freenet.support.SimpleFieldSet;
import freenet.support.io.ArrayBucket;
import java.io.UnsupportedEncodingException;

public class FeedMessage
extends MultipleDataCarryingMessage {
    public static final String NAME = "Feed";
    private String header;
    private String shortText;
    private final short priorityClass;
    private final long updatedTime;

    public FeedMessage(String header, String shortText, String text, short priorityClass, long updatedTime) {
        this.header = header;
        this.shortText = shortText;
        this.priorityClass = priorityClass;
        this.updatedTime = updatedTime;
        try {
            ArrayBucket textBucket = new ArrayBucket(text.getBytes("UTF-8"));
            this.buckets.put("Text", textBucket);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = super.getFieldSet();
        fs.putSingle("Header", this.header);
        fs.putSingle("ShortText", this.shortText);
        fs.put("PriorityClass", this.priorityClass);
        fs.put("UpdatedTime", this.updatedTime);
        return fs;
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, this.getName() + " goes from server to client not the other way around", null, false);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

