/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.node.Node;
import freenet.node.fcp.DataCarryingMessage;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;

public class FilterResultMessage
extends DataCarryingMessage {
    public static final String NAME = "FilterResult";
    private final String identifier;
    private final String charset;
    private final String mimeType;
    private final boolean unsafeContentType;
    private final long dataLength;

    public FilterResultMessage(String identifier, String charset, String mimeType, boolean unsafeContentType, Bucket bucket) {
        this.identifier = identifier;
        this.charset = charset;
        this.mimeType = mimeType;
        this.unsafeContentType = unsafeContentType;
        if (unsafeContentType) {
            this.dataLength = -1L;
        } else {
            this.dataLength = bucket.size();
            this.bucket = bucket;
        }
    }

    @Override
    String getIdentifier() {
        return this.identifier;
    }

    @Override
    boolean isGlobal() {
        return false;
    }

    @Override
    long dataLength() {
        return this.dataLength;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("Identifier", this.identifier);
        fs.putOverwrite("Charset", this.charset);
        fs.putOverwrite("MimeType", this.mimeType);
        fs.put("UnsafeContentType", this.unsafeContentType);
        fs.put("DataLength", this.dataLength);
        return fs;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "FilterResult goes from server to client not the other way around", null, false);
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }
}

