/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.node.Node;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.PluginInfoMessage;
import freenet.node.fcp.ProtocolErrorMessage;
import freenet.pluginmanager.PluginInfoWrapper;
import freenet.support.SimpleFieldSet;

public class GetPluginInfo
extends FCPMessage {
    static final String NAME = "GetPluginInfo";
    private final String identifier;
    private final boolean detailed;
    private final String plugname;

    public GetPluginInfo(SimpleFieldSet fs) throws MessageInvalidException {
        this.identifier = fs.get("Identifier");
        if (this.identifier == null) {
            throw new MessageInvalidException(5, "GetPluginInfo must contain an Identifier field", null, false);
        }
        this.plugname = fs.get("PluginName");
        if (this.plugname == null) {
            throw new MessageInvalidException(5, "GetPluginInfo must contain a PluginName field", this.identifier, false);
        }
        this.detailed = fs.getBoolean("Detailed", false);
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return new SimpleFieldSet(true);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        if (this.detailed && !handler.hasFullAccess()) {
            throw new MessageInvalidException(24, "GetPluginInfo detailed requires full access", this.identifier, false);
        }
        PluginInfoWrapper pi = node.pluginManager.getPluginInfo(this.plugname);
        if (pi == null) {
            handler.outputHandler.queue(new ProtocolErrorMessage(32, false, "Plugin '" + this.plugname + "' does not exist or is not a FCP plugin", this.identifier, false));
        } else {
            handler.outputHandler.queue(new PluginInfoMessage(pi, this.identifier, this.detailed));
        }
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }
}

