/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.node.Node;
import freenet.node.fcp.EndListPersistentRequestsMessage;
import freenet.node.fcp.FCPClient;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPConnectionOutputHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.SimpleFieldSet;
import freenet.support.io.NativeThread;

public class ListPersistentRequestsMessage
extends FCPMessage {
    static final String NAME = "ListPersistentRequests";

    public ListPersistentRequestsMessage(SimpleFieldSet fs) {
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return new SimpleFieldSet(true);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(final FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        FCPClient rebootClient = handler.getRebootClient();
        TransientListJob job = new TransientListJob(rebootClient, handler.outputHandler, node.clientCore.clientContext){

            @Override
            void complete(ObjectContainer container, ClientContext context) {
                if (handler.getRebootClient().watchGlobal) {
                    FCPClient globalRebootClient = handler.server.globalRebootClient;
                    TransientListJob job = new TransientListJob(globalRebootClient, this.outputHandler, context){

                        @Override
                        void complete(ObjectContainer container, ClientContext context) {
                            this.finishComplete(container, context);
                        }
                    };
                    job.run();
                } else {
                    this.finishComplete(container, context);
                }
            }

            private void finishComplete(ObjectContainer container, ClientContext context) {
                try {
                    context.jobRunner.queue(new DBJob(){

                        @Override
                        public boolean run(ObjectContainer container, ClientContext context) {
                            FCPClient foreverClient = handler.getForeverClient(container);
                            PersistentListJob job = new PersistentListJob(foreverClient, outputHandler, context){

                                @Override
                                void complete(ObjectContainer container, ClientContext context) {
                                    if (handler.getRebootClient().watchGlobal) {
                                        FCPClient globalForeverClient = handler.server.globalForeverClient;
                                        PersistentListJob job = new PersistentListJob(globalForeverClient, this.outputHandler, context){

                                            @Override
                                            void complete(ObjectContainer container, ClientContext context) {
                                                this.finishFinal();
                                            }
                                        };
                                        job.run(container, context);
                                    } else {
                                        this.finishFinal();
                                    }
                                }

                                private void finishFinal() {
                                    this.outputHandler.queue(new EndListPersistentRequestsMessage());
                                }
                            };
                            job.run(container, context);
                            return false;
                        }
                    }, NativeThread.HIGH_PRIORITY - 1, false);
                }
                catch (DatabaseDisabledException e) {
                    handler.outputHandler.queue(new EndListPersistentRequestsMessage());
                }
            }
        };
        job.run();
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }

    public static abstract class PersistentListJob
    extends ListJob
    implements DBJob,
    Runnable {
        final ClientContext context;

        PersistentListJob(FCPClient client, FCPConnectionOutputHandler handler, ClientContext context) {
            super(client, handler);
            this.context = context;
        }

        @Override
        void reschedule(ClientContext context) {
            context.ticker.queueTimedJob(this, 100L);
        }

        @Override
        public void run() {
            try {
                this.context.jobRunner.queue(this, NativeThread.HIGH_PRIORITY - 1, false);
            }
            catch (DatabaseDisabledException e) {
                this.outputHandler.queue(new EndListPersistentRequestsMessage());
            }
        }
    }

    public static abstract class TransientListJob
    extends ListJob
    implements Runnable {
        final ClientContext context;

        TransientListJob(FCPClient client, FCPConnectionOutputHandler handler, ClientContext context) {
            super(client, handler);
            this.context = context;
        }

        @Override
        public void run() {
            this.run(null, this.context);
        }

        @Override
        void reschedule(ClientContext context) {
            context.ticker.queueTimedJob(this, 100L);
        }
    }

    public static abstract class ListJob
    implements DBJob {
        final FCPClient client;
        final FCPConnectionOutputHandler outputHandler;
        boolean sentRestartJobs;
        int progressCompleted = 0;
        int progressRunning = 0;

        ListJob(FCPClient client, FCPConnectionOutputHandler outputHandler) {
            this.client = client;
            this.outputHandler = outputHandler;
        }

        @Override
        public boolean run(ObjectContainer container, ClientContext context) {
            int p;
            if (container != null) {
                container.activate((Object)this.client, 1);
            }
            while (!this.sentRestartJobs) {
                if (this.outputHandler.isQueueHalfFull()) {
                    if (container != null && !this.client.isGlobalQueue) {
                        container.deactivate((Object)this.client, 1);
                    }
                    this.reschedule(context);
                    return false;
                }
                p = this.client.queuePendingMessagesOnConnectionRestart(this.outputHandler, container, this.progressCompleted, 30);
                if (p <= this.progressCompleted) {
                    this.sentRestartJobs = true;
                    break;
                }
                this.progressCompleted = p;
            }
            if (this.noRunning()) {
                this.complete(container, context);
            }
            while (true) {
                if (this.outputHandler.isQueueHalfFull()) {
                    if (container != null && !this.client.isGlobalQueue) {
                        container.deactivate((Object)this.client, 1);
                    }
                    this.reschedule(context);
                    return false;
                }
                p = this.client.queuePendingMessagesFromRunningRequests(this.outputHandler, container, this.progressRunning, 30);
                if (p <= this.progressRunning) {
                    if (container != null && !this.client.isGlobalQueue) {
                        container.deactivate((Object)this.client, 1);
                    }
                    this.complete(container, context);
                    return false;
                }
                this.progressRunning = p;
            }
        }

        abstract void reschedule(ClientContext var1);

        abstract void complete(ObjectContainer var1, ClientContext var2);

        protected boolean noRunning() {
            return false;
        }
    }
}

