/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.config.Option;
import freenet.config.PersistentConfig;
import freenet.config.SubConfig;
import freenet.node.Node;
import freenet.node.fcp.ConfigData;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;

public class ModifyConfig
extends FCPMessage {
    static final String NAME = "ModifyConfig";
    final SimpleFieldSet fs;
    final String identifier;

    public ModifyConfig(SimpleFieldSet fs) {
        this.fs = fs;
        this.identifier = fs.get("Identifier");
        fs.removeValue("Identifier");
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return new SimpleFieldSet(true);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        if (!handler.hasFullAccess()) {
            throw new MessageInvalidException(24, "ModifyConfig requires full access", this.identifier, false);
        }
        PersistentConfig config = node.config;
        boolean logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        for (SubConfig sc : config.getConfigs()) {
            String prefix = sc.getPrefix();
            for (Option<?> o : sc.getOptions()) {
                String s;
                String configName = o.getName();
                if (logMINOR) {
                    Logger.minor(this, "Setting " + prefix + '.' + configName);
                }
                if ((s = this.fs.get(prefix + '.' + configName)) == null || o.getValueString().equals(s)) continue;
                if (logMINOR) {
                    Logger.minor(this, "Setting " + prefix + '.' + configName + " to " + s);
                }
                try {
                    o.setValue(s);
                }
                catch (Exception e) {
                    Logger.error(this, "Caught " + e, (Throwable)e);
                }
            }
        }
        node.clientCore.storeConfig();
        handler.outputHandler.queue(new ConfigData(node, true, false, false, false, false, false, false, false, this.identifier));
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }
}

