/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.PeerRemoved;
import freenet.node.fcp.UnknownNodeIdentifierMessage;
import freenet.support.SimpleFieldSet;

public class RemovePeer
extends FCPMessage {
    static final String NAME = "RemovePeer";
    final SimpleFieldSet fs;
    final String identifier;

    public RemovePeer(SimpleFieldSet fs) {
        this.fs = fs;
        this.identifier = fs.get("Identifier");
        fs.removeValue("Identifier");
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return new SimpleFieldSet(true);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        if (!handler.hasFullAccess()) {
            throw new MessageInvalidException(24, "RemovePeer requires full access", this.identifier, false);
        }
        String nodeIdentifier = this.fs.get("NodeIdentifier");
        if (nodeIdentifier == null) {
            throw new MessageInvalidException(5, "Error: NodeIdentifier field missing", this.identifier, false);
        }
        PeerNode pn = node.getPeerNode(nodeIdentifier);
        if (pn == null) {
            UnknownNodeIdentifierMessage msg = new UnknownNodeIdentifierMessage(nodeIdentifier, this.identifier);
            handler.outputHandler.queue(msg);
            return;
        }
        String identity = pn.getIdentityString();
        node.removePeerConnection(pn);
        handler.outputHandler.queue(new PeerRemoved(identity, nodeIdentifier, this.identifier));
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }
}

