/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import freenet.client.events.SplitfileProgressEvent;
import freenet.keys.FreenetURI;
import freenet.l10n.NodeL10n;

public abstract class RequestStatus
implements Cloneable {
    private final String identifier;
    private boolean hasStarted;
    private boolean hasFinished;
    private boolean hasSucceeded;
    private short priority;
    private int totalBlocks;
    private int minBlocks;
    private int fetchedBlocks;
    private int fatallyFailedBlocks;
    private int failedBlocks;
    private boolean isTotalFinalized;
    private long lastActivity;
    private final short persistenceType;

    synchronized void setFinished(boolean success) {
        this.lastActivity = System.currentTimeMillis();
        this.hasFinished = true;
        this.hasSucceeded = success;
        this.hasStarted = true;
        this.isTotalFinalized = true;
    }

    synchronized void restart(boolean started) {
        this.lastActivity = System.currentTimeMillis();
        this.hasFinished = false;
        this.hasSucceeded = false;
        this.hasStarted = started;
        this.isTotalFinalized = false;
    }

    RequestStatus(String identifier, short persistence, boolean started, boolean finished, boolean success, int total, int min, int fetched, int fatal, int failed, boolean totalFinalized, long last, short prio) {
        this.identifier = identifier;
        this.hasStarted = started;
        this.hasFinished = finished;
        this.hasSucceeded = success;
        this.priority = prio;
        this.totalBlocks = total;
        this.minBlocks = min;
        this.fetchedBlocks = fetched;
        this.fatallyFailedBlocks = fatal;
        this.failedBlocks = failed;
        this.isTotalFinalized = totalFinalized;
        this.lastActivity = last;
        this.persistenceType = persistence;
    }

    public boolean hasSucceeded() {
        return this.hasSucceeded;
    }

    public boolean hasFinished() {
        return this.hasFinished;
    }

    public short getPriority() {
        return this.priority;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public boolean isTotalFinalized() {
        return this.isTotalFinalized;
    }

    public int getMinBlocks() {
        return this.minBlocks;
    }

    public int getFetchedBlocks() {
        return this.fetchedBlocks;
    }

    public long getLastActivity() {
        return this.lastActivity;
    }

    public abstract FreenetURI getURI();

    public abstract long getDataSize();

    public boolean isPersistentForever() {
        return this.persistenceType == 2;
    }

    public boolean isPersistent() {
        return this.persistenceType != 0;
    }

    public int getFatalyFailedBlocks() {
        return this.fatallyFailedBlocks;
    }

    public int getFailedBlocks() {
        return this.failedBlocks;
    }

    public boolean isStarted() {
        return this.hasStarted;
    }

    public abstract String getFailureReason(boolean var1);

    public synchronized void updateStatus(SplitfileProgressEvent event) {
        this.failedBlocks = event.failedBlocks;
        this.fatallyFailedBlocks = event.fatallyFailedBlocks;
        this.fetchedBlocks = event.succeedBlocks;
        this.isTotalFinalized = event.finalizedTotal;
        this.minBlocks = event.minSuccessfulBlocks;
        this.totalBlocks = event.totalBlocks;
        this.updateLastActivity();
    }

    protected synchronized void updateLastActivity() {
        this.lastActivity = System.currentTimeMillis();
    }

    public synchronized void setPriority(short newPriority) {
        this.priority = newPriority;
    }

    public synchronized void setStarted(boolean started) {
        this.hasStarted = started;
    }

    public abstract String getPreferredFilename();

    public String getPreferredFilenameSafe() {
        String ret = this.getPreferredFilename();
        if (ret == null) {
            return NodeL10n.getBase().getString("RequestStatus.unknownFilename");
        }
        return ret;
    }

    public RequestStatus clone() {
        try {
            return (RequestStatus)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }
}

