/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.node.Node;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.IOException;

public class TestDDACompleteMessage
extends FCPMessage {
    public static final String name = "TestDDAComplete";
    public static final String READ_ALLOWED = "ReadDirectoryAllowed";
    public static final String WRITE_ALLOWED = "WriteDirectoryAllowed";
    final FCPConnectionHandler.DDACheckJob checkJob;
    final String readContentFromClient;
    private final FCPConnectionHandler handler;

    public TestDDACompleteMessage(FCPConnectionHandler handler, FCPConnectionHandler.DDACheckJob job, String readContent) {
        this.checkJob = job;
        this.readContentFromClient = readContent;
        this.handler = handler;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        sfs.putSingle("Directory", this.checkJob.directory.toString());
        boolean isReadAllowed = false;
        boolean isWriteAllowed = false;
        if (this.checkJob.readFilename != null) {
            isReadAllowed = this.readContentFromClient != null && this.checkJob.readContent.equals(this.readContentFromClient);
            this.checkJob.readFilename.delete();
            sfs.putSingle(READ_ALLOWED, String.valueOf(isReadAllowed));
        }
        if (this.checkJob.writeFilename != null) {
            File maybeWrittenFile = this.checkJob.writeFilename;
            if (maybeWrittenFile.exists() && maybeWrittenFile.isFile() && maybeWrittenFile.canRead()) {
                try {
                    String existingContent = FileUtil.readUTF(maybeWrittenFile).toString().trim();
                    isWriteAllowed = this.checkJob.writeContent.equals(existingContent);
                }
                catch (IOException e) {
                    Logger.error(this, "Caught an IOE trying to read the file (" + maybeWrittenFile + ")! " + e.getMessage());
                }
            }
            sfs.putSingle(WRITE_ALLOWED, String.valueOf(isWriteAllowed));
        }
        this.handler.registerTestDDAResult(this.checkJob.directory.toString(), isReadAllowed, isWriteAllowed);
        return sfs;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "TestDDAComplete goes from server to client not the other way around", name, false);
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }
}

