/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.updater;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.client.events.ClientEvent;
import freenet.client.events.ClientEventListener;
import freenet.client.events.SplitfileProgressEvent;
import freenet.clients.http.QueueToadlet;
import freenet.keys.FreenetURI;
import freenet.l10n.NodeL10n;
import freenet.node.RequestClient;
import freenet.node.Version;
import freenet.node.fcp.ClientPut;
import freenet.node.fcp.FCPMessage;
import freenet.node.updater.MainJarDependenciesChecker;
import freenet.node.updater.NodeUpdateManager;
import freenet.node.updater.NodeUpdater;
import freenet.node.updater.UpdateOverMandatoryManager;
import freenet.node.useralerts.UserAlert;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.io.Closer;
import freenet.support.io.FileBucket;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;

public class MainJarUpdater
extends NodeUpdater
implements MainJarDependenciesChecker.Deployer {
    private static volatile boolean logMINOR;
    private final FetchContext dependencyCtx;
    private final ClientContext clientContext;
    private final MainJarDependenciesChecker dependencies;
    private HashSet<DependencyJarFetcher> fetchers = new HashSet();
    private HashSet<DependencyJarFetcher> essentialFetchers = new HashSet();

    MainJarUpdater(NodeUpdateManager manager, FreenetURI URI2, int current, int min, int max, String blobFilenamePrefix) {
        super(manager, URI2, current, min, max, blobFilenamePrefix);
        this.dependencyCtx = this.core.makeClient((short)0, true, false).getFetchContext();
        this.dependencyCtx.allowSplitfiles = true;
        this.dependencyCtx.dontEnterImplicitArchives = false;
        this.dependencyCtx.maxNonSplitfileRetries = -1;
        this.dependencyCtx.maxSplitfileBlockRetries = -1;
        this.clientContext = this.core.clientContext;
        this.dependencies = new MainJarDependenciesChecker(this, manager.node.executor);
    }

    @Override
    public String jarName() {
        return "freenet.jar";
    }

    @Override
    public void start() {
        this.maybeProcessOldBlob();
        super.start();
    }

    @Override
    protected void maybeParseManifest(FetchResult result, int build) {
    }

    @Override
    protected void processSuccess(int fetched, FetchResult result, File blob) {
        this.manager.onDownloadedNewJar(result.asBucket(), fetched, blob);
        this.parseDependencies(result, fetched);
    }

    @Override
    protected void onStartFetching() {
        this.manager.onStartFetching();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void parseDependencies(Properties props, int build) {
        HashSet<DependencyJarFetcher> hashSet = this.fetchers;
        synchronized (hashSet) {
            this.fetchers.clear();
        }
        MainJarDependenciesChecker.MainJarDependencies deps = this.dependencies.handle(props, build);
        if (deps != null) {
            this.manager.onDependenciesReady(deps);
        }
    }

    @Override
    public void deploy(MainJarDependenciesChecker.MainJarDependencies deps) {
        this.manager.onDependenciesReady(deps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MainJarDependenciesChecker.JarFetcher fetch(FreenetURI uri, File downloadTo, long expectedLength, byte[] expectedHash, MainJarDependenciesChecker.JarFetcherCallback cb, int build, boolean essential, boolean executable) throws FetchException {
        if (essential) {
            System.out.println("Fetching " + downloadTo + " needed for new Freenet update " + build);
        } else if (build != 0) {
            System.out.println("Preloading " + downloadTo + " needed for new Freenet update " + build);
        }
        if (logMINOR) {
            Logger.minor(this, "Fetching " + uri + " to " + downloadTo + " for next update");
        }
        DependencyJarFetcher fetcher = new DependencyJarFetcher(downloadTo, uri, expectedLength, expectedHash, cb, essential, executable);
        HashSet<DependencyJarFetcher> hashSet = this.fetchers;
        synchronized (hashSet) {
            this.fetchers.add(fetcher);
            if (essential) {
                this.essentialFetchers.add(fetcher);
            }
        }
        fetcher.start();
        if (this.manager.uom.fetchingUOM() && essential) {
            fetcher.fetchFromUOM();
        }
        return fetcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStartFetchingUOM() {
        DependencyJarFetcher[] f;
        HashSet<DependencyJarFetcher> hashSet = this.fetchers;
        synchronized (hashSet) {
            f = this.fetchers.toArray(new DependencyJarFetcher[this.fetchers.size()]);
        }
        for (DependencyJarFetcher fetcher : f) {
            fetcher.fetchFromUOM();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderProperties(HTMLNode alertNode) {
        HashSet<DependencyJarFetcher> hashSet = this.fetchers;
        synchronized (hashSet) {
            if (!this.fetchers.isEmpty()) {
                alertNode.addChild("p", this.l10n("fetchingDependencies") + ":");
                HTMLNode table = alertNode.addChild("table");
                for (DependencyJarFetcher f : this.fetchers) {
                    table.addChild(f.renderRow());
                }
            }
        }
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("MainJarUpdater." + key);
    }

    public boolean brokenDependencies() {
        return this.dependencies.isBroken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupDependencies() {
        InputStream is = this.getClass().getResourceAsStream("/dependencies.properties");
        if (is == null) {
            System.err.println("Can't find dependencies file. Other nodes will not be able to use Update Over Mandatory through this one.");
            return;
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            System.err.println("Can't read dependencies file. Other nodes will not be able to use Update Over Mandatory through this one.");
            return;
        }
        finally {
            Closer.close(is);
        }
        this.dependencies.cleanup(props, this, Version.buildNumber());
    }

    @Override
    public void addDependency(byte[] expectedHash, File filename) {
        this.manager.uom.addDependency(expectedHash, filename);
    }

    @Override
    public void reannounce() {
        this.manager.broadcastUOMAnnouncesNew();
        this.manager.broadcastUOMAnnouncesOld();
    }

    @Override
    public void multiFileReplaceReadyToDeploy(final MainJarDependenciesChecker.AtomicDeployer atomicDeployer) {
        if (this.manager.isAutoUpdateAllowed()) {
            atomicDeployer.deployMultiFileUpdateOffThread();
        } else {
            final long now = System.currentTimeMillis();
            System.err.println("Not deploying multi-file update for " + atomicDeployer.name + " because auto-update is not enabled.");
            this.node.clientCore.alerts.register(new UserAlert(){

                private String l10n(String key) {
                    return NodeL10n.getBase().getString("MainJarUpdater.ConfirmMultiFileUpdater." + key);
                }

                @Override
                public boolean userCanDismiss() {
                    return true;
                }

                @Override
                public String getTitle() {
                    return this.l10n("title." + atomicDeployer.name);
                }

                @Override
                public String getText() {
                    return this.l10n("text." + atomicDeployer.name);
                }

                @Override
                public HTMLNode getHTMLText() {
                    return new HTMLNode("p", this.getText());
                }

                @Override
                public String getShortText() {
                    return this.getTitle();
                }

                @Override
                public short getPriorityClass() {
                    return 1;
                }

                @Override
                public boolean isValid() {
                    return true;
                }

                @Override
                public void isValid(boolean validity) {
                }

                @Override
                public String dismissButtonText() {
                    return NodeL10n.getBase().getDefaultString("UpdatedVersionAvailableUserAlert.updateNowButton");
                }

                @Override
                public boolean shouldUnregisterOnDismiss() {
                    return true;
                }

                @Override
                public void onDismiss() {
                    atomicDeployer.deployMultiFileUpdateOffThread();
                }

                @Override
                public String anchor() {
                    return "multi-file-update-confirm-" + atomicDeployer.name;
                }

                @Override
                public boolean isEventNotification() {
                    return false;
                }

                @Override
                public FCPMessage getFCPMessage() {
                    return null;
                }

                @Override
                public long getUpdatedTime() {
                    return now;
                }
            });
        }
    }

    static {
        Logger.registerClass(MainJarUpdater.class);
    }

    private class DependencyJarFetcher
    implements MainJarDependenciesChecker.JarFetcher,
    ClientGetCallback,
    RequestClient,
    ClientEventListener {
        private final File filename;
        private final ClientGetter getter;
        private SplitfileProgressEvent lastProgress;
        private final MainJarDependenciesChecker.JarFetcherCallback cb;
        private boolean fetched;
        private final byte[] expectedHash;
        private final long expectedLength;
        private final boolean essential;
        private final File tempFile;
        private UpdateOverMandatoryManager.UOMDependencyFetcher uomFetcher;
        private final boolean executable;

        DependencyJarFetcher(File filename, FreenetURI chk, long expectedLength, byte[] expectedHash, MainJarDependenciesChecker.JarFetcherCallback cb, boolean essential, boolean executable) throws FetchException {
            FetchContext myCtx = new FetchContext(MainJarUpdater.this.dependencyCtx, 0, false, null);
            File parent = filename.getParentFile();
            if (parent == null) {
                parent = new File(".");
            }
            try {
                this.tempFile = File.createTempFile(filename.getName(), ".updater.tmp", parent);
            }
            catch (IOException e) {
                throw new FetchException(12, "Cannot create temp file for " + filename + " in " + parent + " - disk full? permissions problem?");
            }
            this.getter = new ClientGetter(this, chk, myCtx, 2, this, new FileBucket(this.tempFile, false, false, false, false, false), null, null);
            myCtx.eventProducer.addEventListener(this);
            this.cb = cb;
            this.filename = filename;
            this.expectedHash = expectedHash;
            this.expectedLength = expectedLength;
            this.essential = essential;
            this.executable = executable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            UpdateOverMandatoryManager.UOMDependencyFetcher f;
            DependencyJarFetcher dependencyJarFetcher = this;
            synchronized (dependencyJarFetcher) {
                this.fetched = true;
                f = this.uomFetcher;
            }
            MainJarUpdater.this.node.executor.execute(new Runnable(){

                @Override
                public void run() {
                    DependencyJarFetcher.this.getter.cancel(null, MainJarUpdater.this.clientContext);
                    if (f != null) {
                        f.cancel();
                    }
                }
            });
        }

        @Override
        public void onMajorProgress(ObjectContainer container) {
        }

        @Override
        public boolean persistent() {
            return false;
        }

        @Override
        public boolean realTimeFlag() {
            return false;
        }

        @Override
        public void removeFrom(ObjectContainer container) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(FetchResult result, ClientGetter state, ObjectContainer container) {
            DependencyJarFetcher dependencyJarFetcher = this;
            synchronized (dependencyJarFetcher) {
                if (this.fetched) {
                    this.tempFile.delete();
                    return;
                }
                this.fetched = true;
            }
            if (!MainJarDependenciesChecker.validFile(this.tempFile, this.expectedHash, this.expectedLength, this.executable)) {
                Logger.error(this, "Unable to download dependency " + this.filename + " : not the expected size or hash!");
                System.err.println("Download of " + this.filename + " for update failed because temp file appears to be corrupted!");
                if (this.cb != null) {
                    this.cb.onFailure(new FetchException(12, "Downloaded jar from Freenet but failed consistency check: " + this.tempFile + " length " + this.tempFile.length() + " "));
                }
                this.tempFile.delete();
                return;
            }
            if (!FileUtil.renameTo(this.tempFile, this.filename)) {
                Logger.error(this, "Unable to rename temp file " + this.tempFile + " to " + this.filename);
                System.err.println("Download of " + this.filename + " for update failed because cannot rename from " + this.tempFile);
                if (this.cb != null) {
                    this.cb.onFailure(new FetchException(12, "Unable to rename temp file " + this.tempFile + " to " + this.filename));
                }
                this.tempFile.delete();
                return;
            }
            if (this.cb != null) {
                this.cb.onSuccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(FetchException e, ClientGetter state, ObjectContainer container) {
            this.tempFile.delete();
            DependencyJarFetcher dependencyJarFetcher = this;
            synchronized (dependencyJarFetcher) {
                if (this.fetched) {
                    return;
                }
            }
            if (this.cb != null) {
                this.cb.onFailure(e);
            }
        }

        @Override
        public synchronized void receive(ClientEvent ce, ObjectContainer maybeContainer, ClientContext context) {
            if (ce instanceof SplitfileProgressEvent) {
                this.lastProgress = (SplitfileProgressEvent)ce;
            }
        }

        @Override
        public void onRemoveEventProducer(ObjectContainer container) {
        }

        private void start() throws FetchException {
            this.getter.start(null, MainJarUpdater.this.clientContext);
        }

        public synchronized HTMLNode renderRow() {
            HTMLNode row = new HTMLNode("tr");
            row.addChild("td").addChild("p", this.filename.toString());
            if (this.uomFetcher != null) {
                row.addChild("td").addChild("#", MainJarUpdater.this.l10n("fetchingFromUOM"));
            } else if (this.lastProgress == null) {
                row.addChild(QueueToadlet.createProgressCell(false, true, ClientPut.COMPRESS_STATE.WORKING, 0, 0, 0, 0, 0, false, false));
            } else {
                row.addChild(QueueToadlet.createProgressCell(false, true, ClientPut.COMPRESS_STATE.WORKING, this.lastProgress.succeedBlocks, this.lastProgress.failedBlocks, this.lastProgress.fatallyFailedBlocks, this.lastProgress.minSuccessfulBlocks, this.lastProgress.totalBlocks, this.lastProgress.finalizedTotal, false));
            }
            return row;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fetchFromUOM() {
            DependencyJarFetcher dependencyJarFetcher = this;
            synchronized (dependencyJarFetcher) {
                if (this.fetched) {
                    return;
                }
                if (!this.essential) {
                    return;
                }
            }
            UpdateOverMandatoryManager.UOMDependencyFetcher f = MainJarUpdater.this.manager.uom.fetchDependency(this.expectedHash, this.expectedLength, this.filename, this.executable, new UpdateOverMandatoryManager.UOMDependencyFetcherCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSuccess() {
                    DependencyJarFetcher dependencyJarFetcher = DependencyJarFetcher.this;
                    synchronized (dependencyJarFetcher) {
                        if (DependencyJarFetcher.this.fetched) {
                            return;
                        }
                        DependencyJarFetcher.this.fetched = true;
                    }
                    if (DependencyJarFetcher.this.cb != null) {
                        DependencyJarFetcher.this.cb.onSuccess();
                    }
                }
            });
            DependencyJarFetcher dependencyJarFetcher2 = this;
            synchronized (dependencyJarFetcher2) {
                if (this.uomFetcher != null) {
                    Logger.error(this, "Started UOMFetcher twice for " + this.filename, (Throwable)new Exception("error"));
                    return;
                }
                this.uomFetcher = f;
            }
        }
    }
}

