/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.useralerts;

import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.FeedMessage;
import freenet.node.useralerts.UserAlert;
import freenet.support.HTMLNode;

public abstract class AbstractUserAlert
implements UserAlert {
    private final boolean userCanDismiss;
    private final String title;
    private final String text;
    private final String shortText;
    private final HTMLNode htmlText;
    private final short priorityClass;
    protected boolean valid;
    private final String dismissButtonText;
    private final boolean shouldUnregisterOnDismiss;
    private final Object userIdentifier;
    private final long creationTime;

    protected AbstractUserAlert() {
        this.userCanDismiss = false;
        this.title = null;
        this.text = null;
        this.htmlText = null;
        this.priorityClass = 0;
        this.valid = true;
        this.dismissButtonText = null;
        this.shouldUnregisterOnDismiss = false;
        this.userIdentifier = null;
        this.shortText = null;
        this.creationTime = System.currentTimeMillis();
    }

    protected AbstractUserAlert(boolean userCanDismiss, String title, String text, String shortText, HTMLNode htmlText, short priorityClass, boolean valid, String dismissButtonText, boolean shouldUnregisterOnDismiss, Object userIdentifier) {
        this.userCanDismiss = userCanDismiss;
        this.title = title;
        this.text = text;
        this.shortText = shortText;
        this.htmlText = htmlText;
        this.priorityClass = priorityClass;
        this.valid = valid;
        this.dismissButtonText = dismissButtonText;
        this.shouldUnregisterOnDismiss = shouldUnregisterOnDismiss;
        this.userIdentifier = userIdentifier;
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public boolean userCanDismiss() {
        return this.userCanDismiss;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getShortText() {
        return this.shortText;
    }

    @Override
    public HTMLNode getHTMLText() {
        return this.htmlText;
    }

    @Override
    public short getPriorityClass() {
        return this.priorityClass;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void isValid(boolean valid) {
        if (this.userCanDismiss()) {
            this.valid = valid;
        }
    }

    @Override
    public String dismissButtonText() {
        return this.dismissButtonText;
    }

    @Override
    public boolean shouldUnregisterOnDismiss() {
        return this.shouldUnregisterOnDismiss;
    }

    @Override
    public void onDismiss() {
    }

    @Override
    public String anchor() {
        return Integer.toString(this.hashCode());
    }

    @Override
    public boolean isEventNotification() {
        return false;
    }

    public boolean isEvent() {
        return false;
    }

    @Override
    public long getUpdatedTime() {
        return this.creationTime;
    }

    @Override
    public FCPMessage getFCPMessage() {
        return new FeedMessage(this.getTitle(), this.getShortText(), this.getText(), this.getPriorityClass(), this.getUpdatedTime());
    }
}

