/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.useralerts;

import freenet.config.Option;
import freenet.config.SubConfig;
import freenet.l10n.NodeL10n;
import freenet.node.Node;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.support.HTMLNode;
import java.util.concurrent.TimeUnit;

public class IPUndetectedUserAlert
extends AbstractUserAlert {
    final Node node;

    public IPUndetectedUserAlert(Node n) {
        super(true, null, null, null, null, (short)0, true, NodeL10n.getBase().getString("UserAlert.hide"), false, null);
        this.node = n;
    }

    @Override
    public String getTitle() {
        return this.l10n("unknownAddressTitle");
    }

    @Override
    public String getText() {
        if (this.node.ipDetector.noDetectPlugins()) {
            return this.l10n("noDetectorPlugins");
        }
        if (this.node.ipDetector.isDetecting()) {
            return this.l10n("detecting");
        }
        return this.l10n("unknownAddress", "port", Integer.toString(this.node.getDarknetPortNumber())) + ' ' + this.textPortForwardSuggestion();
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("IPUndetectedUserAlert." + key);
    }

    private String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("IPUndetectedUserAlert." + key, pattern, value);
    }

    private String l10n(String key, String[] patterns, String[] values) {
        return NodeL10n.getBase().getString("IPUndetectedUserAlert." + key, patterns, values);
    }

    @Override
    public boolean isValid() {
        if (this.node.isOpennetEnabled()) {
            return false;
        }
        return this.node.peers.countConnectiblePeers() < 5 || this.node.getUptime() >= TimeUnit.MINUTES.toMillis(1L) && !this.node.ipDetector.isDetecting();
    }

    @Override
    public HTMLNode getHTMLText() {
        HTMLNode p;
        HTMLNode textNode = new HTMLNode("div");
        SubConfig sc = this.node.config.get("node");
        Option<?> o = sc.getOption("tempIPAddressHint");
        NodeL10n.getBase().addL10nSubstitution(textNode, "IPUndetectedUserAlert." + (this.node.ipDetector.isDetecting() ? "detectingWithConfigLink" : "unknownAddressWithConfigLink"), new String[]{"link"}, new HTMLNode[]{HTMLNode.link("/config/" + sc.getPrefix())});
        int peers = this.node.peers.getDarknetPeers().length;
        if (peers > 0) {
            textNode.addChild("p", this.l10n("noIPMaybeFromPeers", "number", Integer.toString(peers)));
        }
        if (this.node.ipDetector.noDetectPlugins()) {
            p = textNode.addChild("p");
            NodeL10n.getBase().addL10nSubstitution(p, "IPUndetectedUserAlert.loadDetectPlugins", new String[]{"plugins", "config"}, new HTMLNode[]{HTMLNode.link("/plugins/"), HTMLNode.link("/config/node")});
        } else if (!this.node.ipDetector.hasJSTUN() && !this.node.ipDetector.isDetecting()) {
            p = textNode.addChild("p");
            NodeL10n.getBase().addL10nSubstitution(p, "IPUndetectedUserAlert.loadJSTUN", new String[]{"plugins"}, new HTMLNode[]{HTMLNode.link("/plugins/")});
        }
        this.addPortForwardSuggestion(textNode);
        HTMLNode formNode = textNode.addChild("form", new String[]{"action", "method"}, new String[]{"/config/" + sc.getPrefix(), "post"});
        formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", this.node.clientCore.formPassword});
        formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "subconfig", sc.getPrefix()});
        HTMLNode listNode = formNode.addChild("ul", "class", "config");
        HTMLNode itemNode = listNode.addChild("li");
        itemNode.addChild("span", "class", "configshortdesc", o.getLocalisedShortDesc()).addChild("input", new String[]{"type", "name", "value"}, new String[]{"text", sc.getPrefix() + ".tempIPAddressHint", o.getValueString()});
        itemNode.addChild("span", "class", "configlongdesc", o.getLocalisedLongDesc());
        formNode.addChild("input", new String[]{"type", "value"}, new String[]{"submit", NodeL10n.getBase().getString("UserAlert.apply")});
        formNode.addChild("input", new String[]{"type", "value"}, new String[]{"reset", NodeL10n.getBase().getString("UserAlert.reset")});
        return textNode;
    }

    private void addPortForwardSuggestion(HTMLNode textNode) {
        int darknetPort = this.node.getDarknetPortNumber();
        int opennetPort = this.node.getOpennetFNPPort();
        if (opennetPort <= 0) {
            textNode.addChild("#", " " + this.l10n("suggestForwardPort", "port", Integer.toString(darknetPort)));
        } else {
            textNode.addChild("#", " " + this.l10n("suggestForwardTwoPorts", new String[]{"port1", "port2"}, new String[]{Integer.toString(darknetPort), Integer.toString(opennetPort)}));
        }
    }

    private String textPortForwardSuggestion() {
        int darknetPort = this.node.getDarknetPortNumber();
        int opennetPort = this.node.getOpennetFNPPort();
        if (opennetPort <= 0) {
            return this.l10n("suggestForwardPort", "port", Integer.toString(darknetPort));
        }
        return " " + this.l10n("suggestForwardTwoPorts", new String[]{"port1", "port2"}, new String[]{Integer.toString(darknetPort), Integer.toString(opennetPort)});
    }

    @Override
    public short getPriorityClass() {
        if (this.node.ipDetector.isDetecting()) {
            return 2;
        }
        return 1;
    }

    @Override
    public String getShortText() {
        if (this.node.ipDetector.noDetectPlugins()) {
            return this.l10n("noDetectorPlugins");
        }
        if (this.node.ipDetector.isDetecting()) {
            return this.l10n("detectingShort");
        }
        return this.l10n("unknownAddressShort");
    }
}

