/*
 * Decompiled with CFR 0.152.
 */
package freenet.pluginmanager;

import freenet.pluginmanager.FredPlugin;
import freenet.pluginmanager.PluginInfoWrapper;
import freenet.pluginmanager.PluginManager;
import freenet.support.Logger;
import freenet.support.OOMHandler;

public class PluginHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startPlugin(PluginManager pm, PluginInfoWrapper pi) {
        PluginStarter ps = new PluginStarter(pm, pi);
        FredPlugin plug = pi.getPlugin();
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader pluginClassLoader = plug.getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(pluginClassLoader);
        try {
            if (!pi.isThreadlessPlugin()) {
                final Thread t = new Thread(ps);
                t.setDaemon(true);
                pi.setThread(t);
                Runnable job = new Runnable(){

                    @Override
                    public void run() {
                        t.start();
                    }
                };
                pm.getTicker().queueTimedJob(job, 0L);
            } else {
                plug.runPlugin(pi.getPluginRespirator());
                pm.register(pi);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private static class PluginStarter
    implements Runnable {
        private PluginManager pm = null;
        final PluginInfoWrapper pi;

        public PluginStarter(PluginManager pm, PluginInfoWrapper pi) {
            this.pm = pm;
            this.pi = pi;
        }

        @Override
        public void run() {
            try {
                this.pm.register(this.pi);
                this.pi.getPlugin().runPlugin(this.pi.getPluginRespirator());
            }
            catch (OutOfMemoryError e) {
                OOMHandler.handleOOM(e);
            }
            catch (Throwable t) {
                Logger.normal(this, "Caught Throwable while running plugin: " + t, t);
                System.err.println("Caught Throwable while running plugin: " + t);
                t.printStackTrace();
            }
            this.pi.unregister(this.pm, false);
            this.pm.removePlugin(this.pi);
        }
    }
}

