/*
 * Decompiled with CFR 0.152.
 */
package freenet.store;

import freenet.keys.KeyVerifyException;
import freenet.node.SemiOrderedShutdownHook;
import freenet.node.stats.StoreAccessStats;
import freenet.node.useralerts.UserAlertManager;
import freenet.store.BlockMetadata;
import freenet.store.FreenetStore;
import freenet.store.KeyCollisionException;
import freenet.store.StorableBlock;
import freenet.store.StoreCallback;
import freenet.support.ByteArrayWrapper;
import freenet.support.Logger;
import freenet.support.Ticker;
import freenet.support.io.NativeThread;
import java.io.IOException;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CachingFreenetStore<T extends StorableBlock>
implements FreenetStore<T> {
    private static volatile boolean logMINOR;
    private long size;
    private boolean startJob;
    private boolean shuttingDown;
    private final long maxSize;
    private final long period;
    private final TreeMap<ByteArrayWrapper, Block<T>> blocksByRoutingKey;
    private final StoreCallback<T> callback;
    private final FreenetStore<T> backDatastore;
    private final Ticker ticker;
    private final boolean collisionPossible;
    private final ReadWriteLock configLock = new ReentrantReadWriteLock();

    public CachingFreenetStore(StoreCallback<T> callback, long maxSize, long period, FreenetStore<T> backDatastore, Ticker ticker) {
        if (ticker == null) {
            throw new IllegalArgumentException();
        }
        this.callback = callback;
        this.maxSize = maxSize;
        this.period = period;
        this.backDatastore = backDatastore;
        SemiOrderedShutdownHook shutdownHook = SemiOrderedShutdownHook.get();
        this.blocksByRoutingKey = new TreeMap(ByteArrayWrapper.FAST_COMPARATOR);
        this.ticker = ticker;
        this.size = 0L;
        this.startJob = false;
        this.collisionPossible = callback.collisionPossible();
        this.shuttingDown = false;
        callback.setStore(this);
        shutdownHook.addEarlyJob(new NativeThread("Close CachingFreenetStore", NativeThread.HIGH_PRIORITY, true){

            @Override
            public void realRun() {
                CachingFreenetStore.this.innerClose();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T fetch(byte[] routingKey, byte[] fullKey, boolean dontPromote, boolean canReadClientCache, boolean canReadSlashdotCache, boolean ignoreOldBlocks, BlockMetadata meta) throws IOException {
        ByteArrayWrapper key = new ByteArrayWrapper(routingKey);
        Block<T> block = null;
        this.configLock.readLock().lock();
        try {
            block = this.blocksByRoutingKey.get(key);
        }
        finally {
            this.configLock.readLock().unlock();
        }
        if (block != null) {
            try {
                return this.callback.construct(block.data, block.header, routingKey, ((StorableBlock)block.block).getFullKey(), canReadClientCache, canReadSlashdotCache, meta, null);
            }
            catch (KeyVerifyException e) {
                Logger.error(this, "Error in fetching for CachingFreenetStore: " + e, (Throwable)e);
            }
        }
        return this.backDatastore.fetch(routingKey, fullKey, dontPromote, canReadClientCache, canReadSlashdotCache, ignoreOldBlocks, meta);
    }

    @Override
    public long getBloomFalsePositive() {
        return this.backDatastore.getBloomFalsePositive();
    }

    @Override
    public long getMaxKeys() {
        return this.backDatastore.getMaxKeys();
    }

    @Override
    public long hits() {
        return this.backDatastore.hits();
    }

    @Override
    public long keyCount() {
        return this.backDatastore.keyCount();
    }

    @Override
    public long misses() {
        return this.backDatastore.misses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean probablyInStore(byte[] routingKey) {
        ByteArrayWrapper key = new ByteArrayWrapper(routingKey);
        Block<T> block = null;
        this.configLock.readLock().lock();
        try {
            block = this.blocksByRoutingKey.get(key);
        }
        finally {
            this.configLock.readLock().unlock();
        }
        return block != null || this.backDatastore.probablyInStore(routingKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T block, byte[] data, byte[] header, boolean overwrite, boolean isOldBlock) throws IOException, KeyCollisionException {
        byte[] routingKey = block.getRoutingKey();
        ByteArrayWrapper key = new ByteArrayWrapper(routingKey);
        Block storeBlock = new Block();
        storeBlock.block = block;
        storeBlock.data = data;
        storeBlock.header = header;
        storeBlock.overwrite = overwrite;
        storeBlock.isOldBlock = isOldBlock;
        long sizeBlock = data.length + header.length + block.getFullKey().length + routingKey.length;
        boolean cacheIt = true;
        this.configLock.writeLock().lock();
        try {
            if (sizeBlock < this.maxSize && !this.shuttingDown) {
                Block<T> previousBlock = this.blocksByRoutingKey.get(key);
                if (!this.collisionPossible || overwrite) {
                    this.blocksByRoutingKey.put(key, storeBlock);
                    if (previousBlock == null) {
                        this.size += sizeBlock;
                    }
                } else {
                    if (previousBlock != null) {
                        if (block.equals(previousBlock.block)) {
                            return;
                        }
                        throw new KeyCollisionException();
                    }
                    if (this.backDatastore.probablyInStore(routingKey)) {
                        cacheIt = false;
                    } else {
                        this.blocksByRoutingKey.put(key, storeBlock);
                        this.size += sizeBlock;
                    }
                }
                if (this.size > this.maxSize) {
                    this.pushAll();
                } else if (!this.blocksByRoutingKey.isEmpty() && !this.startJob) {
                    this.startJob = true;
                    this.ticker.queueTimedJob(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            CachingFreenetStore.this.configLock.writeLock().lock();
                            try {
                                CachingFreenetStore.this.pushAll();
                            }
                            finally {
                                CachingFreenetStore.this.startJob = false;
                                CachingFreenetStore.this.configLock.writeLock().unlock();
                            }
                        }
                    }, this.period);
                }
            } else {
                cacheIt = false;
            }
        }
        finally {
            this.configLock.writeLock().unlock();
        }
        if (!cacheIt) {
            this.backDatastore.put(block, data, header, overwrite, isOldBlock);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushAll() {
        this.configLock.writeLock().lock();
        try {
            for (Block<T> block : this.blocksByRoutingKey.values()) {
                try {
                    this.backDatastore.put((StorableBlock)block.block, block.data, block.header, block.overwrite, block.isOldBlock);
                }
                catch (IOException e) {
                    Logger.error(this, "Error in pushAll for CachingFreenetStore: " + e, (Throwable)e);
                }
                catch (KeyCollisionException e) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "KeyCollisionException in pushAll for CachingFreenetStore: " + e, (Throwable)e);
                }
            }
            this.blocksByRoutingKey.clear();
            this.size = 0L;
        }
        finally {
            this.configLock.writeLock().unlock();
        }
    }

    @Override
    public void setMaxKeys(long maxStoreKeys, boolean shrinkNow) throws IOException {
        this.backDatastore.setMaxKeys(maxStoreKeys, shrinkNow);
    }

    @Override
    public long writes() {
        return this.backDatastore.writes();
    }

    @Override
    public StoreAccessStats getSessionAccessStats() {
        return this.backDatastore.getSessionAccessStats();
    }

    @Override
    public StoreAccessStats getTotalAccessStats() {
        return this.backDatastore.getTotalAccessStats();
    }

    @Override
    public boolean start(Ticker ticker, boolean longStart) throws IOException {
        return this.backDatastore.start(ticker, longStart);
    }

    @Override
    public void setUserAlertManager(UserAlertManager userAlertManager) {
        this.backDatastore.setUserAlertManager(userAlertManager);
    }

    @Override
    public FreenetStore<T> getUnderlyingStore() {
        return this.backDatastore;
    }

    @Override
    public void close() {
        this.innerClose();
        this.backDatastore.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerClose() {
        this.configLock.writeLock().lock();
        try {
            this.shuttingDown = true;
            this.pushAll();
        }
        finally {
            this.configLock.writeLock().unlock();
        }
    }

    static {
        Logger.registerClass(CachingFreenetStore.class);
    }

    private static final class Block<T> {
        T block;
        byte[] data;
        byte[] header;
        boolean overwrite;
        boolean isOldBlock;

        private Block() {
        }
    }
}

