/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.DoublyLinkedListImpl;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class LRUMap<K, V> {
    private static volatile boolean logMINOR;
    private final DoublyLinkedListImpl<QItem<K, V>> list = new DoublyLinkedListImpl();
    private final Map<K, QItem<K, V>> hash;

    public LRUMap() {
        this.hash = new HashMap<K, QItem<K, V>>();
    }

    private LRUMap(Map<K, QItem<K, V>> map) {
        this.hash = map;
    }

    public static <K extends Comparable<K>, V> LRUMap<K, V> createSafeMap() {
        return new LRUMap(new TreeMap());
    }

    public static <K, V> LRUMap<K, V> createSafeMap(Comparator<K> comparator) {
        return new LRUMap<K, V>(new TreeMap(comparator));
    }

    public final synchronized void push(K key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        QItem<K, V> insert = this.hash.get(key);
        if (insert == null) {
            insert = new QItem<K, V>(key, value);
            this.hash.put(key, insert);
        } else {
            insert.value = value;
            this.list.remove(insert);
        }
        if (logMINOR) {
            Logger.minor(this, "Pushed " + insert + " ( " + key + ' ' + value + " )");
        }
        this.list.unshift(insert);
    }

    public final synchronized K popKey() {
        if (this.list.size() > 0) {
            return this.hash.remove(this.list.pop().obj).obj;
        }
        return null;
    }

    public final synchronized V popValue() {
        if (this.list.size() > 0) {
            return this.hash.remove(this.list.pop().obj).value;
        }
        return null;
    }

    public final synchronized V peekValue() {
        if (this.list.size() > 0) {
            return this.hash.get(this.list.tail().obj).value;
        }
        return null;
    }

    public final synchronized K peekKey() {
        if (this.list.size() > 0) {
            return this.hash.get(this.list.tail().obj).obj;
        }
        return null;
    }

    public final int size() {
        return this.list.size();
    }

    public final synchronized boolean removeKey(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        QItem<K, V> i = this.hash.remove(key);
        if (i != null) {
            this.list.remove(i);
            return true;
        }
        return false;
    }

    public final synchronized boolean containsKey(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.hash.containsKey(key);
    }

    public final synchronized V get(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        QItem<K, V> q = this.hash.get(key);
        if (q == null) {
            return null;
        }
        return q.value;
    }

    public Enumeration<K> keys() {
        return new ItemEnumeration();
    }

    public Enumeration<V> values() {
        return new ValuesEnumeration();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public synchronized void valuesToArray(V[] entries) {
        Enumeration<V> values = this.values();
        int i = 0;
        while (values.hasMoreElements()) {
            entries[i++] = values.nextElement();
        }
    }

    public synchronized void clear() {
        this.list.clear();
        this.hash.clear();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    public static class QItem<K, V>
    extends DoublyLinkedListImpl.Item<QItem<K, V>> {
        public K obj;
        public V value;

        public QItem(K key, V val) {
            this.obj = key;
            this.value = val;
        }

        public String toString() {
            return super.toString() + ": " + this.obj + ' ' + this.value;
        }
    }

    private class ValuesEnumeration
    implements Enumeration<V> {
        private Enumeration<QItem<K, V>> source;

        private ValuesEnumeration() {
            this.source = LRUMap.this.list.reverseElements();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasMoreElements() {
            LRUMap lRUMap = LRUMap.this;
            synchronized (lRUMap) {
                return this.source.hasMoreElements();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V nextElement() {
            LRUMap lRUMap = LRUMap.this;
            synchronized (lRUMap) {
                return this.source.nextElement().value;
            }
        }
    }

    private class ItemEnumeration
    implements Enumeration<K> {
        private Enumeration<QItem<K, V>> source;

        private ItemEnumeration() {
            this.source = LRUMap.this.list.reverseElements();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasMoreElements() {
            LRUMap lRUMap = LRUMap.this;
            synchronized (lRUMap) {
                return this.source.hasMoreElements();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K nextElement() {
            LRUMap lRUMap = LRUMap.this;
            synchronized (lRUMap) {
                return this.source.nextElement().obj;
            }
        }
    }
}

